# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CPR
                                 A QGIS plugin
 CPR (Colour Pattern Regression)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-16
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Vielca Ingenieros
        email                : pep.j@vielca.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon, QColor
from qgis.PyQt import QtGui, uic
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QTableWidgetItem, QTableWidget
from qgis.core import QgsRasterLayer,  QgsRasterBandStats, QgsProject, QgsVectorLayer, QgsFillSymbol,QgsRenderContext, QgsColorRampShader, QgsRasterShader, QgsSingleBandPseudoColorRenderer
from qgis.core import QgsMessageLog
from console import console



# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .CPR_dialog import CPRDialog
import os.path


class CPR:
    """QGIS Plugin Implementation."""
    TYPE_STYLE_POLYGON  = 1
    TYPE_STYLE_POLYLINE = 2


    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CPR_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CPR')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CPR', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CPR/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CPR (Colour Pattern Regression)'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CPR'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        if self.first_start == True:
            self.first_start = False
            self.dlg = CPRDialog()
            self.dlg.cpr_variability_loop_1.setPlainText("100")
            self.dlg.cpr_variability_loop_2.setPlainText("10")
            self.dlg.cpr_variability_red.setPlainText("0.1")
            self.dlg.cpr_variability_green.setPlainText("0.1")
            self.dlg.cpr_variability_blue.setPlainText("0.1")
            header_columns=["NNSE", "KGE", "PBIAS"]
            header_rows=["Very good", "Good", "Satisfactory", "Unsatisfactory"]
            self.dlg.cpr_adjust.setRowCount(len(header_rows))
            self.dlg.cpr_adjust.setColumnCount(len(header_columns))

            self.dlg.cpr_adjust.setHorizontalHeaderLabels(header_columns)
            self.dlg.cpr_adjust.setVerticalHeaderLabels(header_rows)

            result_nnse_input=["[0.8;1]", "[0.74;0.8]", "[0.5;0.74]", "[0.5]"]
            result_kge_input=["[0;1]", "[-0.5;0]", "[-2;-0.5]", "[-2]"]
            result_pbias_input=["[+-25]", "[+-25;+-40]", "[+-40;+-70]", "[+-70]"]

            for x in range(0, len(result_nnse_input)):
                label = QTableWidgetItem()
                label.setText(result_nnse_input[x])
                self.dlg.cpr_adjust.setItem(x,0,label)

            for x in range(0, len(result_kge_input)):
                label = QTableWidgetItem()
                label.setText(result_kge_input[x])
                self.dlg.cpr_adjust.setItem(x,1,label)

            for x in range(0, len(result_pbias_input)):

                label = QTableWidgetItem()
                label.setText(result_pbias_input[x])
                self.dlg.cpr_adjust.setItem(x,2,label)


        self.dlg.show()
        self.dlg.cpr_calc.clicked.connect(self.cpr_func_calc)
        self.dlg.cpr_close.clicked.connect(self.cpr_func_close)
        

        header_columns=["NNSE", "KGE", "PBIAS"]
        header_rows=["Very good", "Good", "Satisfactory", "Unsatisfactory"]

        self.dlg.cpr_result.setRowCount(len(header_rows))
        self.dlg.cpr_result.setColumnCount(len(header_columns))

        self.dlg.cpr_result.setHorizontalHeaderLabels(header_columns)
        self.dlg.cpr_result.setVerticalHeaderLabels(header_rows)
          
        result_nnse=["0","0","0","0",]
        result_kge=["0","0","0","0",]
        result_pbias=["0","0","0","0",]

        for x in range(0, len(result_nnse)):
            label = QTableWidgetItem()
            label.setText(result_nnse[x])
            self.dlg.cpr_result.setItem(x,0,label)

        for x in range(0, len(result_kge)):
            label = QTableWidgetItem()
            label.setText(result_kge[x])
            self.dlg.cpr_result.setItem(x,1,label)

        for x in range(0, len(result_pbias)):
            label = QTableWidgetItem()
            label.setText(result_pbias[x])
            self.dlg.cpr_result.setItem(x,2,label)

        self.dlg.cpr_progress.setValue(0)
        
        result = self.dlg.exec_()
        
        if result:
            pass
        
    def cpr_func_calc(self):
        import warnings
        warnings.filterwarnings("ignore")
        import numpy as np
        from osgeo import gdal
        import time
        import os
        cpr_raster_input = self.dlg.cpr_raster_input.filePath()
        cpr_image_input = self.dlg.cpr_image_input.filePath()
        cpr_calibration_area = self.dlg.cpr_calibration_area.filePath()
        cpr_interest_area = self.dlg.cpr_interest_area.filePath()
        cpr_result_destination = self.dlg.cpr_result_destination.filePath()
        cpr_variability_loop_1 = self.dlg.cpr_variability_loop_1.toPlainText()
        cpr_variability_loop_2 = self.dlg.cpr_variability_loop_2.toPlainText()

        cpr_variability_red = float(self.dlg.cpr_variability_red.toPlainText())
        cpr_variability_green = float(self.dlg.cpr_variability_green.toPlainText())
        cpr_variability_blue = float(self.dlg.cpr_variability_blue.toPlainText())

        self.dlg.cpr_progress.setValue(0)

        root = QgsProject.instance().layerTreeRoot()
        QgsProject.instance().removeAllMapLayers()
        groups = []
        groups.append(root.findGroup('Input Data'))
        groups.append(root.findGroup('Statistics'))
        groups.append(root.findGroup('Results'))
        for group in groups:
            if group is not None:
                for child in group.children():
                    QgsProject.instance().removeMapLayer(child.layerId())
                root.removeChildNode(group)

        group_input_data = root.insertGroup(0, "Input Data")
        group_statistics = root.insertGroup(1, "Statistics")
        group_results = root.insertGroup(2, "Results")
        
        color = list(np.random.choice(range(256), size=3))
        self.cpr_cpr_load_vector_map_in_group(cpr_calibration_area, self.TYPE_STYLE_POLYLINE, group_input_data, color)
        color = list(np.random.choice(range(256), size=3))
        self.cpr_cpr_load_vector_map_in_group(cpr_interest_area, self.TYPE_STYLE_POLYLINE, group_input_data, color)
        
        self.cpr_load_map_raster_in_group(cpr_image_input, group_input_data)
        self.cpr_load_map_raster_in_group(cpr_raster_input, group_input_data)

        if cpr_variability_loop_1:
            cpr_variability_loop_1 = int(cpr_variability_loop_1)
        else:
            cpr_variability_loop_1 = 100
        if cpr_variability_loop_2:
            cpr_variability_loop_2 = int(cpr_variability_loop_2)
        else:
            cpr_variability_loop_2 = 10

        NODATA = -3.4028235e+37
        SCALE = 4

        cpr_dst_raster = os.path.join(cpr_result_destination, "raster.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True)            
        gdal.Warp(srcDSOrSrcDSTab=cpr_raster_input,
                    destNameOrDestDS=cpr_dst_raster,
                    options=options)  

        cpr_dst_image = os.path.join(cpr_result_destination, "origin_rgb.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True)
        gdal.Warp(srcDSOrSrcDSTab=cpr_image_input,
                    destNameOrDestDS=cpr_dst_image,
                    options=options) 

        cpr_in_ds_raster_scale = gdal.Open(cpr_dst_raster)
        DIM_X_CALIBRATION_AREA = int(cpr_in_ds_raster_scale.RasterXSize / SCALE)
        DIM_Y_CALIBRATION_AREA = int(cpr_in_ds_raster_scale.RasterYSize / SCALE)

        del cpr_in_ds_raster_scale

        cpr_dst_raster_calibration_area= os.path.join(cpr_result_destination, "raster_calibration_area.tif")      
        options = gdal.WarpOptions(cutlineDSName=cpr_calibration_area, cropToCutline=True, width = DIM_X_CALIBRATION_AREA * SCALE, height=DIM_Y_CALIBRATION_AREA * SCALE)   
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster, 
                    destNameOrDestDS=cpr_dst_raster_calibration_area,
                    options=options)

        cpr_in_ds_raster_calibration_area = gdal.Open(cpr_dst_raster_calibration_area)
        cpr_bnd_raster_calibration_area = cpr_in_ds_raster_calibration_area.GetRasterBand(1)
        cpr_data_raster_calibration_area = cpr_bnd_raster_calibration_area.ReadAsArray()
        cpr_data_raster_calibration_area[cpr_data_raster_calibration_area <= NODATA] = np.nan
        
        cpr_dst_raster_interest_area= os.path.join(cpr_result_destination, "raster_interest_area.tif")
        
        options = gdal.WarpOptions(width = (DIM_X_CALIBRATION_AREA**2) * SCALE, height=SCALE * (DIM_Y_CALIBRATION_AREA**2))
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster, 
                    destNameOrDestDS=cpr_dst_raster_interest_area, 
                    options=options)

        if cpr_bnd_raster_calibration_area.GetMinimum() is None or cpr_bnd_raster_calibration_area.GetMaximum() is None:
            cpr_bnd_raster_calibration_area.ComputeStatistics(0)
        RI = cpr_bnd_raster_calibration_area.GetMaximum() / 255 / 30
        RS = 100 * RI
        
        options = gdal.WarpOptions(cutlineDSName=cpr_calibration_area, cropToCutline=True, width = DIM_X_CALIBRATION_AREA * SCALE, height=DIM_Y_CALIBRATION_AREA * SCALE)   
        cpr_dst_image_calibration_area= os.path.join(cpr_result_destination, "origin_rgb_calibration_area.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image, 
                    destNameOrDestDS=cpr_dst_image_calibration_area,
                    options=options)
        
        cpr_in_ds_image_calibration_area  = gdal.Open(cpr_dst_image_calibration_area)
        cpr_matrix_red_image_calibration_area = cpr_in_ds_image_calibration_area.GetRasterBand(1)
        cpr_data_red_image_calibration_area = cpr_matrix_red_image_calibration_area.ReadAsArray()
        cpr_matrix_green_image_calibration_area = cpr_in_ds_image_calibration_area.GetRasterBand(2)
        cpr_data_green_image_calibration_area = cpr_matrix_green_image_calibration_area.ReadAsArray()
        cpr_matrix_blue_image_calibration_area = cpr_in_ds_image_calibration_area.GetRasterBand(3)
        cpr_data_blue_image_calibration_area = cpr_matrix_blue_image_calibration_area.ReadAsArray()

        options = gdal.WarpOptions(width = (DIM_X_CALIBRATION_AREA**2) * SCALE, height=SCALE * (DIM_Y_CALIBRATION_AREA**2))
        cpr_dst_image_interest_area= os.path.join(cpr_result_destination, "origin_rgb_interest_area.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image, 
                    destNameOrDestDS=cpr_dst_image_interest_area
                    ,options=options)

        cpr_in_ds_image_interest_area  = gdal.Open(cpr_dst_image_interest_area)
        cpr_matrix_red_image_interest_area = cpr_in_ds_image_interest_area.GetRasterBand(1)
        cpr_data_red_image_interest_area = cpr_matrix_red_image_interest_area.ReadAsArray()
        cpr_matrix_green_image_interest_area = cpr_in_ds_image_interest_area.GetRasterBand(2)
        cpr_data_green_image_interest_area = cpr_matrix_green_image_interest_area.ReadAsArray()
        cpr_matrix_blue_image_interest_area = cpr_in_ds_image_interest_area.GetRasterBand(3)
        cpr_data_blue_image_interest_area = cpr_matrix_blue_image_interest_area.ReadAsArray()

        cpr_in_ds_raster_interest_area = gdal.Open(cpr_dst_raster_interest_area)
        cpr_bnd_raster_interest_area = cpr_in_ds_raster_interest_area.GetRasterBand(1)
        cpr_data_raster_interest_area = cpr_bnd_raster_interest_area.ReadAsArray()
        cpr_data_raster_interest_area[cpr_data_raster_interest_area <= NODATA] = np.nan


        #rgb_interest_area
        cpr_in_ds_rbg_interest_area  = gdal.Open(cpr_dst_image)
        cpr_matrix_red_rbg_interest_area = cpr_in_ds_rbg_interest_area.GetRasterBand(1)
        cpr_data_red_rbg_interest_area = cpr_matrix_red_rbg_interest_area.ReadAsArray()
        cpr_matrix_green_rbg_interest_area = cpr_in_ds_rbg_interest_area.GetRasterBand(2)
        cpr_data_green_rbg_interest_area = cpr_matrix_green_rbg_interest_area.ReadAsArray()
        cpr_matrix_blue_rbg_interest_area = cpr_in_ds_rbg_interest_area.GetRasterBand(3)
        cpr_data_blue_rbg_interest_area = cpr_matrix_blue_rbg_interest_area.ReadAsArray()

        objetive = 1e+300
    
        coefficient_red=0
        coefficient_green=0 
        coefficient_blue=0
                
        position_red=0
        position_blue=0
        position_green=0

        self.dlg.cpr_progress.setValue(20)
        coefficient_blue_length = np.linspace(RI,RS,cpr_variability_loop_1)
        coefficient_red_length = np.linspace(RI,RS,cpr_variability_loop_1)
        coefficient_green_length = np.linspace(RI,RS,cpr_variability_loop_1)

        for coefficient_blue_cnt in coefficient_blue_length:
            position_red = 0
            for coefficient_red_cnt in coefficient_red_length:
                position_green = 0
                for coefficient_green_cnt in coefficient_green_length:
                    
                    image = (coefficient_red_cnt * cpr_data_red_image_calibration_area) + (coefficient_green_cnt * cpr_data_green_image_calibration_area) + (coefficient_blue_cnt * cpr_data_blue_image_calibration_area)
                    image = np.where(image <= 0, np.nan, image)
                    image = np.ma.array(image, mask=np.isnan(image))
                    cpr_data_raster_calibration_area = np.ma.array(cpr_data_raster_calibration_area, mask=np.isnan(cpr_data_raster_calibration_area))
                    diff_obj = np.square(image  - cpr_data_raster_calibration_area)
                    diff_obj = np.nansum(diff_obj)

                    if diff_obj < objetive:
                        objetive = diff_obj
                        coefficient_red=position_red
                        coefficient_green=position_green
                        coefficient_blue=position_blue
                    position_green+=1
                position_red+=1
            position_blue+=1
        
        coefficient_red = coefficient_red_length[coefficient_red]
        coefficient_green = coefficient_green_length[coefficient_green]
        coefficient_blue =coefficient_blue_length[coefficient_blue]       
        
        self.dlg.cpr_progress.setValue(40)
        
        calculo_red_minus_10 = coefficient_red  * (1 - cpr_variability_red)
        calculo_red_over_10 = coefficient_red * (1 + cpr_variability_red)
        calculo_green_minus_10 = coefficient_green  * (1 - cpr_variability_green)
        calculo_green_over_10 = coefficient_green  * (1 + cpr_variability_green)
        calculo_blue_minus_10 = coefficient_blue  * (1 - cpr_variability_blue)
        calculo_blue_over_10 = coefficient_blue  * (1 + cpr_variability_blue)

        objetive = 1e+300

        coefficient_red=0
        coefficient_green=0 
        coefficient_blue=0        
        
        coefficient_blue_length = np.linspace(calculo_blue_minus_10, calculo_blue_over_10, cpr_variability_loop_2)
        coefficient_red_length = np.linspace(calculo_red_minus_10, calculo_red_over_10, cpr_variability_loop_2)
        coefficient_green_length = np.linspace(calculo_green_minus_10, calculo_green_over_10, cpr_variability_loop_2)
        
        position_blue = 0   
        for coefficient_blue_cnt in coefficient_blue_length:
            position_red = 0
            for coefficient_red_cnt in coefficient_red_length:
                position_green = 0      
                for coefficient_green_cnt in coefficient_green_length:
                    
                    image = (coefficient_red_cnt * cpr_data_red_image_interest_area) + (coefficient_green_cnt * cpr_data_green_image_interest_area) + (coefficient_blue_cnt * cpr_data_blue_image_interest_area)
                    image = np.where(image <= 0, np.nan, image)
                    image = np.ma.array(image, mask=np.isnan(image))
                    cpr_data_raster_interest_area = np.ma.array(cpr_data_raster_interest_area, mask=np.isnan(cpr_data_raster_interest_area))
                    diff_obj = np.square(image - cpr_data_raster_interest_area)
                    diff_obj = np.nansum(diff_obj)

                    if diff_obj < objetive:
                        objetive = diff_obj
                        coefficient_red=position_red
                        coefficient_green=position_green
                        coefficient_blue=position_blue
                    position_green+=1
                position_red+=1
            position_blue+=1

        coefficient_red = coefficient_red_length[coefficient_red]
        coefficient_green = coefficient_green_length[coefficient_green]
        coefficient_blue =coefficient_blue_length[coefficient_blue]
        
        self.dlg.cpr_red_coefficient.setPlainText("{:.4f}".format(coefficient_red))
        self.dlg.cpr_green_coefficient.setPlainText("{:.4f}".format(coefficient_green))
        self.dlg.cpr_blue_coefficient.setPlainText("{:.4f}".format(coefficient_blue))        

        self.dlg.cpr_progress.setValue(60)
        
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True,  width = DIM_X_CALIBRATION_AREA * SCALE, height=DIM_Y_CALIBRATION_AREA * SCALE)
        cpr_dst_raster_stats = os.path.join(cpr_result_destination, "raster_stats.tif")

        gdal.Warp(srcDSOrSrcDSTab=cpr_raster_input,
                    destNameOrDestDS=cpr_dst_raster_stats,
                    options=options) 
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True ,  width = DIM_X_CALIBRATION_AREA * SCALE, height=DIM_Y_CALIBRATION_AREA * SCALE)            
        cpr_dst_image_stats = os.path.join(cpr_result_destination, "origin_rgb_stats.tif")

        gdal.Warp(srcDSOrSrcDSTab=cpr_image_input,
                    destNameOrDestDS=cpr_dst_image_stats,
                    options=options) 
        
        in_ds_raster_stats_scale = gdal.Open(cpr_dst_raster_stats)
        DIM_X_INTEREST_AREA = int(in_ds_raster_stats_scale.RasterXSize / SCALE)
        DIM_Y_INTEREST_AREA = int(in_ds_raster_stats_scale.RasterYSize / SCALE)

        cpr_dst_raster_stats_calibration_area = os.path.join(cpr_result_destination, "raster_stats_calibration_area.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_calibration_area, cropToCutline=True, width = DIM_X_INTEREST_AREA * SCALE, height=DIM_Y_INTEREST_AREA * SCALE)
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster_stats, 
                    destNameOrDestDS=cpr_dst_raster_stats_calibration_area, 
                    options=options)

        cpr_in_ds_raster_stats_calibration_area = gdal.Open(cpr_dst_raster_stats_calibration_area)

        cpr_bnd_raster_stats_calibration_area = cpr_in_ds_raster_stats_calibration_area.GetRasterBand(1)
        cpr_data_raster_stats_calibration_area = cpr_bnd_raster_stats_calibration_area.ReadAsArray()
        cpr_data_raster_stats_calibration_area[cpr_data_raster_stats_calibration_area <= NODATA] = np.nan
        
        options = gdal.WarpOptions(width = (DIM_X_CALIBRATION_AREA**2) * SCALE, height=SCALE * (DIM_Y_CALIBRATION_AREA**2))
        cpr_dst_raster_stats_interest_area = os.path.join(cpr_result_destination, "raster_stats_interest_area.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster_stats, 
                    destNameOrDestDS=cpr_dst_raster_stats_interest_area, 
                    options=options)
         
        cpr_dst_image_stats_calibration_area= os.path.join(cpr_result_destination, "origin_rgb_stats_calibration_area.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_calibration_area, cropToCutline=True,  width = DIM_X_INTEREST_AREA * SCALE, height=DIM_Y_INTEREST_AREA * SCALE)
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image_stats, 
                    destNameOrDestDS=cpr_dst_image_stats_calibration_area, 
                    options=options)

        cpr_in_ds_image_stats_calibration_area  = gdal.Open(cpr_dst_image_stats_calibration_area)

        cpr_matrix_red_image_stats_calibration_area = cpr_in_ds_image_stats_calibration_area.GetRasterBand(1)
        cpr_data_red_image_stats_calibration_area = cpr_matrix_red_image_stats_calibration_area.ReadAsArray()
        cpr_matrix_green_image_stats_calibration_area = cpr_in_ds_image_stats_calibration_area.GetRasterBand(2)
        cpr_data_green_image_stats_calibration_area = cpr_matrix_green_image_stats_calibration_area.ReadAsArray()
        cpr_matrix_blue_image_stats_calibration_area = cpr_in_ds_image_stats_calibration_area.GetRasterBand(3)
        cpr_data_blue_image_stats_calibration_area = cpr_matrix_blue_image_stats_calibration_area.ReadAsArray()

        options = gdal.WarpOptions(width = (DIM_X_CALIBRATION_AREA**2) * SCALE, height=SCALE * (DIM_Y_CALIBRATION_AREA**2))
        
        cpr_dst_image_stats_interest_area= os.path.join(cpr_result_destination, "origin_rgb_stats_interest_area.tif")

        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image_stats, 
                    destNameOrDestDS=cpr_dst_image_stats_interest_area, 
                    options=options)

        cpr_in_ds_image_stats_interest_area  = gdal.Open(cpr_dst_image_stats_interest_area)

        cpr_matrix_red_image_stats_interest_area = cpr_in_ds_image_stats_interest_area.GetRasterBand(1)
        cpr_data_red_image_stats_interest_area = cpr_matrix_red_image_stats_interest_area.ReadAsArray()
        cpr_matrix_green_image_stats_interest_area = cpr_in_ds_image_stats_interest_area.GetRasterBand(2)
        cpr_data_green_image_stats_interest_area = cpr_matrix_green_image_stats_interest_area.ReadAsArray()
        cpr_matrix_blue_image_stats_interest_area = cpr_in_ds_image_stats_interest_area.GetRasterBand(3)
        cpr_data_blue_image_stats_interest_area = cpr_matrix_blue_image_stats_interest_area.ReadAsArray()

        self.cpr_load_map_raster_in_group(cpr_dst_raster_interest_area, group_results)

        cpr_in_ds_raster_stats_interest_area = gdal.Open(cpr_dst_raster_stats_interest_area)
        cpr_bnd_raster_stats_interest_area = cpr_in_ds_raster_stats_interest_area.GetRasterBand(1)
        cpr_data_raster_stats_interest_area = cpr_bnd_raster_stats_interest_area.ReadAsArray()
        cpr_data_raster_stats_interest_area[cpr_data_raster_stats_interest_area <= NODATA] = np.nan

        vector_image_normalized_stats_calibration_area = coefficient_red * cpr_data_red_image_stats_calibration_area + coefficient_green * cpr_data_green_image_stats_calibration_area + coefficient_blue * cpr_data_blue_image_stats_calibration_area

        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_vector_image_normalized_stats_calibration_area= os.path.join(cpr_result_destination, "vector_image_normalized_stats_calibration_area.tif")

        out_ds = gtiff_driver.Create(cpr_dst_vector_image_normalized_stats_calibration_area, cpr_in_ds_image_stats_calibration_area.RasterXSize, cpr_in_ds_image_stats_calibration_area.RasterYSize, 1, gdal.GDT_Float32)

        out_ds.SetGeoTransform(cpr_in_ds_image_stats_calibration_area.GetGeoTransform())     
        out_ds.SetProjection(cpr_in_ds_image_stats_calibration_area.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(vector_image_normalized_stats_calibration_area)
        out_band.FlushCache()

        del out_ds
        vector_image_normalized_stats_interest_area = coefficient_red * cpr_data_red_image_stats_interest_area + coefficient_green * cpr_data_green_image_stats_interest_area + coefficient_blue * cpr_data_blue_image_stats_interest_area

        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_vector_image_normalized_stats_interest_area= os.path.join(cpr_result_destination, "vector_image_normalized_stats_interest_area.tif")        

        out_ds = gtiff_driver.Create(cpr_dst_vector_image_normalized_stats_interest_area, (DIM_X_CALIBRATION_AREA**2) * SCALE,  SCALE * (DIM_Y_CALIBRATION_AREA**2), 1, gdal.GDT_Float32)

        out_ds.SetGeoTransform(cpr_in_ds_image_stats_interest_area.GetGeoTransform())     
        out_ds.SetProjection(cpr_in_ds_image_stats_interest_area.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(vector_image_normalized_stats_interest_area)
        out_band.FlushCache()

        del out_ds

        cpr_in_ds_image_normalized_stats_interest_area = gdal.Open(cpr_dst_vector_image_normalized_stats_interest_area)
        bnd_image_normalized_stats_interest_area = cpr_in_ds_image_normalized_stats_interest_area.GetRasterBand(1)
        cpr_data_image_normalized_stats_interest_area = bnd_image_normalized_stats_interest_area.ReadAsArray()

        cpr_data_raster_stats_interest_area = cpr_in_ds_raster_stats_interest_area.ReadAsArray()
        cpr_data_raster_stats_interest_area[cpr_data_raster_stats_interest_area <= NODATA] = np.nan

        cpr_data_raster_stats_corr_NNSE_calibration_area = np.empty((DIM_Y_INTEREST_AREA * SCALE, DIM_X_INTEREST_AREA * SCALE), np.float32)
        cpr_data_raster_stats_corr_NNSE_calibration_area[:] = np.nan
        cpr_data_raster_stats_corr_PBIAS_calibration_area = np.empty((DIM_Y_INTEREST_AREA * SCALE, DIM_X_INTEREST_AREA * SCALE), np.float32)
        cpr_data_raster_stats_corr_PBIAS_calibration_area[:] = np.nan
        cpr_data_raster_stats_corr_KGE_calibration_area = np.empty((DIM_Y_INTEREST_AREA * SCALE, DIM_X_INTEREST_AREA * SCALE), np.float32)     
        cpr_data_raster_stats_corr_KGE_calibration_area[:] = np.nan  
        
        cpr_nnse_vg = 0
        cpr_kge_vg = 0
        cpr_pbias_vg = 0

        cpr_nnse_g = 0
        cpr_kge_g = 0
        cpr_pbias_g = 0
        
        cpr_nnse_s = 0
        cpr_kge_s = 0
        cpr_pbias_s = 0

        cpr_nnse_us = 0
        cpr_kge_us = 0
        cpr_pbias_us = 0

        cpr_pbias_total = 0
        cpr_kge_total = 0
        cpr_nnse_total = 0

        self.dlg.cpr_progress.setValue(80)  
        media_obs = np.nanmean(cpr_data_raster_stats_interest_area)
                
        result_nnse_input=[]
        result_kge_input=[]
        result_pbias_input=[]
        
        get_nnse_input=[]
        get_kge_input=[]
        get_pbias_input=[]
        
        for x in range(0, 4):
            get_nnse_input.append(self.dlg.cpr_adjust.item(x, 0).text())
            
        for x in range(0, 4):
            get_kge_input.append(self.dlg.cpr_adjust.item(x, 1).text())
            
        for x in range(0, 4):
            get_pbias_input.append(self.dlg.cpr_adjust.item(x, 2).text())           

        for x in range(0, 4):
            result_nnse_input.append(self.dlg.cpr_adjust.item(x, 0).text())

        for x in range(0, 4):
            result_kge_input.append(self.dlg.cpr_adjust.item(x, 1).text())

        for x in range(0, 4):
            string_aux = self.dlg.cpr_adjust.item(x, 2).text().replace('+', '')
            string_aux = string_aux.replace('-', '')
            result_pbias_input.append(string_aux)
            
        for slc_cols  in range(0, DIM_Y_INTEREST_AREA * SCALE , 1):
            for slc_rows  in range(0, DIM_X_INTEREST_AREA * SCALE , 1):
                size_row = 0
                size_row = slc_rows * DIM_X_INTEREST_AREA
                matrix_image_normalized = []
                matrix_raster = []
                for row in range(size_row , size_row + DIM_X_INTEREST_AREA , 1):    
                    sub_vector_image_normalized=[]   
                    sub_vector_raster=[]
                    size_col = 0
                    size_col = slc_cols * DIM_Y_INTEREST_AREA
                    
                    for col in range(size_col, size_col + DIM_Y_INTEREST_AREA, 1):  
                        
                        sub_vector_image_normalized.append(cpr_data_image_normalized_stats_interest_area[col, row])
                        sub_vector_raster.append(cpr_data_raster_stats_interest_area[col, row])

                    matrix_raster.append(sub_vector_raster)
                    matrix_image_normalized.append(sub_vector_image_normalized)

                
                matrix_raster_normalized_flatten = np.array(matrix_image_normalized).flatten()
                matrix_image_flatten = np.array(matrix_raster).flatten()
                 
                nse_pablo = 1 - (np.nansum((matrix_image_flatten - matrix_raster_normalized_flatten) ** 2) / np.nansum((matrix_raster_normalized_flatten - media_obs) ** 2))
                nnse = 1/(2-nse_pablo)                
                
                # kge inicio
                sim_mean = np.nanmean(matrix_image_flatten)
                obs_mean = np.nanmean(matrix_raster_normalized_flatten)
                obs_var = np.nanstd(matrix_raster_normalized_flatten)
                alpha = (np.nanstd(matrix_image_flatten) / obs_var)
                beta = sim_mean / media_obs
                r_num = np.nansum((matrix_raster_normalized_flatten - media_obs) * (matrix_image_flatten - sim_mean))
                r_den = np.sqrt(np.nansum((matrix_raster_normalized_flatten - media_obs) ** 2) * np.nansum((matrix_image_flatten - sim_mean) ** 2))                
                r = r_num / r_den
                kge_ = 1 - np.sqrt((r - 1) ** 2 + (alpha - 1) ** 2 + (beta - 1) ** 2)
                values_kge = np.vstack((kge_, r, alpha, beta))
                pbias = (100 * (np.nansum(matrix_raster_normalized_flatten - matrix_image_flatten) / (len(matrix_raster_normalized_flatten) * media_obs)))

                if (np.nansum(matrix_raster_normalized_flatten) == 0):
                    nnse = np.nan
                    values_kge[0] = np.nan
                    pbias = np.nan

                cpr_data_raster_stats_corr_NNSE_calibration_area[slc_cols, slc_rows] = nnse
                cpr_data_raster_stats_corr_KGE_calibration_area[slc_cols, slc_rows] = values_kge[0]
                cpr_data_raster_stats_corr_PBIAS_calibration_area[slc_cols, slc_rows] = pbias 
                
                if nnse > float(result_nnse_input[0].replace('[','').replace(']','').split(';')[0]) and nnse <= float(result_nnse_input[0].replace('[','').replace(']','').split(';')[1]):
                    cpr_nnse_vg += 1
                    cpr_nnse_total += 1
                if nnse > float(result_nnse_input[1].replace('[','').replace(']','').split(';')[0]) and nnse <= float(result_nnse_input[1].replace('[','').replace(']','').split(';')[1]):
                    cpr_nnse_g += 1
                    cpr_nnse_total += 1
                if nnse > float(result_nnse_input[2].replace('[','').replace(']','').split(';')[0]) and nnse <= float(result_nnse_input[2].replace('[','').replace(']','').split(';')[1]):
                    cpr_nnse_s += 1
                    cpr_nnse_total += 1                    
                if nnse <= float(result_nnse_input[3].replace('[','').replace(']','')):
                    cpr_nnse_us += 1
                    cpr_nnse_total += 1
                    
                if values_kge[0] > float(result_kge_input[0].replace('[','').replace(']','').split(';')[0]) and values_kge[0] <= float(result_kge_input[0].replace('[','').replace(']','').split(';')[1]):
                    cpr_kge_vg += 1
                    cpr_kge_total += 1                    
                if values_kge[0] > float(result_kge_input[1].replace('[','').replace(']','').split(';')[0]) and values_kge[0] <= float(result_kge_input[1].replace('[','').replace(']','').split(';')[1]):
                    cpr_kge_g += 1
                    cpr_kge_total += 1
                if values_kge[0] > float(result_kge_input[2].replace('[','').replace(']','').split(';')[0]) and values_kge[0] <= float(result_kge_input[2].replace('[','').replace(']','').split(';')[1]):
                    cpr_kge_s += 1
                    cpr_kge_total += 1
                if values_kge[0] <= float(result_kge_input[3].replace('[','').replace(']','')):
                    cpr_kge_us += 1
                    cpr_kge_total += 1

                if pbias > float(result_pbias_input[0].replace('[','').replace(']','').split(';')[0]) and pbias < -float(result_pbias_input[0].replace('[','').replace(']','').split(';')[0]):
                    cpr_pbias_g += 1
                    cpr_pbias_total += 1
                if (pbias >= float(result_pbias_input[1].replace('[','').replace(']','').split(';')[0]) and pbias < float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1])) or pbias <= -float(result_pbias_input[1].replace('[','').replace(']','').split(';')[0]) and pbias > -float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1]):
                    cpr_pbias_vg += 1
                    cpr_pbias_total += 1
                if (pbias >= float(result_pbias_input[2].replace('[','').replace(']','').split(';')[0])  and pbias < float(result_pbias_input[2].replace('[','').replace(']','').split(';')[1])) or pbias <= -float(result_pbias_input[2].replace('[','').replace(']','').split(';')[0])  and pbias > -float(result_pbias_input[2].replace('[','').replace(']','').split(';')[1]):
                    cpr_pbias_s += 1
                    cpr_pbias_total += 1
                if pbias >= float(result_pbias_input[3].replace('[','').replace(']','')) or pbias <= -float(result_pbias_input[3].replace('[','').replace(']','')):
                    cpr_pbias_s += 1
                    cpr_pbias_total += 1
                    
        result_nnse_p1 = 0
        result_nnse_p2 = 0
        result_nnse_p3 = 0
        result_nnse_p4 = 0
        result_kge_p1 = 0
        result_kge_p2 = 0
        result_kge_p3 = 0
        result_kge_p4 = 0
        result_pbias_p1 = 0
        result_pbias_p2 = 0
        result_pbias_p3 = 0
        result_pbias_p4 = 0
        
        if cpr_nnse_vg != 0:
            result_nnse_p1 = float(cpr_nnse_vg/cpr_nnse_total*100)        
        if cpr_nnse_g != 0:
            result_nnse_p2 = float(cpr_nnse_g/cpr_nnse_total*100)
        if cpr_nnse_s != 0:
            result_nnse_p3 = float(cpr_nnse_s/cpr_nnse_total*100)
        if cpr_nnse_us != 0:
            result_nnse_p4 = float(cpr_nnse_us/cpr_nnse_total*100)
            
        if cpr_kge_vg != 0:
            result_kge_p1 = float(cpr_kge_vg/cpr_kge_total*100)    
        if cpr_kge_g != 0:
            result_kge_p2 = float(cpr_kge_g/cpr_kge_total*100)
        if cpr_kge_s != 0:
            result_kge_p3 = float(cpr_kge_s/cpr_kge_total*100)
        if cpr_kge_us != 0:
            result_kge_p4 = float(cpr_kge_us/cpr_kge_total*100)
            
        if cpr_pbias_vg != 0:
            result_pbias_p1 = float(cpr_pbias_vg/cpr_pbias_total*100) 
        if cpr_pbias_g != 0:
            result_pbias_p2 = float(cpr_pbias_g/cpr_pbias_total*100)
        if cpr_pbias_s != 0:
            result_pbias_p3 = float(cpr_pbias_s/cpr_pbias_total*100)
        if cpr_pbias_us != 0:
            result_pbias_p4 = float(cpr_pbias_us/cpr_pbias_total*100)
            
        result_nnse=["{:.2f}%".format(result_nnse_p1), "{:.2f}%".format(result_nnse_p2), "{:.2f}%".format(result_nnse_p3), "{:.2f}%".format(result_nnse_p4)]
        result_kge=["{:.2f}%".format(result_kge_p1), "{:.2f}%".format(result_kge_p2), "{:.2f}%".format(result_kge_p3), "{:.2f}%".format(result_kge_p4)]
        result_pbias=["{:.2f}%".format(result_pbias_p1), "{:.2f}%".format(result_pbias_p2), "{:.2f}%".format(result_pbias_p3), "{:.2f}%".format(result_pbias_p4)]

        for x in range(0, len(result_nnse)):
            label = QTableWidgetItem()
            label.setText(result_nnse[x])
            self.dlg.cpr_result.setItem(x,0,label)

        for x in range(0, len(result_kge)):
            label = QTableWidgetItem()
            label.setText(result_kge[x])
            self.dlg.cpr_result.setItem(x,1,label)

        for x in range(0, len(result_pbias)):
            label = QTableWidgetItem()
            label.setText(result_pbias[x])
            self.dlg.cpr_result.setItem(x,2,label)

        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_nnse= os.path.join(cpr_result_destination, "nnse.tif")

        out_ds = gtiff_driver.Create(cpr_dst_nnse, in_ds_raster_stats_scale.RasterXSize, in_ds_raster_stats_scale.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(0)
        
        out_ds.SetGeoTransform(in_ds_raster_stats_scale.GetGeoTransform())     
        out_ds.SetProjection(in_ds_raster_stats_scale.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_raster_stats_corr_NNSE_calibration_area)
        out_band.FlushCache()

        del out_ds
        
        self.cpr_load_map_raster_in_group_colour(cpr_dst_nnse, 
                                                group_statistics, 
                                                [
                                                    float(result_nnse_input[0].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_nnse_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_nnse_input[2].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_nnse_input[3].replace('[','').replace(']',''))])
                       
        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_pbias= os.path.join(cpr_result_destination, "pbias.tif")

        out_ds = gtiff_driver.Create(cpr_dst_pbias, in_ds_raster_stats_scale.RasterXSize, in_ds_raster_stats_scale.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(0)

        out_ds.SetGeoTransform(in_ds_raster_stats_scale.GetGeoTransform())     
        out_ds.SetProjection(in_ds_raster_stats_scale.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_raster_stats_corr_PBIAS_calibration_area)
        out_band.FlushCache()        

        del out_ds
        self.cpr_load_map_raster_in_group_colour(cpr_dst_pbias, 
                                                group_statistics,  
                                                [
                                                    float(result_pbias_input[0].replace('[','').replace(']','').split(';')[0]),
                                                    -float(result_pbias_input[0].replace('[','').replace(']','').split(';')[0]),
                                                    float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    -float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1])])
        
        
        cpr_data_to_raster = cpr_data_red_rbg_interest_area * coefficient_red + cpr_data_green_rbg_interest_area * coefficient_green + cpr_data_blue_rbg_interest_area * coefficient_blue

        
        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_rbg_interest_area= os.path.join(cpr_result_destination, "rbg_interest_area.tif")
        out_ds = gtiff_driver.Create(cpr_dst_rbg_interest_area, cpr_in_ds_rbg_interest_area.RasterXSize, cpr_in_ds_rbg_interest_area.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(0)
        
        out_ds.SetGeoTransform(cpr_in_ds_rbg_interest_area.GetGeoTransform())     
        out_ds.SetProjection(cpr_in_ds_rbg_interest_area.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_to_raster)
        out_band.FlushCache()
        
        del out_ds
        self.cpr_load_map_raster_in_group(cpr_dst_rbg_interest_area, group_results)
        
        
        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_kge= os.path.join(cpr_result_destination, "kge.tif")
        out_ds = gtiff_driver.Create(cpr_dst_kge, in_ds_raster_stats_scale.RasterXSize, in_ds_raster_stats_scale.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(0)
        
        out_ds.SetGeoTransform(in_ds_raster_stats_scale.GetGeoTransform())     
        out_ds.SetProjection(in_ds_raster_stats_scale.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_raster_stats_corr_KGE_calibration_area)
        out_band.FlushCache()

        del out_ds
        self.cpr_load_map_raster_in_group_colour(cpr_dst_kge, 
                                                group_statistics,  
                                                 [
                                                    float(result_kge_input[0].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_kge_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_kge_input[2].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_kge_input[3].replace('[','').replace(']',''))])
        self.dlg.cpr_progress.setValue(100)
        
        for x in range(0, len(get_nnse_input)):
            label = QTableWidgetItem()
            label.setText(get_nnse_input[x])
            self.dlg.cpr_adjust.setItem(x,0,label)
            
        for x in range(0, len(get_kge_input)):
            label = QTableWidgetItem()
            label.setText(get_kge_input[x])
            self.dlg.cpr_adjust.setItem(x,1,label)
            
        for x in range(0, len(get_pbias_input)):
            label = QTableWidgetItem()
            label.setText(get_pbias_input[x])
            self.dlg.cpr_adjust.setItem(x,2,label)
            
    def cpr_func_close(self):    
        self.dlg.close()

    def cpr_load_map_raster(self,pathRasterMap):
        
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()
    
        if (os.path.exists (pathRasterMap)):
    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap)
    
            returnIsValidRasterMap = layerRasterMap.isValid()
        return returnIsValidRasterMap

    def cpr_load_map_raster_in_group(self,pathRasterMap, group):
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()    
    
        if (os.path.exists (pathRasterMap)):    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap, False)
            group.addLayer(layerRasterMap)
            returnIsValidRasterMap = layerRasterMap.isValid()
    
        return returnIsValidRasterMap 
    def cpr_load_map_raster_in_group_colour(self, pathRasterMap, group , interval):
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()
        if (os.path.exists (pathRasterMap)):
    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap, False)
            group.addLayer(layerRasterMap)
            returnIsValidRasterMap = layerRasterMap.isValid()

            rasterShader = QgsRasterShader()
            colourRamp = QgsColorRampShader(interval[3], interval[0])
            
            
            colourRamp.setColorRampType(QgsColorRampShader.Discrete)
            colourRamp.setColorRampItemList([ QgsColorRampShader.ColorRampItem(interval[3], QColor(175, 25, 28), "Unsatisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[2], QColor(205, 20, 216), "Satisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[1], QColor(30, 45, 177), "Good"), 
                    QgsColorRampShader.ColorRampItem(interval[0], QColor(30, 177, 107), "Very good") ])
            
            rasterShader.setRasterShaderFunction(colourRamp)
            pseudoRenderer = QgsSingleBandPseudoColorRenderer(
                layerRasterMap.dataProvider(), layerRasterMap.type(),  rasterShader)

            layerRasterMap.setRenderer(pseudoRenderer)

            layerRasterMap.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(layerRasterMap.id())
 
    
        return returnIsValidRasterMap 
    def cpr_exists(self, pathRasterMap):
        baseNameRasterMap   = os.path.basename(pathRasterMap)
        baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
        layer_names = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        if baseNameRasterMap in layer_names:
            return True
        else:
            return False


    def cpr_cpr_load_vector_map_in_group(self, pathVectorMap, type_style, group, colour = (50,50,250)):
        returnLoadVectorMap = False
        pathVectorMap = pathVectorMap.strip()
        if os.path.exists(pathVectorMap):

            baseNameMapaVector = os.path.basename(pathVectorMap)
            baseNameMapaVector = os.path.splitext(baseNameMapaVector)[0]
            layerVectorMap = QgsVectorLayer(pathVectorMap, baseNameMapaVector, 'ogr')
            QgsProject.instance().addMapLayer(layerVectorMap, False)
            group.addLayer(layerVectorMap)

            if type_style == self.TYPE_STYLE_POLYLINE:

                symbols = layerVectorMap.renderer().symbols(QgsRenderContext())
                symbol = symbols[0]
                symbol.setColor(QtGui.QColor.fromRgb(colour[0],colour[1],colour[2]))


            elif type_style == self.TYPE_STYLE_POLYGON:

                Render = layerVectorMap.renderer()
                mySymbol = QgsFillSymbol.createSimple({'color':'blue', 
                                                          'color_border':'#%02x%02x%02x' % colour,
                                                          'style':'no',
                                                          'style_border':'solid'})

                Render.setSymbol(mySymbol)
                layerVectorMap.triggerRepaint()

            returnLoadVectorMap = layerVectorMap.isValid()
        return returnLoadVectorMap, layerVectorMap
    
    def cpr_load_vector_map(self, pathVectorMap, type_style, colour = (50,50,250), width = 0.5):
        returnLoadVectorMap = False
        pathVectorMap = pathVectorMap.strip()

        if os.path.exists(pathVectorMap):

            baseNameVectorMap = os.path.basename(pathVectorMap)
            baseNameVectorMap = os.path.splitext(baseNameVectorMap)[0]
            layerVectorMap = QgsVectorLayer(pathVectorMap, baseNameVectorMap, 'ogr')
            QgsProject.instance().addMapLayer(layerVectorMap)

            if type_style == self.TYPE_STYLE_POLYLINE:

                symbols = layerVectorMap.renderer().symbols(QgsRenderContext())
                symbol = symbols[0]
                symbol.setColor(QtGui.QColor.fromRgb(colour[0],colour[1],colour[2]))
                symbol.setWidth(width)

            elif type_style == self.TYPE_STYLE_POLYGON:

                Render = layerVectorMap.renderer()
                mySymbol = QgsFillSymbol.createSimple({'color':'blue', 
                                                          'color_border':'#%02x%02x%02x' % colour,
                                                          'width_border':str(width),
                                                          'style':'no',
                                                          'style_border':'solid'})

                Render.setSymbol(mySymbol)
                layerVectorMap.triggerRepaint()

            returnLoadVectorMap = layerVectorMap.isValid()
        return returnLoadVectorMap, layerVectorMap
    