# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CIGeoECopyPasteFeatures3D
                                 A QGIS plugin
 Copy and paste features from one layer to another of the same type
                              -------------------
        begin                : 2019-06-06
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Centro de Informação Geoespacial do Exército
        email                : igeoe@igeoe.pt
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt
from PyQt4.QtGui import QAction, QIcon, QToolBar, QMessageBox

# Initialize Qt resources from file resources.py
import resources
from Retangulo import Retangulo

# Import the code for the dialog
from CIGeoE_Copy_Paste_Feature_3D_dialog import CIGeoECopyPasteFeatures3DDialog
import os.path
from qgis.gui import *
from qgis.core import *

class CIGeoECopyPasteFeatures3D:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CIGeoECopyPasteFeatures3D_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)


        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CIGeoE Copy Paste Features 3D')
        # TODO: We are going to let the user set this up in a future iteration

        # Check for CIGeoE toolbar. If exists, add button there; if not exists, create one
        cigeoeToolBarExists = False
        for x in iface.mainWindow().findChildren(QToolBar): 
            if x.windowTitle() == 'CIGeoE':
                self.toolbar = x
                cigeoeToolBarExists = True
        if cigeoeToolBarExists==False:
            self.toolbar = self.iface.addToolBar(u'CIGeoE')

        self.toolbar.setObjectName(u'CIGeoECopyPasteFeatures3D')


        #************* connect to the rectangle ******************
        self.dlg = CIGeoECopyPasteFeatures3DDialog()       
        self.canvas = self.iface.mapCanvas()

        self.retangulo = Retangulo(self.canvas, self.iface, self.dlg)    #add iface for work with active layer  

        self.rectIsActive = False
               
        #*********************************************




    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CIGeoECopyPasteFeatures3D', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        # Create the dialog (after translation) and keep reference
        #self.dlg = CIGeoECopyPasteFeatures3DDialog()

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CIGeoECopyPasteFeatures3D/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CIGeoE Copy Paste Features 3D: Copy and paste features from one layer to another of the same type preserving original Z coordinate'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CIGeoE Copy Paste Features 3D'),
                action)
            self.iface.removeToolBarIcon(action)
        
        #********************************************************
        # Unset the map tool in case it's set
        self.iface.mapCanvas().unsetMapTool(self.retangulo)

        #*********************************************************
            

        # remove the toolbar
        del self.toolbar


    def run(self):
        """Run method that performs all the real work"""
        
        layer = self.iface.activeLayer()

        if not layer:
            QMessageBox.information(self.iface.mainWindow(), "Error", 'Layer is not loaded!')
            return      

        if layer.type() != QgsMapLayer.VectorLayer: 
            QMessageBox.information(self.iface.mainWindow(), "Error", 'The layer must be of point or line or polygon type .')            
            return    

        if layer.geometryType() != QGis.Point:
            if layer.geometryType() != QGis.Line:
                if layer.geometryType() != QGis.Polygon:  
                    QMessageBox.information(self.iface.mainWindow(), "Error", 'The layer must be of point or line or polygon type .')            
                    return     

        if self.rectIsActive == False:
            self.iface.mapCanvas().setMapTool(self.retangulo)
            self.rectIsActive = True
        else:
            self.iface.mapCanvas().unsetMapTool(self.retangulo)
            self.rectIsActive = False
