# ČHMÚ/CHMI – Meteorological Data Processing

*Copyright (C) 2025 Mikuláš Kadečka – mikulas.kad@seznam.cz*

This QGIS plugin processes meteorological measurements published by the Czech Hydrometeorological Institute using spatial interpolation methods. To function properly, the tool requires all measurements to be downloaded and formatted correctly.  

You can either download preprocessed datasets from this [webpage](https://drive.google.com/drive/folders/12qYemjNOktYcyJgaK6pPfBqbJCzDAlbV?usp=sharing) or use scripts from this [GitHub repository](https://github.com/mkik12/CHMU-weatherFilesScraper) to automate the download of raw data from the CHMI website and convert them into a format suitable for GIS processing.

## What Results to Expect

> [!IMPORTANT]  
> Please take the tool's results with caution, as this is my first attempt at creating a plugin, and the results may be distorted.

The plugin analyzes the activity of CHMI measuring stations and, based on the user-specified time interval, groups them into units with the same active periods. These groups serve as input for multiple iterations of spatial interpolation, accounting for the fact that stations frequently change locations and often switch between active and inactive states.

After generating interpolation result rasters, the tool calculates a weighted average, where the weights represent the number of active measuring days for each station group. This method can produce more accurate results compared to a single iteration of spatial interpolation.  

The tool can generate the following outputs:  

- A **weighted average raster** (mandatory result)  
- **Point layers** of stations with the same active period (optional, can be enabled in the plugin’s input parameters)

## How to Use the Plugin  

1. Install the plugin and either use the scripts to download and preprocess data files from the CHMI webpage or download the preprocessed dataset and extract the root folder.  
2. Start the plugin, go to the **Settings** tab, and set the directory path for the "spatial_data" folder obtained in the first step.  
3. Switch to the **Raster** tab and fill in the primary and secondary parameters.  
4. Click the **Start** button to run the plugin.

> [!TIP]
> Be cautious when setting the extent layer parameter, which must be a vector layer - preferably a polygon - and the cell size, whose unit is determined by the chosen projection. If you want to save the plugin's output, enter a path that ends with a GIS raster file extension.

## How the Plugin Works  

The structure of this plugin was initially created using the [**Plugin Builder**](https://plugins.qgis.org/plugins/pluginbuilder/), but some components require further explanation. These components include:  

- **i18n** – A directory that stores translation files for the plugin, created using **Qt Linguist**.  
- **functions** – A Python library that contains most of the custom functions developed for this project.  
- **data_chmu_dialog_base.ui** – A file that defines the plugin’s user interface, created with **Qt Designer**.  
- **data_chmu.py** – A Python file partially generated by Plugin Builder. It adds functionality to the UI and processes input parameters for the core of the plugin.  
- **tool.py** – The core file of the plugin. It utilizes custom functions and tools from QGIS libraries, including GDAL and Processing.  

If you're interested in learning more about the plugin’s functionality, please check out my [bachelor's thesis](https://drive.google.com/file/d/1DXLyOIdGAFoZxHrDPvD5-rdhIUGaceaf/view?usp=drive_link).