######################################################################
#             / ____|  ____|  __ \| |  | |  ____|  ____|             #
#            | |    | |__  | |__) | |__| | |__  | |__                #
#            | |    |  __| |  ___/|  __  |  __| |  __|               #
#            | |____| |____| |    | |  | | |____| |____              #
#             \_____|______|_|    |_|  |_|______|______|             #
######################################################################
#
# CEPHEE
# Copyright (C) 2024 Toulouse INP
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details :
# <http://www.gnu.org/licenses/>.
#
######################################################################

from PyQt5.QtWidgets import QTableWidgetItem
from qgis.PyQt.QtWidgets import QDialog
from .ui.Ui_ReachDischarge import Ui_ReachTab

class ReachTab(QDialog, Ui_ReachTab):

    def __init__(self, BV, ui_line, parent = None):
        super().__init__()
        self.setupUi(self)
        self.BV = BV
        self.ui_line = ui_line
        self.tableWidget.setColumnCount(2)
        self.tableWidget.setRowCount(len(self.BV.reach))
        self.tableWidget.setHorizontalHeaderLabels(["Reach name", "Discharge"])
        if len(self.BV.reach) > 0:
            for i, reach in enumerate(self.BV.reach):
                self.tableWidget.setItem(i, 0, QTableWidgetItem(reach.name))
                self.tableWidget.setItem(i, 1, QTableWidgetItem(str(reach.Q)))


    def accept(self):
        line = ""
        if len(self.BV.reach) > 0:
            for i, reach in enumerate(self.BV.reach):
                line += self.tableWidget.item(i,1).text() + ";"
            self.ui_line.setText(line[:-1])
        self.done(QDialog.Accepted)
