 # -*- coding: utf-8 -*-
"""
Created on Wed Aug 23 07:56:23 2023

@author: lcassan
"""
import sys
import os
'''
#from centerline.geometry import Centerline
import geopandas as gpd
from scipy.interpolate import splprep, splev
from shapely.geometry import Point
workflow_dir ='/space/globc/cassan/CARS/RT_Hydro/demo_workflow/Scripts/'
raster_dir = '/space/globc/cassan/CARS/RT_Hydro/demo_workflow/'

parent_dir = os.path.abspath(os.path.join(os.path.dirname(__file__),'..'))
sys.path.append(parent_dir)
sys.path.append(workflow_dir)
sys.path.append(raster_dir)
'''

from core.Parameters import Parameters
from core.PreProcessing2D import *
from os import getcwd, path
import argparse
#from core.postCEPHEE import *
from core.ModelCatchment import ModelCatchment
from core.Tools import *
from core.Hydraulics import *
from core.CrossSection import *
from core.Data import *
from core.Bathymetrics import *
from shapely.geometry import Point
from shapely.geometry import LineString


# CLI argument parser
parser = argparse.ArgumentParser(description='a CLI (command line interface) for CEPHEE')
parser.add_argument('parameter_file', help='Provide parameter file')
parser.add_argument('--output_folder', help='Specify folder for output files', default=getcwd())
args = parser.parse_args()

# read input files
if not path.isfile(args.parameter_file):
    raise SystemExit(args.parameter_file + ' file not found')

# Créer un dictionnaire pour stocker les variables et classes définies dans le fichier
name= {}
# Ouvrir et lire le fichier Python
with open(args.parameter_file, "r") as file:
    code = file.read()
# Exécuter le contenu du fichier dans le namespace
exec(code,name)
Param = name.get('Parameters')
params =Param()

#Force certains paramètres à avoir un sens physique pour ce workflow (un seul tronçon, pas de MNT)
params['H']['dischargeMethod']= 'Constant'
params['C']['findCatchment'] = False
params['C']['computeGlobal'] = False
params['B']['interpolationMethod'] = params['H']['createBanksMethods']
if params['XS']['reachInterStep'] <= params['XS']['XSInterStep']:
    params['XS']['interpXS'] = False

params['H']['createBanksMethods'] = 'Obs'
params['B']['interpolationMethod'] = 'Obs'
params['XS']['distSearchMin'] = 0

filename_mask = '/Users/cassan/Documents/CARS/water_msk_2154.tif'
bank_filename =params['B']['bank_filename']
#-----------------------------------------------------------------------------
#instanciation du modèle
BV1=ModelCatchment()

params.user_outlet_point = Point(471339,6382306)
#-------EXECUTION DATA ----------------------------------------------------
#-----------------------------------------------------------------------------
#lecture des données topo

BV1.read_network(river_filename=params['N']['riverPath'], nclassemax=params['N']['classeMax'])
BV1.outlet_point = params.user_outlet_point

BV1.read_DEM_stack(DEM_path_ext=(params['C']['DEMpath'], params['C']['DEM_file_extension']))
BV1.clipRiverFromDEM()
print('DEM and Network read')

#attribue un z à la centerline, remplace la fonction de projection qui n'est pas possible sans MNT dans le lit
for i, row in BV1.HydroNetwork.iterrows():
    line = row['geometry']
    line_with_z =  LineString(
                    [(x, y, 0) for x, y in zip(line.xy[0], line.xy[1])])
    row['geometry'] = line_with_z

print('Network projection completed')
#-----------------------------------------------------------------------------
#Traitement du reséau pour le mettre au standard hydraulique 'utilisable par un code 1D)

BV1.ordered_network = BV1.HydroNetwork
BV1.ordered_network['River']= BV1.ordered_network['gid']
# choix de l'exutoire et du réseau correspondant 0= aire drainée
                                            # la plus grande (valeur par défaut)
BV1.find_junctionAndOutlet(params['N']['minDistJunction']) #trouve la position des confluences et les exutoires
BV1.setOutlet(params.user_outlet_point)                                                     # param=distance minimale entre 2 reachs pour connexion

#-----------------------------------------------------------------------------
#création des section sur le réseau d'un seul exutoire
BV1.renameReachFromJunction(params) # crée les biefs et renomme les biefs en fonction de la position des tronçons
BV1.createReach()
network_filepath = os.path.join(params.work_path, 'ordered_network.shp')
BV1.ordered_network.to_file(network_filepath)
BV1.junction.to_file(os.path.join(params.work_path, 'junction.shp'))

if params['B']['useImportedSections']:
    importXSlines(BV1, params, XS_filename=params['XS']['XS_filename'])
else:
    BV1.interpolateReach(params['XS']['reachInterStep']) #interpole les tronçons de la distance fournit en argument
    createXSlines(BV1, params['XS']['width'], params['XS']['numberOfPoints'])
    if params['XS']['optimizeXS']:
        optimizeXSlines(BV1)
    projectionXSline(BV1, params)

if params['XS']['interpXS']:
    interpolateAllXS(BV1, params)

XS_lines_filepath = os.path.join(params.work_path, 'XS_lines.shp')
saveXSlines(BV1, XS_lines_filepath)
print('Cross section created')

addQtoSection(BV1,params)
setConstantFriction(BV1,params['H']['frictionValue'])
polygonize_water_mask(filename_mask,params,5)
polygone_file = os.path.join(params.work_path,'polygone_smooth.shp')


drag_all_XS(BV1, params, type_comp=params['B']['interpolationMethod'],bank_filename =polygone_file )  # create the line of each section with the points of the banks
if params['H']['mapping_method'] == 'interpolation':
    interpolate_MNTchannel(BV1, params, params['H']['dxlat'])
else:
    rasterize_MNTchannel(BV1, params,params['H']['dxlat'])
MergeRaster_channel_DEM(BV1,  params.work_path)

