######################################################################
#             / ____|  ____|  __ \| |  | |  ____|  ____|             #
#            | |    | |__  | |__) | |__| | |__  | |__                #
#            | |    |  __| |  ___/|  __  |  __| |  __|               #
#            | |____| |____| |    | |  | | |____| |____              #
#             \_____|______|_|    |_|  |_|______|______|             #
######################################################################
#
# CEPHEE
# Copyright (C) 2024 Toulouse INP
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details :
# <http://www.gnu.org/licenses/>.
#
######################################################################

from qgis.PyQt.QtWidgets import QDialog
from qgis.PyQt.QtCore import Qt
from .ui.Ui_MainWindow import Ui_MainWindow
from .DataWidget import DataWidget
from .CrossSectionWidget import CrossSectionWidget
from .HydraulicWidget import HydraulicWidget
from .BathymetricWidget import BathymetricWidget
from .Preprocessing2DWidget import Preprocessing2DWidget


class MainWindow(QDialog, Ui_MainWindow):

    def __init__(self, iface, BV, param, parent = None):
        super(MainWindow, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface
        self.BV = BV
        self.param = param
        self.task = None
        self.setWindowFlag(Qt.WindowStaysOnTopHint)

        panels = [
            {
                "tool_tool_name": "Data Widget",
                "widget": DataWidget(self.iface, self.BV, self.param, self)
            },
            {
                "tool_tool_name": "Cross Section Widget",
                "widget": CrossSectionWidget(self.iface, self.BV, self.param, self)
            },
            {
                "tool_tool_name": "Hydraulic Widget",
                "widget": HydraulicWidget(self.iface, self.BV, self.param, self)
            },
            {
                "tool_tool_name": "Bathymetric Widget",
                "widget": BathymetricWidget(self.iface, self.BV, self.param, self)
            },
            {
                "tool_tool_name": "Preprocessing 2D Widget",
                "widget": Preprocessing2DWidget(self.iface, self.BV, self.param, self)
            }
        ]

        for panel in panels:
            self.tabWidget.addTab(panel["widget"], panel["tool_tool_name"])

    def updateParameters(self):
        pass

    def process(self):
        self.updateParameters()