 # -*- coding: utf-8 -*-
"""
Created on Wed Aug 23 07:56:23 2023

@author: lcassan
"""

from os import getcwd, path
import time
import argparse

from core.postCEPHEE import *
from core.ModelCatchment import ModelCatchment
from core.Tools import *
from core.Hydraulics import *
from core.CrossSection import *
from core.Data import *
from core.Bathymetrics import *
from shapely.geometry import Point
from shapely.geometry import LineString
from core.Parameters import Parameters
import importlib
'''
Exemple de fichier CLI permettant une utilisation classique de CEPHEE.
Les choix des opérations à faire est faite dans la classe paramètre 
ainsi quel'ensemble des chemin d'accés et des valeurs numériques des paramètres

ce fichier permet de choisir si les cross section seront créés ou lues dans un fichier
par défaut les sections importées ne sont pas reprojetéées car elles sont utilisées pour creuser le lit mineur
On peut aussi choisir de creuser le MNT en fonctin du calcul fait

'''

# CLI argument parser
parser = argparse.ArgumentParser(description='a CLI (command line interface) for CEPHEE')
parser.add_argument('parameter_file', help='Provide parameter file')
parser.add_argument('--output_folder', help='Specify folder for output files', default=getcwd())
args = parser.parse_args()

# read input files
if not path.isfile(args.parameter_file):
    raise SystemExit(args.parameter_file + ' file not found')

# Créer un dictionnaire pour stocker les variables et classes définies dans le fichier
name= {}
# Ouvrir et lire le fichier Python
with open(args.parameter_file, "r") as file:
    code = file.read()
# Exécuter le contenu du fichier dans le namespace
exec(code,name)
Param = name.get('Parameters')
params =Param()
params['XS']['XSInterStep']=10

choice_XS ='New' #(or Imported)
choix_post = True
choix_bathy = True
XS_filename = os.path.join(params.work_path, 'XS_precourlis_point2023.shp')
#-----------------------------------------------------------------------------
#instanciation du modèle
BV1=ModelCatchment()

#-------EXECUTION DATA ----------------------------------------------------
#-----------------------------------------------------------------------------
#lecture des données topo
BV1.read_data(params)
print('DEM and Network read')
hydro_network_filepath = os.path.join(params.work_path, 'hydro_network.shp')
BV1.HydroNetwork.to_file(hydro_network_filepath)
#-----------------------------------------------------------------------------
BV1.build_globalDEM(params)
#-----------------------------------------------------------------------------
#selection et projection du réseau dans la ROI
BV1.projectionOnDEM(params['N']['typeProj'], params['N']['interpolationMethod'])
print('Network projection completed')
#-----------------------------------------------------------------------------
#Traitement du reséau pour le mettre au standard hydraulique 'utilisable par un code 1D)
BV1.order_network(params['N']['minDistJunction']) #reunis et ordonne les lignes de l'amont vers l'aval
BV1.find_junctionAndOutlet(params['N']['minDistJunction']) #trouve la position des confluences et les exutoires
                                                          # param=distance minimale entre 2 reachs pour connexion
BV1.setOutlet(params.user_outlet_point)# choix de l'exutoire et du réseau correspondant 0= aire drainée
                                      # la plus grande (valeur par défaut)
#-----------------------------------------------------------------------------
#création des section sur le réseau d'un seul exutoire
BV1.renameReachFromJunction(params) # crée les biefs et renomme les biefs en fonction de la position des tronçons
BV1.createReach()  #sélectionne les biefs pour le modèle hydrualique et créer l'objet reach contenant touts les tronçons
                    # et leur sections associées

network_filepath = os.path.join(params.work_path, 'ordered_network.shp')
BV1.ordered_network.to_file(network_filepath)
BV1.junction.to_file(os.path.join(params.work_path, 'junction.shp'))


if choice_XS == 'New':
    BV1.interpolateReach(params['XS']['reachInterStep']) #interpole les tronçons de la distance fournit en argument
    createXSlines(BV1, params['XS']['width'], params['XS']['numberOfPoints'])
    if params['XS']['optimizeXS']:
        optimizeXSlines(BV1)
    projectionXSline(BV1, params)
elif choice_XS == 'Imported':
     importXSlines(BV1, params, XS_filename=XS_filename)

if params['XS']['interpXS']:
    interpolateAllXS(BV1,params)

XS_lines_filepath = os.path.join(params.work_path, 'XS_lines.shp')
saveXSlines(BV1, XS_lines_filepath)
print('Cross section created')

setConstantFriction(BV1,params['H']['frictionValue'])

if params['H']['frictionMap']:
    projOnFrictionMap(BV1,params['H']['friction_filename'])
export_as_csv_for_HECRASgeometry(BV1,params.work_path)

#------Hydraulic curve computation--------------------------------------------
#-----------------------------------------------------------------------------
#
if params['H']['hydraulicCurve']:
    addWidthtoSection(BV1,params)

if params['H']['createBanks']:
    if params['H']['createBanksMethods'] == 'Normal':
        Q_outlet = addQtoSection(BV1,params)
        computeNormalAndCriticalDepth(BV1,params)

    elif params['H']['createBanksMethods'] == '1D':
        addQtoSection(BV1, params)
        backWaterProfile(BV1, params)
    elif params['H']['createBanksMethods'] == 'Himposed':
        addQtoSection(BV1, params)
        impose_water_depth(BV1, params)

    createAllBankLines(BV1, resultType=params['H']['createBanksMethods'])
    saveBankslines(BV1, params.work_path)
    export_result_as_csv(BV1, params)
'''
line_bed = BV1.reach[0].geodata['geometry']
Zbed = [BV1.reach[0].section[idpoint].Zbed for idpoint in range(len(BV1.reach[0].section))]

for idpoint in range(len(line_bed.coords)):
    line_bed= LineString([(x,y,z) for x,y,z in zip(line_bed.coords[0],line_bed.coords[1],Zbed)])
'''
dectect_inline_structure(BV1,params)
#--sauvegarde des resultats du calcul---------------------------------------
#-----------------------------------------------------------------------------
ind_river = BV1.list_of_outlet[BV1.id_outlet][1]

if choix_post:

    pixel_size = params['H']['dxlat']#BV1.resmin
    data_poly = create_poly_CEPHEE(BV1, nx_trans = 0, pixel_size=pixel_size,
                                  resultType =params['H']['createBanksMethods'])
    DEM_file =os.path.join(params.work_path,'_' + str(int(params['C']['resolution'])) + "m_merged.tif")
    config_cal = params['H']['createBanksMethods'] + '_Q' + str(params['H']['outletDischarge']) + '_h' + str(
         params['H']['hWaterOutlet'])

    if params['H']['mapping_method'] == 'interpolation':
        raster_result_interp = interpolate_result_CEPHEE(data_poly, params.work_path, config_cal, [pixel_size, pixel_size],
                                                         params['C']['DEM_CRS_ID'])

    else:
        raster_result_path = rasterize_poly_CEPHEE(data_poly, params.work_path, config_cal,
                                                    [pixel_size, pixel_size],
                                                    BV1.global_DEM_path)



#---modification de la bathymetry---------------------------------------------
#-----------------------------------------------------------------------------

if choix_bathy:
    if params['B']['interpolationMethod'] =='Obs':
        bank_filename = os.path.join(params.work_path, 'banks_lines.shp')
    else:
        bank_filename =None

    drag_all_XS(BV1, params, type_comp=params['B']['interpolationMethod'],bank_filename = bank_filename)  # create the line of each section with the points of the banks
    if params['H']['mapping_method'] == 'interpolation':
        interpolate_MNTchannel(BV1, params,params['H']['dxlat'])
    else:
        rasterize_MNTchannel(BV1, params,params['H']['dxlat'])
    MergeRaster_channel_DEM(BV1, params.work_path)

