######################################################################
#             / ____|  ____|  __ \| |  | |  ____|  ____|             #
#            | |    | |__  | |__) | |__| | |__  | |__                #
#            | |    |  __| |  ___/|  __  |  __| |  __|               #
#            | |____| |____| |    | |  | | |____| |____              #
#             \_____|______|_|    |_|  |_|______|______|             #
######################################################################
#
# CEPHEE
# Copyright (C) 2024 Toulouse INP
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details :
# <http://www.gnu.org/licenses/>.
#
######################################################################

import matplotlib.pyplot as plt
from qgis.PyQt import QtCore
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
from qgis.core import  QgsFeatureRequest
import geojson
from ..core.Tools import compute_distance

class FigureWidget(FigureCanvas):
    editing_finished = QtCore.pyqtSignal()

    def __init__(self, BV, parent=None):
        self.BV = BV
        self.figure = plt.figure(dpi=100)
        self.axes = self.figure.add_subplot(111)
        super(FigureWidget, self).__init__(self.figure)
        self.setParent(parent)


    def plot_qgis(self, map_layer, id_section):
        # select section
        if not -1 < id_section < len(map_layer):
            print("section not available")
            return
        self.axes.cla()
        features = map_layer.getFeatures(QgsFeatureRequest(id_section))
        for feature in features:
            geom = geojson.loads(feature.geometry().asJson())
            if 'coordinates' not in geom:
                print("Geom has no coordinates")
                return
            for linestring in geom['coordinates']:
                x = compute_distance(linestring)
                y = []
                for id_point in range(0, len(linestring)):
                    y.append(linestring[id_point][2])
                self.axes.plot(x,y, 'k-')

        self.draw()


    def plot_z(self, distance, line):
        z = [line.coords[i][2] for i in range(0, len(line.coords))]
        self.axes.plot(distance, z, 'k-')
        self.draw()

    def plot_z_origin(self, distance, line):
        z = [line.coords[i][2] for i in range(0, len(line.coords))]
        self.axes.plot(distance, z, 'k--')
        self.draw()

    def plot_WS(self, distance, WS):
        self.axes.scatter(distance, WS, color='red')
        self.axes.plot(distance, WS, color='blue')
        self.draw()

    def plot_V(self, distance, V):
        self.axes.plot(distance, V, color='blue')
        self.draw()