######################################################################
#             / ____|  ____|  __ \| |  | |  ____|  ____|             #
#            | |    | |__  | |__) | |__| | |__  | |__                #
#            | |    |  __| |  ___/|  __  |  __| |  __|               #
#            | |____| |____| |    | |  | | |____| |____              #
#             \_____|______|_|    |_|  |_|______|______|             #
######################################################################
#
# CEPHEE
# Copyright (C) 2024 Toulouse INP
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details :
# <http://www.gnu.org/licenses/>.
#
######################################################################


from os import getcwd, path
import time
import argparse


from core.ModelCatchment import ModelCatchment
from core.Parameters import Parameters
from core.PreProcessing2D import *

#-----------------------------------------------------------------------------

# CLI argument parser
parser = argparse.ArgumentParser(description='a CLI (command line interface) for CEPHEE')
parser.add_argument('parameter_file', help='Provide parameter file')
parser.add_argument('--output_folder', help='Specify folder for output files', default=getcwd())
args = parser.parse_args()

# read input files
if not path.isfile(args.parameter_file):
    raise SystemExit(args.parameter_file + ' file not found')

# Créer un dictionnaire pour stocker les variables et classes définies dans le fichier
name= {}
# Ouvrir et lire le fichier Python
with open(args.parameter_file, "r") as file:
    code = file.read()
# Exécuter le contenu du fichier dans le namespace
exec(code,name)
Param = name.get('Parameters')
params =Param()

#-----------------------------------------------------------------------------
#instanciation du modèle
BV1=ModelCatchment()

#-------EXECUTION DATA ----------------------------------------------------
#-----------------------------------------------------------------------------
#lecture des données topo
BV1.read_data(params)
print('DEM and Network read')

DEM_file = BV1.DEM_stack['file_list'][0]
area_min = 150

#output_name = os.path.join('', params.work_path, 'dsm_L' + str(params['P']['averageSize']) + 'm_OT' + str(params['P']['overtopping']) + 'm_minA' + str(area_min) + 'm2')

output_name = os.path.join(params.work_path, 'areaMin' + str(area_min) + 'm2')

width_range =  np.arange(10,30,10)
height_range = np.arange(0.4,1,0.2)

_, nstructure = find_dikes(params,DEM_file,areaMin = area_min , output_name = output_name,method ='avg',width_range =width_range ,height_range = height_range )

params['P']['averageSize'] = 20
params['P']['overtopping'] = 0.7

out = density_zone(DEM_file,params,5,200,3)

