 # -*- coding: utf-8 -*-
"""
Created on Wed Aug 23 07:56:23 2023

@author: lcassan
"""
import sys
import os
'''
#from centerline.geometry import Centerline
import geopandas as gpd
from scipy.interpolate import splprep, splev
from shapely.geometry import Point
workflow_dir ='/space/globc/cassan/CARS/RT_Hydro/demo_workflow/Scripts/'
raster_dir = '/space/globc/cassan/CARS/RT_Hydro/demo_workflow/'

parent_dir = os.path.abspath(os.path.join(os.path.dirname(__file__),'..'))
sys.path.append(parent_dir)
sys.path.append(workflow_dir)
sys.path.append(raster_dir)
'''

from core.Parameters import Parameters
from core.PreProcessing2D import *

#from core.postCEPHEE import *
from core.ModelCatchment import ModelCatchment
from core.Tools import *
from core.Hydraulics import *
from core.CrossSection import *
from core.Data import *
from core.Bathymetrics import *
from shapely.geometry import Point
from shapely.geometry import LineString

#instanciation du modèle
BV1=ModelCatchment()
params = Parameters()
params.work_path = 'tmp/cars/'
params['C'] = {
            'DEMpath': '/Users/cassan/Documents/CARS/demo_workflow/10_HYDRO_DTM', # dossier des dalles MNT
            'DEM_file_extension' : '.tif',
            'DEM_CRS_ID': 'EPSG:2154',  # identifiant du système de projection
            'resolution': 20, #résolution du raster agrégeant toutes les dalles d'un même BV
            'window_size': 2,
            # 'storageDEM': 'no', # ('no','vector','grid')
            'findCatchment': False,  #choix de sélectionner uniquement les dalles correspondant à l'exutoire voulu
            'computeGlobal': False
        }

params['N'] = {
            'riverPath': '/Users/cassan/Documents/HydroPrepro/data/CoursEau_76_Occitanie/CoursEau_76_Occitanie.shp',
            # 'NetworkType': 'BDCarthage',
            'classeMax': 3, #ordre maximum du réseau hydrographique
            'minAccumulativeArea': 500, #surface minimale de l'aire drainée pour débuter le réseau hydrographique automatique
            'minDistJunction': 500,
            'typeProj': 'raster',  #methode de projection des lignes(interpolation ou raster )
            'interpolationMethod': 'nearest', #méthode d'interpolation  des élévations
        }


params['XS'] = {
            'reachInterStep': 50, #distance entre les sections sur un bief (m)
            'width': 200, #Demi largeur des sections en travers (m)
            'numberOfPoints': 100, #nombre de points topo des sections en travers (m)
            'defaultManning': 0.03, #valeur par défaut du manning
            'XSInterStep': 100, # pas d'espace d'interpolation des sections
            'methodChannel': 'multi channel', #méthode d'interpolation des sections en travers
            'originSection': 'riverline', #position transversale du 0 des sections en travers
            'typeProj': 'raster',  #methode de projection des lignes(interpolation ou raster )
            'interpolationMethod': 'nearest', #méthode d'interpolation  des élévations
            'distSearchMin' : 0, #distance de recherche du fond du lit autour du tracé shp
            'interpXS' : False,
            'optimizeXS': False,
            'XS_filename' : None
        }

params['H'] = {
         'outletDischarge': 500,
         'dxlat': 2,
         'levee': True,
         'hWaterOutlet': 14,
         'himposed': 1,
         'hydraulicCurve': False,
         'dz': 2,
         'hmax': 50,
         'createBanks': True,
         'dischargeMethod': 'Constant',
         'createBanksMethods': 'Obs',
         'frictionLaw': 'Manning',
         'frictionValue': 0.033,
         'frictionMap': False,
         'mapping_method': 'interpolation',
         'slope_structure': 0.1,
         'hinf': 0.1,
         'hsup': 30,
         'eps': 1e-2,
         'MaxIter': 30
     }

params['B'] = {
         'bathymetricSections': 'Parabolic',
         'depth': 5,
         'fromQ': False,
         'smoothSlope':True,
         'reachIntersStep': 100,
         'interpolationMethod': 'nearest',
         'useImportedSections': False
     }

filename_mask = '/Users/cassan/Documents/CARS/water_msk_2154.tif'

#choix du traitement à faire
choice_XS ='New' #(or Imported)
choix_bathy = True

params.user_outlet_point = Point(471339,6382306)
#-------EXECUTION DATA ----------------------------------------------------
#-----------------------------------------------------------------------------
#lecture des données topo
BV1.read_network(river_filename=params['N']['riverPath'], nclassemax=params['N']['classeMax'])

BV1.outlet_point = params.user_outlet_point
BV1.read_DEM_stack(DEM_path_ext=(params['C']['DEMpath'], params['C']['DEM_file_extension']))
BV1.clipRiverFromDEM()
print('DEM and Network read')

#attribue un z à la centerline, remplace la fonction de projection qui n'est pas possible sans MNT dans le lit
for i, row in BV1.HydroNetwork.iterrows():
    line = row['geometry']
    line_with_z =  LineString(
                    [(x, y, 0) for x, y in zip(line.xy[0], line.xy[1])])
    row['geometry'] = line_with_z

print('Network projection completed')
#-----------------------------------------------------------------------------
#Traitement du reséau pour le mettre au standard hydraulique 'utilisable par un code 1D)

BV1.ordered_network = BV1.HydroNetwork
BV1.ordered_network['River']= BV1.ordered_network['gid']
# choix de l'exutoire et du réseau correspondant 0= aire drainée
                                            # la plus grande (valeur par défaut)
BV1.find_junctionAndOutlet(params['N']['minDistJunction']) #trouve la position des confluences et les exutoires
BV1.setOutlet(params.user_outlet_point)                                                     # param=distance minimale entre 2 reachs pour connexion

#-----------------------------------------------------------------------------
#création des section sur le réseau d'un seul exutoire
BV1.renameReachFromJunction(params) # crée les biefs et renomme les biefs en fonction de la position des tronçons
BV1.createReach()
network_filepath = os.path.join(params.work_path, 'ordered_network.shp')
BV1.ordered_network.to_file(network_filepath)
BV1.junction.to_file(os.path.join(params.work_path, 'junction.shp'))


if choice_XS == 'New':
    BV1.interpolateReach(params['XS']['reachInterStep']) #interpole les tronçons de la distance fournit en argument
    createXSlines(BV1, params['XS']['width'], params['XS']['numberOfPoints'])
    if params['XS']['optimizeXS']:
        optimizeXSlines(BV1)
    projectionXSline(BV1, params)
elif choice_XS == 'Imported':
     XS_filename ='/Users/cassan/Documents/SWIFT/GARONNE/data/bathy_survey_SPC_2023/unzip_shp/La Garonne marmandaise.shp'
     #XS_filename = os.path.join(params.work_path, 'XS_lines.shp')
     importXSlines(BV1, params, XS_filename=XS_filename)

if params['XS']['interpXS']:
    interpolateAllXS(BV1,params)

XS_lines_filepath = os.path.join(params.work_path, 'XS_lines.shp')
saveXSlines(BV1, XS_lines_filepath)
print('Cross section created')

addQtoSection(BV1,params)
setConstantFriction(BV1,params['H']['frictionValue'])
polygonize_water_mask(filename_mask,params,5)
polygone_file = os.path.join(params.work_path,'polygone_smooth.shp')

#---modification de la bathymetry---------------------------------------------
#-----------------------------------------------------------------------------

if choix_bathy:
    drag_all_XS(BV1, params, type_comp= params['H']['createBanksMethods'],bank_filename =polygone_file )  # create the line of each section with the points of the banks
    if params['H']['mapping_method'] == 'interpolation':
        interpolate_MNTchannel(BV1, params, params['H']['dxlat'])
    else:
        rasterize_MNTchannel(BV1, params,params['H']['dxlat'])
    MergeRaster_channel_DEM(BV1,  params.work_path)

createAllBankLines(BV1,resultType =  params['H']['createBanksMethods'])
saveBankslines(BV1,params.work_path)