 # -*- coding: utf-8 -*-
"""
Created on Wed Aug 23 07:56:23 2023

@author: lcassan
"""

from postProcessing.postCEPHEE import *
from core.ModelCatchment import ModelCatchment
from core.Tools import *
from shapely.geometry import Point
from core.Parameters import Parameters
import geopandas as gpd
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------

params = Parameters()
#params.dict['C']['DEMpath'] = "./tmp/DEM_test/"
params['C']['DEMpath'] = "tmp/"
params['C']['DEM_file_extension'] = '.tif'
params['C']['DEM_CRS_ID'] = 'EPSG:2154'
params['C']['resolution'] =500
params['N']['riverPath'] = "tmp/CoursEau_05_Adour-Garonne_decoupe_sectetude.shp"
params['N']['classeMax'] = 2
params['C']['findCatchment'] = False
params['XS']['numberOfPoints'] = 100
#-----------------------------------------------------------------------------
#instanciation du modèle et option des MNT
BV1=ModelCatchment()
params.outlet = Point(455320,6390755)
BV1.setOutlet(0,params.outlet)
#-----------------------------------------------------------------------------
#lecture des données topo
BV1.read_data(params, params.outlet)
print('DEM and Network read')
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
#création des section sur le réseau d'un seul exutoire
BV1.createReach()  #sélectionne les biefs pour le modèle hydrualique et créer l'objet reach contenant touts les tronçons et leur sections associées
XS_filename ='tmp/XS_with_z.shp'
BV1.importXSlines(params,XS_filename = XS_filename )  #créer les sections en travers pour tous les tronçons et les projeter sur le DEM (demi-largeur section, nbre de points, methode d'intep, manning)
BV1.interpolateAllXS(params)
#map_model(BV1)
print('Cross section created')
#-----------------------------------------------------------------------------
ind_river = BV1.list_of_outlet[BV1.id_outlet][1]
Qoutlet = 2000 #débit à l'exutoire
BV1.addQtoSection(Qoutlet, method = 'PerReach')
BV1.computeNormalAndCriticalDepth(params) #calcul la cote pour le régime uniforme et la largeur associée
haval=15
#BV1.backWaterProfile(haval,params)
#for i in range(len(BV1.reach)):
   # for j in range(0, len(BV1.reach[i].section)):
     #  plot_section(BV1.reach[i], j, 'Normal', 'WS')


#ind_river = BV1.list_of_outlet[BV1.id_outlet][1]
nx_trans =100
pixel_size =20
data_poly =create_poly_CEPHEE(BV1.reach[0], nx_trans = nx_trans, pixel_size=pixel_size, resultType ='Normal')
DEM_file ='tmp/MNT_2023.tif'
h_interp,V_interp, WSE_interp = rasterize_poly_CEPHEE(data_poly,'tmp/result/', [pixel_size,pixel_size],DEM_file)
BV1.gdf_ordered.plot()
BV1.globalDEM[BV1.globalDEM==np.min(BV1.globalDEM)]=0
plot_extent = [BV1.DEM_stack['global_extent'][0],BV1.DEM_stack['global_extent'][2],
                   BV1.DEM_stack['global_extent'][1],BV1.DEM_stack['global_extent'][3]]
plt.imshow(h_interp , extent=plot_extent,cmap='jet')
plt.show()


#BV1.createAllBankLines(params['N']['riverPath'])
#map_model(BV1)
path_shp, _ = os.path.split(params['N']['riverPath'] )


map_model(BV1)  # plot 2D réseau et sections



 # choix d'un bief avec calcul

#for i in range(len(BV1.reach)):
  #  if BV1.reach[i].geodata['River'] in ind_river:
   #     print(len(BV1.reach[i].section))
   #     for j in range(0,len(BV1.reach[i].section)):
    #        plot_section(BV1.reach[i],j,'Normal','WS')

 # #ind_river=[0]
 # for i in range(len(BV1.reach)):
 #     if BV1.reach[i].geodata['River'] in ind_river:
 #         print(len(BV1.reach[i].section))
 #         for j in range(0,len(BV1.reach[i].section)):
 #             BV1.reach[i].section[j].equivalentChannel('triangle')
 #             plt.plot(BV1.reach[i].section[j].hydro['depth'],BV1.reach[i].section[j].hydro['W'])

for i in range(len(BV1.reach)):
    if BV1.reach[i].geodata['River'] in ind_river:
        plot_longProfile(BV1.reach[i])

 # -----------------------------------------------------------------------------
print('stop')
