######################################################################
#             / ____|  ____|  __ \| |  | |  ____|  ____|             #
#            | |    | |__  | |__) | |__| | |__  | |__                #
#            | |    |  __| |  ___/|  __  |  __| |  __|               #
#            | |____| |____| |    | |  | | |____| |____              #
#             \_____|______|_|    |_|  |_|______|______|             #
######################################################################
#
# CEPHEE
# Copyright (C) 2024 Toulouse INP
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details :
# <http://www.gnu.org/licenses/>.
#
######################################################################

class Parameters(dict):
    """ TODO

    """
    def __init__(self):
        super().__init__()
        self.work_path = None
        self.qgis_river_layer = None
        self.qgis_DEM_layer = None
        self.user_outlet_point = None
        self.reset_C()
        self.reset_N()
        self.reset_XS()
        self.reset_H()
        self.reset_B()
        self.reset_P()

    def reset_C(self):
        self['C'] = {
            'DEMpath': None, # dossier des dalles MNT
            'DEM_CRS_ID': 'EPSG:2154',  # identifiant du système de projection
            'DEM_file_extension' : '.asc',
            'resolution': 20, #résolution du raster agrégeant toutes les dalles d'un même BV
            'withDEM': 20, #bande de largeur pour enregistrement DEM autour de la rivière (m)
            'window_size': 2,
            # 'storageDEM': 'no', # ('no','vector','grid')
            'findCatchment': False,  #choix de sélectionner uniquement les dalles correspondant à l'exutoire voulu
            'computeGlobal': True
        }

    def reset_N(self):
        self['N'] = {
            'riverPath': '/Users/cassan/Documents/HydroPrepro/data/CoursEau_76_Occitanie/CoursEau_76_Occitanie.shp',
            # 'NetworkType': 'BDCarthage',
            'classeMax': 6, #ordre maximum du réseau hydrographique
            'minAccumulativeArea': 500, #surface minimale de l'aire drainée pour débuter le réseau hydrographique automatique
            'minDistJunction': 500,
            'typeProj': 'raster',  #methode de projection des lignes(interpolation ou raster )
            'interpolationMethod': 'nearest', #méthode d'interpolation  des élévations
        }

    def reset_XS(self):
        self['XS'] = {
            'reachInterStep': 100, #distance entre les sections sur un bief (m)
            'width': 100, #Demi largeur des sections en travers (m)
            'numberOfPoints': 100, #nombre de points topo des sections en travers (m)
            'defaultManning': 0.03, #valeur par défaut du manning
            'XSInterStep': 100, # pas d'espace d'interpolation des sections
            'methodChannel': 'multi channel', #méthode d'interpolation des sections en travers
            'originSection': 'riverline', #position transversale du 0 des sections en travers
            'typeProj': 'raster',  #methode de projection des lignes(interpolation ou raster )
            'interpolationMethod': 'nearest', #méthode d'interpolation  des élévations
            'distSearchMin' : 10, #distance de recherche du fond du lit autour du tracé shp
            'interpXS' : False,
            'optimizeXS': False,
            'XS_filename' : None
        }

    def reset_H(self):
        self['H'] = {
            'outletDischarge': 0,
            'dischargeMethod': 'Constant',
            'dxlat': 5,
            'levee': True,
            'hWaterOutlet' : 0,
            'himposed' : 1,
            'hydraulicCurve': True,
            'dz': 2,
            'hmax': 50,
            'createBanks': False,
            'createBanksMethods': 'Himposed',
            'frictionLaw' : 'Manning',
            'frictionValue': 0.03,
            'frictionMap' : False,
            'mapping_method' : 'interpolation',
            'slope_structure' : 0.05,
            'hinf': 0.1,
            'hsup': 30,
            'eps': 1e-2,
            'MaxIter': 30
        }

    def reset_B(self):
        self['B'] = {
            'bathymetricSections': 'Parabolic',
            'depth' : 5,
            'fromQ' : False,
            'smoothSlope': False,
            'reachIntersStep': 100,
            'interpolationMethod': 'Normal',
            'useImportedSections': False
        }

    def reset_P(self):
        self['P'] = {
            'findDikes': False,
            'overtopping': 1,
            'averageSize': 10,
            'densityZone': False,
            'minMeshSize': 1,
            'maxMeshSize': 10,
            'findFlatZone': False,
            'eps': 1
        }


