# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CADDigitize
                                 A QGIS plugin
 CAD like tools for QGis
 Fork of Rectangles Ovals Digitizing. Inspired by CadTools, LibreCAD/AutoCAD.
                              -------------------
        begin                : 2016-01-25
        git sha              : $Format:%H$
        copyright            : (C) 2016 by Loïc BARTOLETTI
        email                : lbartoletti@tuxfamily.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui
from qgis.gui import *
try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    def _fromUtf8(s):
        return s

try:
    _encoding = QtGui.QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QtGui.QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QtGui.QApplication.translate(context, text, disambig)

class Ui_CADDigitizeSettings(object):
    def setupUi(self, CADDigitizeSettings):
        CADDigitizeSettings.setObjectName(_fromUtf8("CADDigitizeSettings"))
        CADDigitizeSettings.resize(515, 500)
        self.verticalLayout_6 = QtGui.QVBoxLayout(CADDigitizeSettings)
        self.verticalLayout_6.setObjectName(_fromUtf8("verticalLayout_6"))
        self.verticalLayout = QtGui.QVBoxLayout()
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.tabWidget = QtGui.QTabWidget(CADDigitizeSettings)
        self.tabWidget.setObjectName(_fromUtf8("tabWidget"))
        self.CircleTab = QtGui.QWidget()
        self.CircleTab.setObjectName(_fromUtf8("CircleTab"))
        self.layoutWidget = QtGui.QWidget(self.CircleTab)
        self.layoutWidget.setGeometry(QtCore.QRect(10, 20, 134, 42))
        self.layoutWidget.setObjectName(_fromUtf8("layoutWidget"))
        self.verticalLayout_5 = QtGui.QVBoxLayout(self.layoutWidget)
        self.verticalLayout_5.setMargin(0)
        self.verticalLayout_5.setObjectName(_fromUtf8("verticalLayout_5"))
        self.label_2 = QtGui.QLabel(self.layoutWidget)
        self.label_2.setScaledContents(True)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.verticalLayout_5.addWidget(self.label_2)
        self.circleSegmentsSpinbox = QtGui.QDoubleSpinBox(self.layoutWidget)
        self.circleSegmentsSpinbox.setDecimals(0)
        self.circleSegmentsSpinbox.setMinimum(4.0)
        self.circleSegmentsSpinbox.setMaximum(3600.0)
        self.circleSegmentsSpinbox.setProperty("value", 36.0)
        self.circleSegmentsSpinbox.setObjectName(_fromUtf8("circleSegmentsSpinbox"))
        self.verticalLayout_5.addWidget(self.circleSegmentsSpinbox)
        self.tabWidget.addTab(self.CircleTab, _fromUtf8(""))
        self.EllipseTab = QtGui.QWidget()
        self.EllipseTab.setObjectName(_fromUtf8("EllipseTab"))
        self.layoutWidget1 = QtGui.QWidget(self.EllipseTab)
        self.layoutWidget1.setGeometry(QtCore.QRect(10, 20, 174, 42))
        self.layoutWidget1.setObjectName(_fromUtf8("layoutWidget1"))
        self.verticalLayout_4 = QtGui.QVBoxLayout(self.layoutWidget1)
        self.verticalLayout_4.setMargin(0)
        self.verticalLayout_4.setObjectName(_fromUtf8("verticalLayout_4"))
        self.label = QtGui.QLabel(self.layoutWidget1)
        self.label.setScaledContents(True)
        self.label.setObjectName(_fromUtf8("label"))
        self.verticalLayout_4.addWidget(self.label)
        self.ellipsePointsSpinbox = QtGui.QDoubleSpinBox(self.layoutWidget1)
        self.ellipsePointsSpinbox.setDecimals(0)
        self.ellipsePointsSpinbox.setMinimum(4.0)
        self.ellipsePointsSpinbox.setMaximum(3600.0)
        self.ellipsePointsSpinbox.setProperty("value", 8.0)
        self.ellipsePointsSpinbox.setObjectName(_fromUtf8("ellipsePointsSpinbox"))
        self.verticalLayout_4.addWidget(self.ellipsePointsSpinbox)
        self.tabWidget.addTab(self.EllipseTab, _fromUtf8(""))
        self.RegPolyTab = QtGui.QWidget()
        self.RegPolyTab.setObjectName(_fromUtf8("RegPolyTab"))
        self.layoutWidget_3 = QtGui.QWidget(self.RegPolyTab)
        self.layoutWidget_3.setGeometry(QtCore.QRect(10, 20, 134, 42))
        self.layoutWidget_3.setObjectName(_fromUtf8("layoutWidget_3"))
        self.verticalLayout_9 = QtGui.QVBoxLayout(self.layoutWidget_3)
        self.verticalLayout_9.setMargin(0)
        self.verticalLayout_9.setObjectName(_fromUtf8("verticalLayout_9"))
        self.label_3 = QtGui.QLabel(self.layoutWidget_3)
        self.label_3.setScaledContents(True)
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.verticalLayout_9.addWidget(self.label_3)
        self.rpolygonEdgesSpinbox = QtGui.QDoubleSpinBox(self.layoutWidget_3)
        self.rpolygonEdgesSpinbox.setDecimals(0)
        self.rpolygonEdgesSpinbox.setMinimum(3.0)
        self.rpolygonEdgesSpinbox.setMaximum(9999.0)
        self.rpolygonEdgesSpinbox.setProperty("value", 5.0)
        self.rpolygonEdgesSpinbox.setObjectName(_fromUtf8("rpolygonEdgesSpinbox"))
        self.verticalLayout_9.addWidget(self.rpolygonEdgesSpinbox)
        self.tabWidget.addTab(self.RegPolyTab, _fromUtf8(""))
        self.ArcTab = QtGui.QWidget()
        self.ArcTab.setObjectName(_fromUtf8("ArcTab"))
        self.layoutWidget2 = QtGui.QWidget(self.ArcTab)
        self.layoutWidget2.setGeometry(QtCore.QRect(11, 11, 461, 391))
        self.layoutWidget2.setObjectName(_fromUtf8("layoutWidget2"))
        self.verticalLayout_3 = QtGui.QVBoxLayout(self.layoutWidget2)
        self.verticalLayout_3.setMargin(0)
        self.verticalLayout_3.setObjectName(_fromUtf8("verticalLayout_3"))
        self.groupBox = QtGui.QGroupBox(self.layoutWidget2)
        self.groupBox.setObjectName(_fromUtf8("groupBox"))
        self.verticalLayout_8 = QtGui.QVBoxLayout(self.groupBox)
        self.verticalLayout_8.setObjectName(_fromUtf8("verticalLayout_8"))
        self.horizontalLayout_2 = QtGui.QHBoxLayout()
        self.horizontalLayout_2.setObjectName(_fromUtf8("horizontalLayout_2"))
        self.radioFeatureAngle = QtGui.QRadioButton(self.groupBox)
        self.radioFeatureAngle.setObjectName(_fromUtf8("radioFeatureAngle"))
        self.horizontalLayout_2.addWidget(self.radioFeatureAngle)
        self.ArcFeatureAngle = QtGui.QDoubleSpinBox(self.groupBox)
        self.ArcFeatureAngle.setDecimals(1)
        self.ArcFeatureAngle.setProperty("value", 1.0)
        self.ArcFeatureAngle.setObjectName(_fromUtf8("ArcFeatureAngle"))
        self.horizontalLayout_2.addWidget(self.ArcFeatureAngle)
        self.verticalLayout_8.addLayout(self.horizontalLayout_2)
        self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        self.radioFeaturePitch = QtGui.QRadioButton(self.groupBox)
        self.radioFeaturePitch.setChecked(True)
        self.radioFeaturePitch.setObjectName(_fromUtf8("radioFeaturePitch"))
        self.horizontalLayout.addWidget(self.radioFeaturePitch)
        self.ArcFeaturePitch = QtGui.QDoubleSpinBox(self.groupBox)
        self.ArcFeaturePitch.setEnabled(True)
        self.ArcFeaturePitch.setDecimals(1)
        self.ArcFeaturePitch.setMaximum(100.0)
        self.ArcFeaturePitch.setProperty("value", 2.0)
        self.ArcFeaturePitch.setObjectName(_fromUtf8("ArcFeaturePitch"))
        self.horizontalLayout.addWidget(self.ArcFeaturePitch)
        self.verticalLayout_8.addLayout(self.horizontalLayout)
        self.verticalLayout_3.addWidget(self.groupBox)
        self.groupBox_2 = QtGui.QGroupBox(self.layoutWidget2)
        self.groupBox_2.setObjectName(_fromUtf8("groupBox_2"))
        self.layoutWidget3 = QtGui.QWidget(self.groupBox_2)
        self.layoutWidget3.setGeometry(QtCore.QRect(10, 19, 441, 46))
        self.layoutWidget3.setObjectName(_fromUtf8("layoutWidget3"))
        self.verticalLayout_2 = QtGui.QVBoxLayout(self.layoutWidget3)
        self.verticalLayout_2.setMargin(0)
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        self.ArcClockWise = QtGui.QRadioButton(self.layoutWidget3)
        self.ArcClockWise.setChecked(True)
        self.ArcClockWise.setObjectName(_fromUtf8("ArcClockWise"))
        self.verticalLayout_2.addWidget(self.ArcClockWise)
        self.ArcCounterClockWise = QtGui.QRadioButton(self.layoutWidget3)
        self.ArcCounterClockWise.setObjectName(_fromUtf8("ArcCounterClockWise"))
        self.verticalLayout_2.addWidget(self.ArcCounterClockWise)
        self.verticalLayout_3.addWidget(self.groupBox_2)
        self.groupBox_3 = QtGui.QGroupBox(self.layoutWidget2)
        self.groupBox_3.setObjectName(_fromUtf8("groupBox_3"))
        self.layoutWidget_2 = QtGui.QWidget(self.groupBox_3)
        self.layoutWidget_2.setGeometry(QtCore.QRect(10, 20, 441, 46))
        self.layoutWidget_2.setObjectName(_fromUtf8("layoutWidget_2"))
        self.verticalLayout_7 = QtGui.QVBoxLayout(self.layoutWidget_2)
        self.verticalLayout_7.setMargin(0)
        self.verticalLayout_7.setObjectName(_fromUtf8("verticalLayout_7"))
        self.ArcPolygonChord = QtGui.QRadioButton(self.layoutWidget_2)
        self.ArcPolygonChord.setChecked(True)
        self.ArcPolygonChord.setObjectName(_fromUtf8("ArcPolygonChord"))
        self.verticalLayout_7.addWidget(self.ArcPolygonChord)
        self.ArcPolygonPie = QtGui.QRadioButton(self.layoutWidget_2)
        self.ArcPolygonPie.setObjectName(_fromUtf8("ArcPolygonPie"))
        self.verticalLayout_7.addWidget(self.ArcPolygonPie)
        self.verticalLayout_3.addWidget(self.groupBox_3)
        self.tabWidget.addTab(self.ArcTab, _fromUtf8(""))
        self.snapColorTab = QtGui.QWidget()
        self.snapColorTab.setObjectName(_fromUtf8("snapColorTab"))
        self.splitter = QtGui.QSplitter(self.snapColorTab)
        self.splitter.setGeometry(QtCore.QRect(10, 10, 470, 146))
        self.splitter.setOrientation(QtCore.Qt.Vertical)
        self.splitter.setObjectName(_fromUtf8("splitter"))
        self.groupBox_4 = QtGui.QGroupBox(self.splitter)
        self.groupBox_4.setObjectName(_fromUtf8("groupBox_4"))
        self.gridLayout = QtGui.QGridLayout(self.groupBox_4)
        self.gridLayout.setObjectName(_fromUtf8("gridLayout"))
        self.mLineColorSnapToolButton = QgsColorButtonV2(self.groupBox_4)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mLineColorSnapToolButton.sizePolicy().hasHeightForWidth())
        self.mLineColorSnapToolButton.setSizePolicy(sizePolicy)
        self.mLineColorSnapToolButton.setMinimumSize(QtCore.QSize(120, 0))
        self.mLineColorSnapToolButton.setMaximumSize(QtCore.QSize(120, 16777215))
        self.mLineColorSnapToolButton.setText(_fromUtf8(""))
        self.mLineColorSnapToolButton.setColor(QtGui.QColor(0, 127, 255, 120))
        self.mLineColorSnapToolButton.setAllowAlpha(True)
        self.mLineColorSnapToolButton.setDefaultColor(QtGui.QColor(0, 127, 255, 120))
        self.mLineColorSnapToolButton.setObjectName(_fromUtf8("mLineColorSnapToolButton"))
        self.gridLayout.addWidget(self.mLineColorSnapToolButton, 0, 3, 1, 1)
        self.mLineWidthTextLabel = QtGui.QLabel(self.groupBox_4)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Maximum, QtGui.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mLineWidthTextLabel.sizePolicy().hasHeightForWidth())
        self.mLineWidthTextLabel.setSizePolicy(sizePolicy)
        self.mLineWidthTextLabel.setObjectName(_fromUtf8("mLineWidthTextLabel"))
        self.gridLayout.addWidget(self.mLineWidthTextLabel, 0, 0, 1, 1)
        self.mLineWidthSnapSpinBox = QtGui.QSpinBox(self.groupBox_4)
        self.mLineWidthSnapSpinBox.setMinimum(1)
        self.mLineWidthSnapSpinBox.setObjectName(_fromUtf8("mLineWidthSnapSpinBox"))
        self.gridLayout.addWidget(self.mLineWidthSnapSpinBox, 0, 1, 1, 1)
        self.mLineColorTextLabel = QtGui.QLabel(self.groupBox_4)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Maximum, QtGui.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mLineColorTextLabel.sizePolicy().hasHeightForWidth())
        self.mLineColorTextLabel.setSizePolicy(sizePolicy)
        self.mLineColorTextLabel.setObjectName(_fromUtf8("mLineColorTextLabel"))
        self.gridLayout.addWidget(self.mLineColorTextLabel, 0, 2, 1, 1)
        spacerItem = QtGui.QSpacerItem(128, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.gridLayout.addItem(spacerItem, 0, 4, 1, 1)
        self.groupBox_5 = QtGui.QGroupBox(self.splitter)
        self.groupBox_5.setObjectName(_fromUtf8("groupBox_5"))
        self.gridLayout_2 = QtGui.QGridLayout(self.groupBox_5)
        self.gridLayout_2.setObjectName(_fromUtf8("gridLayout_2"))
        self.mMarkerStyleLabel = QtGui.QLabel(self.groupBox_5)
        self.mMarkerStyleLabel.setObjectName(_fromUtf8("mMarkerStyleLabel"))
        self.gridLayout_2.addWidget(self.mMarkerStyleLabel, 0, 0, 1, 1)
        spacerItem1 = QtGui.QSpacerItem(281, 18, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.gridLayout_2.addItem(spacerItem1, 0, 1, 1, 1)
        self.mMarkerStyleComboBox = QtGui.QComboBox(self.groupBox_5)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mMarkerStyleComboBox.sizePolicy().hasHeightForWidth())
        self.mMarkerStyleComboBox.setSizePolicy(sizePolicy)
        self.mMarkerStyleComboBox.setObjectName(_fromUtf8("mMarkerStyleComboBox"))
        self.mMarkerStyleComboBox.addItem(_fromUtf8(""))
        self.mMarkerStyleComboBox.addItem(_fromUtf8(""))
        self.mMarkerStyleComboBox.addItem(_fromUtf8(""))
        self.mMarkerStyleComboBox.addItem(_fromUtf8(""))
        self.mMarkerStyleComboBox.addItem(_fromUtf8(""))
        self.mMarkerStyleComboBox.addItem(_fromUtf8(""))
        self.gridLayout_2.addWidget(self.mMarkerStyleComboBox, 0, 2, 1, 1)
        self.label_6 = QtGui.QLabel(self.groupBox_5)
        self.label_6.setObjectName(_fromUtf8("label_6"))
        self.gridLayout_2.addWidget(self.label_6, 1, 0, 1, 1)
        spacerItem2 = QtGui.QSpacerItem(281, 18, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.gridLayout_2.addItem(spacerItem2, 1, 1, 1, 1)
        self.mMarkerSizeSpinBox = QtGui.QSpinBox(self.groupBox_5)
        self.mMarkerSizeSpinBox.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.mMarkerSizeSpinBox.setMinimum(3)
        self.mMarkerSizeSpinBox.setSingleStep(2)
        self.mMarkerSizeSpinBox.setObjectName(_fromUtf8("mMarkerSizeSpinBox"))
        self.gridLayout_2.addWidget(self.mMarkerSizeSpinBox, 1, 2, 1, 1)
        self.groupBox_6 = QtGui.QGroupBox(self.snapColorTab)
        self.groupBox_6.setGeometry(QtCore.QRect(10, 160, 470, 64))
        self.groupBox_6.setObjectName(_fromUtf8("groupBox_6"))
        self.gridLayout_3 = QtGui.QGridLayout(self.groupBox_6)
        self.gridLayout_3.setObjectName(_fromUtf8("gridLayout_3"))
        self.mLineWidthTextLabel_2 = QtGui.QLabel(self.groupBox_6)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Maximum, QtGui.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mLineWidthTextLabel_2.sizePolicy().hasHeightForWidth())
        self.mLineWidthTextLabel_2.setSizePolicy(sizePolicy)
        self.mLineWidthTextLabel_2.setObjectName(_fromUtf8("mLineWidthTextLabel_2"))
        self.gridLayout_3.addWidget(self.mLineWidthTextLabel_2, 0, 0, 1, 1)
        self.mLineWidthDimSpinBox = QtGui.QSpinBox(self.groupBox_6)
        self.mLineWidthDimSpinBox.setMinimum(1)
        self.mLineWidthDimSpinBox.setObjectName(_fromUtf8("mLineWidthDimSpinBox"))
        self.gridLayout_3.addWidget(self.mLineWidthDimSpinBox, 0, 1, 1, 1)
        spacerItem3 = QtGui.QSpacerItem(128, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.gridLayout_3.addItem(spacerItem3, 0, 4, 1, 1)
        self.mLineColorTextLabel_2 = QtGui.QLabel(self.groupBox_6)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Maximum, QtGui.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mLineColorTextLabel_2.sizePolicy().hasHeightForWidth())
        self.mLineColorTextLabel_2.setSizePolicy(sizePolicy)
        self.mLineColorTextLabel_2.setObjectName(_fromUtf8("mLineColorTextLabel_2"))
        self.gridLayout_3.addWidget(self.mLineColorTextLabel_2, 0, 2, 1, 1)
        self.mLineColorDimToolButton = QgsColorButtonV2(self.groupBox_6)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.mLineColorDimToolButton.sizePolicy().hasHeightForWidth())
        self.mLineColorDimToolButton.setSizePolicy(sizePolicy)
        self.mLineColorDimToolButton.setMinimumSize(QtCore.QSize(120, 0))
        self.mLineColorDimToolButton.setMaximumSize(QtCore.QSize(120, 16777215))
        self.mLineColorDimToolButton.setText(_fromUtf8(""))
        self.mLineColorDimToolButton.setColor(QtGui.QColor(0, 127, 255, 120))
        self.mLineColorDimToolButton.setAllowAlpha(True)
        self.mLineColorDimToolButton.setDefaultColor(QtGui.QColor(0, 127, 255, 120))
        self.mLineColorDimToolButton.setObjectName(_fromUtf8("mLineColorDimToolButton"))
        self.gridLayout_3.addWidget(self.mLineColorDimToolButton, 0, 3, 1, 1)
        self.tabWidget.addTab(self.snapColorTab, _fromUtf8(""))
        self.verticalLayout.addWidget(self.tabWidget)
        self.buttonBox = QtGui.QDialogButtonBox(CADDigitizeSettings)
        self.buttonBox.setOrientation(QtCore.Qt.Horizontal)
        self.buttonBox.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
        self.buttonBox.setObjectName(_fromUtf8("buttonBox"))
        self.verticalLayout.addWidget(self.buttonBox)
        self.verticalLayout_6.addLayout(self.verticalLayout)

        self.retranslateUi(CADDigitizeSettings)
        self.tabWidget.setCurrentIndex(0)
        self.mMarkerStyleComboBox.setCurrentIndex(3)
        QtCore.QObject.connect(self.buttonBox, QtCore.SIGNAL(_fromUtf8("accepted()")), CADDigitizeSettings.accept)
        QtCore.QObject.connect(self.buttonBox, QtCore.SIGNAL(_fromUtf8("rejected()")), CADDigitizeSettings.reject)
        QtCore.QMetaObject.connectSlotsByName(CADDigitizeSettings)

    def retranslateUi(self, CADDigitizeSettings):
        CADDigitizeSettings.setWindowTitle(_translate("CADDigitizeSettings", "CADDigitize Settings", None))
        self.label_2.setText(_translate("CADDigitizeSettings", "Quadrant segment", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.CircleTab), _translate("CADDigitizeSettings", "Circle", None))
        self.label.setText(_translate("CADDigitizeSettings", "Number of points on ellipse", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.EllipseTab), _translate("CADDigitizeSettings", "Ellipse", None))
        self.label_3.setText(_translate("CADDigitizeSettings", "Number of edges", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.RegPolyTab), _translate("CADDigitizeSettings", "Regular polygon", None))
        self.groupBox.setTitle(_translate("CADDigitizeSettings", "Feature Segmentation", None))
        self.radioFeatureAngle.setText(_translate("CADDigitizeSettings", "Angle", None))
        self.ArcFeatureAngle.setPrefix(_translate("CADDigitizeSettings", "Degree(s) ", None))
        self.radioFeaturePitch.setText(_translate("CADDigitizeSettings", "Pitch", None))
        self.ArcFeaturePitch.setPrefix(_translate("CADDigitizeSettings", "Millimeter(s) ", None))
        self.groupBox_2.setTitle(_translate("CADDigitizeSettings", "Angle Direction", None))
        self.ArcClockWise.setText(_translate("CADDigitizeSettings", "ClockWise", None))
        self.ArcCounterClockWise.setText(_translate("CADDigitizeSettings", "CounterClockWise", None))
        self.groupBox_3.setTitle(_translate("CADDigitizeSettings", "Polygon creation", None))
        self.ArcPolygonChord.setText(_translate("CADDigitizeSettings", "Chord", None))
        self.ArcPolygonPie.setText(_translate("CADDigitizeSettings", "Pie segment", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.ArcTab), _translate("CADDigitizeSettings", "Arcs", None))
        self.groupBox_4.setTitle(_translate("CADDigitizeSettings", "Rubberband - Snapping", None))
        self.mLineWidthTextLabel.setText(_translate("CADDigitizeSettings", "Line width", None))
        self.mLineWidthSnapSpinBox.setToolTip(_translate("CADDigitizeSettings", "Line width in pixels", None))
        self.mLineColorTextLabel.setText(_translate("CADDigitizeSettings", "Line color", None))
        self.groupBox_5.setTitle(_translate("CADDigitizeSettings", "Point markers", None))
        self.mMarkerStyleLabel.setText(_translate("CADDigitizeSettings", "Marker style", None))
        self.mMarkerStyleComboBox.setItemText(0, _translate("CADDigitizeSettings", "No icon", None))
        self.mMarkerStyleComboBox.setItemText(1, _translate("CADDigitizeSettings", "+", None))
        self.mMarkerStyleComboBox.setItemText(2, _translate("CADDigitizeSettings", "x", None))
        self.mMarkerStyleComboBox.setItemText(3, _translate("CADDigitizeSettings", "□", None))
        self.mMarkerStyleComboBox.setItemText(4, _translate("CADDigitizeSettings", "○", None))
        self.mMarkerStyleComboBox.setItemText(5, _translate("CADDigitizeSettings", "■", None))
        self.label_6.setText(_translate("CADDigitizeSettings", "Marker size", None))
        self.groupBox_6.setTitle(_translate("CADDigitizeSettings", "Rubberband - Dimension", None))
        self.mLineWidthTextLabel_2.setText(_translate("CADDigitizeSettings", "Line width", None))
        self.mLineWidthDimSpinBox.setToolTip(_translate("CADDigitizeSettings", "Line width in pixels", None))
        self.mLineColorTextLabel_2.setText(_translate("CADDigitizeSettings", "Line color", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.snapColorTab), _translate("CADDigitizeSettings", "Styles", None))

