# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BulkVectorExportDialog
                                 A QGIS plugin
 export vector layers to common format and crs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-12-08
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Zoltan Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import (uic, QtWidgets, QtCore)
from osgeo import ogr

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'bulkvectorexport_dialog_base.ui'))


class BulkVectorExportDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(BulkVectorExportDialog, self).__init__(parent)
        self.setupUi(self)
        self.dirButton.clicked.connect(self.getDir)
        self.cancelBtn.clicked.connect(self.reject)
        self.okBtn.clicked.connect(self.ok)
        self.supportedDriverList = ['CSV', 'DGN', 'DXF', 'GML', 'GPKG',
            'GPSTrackMaker', 'GeoJSON', 'GEoconcept', 'Interlis 1', 'JML',
            'KML', 'LIBKML', 'ESRI Shapefile', 'MapInfo File', 'ODS', 'OGR_GMT',
            'PGDUMP', 'SQLite', 'VDV', 'XLSX']

    def showEvent(self, event):
        """ set up dialog widgets """
        if self.formatBox.count() == 0:
            # get available ogr driver names which can be created
            driverNameList = []
            for i in range(ogr.GetDriverCount()):
                name = ogr.GetDriver(i).GetName()
                if not name in driverNameList and \
                    name in self.supportedDriverList and \
                    ogr.GetDriver(i).TestCapability(ogr.ODrCCreateDataSource):
                    driverNameList.append(name)
            self.formatBox.addItems(sorted(driverNameList))

    def getDir(self):
        """ select target directory """
        dirName = QtWidgets.QFileDialog.getExistingDirectory(self, \
            "Select Directory")
        # TODO cancel
        self.dirEdit.setText(dirName)

    def ok(self):
        """ check widgets """
        # get target directory
        dirName = self.dirEdit.text().strip()
        if len(dirName) == 0:
            QtWidgets.QMessageBox.critical(self, "BulkVectorExport", \
                "No directory entered")
            return
        if not QtCore.QFileInfo(dirName).isDir():
            QtWidgets.QMessageBox.critical(self, "BulkVectorExport", \
                "No such directory : " + dirName)
            return
        self.accept()
