# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BoundingBoxDialog
                                 A QGIS plugin
 This plugin returns the xmin, ymin, xmax, ymax of the current view window, and the GetMap request of the selected WMS.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-07-10
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Maaka2890
        email                : kkj_15 at hotmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import *
from qgis.gui import *
from qgis.utils import *
from qgis.PyQt.QtCore import QUrl

import os
import sys
import re
from urllib.parse import parse_qs, urlparse

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'BoundingBox_dialog_base.ui'))


class BoundingBoxDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(BoundingBoxDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.GetBB.clicked.connect(self.CalculateBB)
        self.last_wms_requests = {}
        
        # Connect to network access manager to capture WMS requests
        nam = QgsNetworkAccessManager.instance()
        nam.finished.connect(self.captureNetworkReply)
    
    def captureNetworkReply(self, reply):
        """Capture WMS GetMap requests from network replies"""
        url = reply.request().url().toString()
        
        # Check if this is a WMS GetMap request (not GetCapabilities)
        url_lower = url.lower()
        if 'service=wms' in url_lower and 'request=getmap' in url_lower:
            # Parse the URL to extract layer name
            parsed = urlparse(url)
            params_dict = parse_qs(parsed.query, keep_blank_values=True)
            
            # Store the request URL indexed by layer name (case insensitive)
            for key, values in params_dict.items():
                if key.lower() == 'layers' and values:
                    layer_name = values[0].lower()
                    self.last_wms_requests[layer_name] = url
                    break

    def CalculateBB(self):
        xmin=iface.mapCanvas().extent().xMinimum()
        xmax=iface.mapCanvas().extent().xMaximum()
        ymin=iface.mapCanvas().extent().yMinimum()
        ymax=iface.mapCanvas().extent().yMaximum()
        bb1= str(xmin) + ","+str(ymin) + "," +str(xmax) + "," +str(ymax)
        bb=str(bb1)
        self.textOutput.setText(bb)
        layer = iface.activeLayer()

        # Clear any previous warning and hide additional elements
        self.warningLabel.setText("")
        self.actualLabel.setVisible(False)
        self.textOutput_3.setVisible(False)
        self.setFixedHeight(360)

        # Stop here if the user hasn't selected a layer.
        if not layer:
            return

        # The user has selected a layer, try to extract information about it.
        urlsearch = "<tr><td>GetCapabilitiesUrl</td><td>(.+?)</td>"
        urlresult = re.search(urlsearch, layer.htmlMetadata())
        if(urlresult != None):        
            url = urlresult.group(1)
            
            # Clean the URL - remove any existing query parameters
            if '?' in url:
                base_url = url.split('?')[0]
            else:
                base_url = url
            
            versionsearch = "<tr><td>WMS Version</td><td>(.+?)</td>"
            versionresult = re.search(versionsearch, layer.htmlMetadata())
            version = versionresult.group(1)
            crs = iface.activeLayer().crs().authid()
            crs = re.search('(.*)', crs)
            crs= crs.group(1)
            
            # Get the project CRS
            project_crs = iface.mapCanvas().mapSettings().destinationCrs().authid()    
            namesearch = "<tr><td>Name</td><td>(.+?)</td>"
            nameresult = re.search(namesearch, layer.htmlMetadata())
            name= nameresult.group(1)
            width=iface.mapCanvas().size().width()
            width=str(width)
            height=iface.mapCanvas().size().height()
            height=str(height)
            formatsearch = "<tr><td>Image Formats</td><td>(.+?)</td>"
            formatresult = re.search(formatsearch, layer.htmlMetadata())
            format = formatresult.group(1)
            format = format.split('<')[0]
            getmap= base_url + "?service=WMS&request=GetMap&version="+version +"&BGCOLOR=0xFFFFFF"+"&crs="+project_crs+"&bbox=" +bb +"&layers=" +name +"&styles=&width=" +width +"&height=" +height +"&format=" +format
            self.textOutput_2.setText(getmap)
            
            # Check if WMS CRS matches project CRS
            if crs != project_crs:
                self.warningLabel.setText(f"⚠ Warning: WMS EPSG ({crs}) does not match Project EPSG ({project_crs})")
                self.setFixedHeight(550)
                self.actualLabel.setVisible(True)
                self.textOutput_3.setVisible(True)
                
                # Force a layer refresh to trigger a new network request
                layer.triggerRepaint()
                
                # Try to get the actual request from captured network traffic
                layer_name_lower = name.lower()
                
                if layer_name_lower in self.last_wms_requests:
                    # Display the captured network request directly
                    self.textOutput_3.setText(self.last_wms_requests[layer_name_lower])
                else:
                    # Show message to pan/zoom
                    self.textOutput_3.setText("Please pan or zoom to trigger a request. Then press Get BBOX button again.")

