# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BoundingBoxDialog
                                 A QGIS plugin
 This plugin returns the xmin, ymin, xmax, ymax of the current view window, and the GetMap request of the selected WMS.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-07-10
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Maaka2890
        email                : kkj_15@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import *
from qgis.gui import *
from qgis.utils import *

import os
import sys
import re

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'BoundingBox_dialog_base.ui'))


class BoundingBoxDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(BoundingBoxDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.GetBB.clicked.connect(self.CalculateBB)
    def CalculateBB(self):
        xmin=iface.mapCanvas().extent().xMinimum()
        xmax=iface.mapCanvas().extent().xMaximum()
        ymin=iface.mapCanvas().extent().yMinimum()
        ymax=iface.mapCanvas().extent().yMaximum()
        bb1= str(xmin) + ","+str(ymin) + "," +str(xmax) + "," +str(ymax)
        bb=str(bb1)
        self.textOutput.setText(bb)
        layer = iface.activeLayer()
        urlsearch = "<tr><td>GetCapabilitiesUrl</td><td>(.+?)</td>"
        urlresult = re.search(urlsearch, layer.htmlMetadata())
        url = urlresult.group(1)
        versionsearch = "<tr><td>WMS Version</td><td>(.+?)</td>"
        versionresult = re.search(versionsearch, layer.htmlMetadata())
        version = versionresult.group(1)
        crs = iface.activeLayer().crs().authid()
        crs = re.search('(.*)', crs)
        crs= crs.group(1)
        namesearch = "<tr><td>Name</td><td>(.+?)</td>"
        nameresult = re.search(namesearch, layer.htmlMetadata())
        name= nameresult.group(1)
        width=iface.mapCanvas().size().width()
        width=str(width)
        height=iface.mapCanvas().size().height()
        height=str(height)
        formatsearch = "<tr><td>Image Formats</td><td>(.+?)</td>"
        formatresult = re.search(formatsearch, layer.htmlMetadata())
        format = formatresult.group(1)
        format = format.split('<')[0]
        getmap= url + "service=WMS&request=GetMap&version="+version +"&BGCOLOR=0xFFFFFF"+"&crs="+crs+"&bbox=" +bb +"&layers=" +name +"&width=" +width +"&height=" +height +"&format=" +format
        self.textOutput_2.setText(getmap)

