# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5.QtGui import QIcon
from qgis.core import QgsMapLayerProxyModel, Qgis
from qgis.gui import QgsFileWidget

from ..qgis_lib_mc import (utils, qgsUtils, abstract_model, qgsTreatments, feedbacks, styles)
from . import params, subnetworks

import time
import os, sys

cost_fields = ["start_layer","perm_layer","cost","out_layer"]

# CostItem implements DictItem and contains below fields :
#   - 'start_layer' : vector layer containing starting points
#   - 'perm_layer' : raster layer containing cost for each pixel
#   - 'cost' : maximal cost
class CostItem(abstract_model.DictItem):

    FIELDS = [ "start_layer", "perm_layer", "cost", "out_layer" ]

    @classmethod
    def fromValues(cls,start_layer,perm_layer,cost,out_layer):
        dict = {"start_layer" : start_layer,
                "perm_layer" : perm_layer,
                "cost" : cost,
                "out_layer" : out_layer}
        item = cls(dict)
        return item
        
    def equals(self,other):
        same_start = self.dict["start_layer"] == other.dict["start_layer"]
        same_perm = self.dict["perm_layer"] == other.dict["perm_layer"]
        same_cost = self.dict["cost"] == other.dict["cost"]
        return (same_start and same_perm and same_cost)
            
    def checkItem(self):
        pass
        
class CostModel(abstract_model.DictModel):
    
    def __init__(self,bdModel):
        self.is_runnable = True
        self.bdModel = bdModel
        itemClass = getattr(sys.modules[__name__], CostItem.__name__)
        super().__init__(itemClass,feedback=bdModel.feedback)
    
    def mkItemFromDict(self,dict):
        utils.checkFields(cost_fields,dict.keys())
        item = CostItem(dict)
        return item
        
    def applyItemWithContext(self,item,context,feedback):
        feedback.pushDebugInfo("Start runCost")
        # Parameters
        start_layer_path = self.bdModel.getOrigPath(item.dict["start_layer"])
        start_layer, start_layer_type = qgsUtils.loadLayerGetType(start_layer_path)
        feedback.pushDebugInfo("Start layer " + str(start_layer_path)
                               + " of type " + str(start_layer_type))
        cost = item.dict["cost"]
        perm_raster_path = self.bdModel.getOrigPath(item.dict["perm_layer"])
        out_path = self.bdModel.getOrigPath(item.dict["out_layer"])
        qgsUtils.removeLayerFromPath(out_path)
        qgsUtils.removeRaster(out_path)
        tmp_path = utils.mkTmpPath(out_path,suffix="_disp_tmp")
        qgsUtils.removeRaster(tmp_path)
        start_raster_path = utils.mkTmpPath(out_path,suffix="_start")
        qgsUtils.removeRaster(start_raster_path)
        # Feedback
        out_name =  os.path.basename(out_path)
        feedback.setProgressText(" " + str(out_name))
        step_feedback = feedbacks.ProgressMultiStepFeedback(10,feedback)
        step_feedback.setCurrentStep(0)
        # Processing
        crs, extent, resolution = self.bdModel.getRasterParams()
        if start_layer_type == 'Raster':
            # Warp : 'near' resampling, output type = input type
            # qgsTreatments.applyWarpReproject(start_layer_path,start_raster_path,"near",crs.authid(),
                                             # extent=extent,extent_crs=crs,resolution=resolution,
                                             # out_type=-1,context=context,feedback=step_feedback)
            startR = start_layer_path
            nodata = start_layer.dataProvider().sourceNoDataValue(1)
        else:
            # Burning all vals to 1, nodata 0, Byte data type
            startR = qgsUtils.mkTmpPath("startR.tif")
            nodata = 0
            qgsTreatments.applyRasterization(start_layer_path,startR,extent,resolution,
                                             burn_val=1,out_type=Qgis.Byte,nodata_val=nodata,all_touch=False,
                                             context=context,feedback=step_feedback)
        self.bdModel.paramsModel.normalizeRaster(startR,
            out_path=start_raster_path,nodata_val=nodata,
            context=context,feedback=step_feedback)
        step_feedback.setCurrentStep(1)
        qgsTreatments.applyRCost(start_raster_path,perm_raster_path,cost,tmp_path,
                                 context=context,feedback=step_feedback)
        step_feedback.setCurrentStep(9)
        qgsTreatments.applyRasterCalcLE(tmp_path,out_path,cost,context=context,feedback=step_feedback)
        if os.path.isfile(tmp_path):
            qgsUtils.removeRaster(tmp_path)
        step_feedback.setCurrentStep(10)
        loaded_layer = qgsUtils.loadRasterLayer(out_path,loadProject=True)
        styles.setRandomColorRasterRenderer(loaded_layer)
        feedback.pushDebugInfo("End runCost")
        
    def applyItemsWithContext(self,context,feedback,indexes):
        feedback.beginSection("Computing dispersal")
        self.bdModel.paramsModel.checkInit()
        if not indexes:
            utils.internal_error("No indexes in Cost applyItems")
        nb_items = len(indexes)
        step_feedback = feedbacks.ProgressMultiStepFeedback(nb_items,feedback)
        curr_step = 0
        for n in indexes:
            i = self.items[n]
            self.applyItemWithContext(i,context,step_feedback)    
            curr_step += 1
            step_feedback.setCurrentStep(curr_step)        
            #i.applyItem(self.bdModel.stModel)
            #progress_section.next_step()
        feedback.endSection()
        
class CostConnector(abstract_model.AbstractConnector):

    def __init__(self,dlg,costModel):
        self.dlg = dlg
        self.onlySelection = False
        super().__init__(costModel,self.dlg.costView,
                         self.dlg.costAdd,self.dlg.costRemove,
                         self.dlg.costRun,self.dlg.costRunOnlySelection)
        
    def initGui(self):
        #self.dlg.costStartLayerCombo.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.dlg.costStartLayer.setFilter(qgsUtils.getVectorFilters())
        self.dlg.costPermRasterCombo.setFilters(QgsMapLayerProxyModel.RasterLayer)
        self.dlg.costPermRaster.setFilter("*.tif")
        self.dlg.costOutLayer.setFilter("*.tif")
        self.dlg.costOutLayer.setStorageMode(QgsFileWidget.SaveFile)
        
    def connectComponents(self):
        super().connectComponents()
        self.dlg.costStartLayer.fileChanged.connect(self.setStartLayer)
        self.dlg.costPermRaster.fileChanged.connect(self.setPermRaster)
        
    def switchST(self,text):
        st_item = self.model.bdModel.stModel.getSTByName(text)
        st_friction_path = st_item.getFrictionPath()
        self.dlg.costPermRaster.lineEdit().setValue(st_friction_path)
        
    def setStartLayer(self,path):
        utils.debug("setStartLayer : " + path)
        layer = qgsUtils.loadLayer(path,loadProject=True)
        self.dlg.costStartLayerCombo.setLayer(layer)
        
    def setPermRaster(self,path):
        layer = qgsUtils.loadRasterLayer(path,loadProject=True)
        self.dlg.costPermRasterCombo.setLayer(layer)
        
    def setStartLayerFromCombo(self,layer):
        utils.debug("setStartLayerFromCombo")
        if layer:
            path = qgsUtils.pathOfLayer(layer)
            self.dlg.costStartLayer.lineEdit().setValue(path)
        
    def setPermRasterFromCombo(self,layer):
        utils.debug("setPermRasterFromCombo")
        if layer:
            path = qgsUtils.pathOfLayer(layer)
            self.dlg.costPermRaster.lineEdit().setValue(path)
        
    def mkItem(self):
        start_layer = self.dlg.costStartLayerCombo.currentLayer()
        if not start_layer:
            utils.user_error("No start layer selected")
        start_layer_path = self.model.bdModel.normalizePath(qgsUtils.pathOfLayer(start_layer))
        perm_layer = self.dlg.costPermRasterCombo.currentLayer()
        if not perm_layer:
            utils.user_error("No permability layer selected")
        perm_layer_path = self.model.bdModel.normalizePath(qgsUtils.pathOfLayer(perm_layer))
        cost = str(self.dlg.costMaxVal.value())
        out_layer_path = self.model.bdModel.normalizePath(self.dlg.costOutLayer.filePath())
        cost_item = CostItem.fromValues(start_layer_path,perm_layer_path,cost,out_layer_path)
        return cost_item
        
