# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import csv
import os

from PyQt5.QtCore import Qt, QModelIndex
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QFileDialog
from qgis.core import Qgis
from qgis.gui import QgsFileWidget

from ..qgis_lib_mc import utils, qgsUtils, qgsTreatments, feedbacks, styles
from ..qgis_lib_mc.abstract_model import DictItem, ExtensiveTableModel, AbstractConnector, ComboDelegate

from . import params, subnetworks, classes
# from .classes import ClassItem


class FrictionRowItem(DictItem):

    def __init__(self,dict):
        super().__init__(dict)
            

class FrictionModel(ExtensiveTableModel):

    ROW_NAME = 'class'
    ROW_DESCR = 'class_descr'
    BASE_FIELDS = [ ROW_NAME, ExtensiveTableModel.ROW_CODE, ROW_DESCR ]
    
    def __init__(self,parentModel):
        self.parser_name = "FrictionModel"
        self.is_runnable = False
        ExtensiveTableModel.__init__(self,parentModel,idField=self.ROW_NAME,
            rowIdField=classes.ClassItem.idField,baseFields=self.BASE_FIELDS)
        self.feedback.pushDebugInfo("hey")
        
    def reload(self):
        colNames = self.parentModel.speciesModel.getNames()
        
    def getFreeVals(self,nbVals):
        codes = [ i.dict[self.ROW_CODE] for i in self.items ]
        freeVals = getIntValues(nbVals)
        return freeVals
        
    def getHeaderStr(self,col):
        if col < 2:
            h = [self.tr('Value'),self.tr('Description')]
            return h
        return None
        
    def flags(self, index):
        if index.column() in [0,1]:
            flags = Qt.ItemIsSelectable | Qt.ItemIsEnabled
        else:
            flags = Qt.ItemIsSelectable | Qt.ItemIsEnabled | Qt.ItemIsEditable
        return flags
        
    # Creates FrictionItem from ClassItem
    def createRowFromBaseRow(self,classItem):
        d = { self.ROW_NAME : classItem.getName(),
              self.ROW_CODE : classItem.getCode(),
              self.ROW_DESCR : classItem.getDescr() }
        return self.createRowFromDict(d)
    # Reload items of model to match current ClassModel.
    def reloadClasses(self):
        utils.debug("reloadClasses")
        super().reloadModel(self.parentModel.classModel.items)
        # classes_to_delete = []
        # for item in self.items:
            # cls_name = item.dict[self.ROW_NAME]
            # cls_item = self.parentModel.classModel.getClassByName(cls_name)
            # if not cls_item:
                # classes_to_delete.append(cls_name)
                # utils.debug("Removing class " + str(cls_name))
            # else:
                # utils.debug("Class " + cls_name + " indeed exists")
        # self.items = [fr for fr in self.items if fr.dict[self.ROW_NAME] not in classes_to_delete]
        # self.layoutChanged.emit()
        # for cls_item in self.parentModel.classModel.items:
            # utils.debug("cls_item : " + str(cls_item.dict))
            # cls_name = cls_item.getName()
            # cls_code = cls_item.getCode()
            # cls_descr = cls_item.getDescr()
            # row_item = self.getRowByName(cls_name)
            # if row_item:
                # utils.debug("row_item : " + str(row_item.dict))
                # utils.debug("Class " + str(cls_name) + " already exists")
                # if row_item.dict[self.ROW_CODE] != cls_code:
                    # utils.debug("Reassigning code '" + str(cls_code) + "' instead of '"
                                # + str(row_item.dict[self.ROW_CODE]) + " to class " + cls_name)
                    # row_item.dict[self.ROW_CODE] = cls_code
                    # self.layoutChanged.emit()
                # if cls_descr and row_item.dict[self.ROW_DESCR] != cls_descr:
                    # utils.debug("Reassigning descr '" + str(cls_descr) + "' instead of '"
                                # + str(row_item.dict[self.ROW_DESCR]) + " to class " + cls_name)
                    # row_item.dict[self.ROW_DESCR] = cls_descr
                    # self.layoutChanged.emit()
            # else:
                # utils.debug("Reloading class " + cls_name)
                # self.addRowItemFromBase(cls_item)
                # self.layoutChanged.emit()
                
    # Computes friction layer for each item.
    def applyItemsWithContext(self,context,feedback,indexes):
        feedback.beginSection("Friction")
        self.parentModel.paramsModel.checkInit()
        all_st = self.parentModel.stModel.getSTList()
        nbBaseFields = len(self.baseFields)
        st_list = [all_st[idx - nbBaseFields] for idx in indexes]
        feedback.pushDebugInfo("st_list = " + str(st_list))
        reclass_matrixes = self.getReclassifyMatrixes(st_list)
        nb_items = len(reclass_matrixes)
        step_feedback = feedbacks.ProgressMultiStepFeedback(nb_items,feedback)
        curr_step = 0
        feedback.pushDebugInfo("reclass_matrixes = " + str(reclass_matrixes))
        for st_name, matrix in reclass_matrixes.items():
            feedback.setProgressText("computing subnetwork '" + st_name + "'")
            feedback.pushInfo("Friction computation for subnetwork " + str(st_name))
            in_path = self.parentModel.stModel.getMergedPath(st_name)
            utils.checkFileExists(in_path)
            out_path = self.parentModel.stModel.getFrictionPath(st_name)
            qgsUtils.removeLayerFromPath(out_path)
            qgsUtils.removeRaster(out_path)
            self.checkInVals(in_path)
            qgsTreatments.applyReclassifyByTable(in_path,matrix,out_path,
                out_type=Qgis.Float32,boundaries_mode=2,
                context=context,feedback=step_feedback)
            loaded_layer = qgsUtils.loadRasterLayer(out_path,loadProject=True)
            styles.setRendererPalettedGnYlRd(loaded_layer)
            curr_step += 1
            step_feedback.setCurrentStep(curr_step)
        feedback.endSection()
           
           
class FrictionConnector(AbstractConnector):
    
    CUSTOM_MODE = 0
    EXP_MODE = 1
    CONNEX_MODE = 2
    
    def __init__(self,dlg,frictionModel):
        self.dlg = dlg
        super().__init__(frictionModel,self.dlg.frictionView,
                         selectionCheckbox=self.dlg.frictRunOnlySelection)
        
    def initGui(self):
        pass
        
    def connectComponents(self):
        super().connectComponents()
        self.dlg.frictionLoadClass.clicked.connect(self.model.reloadClasses)
        self.dlg.frictionRun.clicked.connect(self.applyItems)
        self.dlg.frictionSave.clicked.connect(self.saveCSVAction)
        self.dlg.frictionLoad.clicked.connect(self.loadCSVAction)
        self.dlg.frictionMethod.currentIndexChanged.connect(self.switchClassifMode)
        
    # Return indexes currently selected in friction view
    def getSelectedIndexes(self):
        nbBaseFields = len(self.model.baseFields)
        if self.onlySelection:
            indexes = list(set([i.column() for i in self.view.selectedIndexes()]))
        else:
            indexes = range(nbBaseFields,len(self.model.fields))
        nb_indexes = len(indexes)
        if nb_indexes == 0:
            utils.user_error("No subnetwork selected for friction step")
        nb_st = len(self.model.parentModel.stModel.getSTList())
        utils.debug("nb_st = " + str(nb_st))
        for idx in indexes:
            st_idx = idx - nbBaseFields
            if st_idx < 0 or st_idx >= nb_st:
                utils.user_error("Column " + str(idx) + " selected is not a subnetwork")
        return indexes
        
    # Updates model with items loaded from file 'fname'
    def loadCSV(self,fname):
        utils.checkFileExists(fname)
        self.model.fromCSV(fname)
        utils.info("Friction loaded from '" + str(fname))
        
    # Opens file dialog and loads model from selected CSV file.
    def loadCSVAction(self):
        utils.debug("loadCSVAction " + str(self))
        fname = qgsUtils.openFileDialog(parent=self.dlg,
                                      msg=self.tr("Open CSV file"),
                                      filter="*.csv")
        if fname:
            self.loadCSV(fname)
            
    def saveCSV(self,fname):
        self.model.saveCSV(fname)
     
    def saveCSVAction(self):
        utils.debug("saveCSVAction")
        fname = qgsUtils.saveFileDialog(parent=self.dlg,
                                      msg="Save friction as CSV file",
                                      filter="*.csv")
        if fname:
            self.saveCSV(fname)
            
    def switchClassifMode(self,mode):
        # CUSTOM_MODE = 0 EXP_MODE = 1 CONNEX_MODE = 2
        if mode == self.CUSTOM_MODE:
            self.switchCustomMode()
        elif mode == self.EXP_MODE:
            self.switchExpMode()
        elif mode == self.CONNEX_MODE:
            self.switchConnexMode()
        else:
            utils.user_error(self.tr("Unexpected mode : ") + str(mode))
            
    def switchCustomMode(self):
        # self.dlg.frictionClassFrame.setEnabled(False)
        # self.dlg.frictionMinMaxFrame.setEnabled(False)
        self.setValues(None)
            
    def switchExpMode(self):
        # self.dlg.frictionClassFrame.setEnabled(True)
        # self.dlg.frictionMinMaxFrame.setEnabled(True)
        # nbClass = self.getNbClasses()
        # minVal = self.dlg.frictionMinVal.value()
        # maxVal = self.dlg.frictionMaxVal.value()
        self.setValues(None)
            
    def switchConnexMode(self):
        # self.dlg.frictionClassFrame.setEnabled(True)
        # self.dlg.frictionMinMaxFrame.setEnabled(False)
        # nbClass = self.getNbClasses()
        # self.setValues(range(1,nbClass))
        pass
        
    def getNbClasses(self):
        return self.dlg.frictionNbClass.value()
        
    def setValues(self,values):
        self.model.setValues(values)
        self.view.setItemDelegate(ComboDelegate(values))
        self.model.layoutChanged.emit()
