# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later *******************************************/
"""
    
from PyQt5.QtCore import QCoreApplication, QVariant
from qgis.core import (Qgis,
                       QgsFields,
                       QgsField,
                       QgsProcessing,
                       QgsProcessingUtils,
                       QgsProcessingAlgorithm,
                       QgsProcessingException,
                       QgsProcessingMultiStepFeedback,
                       QgsProcessingParameterDefinition,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterMatrix,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterString,
                       QgsProcessingParameterField,
                       QgsProcessingParameterRange,
                       QgsProcessingParameterVectorDestination,
                       QgsProcessingParameterRasterDestination,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterFolderDestination,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterMapLayer,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterFile)

import processing
from processing.algs.gdal.rasterize import rasterize

from ..qgis_lib_mc import utils, qgsUtils, qgsTreatments, feedbacks, styles
    
class GraphabAlgorithm(qgsUtils.BaseProcessingAlgorithm):
    def tr(self, string):
       return QCoreApplication.translate(self.__class__.__name__, string)
    def group(self):
        return self.tr("Graphab")
    def groupId(self):
        return 'graphab'
    
class ExportToGraphab(GraphabAlgorithm):

    ALG_NAME = 'exporttographab'
        
    def name(self):
        return self.ALG_NAME
        
    def displayName(self):
        return self.tr('Export to Graphab')
        
    def shortHelpString(self):
        return self.tr('Ensures that friction layer is compatible with Graphab.')

    def initAlgorithm(self, config=None):
        self.addParameter(
            QgsProcessingParameterRasterLayer(
                self.INPUT,
                description=self.tr('Input layer (friction)')))
        self.addParameter(
            QgsProcessingParameterRasterDestination(
                self.OUTPUT,
                self.tr("Exported layer (friction)")))
                
    def processAlgorithm(self,parameters,context,feedback):
        input = self.parameterAsRasterLayer(parameters,self.INPUT,context)
        if input is None:
            raise QgsProcessingException(self.invalidRasterError(parameters, self.INPUT))
        output = self.parameterAsOutputLayer(parameters, self.OUTPUT, context)
        input_nodata_val = input.dataProvider().sourceNoDataValue(1)
        feedback.pushDebugInfo("Input NoData value = " + str(input_nodata_val))
        #input_vals = qgsUtils.getRasterValsBis(input)
        input_vals = qgsTreatments.getRasterUniqueVals(input,feedback)
        feedback.pushDebugInfo("Input values = " + str(input_vals))
        if input_vals == []:
            raise QgsProcessingException("Empty input layer (no input values)")
        for v in input_vals:
            if v <= 0:
                raise QgsProcessingException("Input layer contains value '"
                        + str(v) + "', but Graphab expects strictly positive (> 0) values")
                
        if input_nodata_val == 0 and 0 in input_vals:
            raise QgsProcessingException("Input layer contains value 0, but 0 represents NoData in Graphab")
        tmp = QgsProcessingUtils.generateTempFilename('tmp.tif')
        qgsTreatments.applyRNull(input,0,tmp,context,feedback)
        qgsTreatments.applyRSetNull(tmp,0,output,context,feedback)
        return {'OUTPUT' : output }
    
    