# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys
import traceback
from io import StringIO
import locale

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtCore import QTranslator, qVersion, QCoreApplication
from qgis.gui import QgsFileWidget
from qgis.core import QgsApplication, QgsProcessingContext

file_dir = os.path.dirname(__file__)
if file_dir not in sys.path:
    sys.path.append(file_dir)
    
#from .BioDispersalAbout_dialog import BioDispersalAboutDialog
from .qgis_lib_mc import (utils, qgsUtils, config_parsing, log, feedbacks, abstract_model)
from .steps import (params, subnetworks, classes, groups, selection, fusion, friction, ponderation, cost)
from . import tabs
from .BioDispersal_model import BioDispersalModel

#from BioDispersal_dialog_base import Ui_BioDispersalDialogBase as DLG_CLASS
DLG_CLASS, _ = uic.loadUiType(os.path.join(
 os.path.dirname(__file__), 'BioDispersal_dialog_base.ui'))

#from BioDispersalAbout_dialog_base import Ui_BioDispersalAbout as ABOUT_DLG_CLASS
ABOUT_DLG_CLASS, _ = uic.loadUiType(os.path.join(
 os.path.dirname(__file__), 'BioDispersalAbout_dialog_base.ui'))

class BioDispersalAboutDialog(QtWidgets.QDialog,ABOUT_DLG_CLASS):
    def __init__(self,parent=None):
        #super(ABOUT_DLG_CLASS).__init__(parent)
        super(BioDispersalAboutDialog, self).__init__(parent)
        self.setupUi(self)

class BioDispersalDialog(abstract_model.MainDialog,DLG_CLASS):

    pluginName = 'BioDispersal'

    def __init__(self, parent=None):
        """Constructor."""
        super(BioDispersalDialog, self).__init__(parent)
        #super().__init__()
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
    # Initialize plugin tabs and connectors.
    def initTabs(self):
        #global progressFeedback, paramsModel
        logConnector = log.LogConnector(self)
        logConnector.initGui()
        self.feedback =  feedbacks.ProgressFeedback(self)
        #feedbacks.progressFeedback = self.feedback
        self.context = QgsProcessingContext()
        self.context.setFeedback(self.feedback)
        self.bdModel = BioDispersalModel(self.context,self.feedback)
        self.pluginModel = self.bdModel
        #################
        self.paramsConnector = params.ParamsConnector(self,self.bdModel.paramsModel)
        self.stConnector = subnetworks.STConnector(self,self.bdModel.stModel)
        self.groupsConnector = groups.GroupConnector(self,self.bdModel.groupsModel)
        self.classConnector = classes.ClassConnector(self,self.bdModel.classModel)
        self.selectionConnector = selection.SelectionConnector(self,self.bdModel.selectionModel)
        self.fusionConnector = fusion.FusionConnector(self,self.bdModel.fusionModel)
        self.frictionConnector = friction.FrictionConnector(self,self.bdModel.frictionModel)
        self.ponderationConnector = ponderation.PonderationConnector(self,self.bdModel.ponderationModel)
        self.costConnector = cost.CostConnector(self,self.bdModel.costModel)
        self.tabConnector = tabs.TabConnector(self)
        # self.connectors = {"Params" : self.paramsConnector,
                           # "ST" : self.stConnector,
                           # "Group" : self.groupsConnector,
                           # "Class" : self.classConnector,
                           # "Selection" : self.selectionConnector,
                           # "Fusion" : self.fusionConnector,
                           # "Friction" : self.frictionConnector,
                           # "Ponderation" : self.ponderationConnector,
                           # "Cost" : self.costConnector,
                           # "Log" : logConnector,
                           # "Progress" : self.feedback,
                           # "Tabs" : self.tabConnector}
        self.connectors = [
            self.paramsConnector,
            self.stConnector,
            self.groupsConnector,
            self.classConnector,
            self.selectionConnector,
            self.fusionConnector,
            self.frictionConnector,
            self.ponderationConnector,
            self.costConnector,
            logConnector,
            self.feedback,
            self.tabConnector ]
        self.recomputeParsers()
        
    def tr(self, message):
        return QCoreApplication.translate('BioDispersal_dialog', message)

    def loadHelp(self,widget,prefix,lang):
        #utils.info("loadHelp " + prefix)
        plugin_dir = os.path.dirname(__file__)
        msg_path = os.path.join(plugin_dir,'help', prefix + '-' + str(lang) + '.html')
        with open(msg_path) as f:
            msg = f.read()
        widget.setText(msg)
    
    def openHelpDialog(self):
        #utils.debug("openHelpDialog")
        about_dlg = BioDispersalAboutDialog(self)
        #about_dlg = ABOUT_DLG_CLASS(self)
        about_dlg.show()
        self.loadHelp(about_dlg.aboutLabel,'about',self.curr_language)
        
    def switchLang(self,lang):
        self.curr_language = lang
        super().switchLang(lang)
        self.loadHelp(self.homeLabel,'home',lang)
        
    # Recompute self.parsers in case they have been reloaded
    # TODO
    def recomputeParsers(self):
        self.parsers = [ self.bdModel.paramsModel,
                         self.bdModel.stModel,
                         self.bdModel.classModel,
                         self.bdModel.groupsModel,
                         self.bdModel.selectionModel,
                         self.bdModel.fusionModel,
                         self.bdModel.frictionModel,
                         self.bdModel.ponderationModel,
                         self.bdModel.costModel ]
