# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os, sys

from PyQt5.QtSql import QSqlRecord, QSqlTableModel, QSqlField
from PyQt5.QtCore import Qt, QVariant, QAbstractTableModel, QModelIndex, pyqtSignal
from qgis.gui import QgsFileWidget

from ..qgis_lib_mc import (utils, qgsUtils, abstract_model)
from . import params
         
# Class model is static so that it can be modified by dependant modules suchs as config parsing
# classModel = None

# def getClassLayer(grp):
    # clsItem = classModel.getClassByName(out_name)
    # cls_layer = clsItem.getLayer()
    # return cls_layer
    
# def getClassByName(class_name):
    # for cls in classModel.items:
        # if cls.name == class_name:
            # return cls
    # return None
    
# ClassItem implements DictItem and contains below fields :
#   - 'name' : class name (identifier, unique in model)
#   - 'descr' : class textual description
#   - 'code' : class identifier in raster layers (automatically generated)
class ClassItem(abstract_model.DictItem):
    
    FIELDS = ["name","code","descr","group"]
    idField = "name"
    
    # @classmethod
    # def fromValues(cls,name,descr,code,group):
        # if code == None:
            # code = classModel.getFreeCode()
        # else:
            # try:
                # code = int(code)
            # except TypeError:
                # utils.user_error("Could not build class item from code '" + str(code)+ "'")
        # dict = {"name" : name,
                # "code": code,
                # "descr" : descr,
                # "group" : group}
        # utils.debug("dict = " + str(dict))
        # utils.debug("dict.type = " + str(type(dict)))
        # return cls(dict=dict)
        
    def getName(self):
        return self.dict["name"]
    def getCode(self):
        return self.dict["code"]
    def getDescr(self):
        return self.dict["descr"]
        
    def checkItem(self):
        utils.checkName(self,prefix="Class")
        if not self.dict["descr"]:
            utils.warn("Class '" + self.getName() + "' with empty description")
        
    def equals(self,other):
        return (self.dict["name"] == other.dict["name"])
        
    def getFieldValue(self):
        name = self.dict["name"]
        group = self.dict["group"]
        prefix = str(group) + "_"
        if not name.startswith(prefix):
            utils.internal_error("Attempt to get field value from ill-formed class "
                + str(name) + " of group " + str(group))
        val = name[len(prefix):]
        if not val:
            assert(False)
        return val
            
# ClassModel implements DictModel with ClassItem items
# Signals 'classAdded' and 'classRemoved' are emitted on item addition/deletion
class ClassModel(abstract_model.DictModel):

    # classAdded = pyqtSignal('PyQt_PyObject')
    # classAdded2 = pyqtSignal()
    # classRemoved = pyqtSignal('PyQt_PyObject')
    
    def __init__(self,bdModel):
        self.is_runnable = False
        self.bdModel = bdModel
        itemClass = getattr(sys.modules[__name__], ClassItem.__name__)
        super().__init__(itemClass,feedback=bdModel.feedback)
        
    def mkItemFromDict(self,dict):
        utils.checkFields(self.fields,dict.keys())
        item = ClassItem(dict["name"],dict["descr"],dict["code"],dict["group"])
        return item
        
    def getClassByName(self,name):
        for i in self.items:
            if i.dict["name"] == name:
                return i
        return None
        
    def getClassesOfGroup(self,grp_name):
        class_items = [i for i in self.items if i.dict["group"] == grp_name]
        return class_items
        
    def getMatrixOfGroup(self,grp_name):
        classes = self.getClassesOfGroup(grp_name)
        tups = [(c.getFieldValue(), c.dict["code"]) for c in classes]
        matrix = [ item for tup in tups for item in tup ]
        return matrix
        
    def getReclassifyMatrixOfGroup(self,grp_name):
        classes = self.getClassesOfGroup(grp_name)
        tups = [(c.getFieldValue(), c.getFieldValue(), c.dict["code"]) for c in classes]
        matrix = [ item for tup in tups for item in tup ]
        return matrix
        
    def codeExists(self,n):
        for i in self.items:
            if int(i.dict["code"]) == n:
                return True
        return False
            
    def getFreeCode(self):
        cpt = 1
        while True:
            if not self.codeExists(cpt):
                return cpt
            cpt += 1
            
    def addRowFromClassItem(self,item):
        self.addItem(item)
        self.bdModel.addClass(item)
        
    def removeFromGroupName(self,name):
        indexes = []
        names = []
        codes = []
        cpt = 0
        for cpt, item in enumerate(self.items):
            if item.dict["group"] == name:
                indexes.append(cpt)
                names.append(item.dict["name"])
                # codes.append(item.dict[ClassItem.idField])
            cpt += 1
        self.removeItemsFromRows(indexes) 
        for n in names:
            self.bdModel.removeClass(n)
        # for c in codes:
            # self.bdModel.removeClass(c)
         
    def removeItems(self,indexes):
        names = [self.items[idx.row()].dict["name"] for idx in indexes]
        super().removeItems(indexes)
        for n in names:
            self.bdModel.removeClass(n)
            #self.classRemoved.emit(n)
            
    def flags(self, index):
        if index.column() == 0:
            flags = Qt.ItemIsSelectable | Qt.ItemIsEnabled
        else:
            flags = Qt.ItemIsSelectable | Qt.ItemIsEnabled | Qt.ItemIsEditable
        return flags
            
    # def getReclassDict(self,group_name):
        # reclass_dict = {}
        # grp_classes = [ item for item in self.items if item.dict["group"] == group_name ]
        # for cls_item in grp_classes:
            # class_name = cls_item.dict["name"]
            # if group_name not in class_name:
                # utils.internal_error("Inconsistent class/group : " + str(class_name) + " - " + str(group_name))
            # len_grp = len(group_name)
            # assert(len(class_name) > len_grp)
            # val = class_name[len_grp+1:]
            # reclass_dict[val] = cls_item.dict["code"]
        # assert(len(reclass_dict) > 0)
        # return reclass_dict

class ClassConnector(abstract_model.AbstractConnector):

    def __init__(self,dlg,classModel):
        self.dlg = dlg
        super().__init__(classModel,self.dlg.classView,
                         None,self.dlg.classRemove)
        # super().__init__(classModel,self.dlg.classView,
                         # self.dlg.selectionClassAdd,self.dlg.classRemove)
        
    def initGui(self):
        pass
        
    def connectComponents(self):
        super().connectComponents()

    # Classes are created in selection tab.
    # No code given so that it be automatically generated.
    # def mkItem(self):
        # name = self.dlg.selectionClassName.text()
        # self.dlg.selectionClassCombo.setCurrentText(name)
        # descr = self.dlg.selectionClassDescr.text()
        # code = self.model.getFreeCode()
        # grp = self.dlg.selectionGroupCombo.
        # classItem = ClassItem(name,descr,code)
        # return classItem
         
