# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import copy
import subprocess
import os.path
import xml.etree.ElementTree as ET

from qgis.core import Qgis, QgsProject
from PyQt5.QtCore import QModelIndex, pyqtSlot
from PyQt5.QtGui import QIcon

from ..qgis_lib_mc import utils, qgsUtils, xmlUtils, qgsTreatments, abstract_model, feedbacks, config_parsing
from . import params, subnetworks, groups

fusion_fields = ["name","descr"]
        
# FusionModel works as a delegate with underlying GroupsModel.
class FusionModel(abstract_model.AbstractGroupModel):
    
    def __init__(self,bdModel):
        self.parser_name = "FusionModel"
        self.is_runnable = True
        self.bdModel = bdModel
        self.st_groups = {}
        self.current_st = None
        self.current_model = None
        super().__init__(fields=fusion_fields,feedback=bdModel.feedback)
        
    def __str__(self):
        res = ""
        for st, grp_model in self.st_groups.items():
            res += st + " : "
            for g in grp_model.items:
                res += g.dict["name"] + ", "
            res += "\n"
        return res
        
    def getItems(self):
        return self.current_model.items
        
    def getCurrModel(self):
        return self.st_groups[self.st_current_st]
        
    # Switch current group model to match subnetwork 'st'
    def setCurrentST(self,st):
        utils.debug("setCurrentST " + str(st))
        utils.debug(str(self))
        self.current_st = st
        if st not in self.st_groups: 
            self.loadAllGroups()
        else:
            self.current_model = self.st_groups[st]
            self.current_model.layoutChanged.emit()
        utils.debug(str(self))
        utils.debug("ST addItem, items = " + str(self))
        
    # Reloads all existing groups for current subnetwork
    def loadAllGroups(self):
        utils.debug("[loadAllGroups]")
        if self.current_st:
            utils.debug("Current st = " + str(self.current_st))
            if self.current_st not in self.st_groups:
                self.st_groups[self.current_st] = groups.copyGroupModel(self.bdModel.groupsModel)
                self.current_model = self.st_groups[self.current_st]
            for grp_item in self.bdModel.groupsModel.items:
                utils.debug("grp_item = " + str(grp_item))
                if not self.current_model.groupExists(grp_item):
                    utils.debug("Adding group " + str(grp_item.dict["name"])
                                + " to " + str(self.current_st))
                    self.current_model.addItem(grp_item)
        else:
            utils.user_error("No sous-trame selected")
        
    def toXML(self,indent=""):
        xmlStr = indent + "<" + self.parser_name + ">\n"
        for st, grp in self.st_groups.items():
            xmlStr += indent + " <ST name=\"" + st + "\">\n"
            xmlStr += grp.toXML(indent=indent + "  ")
            xmlStr += indent + " </ST>"
        xmlStr += indent + "</" + self.__class__.__name__ + ">"
        return xmlStr
    
    def fromXML(self,root):
        utils.info("[fromXMLRoot] FusionModel")
        for st_root in root:
            st_name = st_root.attrib["name"]
            utils.debug("parsing '" + str(st_name) + "' subnetwork")
            self.current_st = st_name
            nb_groups = xmlUtils.getNbChildren(st_root)
            if nb_groups == 0:
                utils.warn("No groups for st " + str(st_name))
            for grp in st_root:
                grp_model = groups.GroupModel(self.bdModel)
                for grp_item in grp:
                    item = grp_model.mkItemFromDict(grp_item.attrib)
                    grp_model.addItem(item)
                if not grp_model:
                    utils.internal_error("Could not parse group model for " + st_name)
                utils.debug("Setting groups for st " + str(st_name))
                self.st_groups[st_name] = grp_model
                self.current_model = grp_model
                self.current_model.layoutChanged.emit()
                grp_model.layoutChanged.emit()
        self.layoutChanged.emit()
    def updateFromXML(self,root,feedback=None):
        self.feedback = feedback
        self.fromXML(root)
        
    def applyItemsWithContext(self,context,feedback,onlyCurrent=False):
        feedback.beginSection("Groups merge")
        self.bdModel.paramsModel.checkInit()
        if onlyCurrent:
            if self.current_st:
                groups_keys = [self.current_st]
            else:
                utils.user_error("No current subnetwork, please load one")
        else:
            groups_keys = list(self.st_groups.keys())
        nb_items = len(groups_keys)
        #nb_items = len(self.st_groups)
        feedback.pushDebugInfo("nb_items = " + str(nb_items))
        step_feedback = feedbacks.ProgressMultiStepFeedback(nb_items,feedback)
        curr_step = 0
        #for st in self.st_groups.keys():
        for st in groups_keys:
            step_feedback.setProgressText("merging subnetwork " + st)
            st_item = self.bdModel.stModel.getSTByName(st)
            if st_item is None:
                utils.internal_error("No subnetwork '" + st + "' found")
            groups = self.st_groups[st]
            if not groups.items:
                step_feedback.pushInfo("No layer for group for subnetwork '" + str(st) + "', ignoring.")
                continue
            else:
                step_feedback.pushInfo("groups = " + str(groups.items))
            step_feedback.pushDebugInfo("apply fusion to " + st)
            step_feedback.pushDebugInfo(str([g.dict["name"] for g in groups.items]))
            grp_args = [self.bdModel.groupsModel.getOutPath(g.getName()) for g in reversed(groups.items)]
            for grp_layer_file in grp_args:
                utils.checkFileExists(grp_layer_file,prefix="Group ")
            step_feedback.pushDebugInfo(str(grp_args))
            out_path = self.bdModel.stModel.getMergedPath(st_item.getName())
            qgsUtils.removeLayerFromPath(out_path)
            qgsUtils.removeRaster(out_path)
            qgsTreatments.applyMergeRaster(grp_args,out_path,out_type=Qgis.Int16,
                context=context,feedback=step_feedback)
            qgsUtils.loadRasterLayer(out_path,loadProject=True)
            curr_step += 1
            step_feedback.setCurrentStep(curr_step)
        feedback.endSection()
            
    # Removes subnetwork 'name' from model
    def removeSTFromName(self,name):
        st_groups = self.st_groups.pop(name,None)
        if not st_groups:
            utils.warn("Deleting subnetwork '" + name + "' in merge model but could not find it")
        
    def downgradeElem(self,row):
        utils.debug("downgradeElem " + str(row))
        if row < len(self.current_model.items) - 1:
            self.swapItems(row, row + 1)
            
    def swapItems(self,i1,i2):
        self.current_model.swapItems(i1,i2)
        self.layoutChanged.emit()
        
    def removeItems(self,index):
        utils.debug("[removeItems] nb of items = " + str(len(self.current_model.items))) 
        self.current_model.removeItems(index,updatePluginModel=False)
        self.current_model.layoutChanged.emit()
        self.layoutChanged.emit()
        
    def addItem(self,item):
        utils.debug("[addItemFusion]")
        self.current_model.addItem(item)
        self.current_model.layoutChanged.emit()
        
    def data(self,index,role):
        return self.current_model.data(index,role)
        
    def rowCount(self,parent=QModelIndex()):
        if self.current_model:
            return self.current_model.rowCount(parent)
        else:
            return 0
        
    def columnCount(self,parent=QModelIndex()):
        if self.current_model:
            return self.current_model.columnCount(parent)
        else:
            return 0
            
    def getNbItems(self):
        return len(self.st_groups)
        

class FusionConnector(abstract_model.AbstractConnector):
    
    def __init__(self,dlg,fusionModel):
        self.dlg = dlg
        self.models = {}
        self.onlySelection = False
        super().__init__(fusionModel,self.dlg.fusionView,
                         addButton=None,removeButton=self.dlg.fusionRemove,
                         runButton=self.dlg.fusionRun,
                         selectionCheckbox=self.dlg.fusionRunOnlySelection)
                         
    def initGui(self):
        pass
                         
    def connectComponents(self):
        super().connectComponents()
        self.dlg.fusionST.setModel(self.model.bdModel.stModel)
        self.dlg.fusionST.currentTextChanged.connect(self.changeST)
        self.dlg.fusionLoadGroups.clicked.connect(self.loadAllGroups)
        self.dlg.fusionUp.clicked.connect(self.upgradeItem)
        self.dlg.fusionDown.clicked.connect(self.downgradeItem)
        
    # Workaround to return only boolean value of onlySelection (only current subentwork here)
    def getSelectedIndexes(self):
        return self.onlySelection
        
    def loadAllGroups(self):
        utils.debug("connector loadAllGroups")
        self.model.loadAllGroups()
        self.changeST(self.model.current_st)
        
    def changeST(self,st):
        self.model.setCurrentST(st)
        self.dlg.fusionView.setModel(self.model.current_model)
        
