# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os    
from PyQt5.QtGui import QIcon
from qgis.core import QgsProcessingProvider

from .aux_algs import (
    RasterSelectionByValue,
    RasterizeFixAllTouch,
    ChangeNoDataVal)
from .BioDispersal_steps_algs import (
    SelectVExprAlg,
    SelectVFieldAlg,
    WeightingBasics,
    WeightingByIntervals,
    WeightingByDistance)    
from .circuitscape_algs import (
    ExportPatchesToCircuitscape,
    ExportFrictionToCircuitscape,
    RandomStartPointsCircuitscape,
    AggregateCirctuitscapeCurrentMaps,
    AggregateCirctuitscapeResults)
from .graphab_algs import ExportToGraphab
from .sliding_window_algs import (
    NeighboursCount,
    QuantileDistance,
    PatchAreaWindow,
    PatchSizeWindowRedistrib,
    ConnectivityIndex,
    ConnectivityIndexHabPatch)
from .patch_algs import (
    DistanceToBorderVector,
    DistanceToBorderRaster,
    LabelPatches,
    PatchSizeRaster,
    ExtractPatchesR)
from .qualif_algs import (
    AgregateCriterias,
    ExtractPatchesV,
    ExtractPatchesRV,
    ClassifySymbology,
    CompactnessAlg,
    DistanceAlg,
    PatchAreaV,
    ReachableSurface,
    RelativeSurfaceVR,
    ShannonDiversityIndex)
    
class BioDispersalAlgorithmsProvider(QgsProcessingProvider):

    NAME = "BioDispersal"

    def __init__(self):
        super().__init__()
        
    def unload(self):
        pass
        
    def id(self):
        return self.NAME
        
    def name(self):
        return self.NAME
        
    def longName(self):
        return self.name()
        
    def icon(self):
        icon_path = os.path.join(os.path.dirname(__file__), "..", "icons", "cerf.png")
        return QIcon(icon_path)

    def loadAlgorithms(self):
        alglist = [
            # Steps algs
            SelectVExprAlg(),
            SelectVFieldAlg(),
            WeightingBasics(),
            WeightingByIntervals(),
            WeightingByDistance(),
            # Aux algs
            RasterSelectionByValue(),
            RasterizeFixAllTouch(),
            ChangeNoDataVal(),
            # Graphab alg
            ExportToGraphab(),
            # Circuitscape algs
            ExportPatchesToCircuitscape(),
            ExportFrictionToCircuitscape(),
            RandomStartPointsCircuitscape(),
            AggregateCirctuitscapeCurrentMaps(),
            AggregateCirctuitscapeResults(),
            # Patch algs
            DistanceToBorderRaster(),
            LabelPatches(),
            PatchSizeRaster(),
            PatchAreaWindow(),
            PatchSizeWindowRedistrib(),
            ConnectivityIndex(),
            QuantileDistance(),
            NeighboursCount(),
            ExtractPatchesR(),
            ExtractPatchesRV(),
            ExtractPatchesV(),
            # Qualif algs
            AgregateCriterias(),
            CompactnessAlg(),
            ClassifySymbology(),
            DistanceAlg(),
            PatchAreaV(),
            ReachableSurface(),
            RelativeSurfaceVR(),
            ShannonDiversityIndex()]
        for a in alglist:
            self.addAlgorithm(a)
            
    def supportedOutputRasterLayerExtensions(self):
        return ['tif','asc']
