# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os.path
import pathlib

from qgis.core import (QgsCoordinateReferenceSystem, QgsRectangle, QgsProject,
                       QgsCoordinateTransform, QgsProcessingUtils)
from qgis.gui import QgsFileWidget
from PyQt5.QtCore import QVariant, QAbstractTableModel, QModelIndex, Qt, QCoreApplication
from PyQt5.QtWidgets import QAbstractItemView, QFileDialog, QHeaderView

from ..qgis_lib_mc import utils, qgsUtils, qgsTreatments, abstract_model

# BioDispersal global parameters

# ParamsModel from which parameters are retrieved
paramsModel = None

# Default CRS is set to epsg:2154 (France area, metric system)
defaultCrs = QgsCoordinateReferenceSystem("EPSG:2154")
        
#class ParamsModel(abstract_model.AbstractGroupModel):
class ParamsModel(abstract_model.NormalizingParamsModel):

    def __init__(self,bdModel):
        self.parser_name = "ParamsModel"
        self.is_runnable = False
        self.bdModel = bdModel
        # self.workspace = None
        # self.extentLayer = None
        # self.resolution = 0.0
        # self.projectFile = ""
        # self.crs = defaultCrs
        # fields = ["workspace","extentLayer","resolution","projectFile","crs"]
        abstract_model.NormalizingParamsModel.__init__(self,feedback=bdModel.feedback)
            
    def getGroupsPath(self):
        self.checkWorkspaceInit()
        return utils.joinPath(self.workspace,"Groups")
            
    def getGroupPath(self,name):
        groups_path = self.getGroupsPath()
        if not os.path.isdir(groups_path):
            utils.info("Creating groups directory '" + groups_path + "'")
            os.makedirs(groups_path)
        group_path = utils.joinPath(groups_path,name)
        if not os.path.isdir(group_path):
            utils.info("Creating group directory '" + group_path + "'")
            os.makedirs(group_path)
        return group_path
        
    def getSTPath(self,name):
        self.checkWorkspaceInit()
        all_st_path = utils.joinPath(self.workspace,"Subnetworks")
        if not os.path.isdir(all_st_path):
            utils.info("Creating ST directory '" + all_st_path + "'")
            os.makedirs(all_st_path)
        st_path = utils.joinPath(all_st_path,name)
        if not os.path.isdir(st_path):
            utils.info("Creating ST directory '" + st_path + "'")
            os.makedirs(st_path)
        return st_path
    
    def toXML(self,indent=""):
        xmlStr = indent + "<" + self.parser_name
        if self.workspace:
            xmlStr += " workspace=\"" + str(self.workspace) + "\""
        if self.resolution:
            xmlStr += " resolution=\"" + str(self.resolution) + "\""
        if self.extentLayer:
            xmlStr += " extentLayer=\"" + str(self.extentLayer) + "\""
        xmlStr += "/>"
        return xmlStr
        

class ParamsConnector:

    def __init__(self,dlg,paramsModel):
        self.dlg = dlg
        self.model = paramsModel
        
    def initGui(self):
        #self.dlg.paramsView.setHorizontalScrollBarMode(QAbstractItemView.ScrollPerPixel)
        self.dlg.paramsView.setHorizontalScrollMode(QAbstractItemView.ScrollPerPixel)
        #self.dlg.extentLayer.setFilter("*.shp;*.tif")
        self.dlg.paramsCrs.setCrs(defaultCrs)
        #self.model.setResolution(25)
        #self.dlg.rasterResolution.setValue(25)
        
    def connectComponents(self):
        self.dlg.paramsView.setModel(self.model)
        self.dlg.rasterResolution.valueChanged.connect(self.model.setResolution)
        self.dlg.extentLayer.setStorageMode(QgsFileWidget.GetFile)
        self.dlg.extentLayer.fileChanged.connect(self.model.setExtentLayer)
        self.dlg.workspace.setStorageMode(QgsFileWidget.GetDirectory)
        self.dlg.workspace.fileChanged.connect(self.model.setWorkspace)
        self.dlg.paramsCrs.crsChanged.connect(self.model.setCrs)
        header = self.dlg.paramsView.horizontalHeader()     
        header.setSectionResizeMode(0, QHeaderView.Stretch)
        self.model.layoutChanged.emit()
        
    def tr(self, message):
        return QCoreApplication.translate('BioDispersal', message)
        
    def refreshProjectName(self):
        fname = self.model.projectFile
        basename = os.path.basename(fname)
        if basename:
            self.dlg.projectName.setText(self.tr("Projet BioDispersal : ") + basename)
        else:
            self.dlg.projectName.setText(self.tr("Pas de projet BioDispersal"))
        
        
    def setProjectFile(self,fname):
        self.model.projectFile = fname
        self.refreshProjectName()
        # basename = os.path.basename(fname)
        # if basename:
            # self.dlg.projectName.setText(self.tr("Current project : ") + basename)
