# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Rasterization
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from osgeo import gdal
#import gdal
#import ogr

from qgis.core import *
import processing
from .utils import *
from .qgsUtils import *
from qgis.gui import QgsFileWidget
from .abstract_model import AbstractGroupModel, AbstractGroupItem, DictItem, DictModel, AbstractConnector
import groups

import subprocess
import sys

# class RasterItem(AbstractGroupItem):
    # def __init__(self,group,descr):
        # self.group = group
        # self.descr = descr
        
    # def getNField(self,n):
        # if n == 0:
            # return self.group
        # elif n == 1:
            # return self.descr
        # else:
            # assert false
            
    # def updateNField(self,n,value):
        # if n == 0:
            # self.group = value
        # elif n == 1:
            # self.descr = value
        # else:
            # assert false
            
    # def checkItem(self):
        # debug("[checkItem] todo")
        
raster_displayed_fields = ["in_group","field","out_group"]

class RasterItem(DictItem):
    
    def __init__(self,in_group,field,out_group):
        if not in_layer:
            in_layer = QgsVectorLayer(in_path, layerNameOfPath(in_path), "ogr")
        dict = {"in_group" : in_group,
                "field" : field,
                "out_group" : out_group}
        super().__init__(dict,raster_displayed_fields)
        
    # TODO : possible to filter field combo box with numeric types ?
    def checkItem(self):
        pass
        # in_group = self.dict["in_group"]
        # field = self.dict["field"]
        # out_group = self.dict["out_group"]
        # real_field = in_layer.fields().field(field)
        # if not typeIsNumeric(real_field.type()):
            # user_error("Field " + str(field) + " is not numeric")
        
    def applyItem(self):
        debug("applyRasterization")
        self.checkItem()
        in_group = self.dict["in_group"]
        in_group_item = groups.groupsModel.getGroupByName(in_group)
        in_path = in_group_item.path
        in_layer = in_group.getLayerForce()
        if in_layer.is_memory:
            in_group_item.saveLayerAsFile()
        out_group = self.dict["out_group"]
        out_group_item = groups.groupsModel.getGroupByName(out_group)
        out_path = out_group_item.path
        #out_path = self.dict["out_path"]
        #out_path = out_path.replace("\\","/")
        field = self.dict["field"]
        extent = in_layer.extent()
        x_min = extent.xMinimum()
        x_max = extent.xMaximum()
        y_min = extent.yMinimum()
        y_max = extent.yMaximum()
        # Create the destination data source
        pixel_size = 25
        NoData_value = -9999
        #x_res = int((x_max - x_min) / pixel_size)
        #y_res = int((y_max - y_min) / pixel_size)
        width = int((x_max - x_min) / pixel_size)
        height = int((y_max - y_min) / pixel_size)
        p = subprocess.Popen(['gdal_rasterize',
                                #'-l','layer_name',
                                '-a',field,
                                #'-burn','0.0',
                                '-te',str(x_min),str(y_min),str(x_max),str(y_max),
                                #'-tr',str(x_res),str(y_res),
                                '-ts', str(width), str(height),
                                in_path,
                                out_path],
                                stderr=subprocess.PIPE)#, stdout=sys.stdout)#stdin=PIPE, stdout=PIPE, stderr=PIPE)
        out,err = p.communicate()
        debug(str(p.args))
        info(str(out))
        if err:
            user_error(str(err))
        
class RasterModel(DictModel):
    
    def __init__(self):
        #fields = ["in_layer_name","field","in_path","out_path"]
        super().__init__(self,raster_displayed_fields)

    @staticmethod
    def mkItemFromDict(dict):
        checkFields(raster_displayed_fields,dict.keys())
        item = RasterItem(dict["metagroup"],dict["descr"])
        return item

class RasterizationConnector(AbstractConnector):

    def __init__(self,dlg):
        self.dlg = dlg
        self.raster_model = RasterModel()
        super().__init__(self.raster_model,self.dlg.rasterView,
                         self.dlg.rasterAdd,self.dlg.rasterRemove)
                         
    def initGui(self):
        pass
                         
    def connectComponents(self):
        super().connectComponents()
        
    def mkItem(self):
        in_layer = self.dlg.rasterInLayer.currentLayer()
        if not in_layer:
            user_error("No input layer selected")
        in_layer_path = pathOfLayer(in_layer)
        #checkFileExists(in_layer_path)
        out_layer_path = self.dlg.rasterOutLayer.filePath()
        field = self.dlg.rasterField.currentField()
        if not field:
            user_error("No field selected")
        item = RasterItem(in_layer,in_layer_path,out_layer_path,field)
        return item
        
        
class Rasterization:

    def __init__(self,dlg):
        self.dlg = dlg
        self.segments = 10
        self.raster_model = RasterModel()
        #test_item = 
        #self.raster_model.
        
    def initGui(self):
        self.dlg.rasterView.resize(self.dlg.width / 1.5, self.dlg.height / 3.5)
        
    def connectComponents(self):
        #self.dlg.rasterRun.clicked.connect(self.applyBuffer)
        self.dlg.rasterInLayer.layerChanged.connect(self.updateFieldLayer)
        self.dlg.rasterAdd.clicked.connect(self.addRasterItem)
        self.dlg.rasterRun.clicked.connect(self.rasterizeItems)
        self.dlg.rasterOutLayer.setStorageMode(QgsFileWidget.SaveFile)
        self.dlg.rasterView.setModel(self.raster_model)
        #self.dlg.rasterField.layerChanged.connect(self.setField)
        
    def updateFieldLayer(self,layer):
        self.dlg.rasterField.setLayer(layer)
        
    def applyBuffer(self):
        in_layer = self.dlg.rasterInLayer.currentLayer()
        out_layer_name = self.dlg.rasterOutLayer.filePath()
        uri = "Polygon?crs=epsg:2154"
        out_layer = QgsVectorLayer(uri,'buffer','memory')
        pr = out_layer.dataProvider()
        in_fields = in_layer.fields()
        pr.addAttributes(in_fields)
        out_layer.updateFields()
        features = in_layer.getFeatures()
        for feat in features:
            in_attr = feat.attributes()
            in_geom = feat.geometry()
            bf_in_geom = in_geom.buffer(50,self.segments)
            #poly_geom = bf_in_geom.asPolygon()
            out_feat = QgsFeature()
            #out_feat.setGeometry(QgsGeometry.fromPolygon(poly_geom))
            out_feat.setGeometry(bf_in_geom)
            out_feat.setAttributes(in_attr)
            pr.addFeature(out_feat)
        QgsProject.instance().addMapLayer(out_layer)
        #return out_layer
        
    def addRasterItem(self):
        debug("addRasterItem")
        in_layer = self.dlg.rasterInLayer.currentLayer()
        if not in_layer:
            user_error("No input layer selected")
        in_layer_uri = in_layer.dataProvider().dataSourceUri()
        in_layer_path = in_layer_uri[:in_layer_uri.rfind('|')]
        checkFileExists(in_layer_path)
        out_layer_path = self.dlg.rasterOutLayer.filePath()
        field = self.dlg.rasterField.currentField()
        if not field:
            user_error("No field selected")
        item = RasterItem(in_layer,in_layer_path,out_layer_path,field)
        self.raster_model.addItem(item)
        self.raster_model.layoutChanged.emit()
        #self.dlg.rasterView.setModel(self.raster_model)
        
    def rasterizeItems(self,item):
        for item in self.raster_model.items:
            item.applyRasterization()
        
    def rasterize4(self):
        in_layer = self.dlg.rasterInLayer.currentLayer()
        in_layer_uri = in_layer.dataProvider().dataSourceUri()
        in_layer_path = in_layer_uri[:in_layer_uri.rfind('|')]
        debug("layer path " + str(in_layer_path))
        extent = in_layer.extent()
        x_min = extent.xMinimum()
        x_max = extent.xMaximum()
        y_min = extent.yMinimum()
        y_max = extent.yMaximum()
        #x_min = 617896.1697324323
        #x_max = 6244885.235793086
        #y_min = 723893.6697324323
        #y_max = 6312983.51615631
        # Create the destination data source
        pixel_size = 25
        NoData_value = -9999
        #x_res = int((x_max - x_min) / pixel_size)
        #y_res = int((y_max - y_min) / pixel_size)
        width = int((x_max - x_min) / pixel_size)
        height = int((y_max - y_min) / pixel_size)
        p = subprocess.Popen(['gdal_rasterize',
                                #'-l','layer_name',
                                '-a','Importance',
                                #'-burn','0.0',
                                '-te',str(x_min),str(y_min),str(x_max),str(y_max),
                                #'-tr',str(x_res),str(y_res),
                                '-ts', str(width), str(height),
                                in_layer_path,
                                'D:MChailloux/PNRHL_QGIS/tmpLayer_rasterized.tif'],
                                stderr=subprocess.PIPE)#, stdout=sys.stdout)#stdin=PIPE, stdout=PIPE, stderr=PIPE)
        out,err = p.communicate()
        info(str(out))
        if err:
            user_error(str(err))
        
    def rasterize3(self):
        # command example from qgis : 
        # gdal_rasterize -l layer_name -burn 0.0 -ts 0.0 0.0 -te 617896.1697324323 6244885.235793086 723893.6697324323 6312983.51615631
        # -ot Float32 -of GTiff path_to_data_file C:/Users/mathieu.chailloux/AppData/Local/Temp/processing_1056e33334bf4bfd893729147c7ae91b/5242c59677b04c6fa7aa46e59333c4af/OUTPUT.tif
        name = 'D:\MChailloux\SIG_TrameEcologique\AXE_COMMUNICATION\ROUTE_PRIMAIRE_PNRHL.shp'
        in_layer = self.dlg.rasterInLayer.currentLayer()
        in_layer_uri = in_layer.dataProvider().dataSourceUri()
        in_layer_path = in_layer_uri[:in_layer_uri.rfind('|')]
        debug("layer path " + str(in_layer_path))
        extent = in_layer.extent()
        x_min = extent.xMinimum()
        x_max = extent.xMaximum()
        y_min = extent.yMinimum()
        y_max = extent.yMaximum()
        #x_min = 617896.1697324323
        #x_max = 6244885.235793086
        #y_min = 723893.6697324323
        #y_max = 6312983.51615631
        # Create the destination data source
        pixel_size = 25
        NoData_value = -9999
        #x_res = int((x_max - x_min) / pixel_size)
        #y_res = int((y_max - y_min) / pixel_size)
        width = int((x_max - x_min) / pixel_size)
        height = int((y_max - y_min) / pixel_size)
        p = subprocess.Popen(['gdal_rasterize',
                                #'-l','layer_name',
                                '-a','Importance',
                                #'-burn','0.0',
                                '-te',str(x_min),str(y_min),str(x_max),str(y_max),
                                #'-tr',str(x_res),str(y_res),
                                '-ts', str(width), str(height),
                                in_layer_path,
                                'D:MChailloux/PNRHL_QGIS/tmpLayer_rasterized.tif'],
                                stderr=subprocess.PIPE)#, stdout=sys.stdout)#stdin=PIPE, stdout=PIPE, stderr=PIPE)
        out,err = p.communicate()
        info(str(out))
        if err:
            user_error(str(err))
        #p.communiacte()
        #subprocess.run("gdal_rasterize -help", shell=True,check=True)
        
    def rasterize2(self):
        in_layer = self.dlg.rasterInLayer.currentLayer()
        pixel_size = 25
        NoData_value = -9999

        # Filename of the raster Tiff that will be created
        raster_fn = 'test.tif'
        
        name = 'D:\MChailloux\SIG_TrameEcologique\AXE_COMMUNICATION\ROUTE_PRIMAIRE_PNRHL.shp'
        #in_layer = 

        extent = in_layer.extent()
        x_min = extent.xMinimum()
        x_max = extent.xMaximum()
        y_min = extent.yMinimum()
        y_max = extent.yMaximum()
        #x_min, x_max, y_min, y_max = in_layer.GetExtent()

        # Create the destination data source
        x_res = int((x_max - x_min) / pixel_size)
        y_res = int((y_max - y_min) / pixel_size)
        target_ds = gdal.GetDriverByName('GTiff').Create(raster_fn, x_res, y_res, 1, gdal.GDT_Byte)
        debug(str(target_ds))
        #target_ds.SetGeoTransform((x_min, pixel_size, 0, y_max, 0, -pixel_size))
        #band = target_ds.GetRasterBand(1)
        #band.SetNoDataValue(NoData_value)

        # Rasterize
        #err = gdal.RasterizeLayer(target_ds, [1], name, burn_values=[0])
        err = gdal.RasterizeLayer(target_ds, [1], in_layer, burn_values=[0])
        #err = gdal.RasterizeLayer(target_ds, [1], in_layer,options=["ALL_TOUCHED=TRUE"])
        debug(str(err))
        
    def rasterize(self):
        in_layer = self.dlg.rasterInLayer.currentLayer()
        parameters = { 'INPUT' : in_layer,
                        'UNITS' : 1,
                        'WIDTH' : 0,
                        'HEIGHT' : 0,
                        'EXTENT' : in_layer.extent(),
                        'DATA_TYPE' : 2,
                        'INVERT' : False,
                        'OUTPUT' : 'D:\MChailloux\PNRHL_QGIS\tmpLayer_rasterized.tif'
                        }
        try:
            res = processing.run("gdal:rasterize",parameters)
            debug(str(res))
            print ("call to rasterize successful")
        except Exception as e:
            print ("Failed to call rasterize : " + str(e))
            raise e
        finally:  
            debug("End rasterize")
            
            