# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Utils
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from .utils import *

class Group:

    def __init__(self,row,id,descr):
        self.row = row
        self.id = id
        self.descr = descr
        
    def updateID(self,id):
        old_id = self.id
        self.id = id
        debug("Group '" + old_id + "' renamed to '" + id + "'")
        
    def updateDescr(self,descr):
        old_descr = self.descr
        self.descr = descr
        debug("Group '" + str(self.id) + "' description changed from '" + old_descr + "' to '" + self.descr + "'")
        

class Groups:

    def __init__(self,dlg):
        self.dlg = dlg
        self.groups = {}
        
    def initGui(self):
        pass
        
    def connectComponents(self):
        #self.dlg.groupTable.cellChanged.connect(self.updateTable)
        self.dlg.buttonAddGroup.clicked.connect(self.addRow)
        self.dlg.buttonRemoveGroup.clicked.connect(self.delRow)
        self.dlg.buttonSaveGroups.clicked.connect(self.saveGroups)
        
    #def unload(self):
    #    self.groups = {}
        
    # def idExists(self,row,id):
        # for group in self.groups:
            # if group.id == id and row != group.row:
                # return True
        # return False
        
    def addRow(self):
        debug("Adding row")
        self.dlg.groupTable.insertRow(0)
        # for group in self.groups:
            # group.row += 1
        # self.groups.insert(0,Group(0,"",""))
            
    def delRow(self):
        row = self.dlg.groupTable.currentRow()
        debug("Deleting row " + str(row))
        self.dlg.groupTable.removeRow(row)
        
    def checkNoEmptyCell(self):
        for i in range(0, self.dlg.groupTable.rowCount()):
            for j in range(0, self.dlg.groupTable.columnCount()):
                if not self.dlg.groupTable.item(i,j):
                    user_error("Empty cell at row " + str(i) + ", column " + str(j))
        
    def saveGroups(self):
        self.checkNoEmptyCell()
        self.groups = {}
        for i in range(0, self.dlg.groupTable.rowCount()):
            key = self.dlg.groupTable.item(i,0).text()
            val = self.dlg.groupTable.item(i,1).text()
            debug ("row " + str(i) + " = (" + str(key) + "," + str(val) + ")") 
            if not key.isalnum():
                user_error("Invalid group name : " + str(key))
            elif key in self.groups:
                debug(str(self.groups))
                user_error("Group '" + key + "' already exists")
            else:
                self.groups[key] = val
                debug("Adding group '" + key + "' : " + val)
