# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


import utils

import xml.etree.ElementTree as ET

config_models = None

def setConfigModels(model_dict):
    global config_models
    config_models = model_dict

def parseConfig(config_file):
    utils.info("Parsing configuration from file '" + str(config_file) + "'")
    tree = ET.parse(config_file)
    root = tree.getroot()
    for model in root:
        parseModel(model)
    utils.info("Configuration parsing successful")

# Parse model from XML root.
# Updates models stored in 'config_models'.
# If 'new_model' is True, groups models are instanciated (called in fusion context)
def parseModel(model_root,new_model=False):
    global config_models, mk_item
    model_tag = model_root.tag
    utils.debug("parseModel " + str(model_tag))
    utils.debug("config_models " + str(config_models))
    if model_tag not in config_models:
        utils.user_error("Unknown Model '" + model_tag + "'")
    model = config_models[model_tag]
    try:
        utils.debug("cas 1")
        utils.debug("config_models " + str(config_models))
        if model_tag == "FusionModel":
            model.testFunc(model_root)
            model.fromXMLRoot(model_root)
            utils.debug("config_models " + str(config_models))
        else:
            model.fromXMLRoot(model_root)
            utils.debug("config_models " + str(config_models))
        return model
    except AttributeError:
        utils.debug("cas 2")
        for item in model_root:
            utils.debug("iter")
            dict = item.attrib
            fields = dict.keys()
            item = model.mkItemFromDict(dict)
            model.addItem(item)
        model.layoutChanged.emit()
        return model
        