# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BioDispersal
                                 A QGIS plugin
 Computes ecological continuities based on environments permeability
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-04-12
        git sha              : $Format:%H$
        copyright            : (C) 2018 by IRSTEA
        email                : mathieu.chailloux@irstea.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5.QtSql import QSqlRecord, QSqlTableModel, QSqlField
from PyQt5.QtCore import QVariant, QAbstractTableModel, QModelIndex, pyqtSignal
from qgis.gui import QgsFileWidget
import abstract_model
import utils
import qgsUtils
import params
         
# Class model is static so that it can be modified by dependant modules suchs as config parsing
classModel = None
class_fields = ["name","code","descr","group"]

def getClassLayer(grp):
    clsItem = classModel.getClassByName(out_name)
    cls_layer = clsItem.getLayer()
    return cls_layer
    
def getClassByName(class_name):
    for cls in classModel.items:
        if cls.name == class_name:
            return cls
    return None
    
# ClassItem implements DictItem and contains below fields :
#   - 'name' : class name (identifier, unique in model)
#   - 'descr' : class textual description
#   - 'code' : class identifier in raster layers (automatically generated)
class ClassItem(abstract_model.DictItem):
    
    def __init__(self,cls,descr,code,group):
        utils.debug("init with code " + str(code))
        if code == None:
            code = classModel.getFreeCode()
            utils.debug("new code = " + str(code))
        else:
            try:
                code = int(code)
            except TypeError:
                utils.user_error("Could not build class item from code '" + str(code)+ "'")
        dict = {"name" : cls,
                "code": code,
                "descr" : descr,
                "group" : group}
        self.name = cls
        super().__init__(dict)
        
    def checkItem(self):
        utils.checkName(self,prefix="Class")
        if not self.dict["descr"]:
            utils.warn("Class '" + self.name + "' with empty description")
        
    def equals(self,other):
        return (self.dict["name"] == other.dict["name"])
            
# ClassModel implements DictModel with ClassItem items
# Signals 'classAdded' and 'classRemoved' are emitted on item addition/deletion
class ClassModel(abstract_model.DictModel):

    classAdded = pyqtSignal('PyQt_PyObject')
    classAdded2 = pyqtSignal()
    classRemoved = pyqtSignal('PyQt_PyObject')
    
    def __init__(self):
        super().__init__(self,class_fields)
        
    @staticmethod
    def mkItemFromDict(dict):
        utils.checkFields(class_fields,dict.keys())
        item = ClassItem(dict["name"],dict["descr"],dict["code"],dict["group"])
        return item
        
    def getClassByName(self,name):
        for i in self.items:
            if i.dict["name"] == name:
                return i
        None
        
    def codeExists(self,n):
        for i in self.items:
            if int(i.dict["code"]) == n:
                return True
        return False
            
    def getFreeCode(self):
        cpt = 1
        while True:
            if not self.codeExists(cpt):
                return cpt
            cpt += 1
            
    def addItem(self,item):
        super().addItem(item)
        self.classAdded.emit(item)
        self.classAdded2.emit()
        
    def removeFromGroupName(self,name):
        indexes = []
        names = []
        cpt = 0
        for item in self.items:
            if item.dict["group"] == name:
                indexes.append(cpt)
                names.append(item.dict["name"])
            cpt += 1
        self.removeItemsFromRows(indexes) 
        for n in names:
            self.classRemoved.emit(n)
         
    def removeItems(self,indexes):
        names = [self.items[idx.row()].dict["name"] for idx in indexes]
        super().removeItems(indexes)
        for n in names:
            self.classRemoved.emit(n)

class ClassConnector(abstract_model.AbstractConnector):

    def __init__(self,dlg):
        self.dlg = dlg
        classModel = ClassModel()
        super().__init__(classModel,self.dlg.classView,
                         None,self.dlg.classRemove)
        # super().__init__(classModel,self.dlg.classView,
                         # self.dlg.selectionClassAdd,self.dlg.classRemove)
        
    def initGui(self):
        pass
        
    def connectComponents(self):
        super().connectComponents()

    # Classes are created in selection tab.
    # No code given so that it be automatically generated.
    def mkItem(self):
        name = self.dlg.selectionClassName.text()
        self.dlg.selectionClassCombo.setCurrentText(name)
        descr = self.dlg.selectionClassDescr.text()
        classItem = ClassItem(name,descr,None)
        return classItem
         