# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BatchHeatmaps
                                 A QGIS plugin
 Plugin para gerar heatmaps em determinadas escalas de tempo de forma automatizada
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-11
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Prefeitura Municipal de Betim
        email                : .
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from datetime import *
from PyQt5.QtCore import *
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog
from PyQt5.QtGui import QColor
from PyQt5.QtGui import *
from qgis.PyQt import QtWidgets
from qgis.core import *
from math import ceil
from PIL import Image
import processing
import time

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .batch_heatmaps_dialog import BatchHeatmapsDialog
from .batch_heatmaps_dialog import ProgressDialog
import os.path


class BatchHeatmaps:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'BatchHeatmaps_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.dlg = BatchHeatmapsDialog()
        self.dlg_progress = ProgressDialog()

        self.actions = []
        self.menu = self.tr(u'&Batch Heatmaps')

        # Checks if plugin is running for the first time in QGIS project
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None


    def tr(self, message):
        return QCoreApplication.translate('BatchHeatmaps', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/batch_heatmaps/icon.png' #Image by icon-library.net / CC0 by https://creativecommons.org/publicdomain/zero/1.0/deed.en
        self.add_action(
            icon_path,
            text=self.tr(u'Batch Heatmaps'),
            callback=self.run,
            parent=self.iface.mainWindow())

        self.layersCombobox()
        self.dlg.BatchHeatmaps_Tab.setCurrentIndex(0)
        self.dlg.tb_Shapefiles.clicked.connect(self.addShapefile)
        self.dlg.tb_saveHeatmap.clicked.connect(self.saveLocation)
        self.dlg.btn_ok.clicked.connect(self.Run)
        self.dlg.btn_close.clicked.connect(self.close)
        self.dlg.cb_Shapes.currentIndexChanged.connect(self.fieldsLayerCombobox)
        self.dlg.cb_LayerFields.currentIndexChanged.connect(self.disableDataFormat)
        self.dlg.doubleSpinBox_Columns.valueChanged.connect(self.columnsChanged)
        self.dlg.doubleSpinBox_Rows.valueChanged.connect(self.rowsChanged)
        self.dlg.doubleSpinBox_Pixel.valueChanged.connect(self.pixelSizeChanged)
        self.dlg.btn_groupName.clicked.connect(self.groupName)
        self.dlg.btn_close.clicked.connect(self.removeShapefile)
        
        #When executed will be false
        self.first_start = True
        global points_layer
        points_layer = None

    def layersCombobox(self): #show all vector layers in combobox
        global layer_list
        self.dlg.cb_Shapes.clear()
        layers = [layer for layer in QgsProject.instance().mapLayers().values()] #get all layers in project
        layer_list = []

        for layer in layers:
            if layer.type() == 0:  #vector layer type
                layer_list.append(layer.name())
                
        layer_list.reverse()
        self.dlg.cb_Shapes.addItems(layer_list)

    def fieldsLayerCombobox(self): #show all fields from layer in combobox
    	try:
        	self.dlg.cb_LayerFields.clear()

        	layer_name = self.dlg.cb_Shapes.currentText()

        	layer = QgsProject.instance().mapLayersByName(layer_name)[0]

        	fields = [field.name() for field in layer.fields()]

        	self.dlg.cb_LayerFields.addItems(fields) #add layer fields to combobox
    	except:
            pass


    def disableDataFormat(self): 
    	try:
        	selectedLayerName = self.dlg.cb_Shapes.currentText()
        	selectedLayer = QgsProject.instance().mapLayersByName(selectedLayerName)[0]

        	index = self.dlg.cb_LayerFields.currentIndex()

        	field = selectedLayer.fields()[index]
        	if field.type() == 14:
        		self.dlg.cb_dataFormat.setDisabled(True)
        		self.dlg.label_2.setDisabled(True)
        	else:
        		self.dlg.cb_dataFormat.setDisabled(False)
        		self.dlg.label_2.setDisabled(False)
    	except:
        	pass


    
    def addShapefile(self):
    	
        global layer_list
        global points_file_name
        global points_layer
        
        try:
            if points_layer is not None:
        	    QgsProject.instance().removeMapLayer(points_layer)
        except:
        	pass

        points_layer_path = str(QFileDialog.getOpenFileName(caption="Abrir arquivo",filter="Shapefiles (*.shp *.SHP)")[0])
        
        if points_layer_path:
        	points_file_name = points_layer_path.split('/')
        	points_file_name = points_file_name[-1][:-4] #extract the file name 
            
        	if points_file_name not in layer_list:
        	    points_layer = QgsVectorLayer(points_layer_path, points_file_name, 'ogr')
        	    QgsProject.instance().addMapLayer(points_layer, False)
        

        self.layersCombobox()

    def removeShapefile(self):
    	try:
            QgsProject.instance().removeMapLayer(points_layer)
    	except:
            pass

    	self.layersCombobox()

    def saveLocation(self):
    	savePath = str(QFileDialog.getExistingDirectory(caption="Selecionar pasta"))
    	self.dlg.line_saveLocation.setText(savePath)

    def restartProgressBar(self):
        self.dlg_progress.progress_text.setText(None)
        self.dlg_progress.progress_bar.setValue(0)

    def closePlugin(self):
        self.dlg.BatchHeatmaps_Tab.setCurrentIndex(0)
        self.dlg.line_groupName.setText(None)
        self.dlg.close()
        self.dlg_progress.close()

    def Run(self): #Run the main functions for executing and generating heatmaps
        try:
            heatmap_layerName = self.dlg.cb_Shapes.currentText() #select the layer name in combobox defined by user
            heatmap_layer = QgsProject.instance().mapLayersByName(heatmap_layerName)[0] 
        
            if heatmap_layer.type() != QgsMapLayer.VectorLayer:
        	    self.iface.messageBar().pushMessage("Error", "Select a valid layer", level=Qgis.Warning, duration=3)
            else:
                self.dlg_progress.show() #initialize progress bar window

                try:
                    self.loadData(heatmap_layer)
                except(TypeError):
                    self.iface.messageBar().pushMessage("Error", "Select a field with dates", level=Qgis.Warning, duration=3)
                    QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName("Data Layer")[0])

        except:
            self.iface.messageBar().pushMessage("Error", "There was an error executing the heatmap algorithm", level=Qgis.Warning, duration=3)
            QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName("Data Layer")[0])
            root = QgsProject.instance().layerTreeRoot()
            layersGroup = root.findGroup(self.dlg.line_groupName.text())
            root.removeChildNode(layersGroup)
 
        self.layersCombobox() #update new project layers to combobox
        self.dlg.line_saveLocation.setText("[Save to temporary file]")
        self.removeShapefile()
        self.closePlugin()  
        self.restartProgressBar()

    #----------------Heatmaps-----------------#

    def columnsChanged(self):
        try:
            selectedLayerName = self.dlg.cb_Shapes.currentText() #select the layer name in combobox defined by user
            selectedLayer = QgsProject.instance().mapLayersByName(selectedLayerName)[0] 

            raster_bounds = QgsRectangle()
            source = selectedLayer
            bounds = source.sourceExtent()
            raster_bounds = bounds

            columns = self.dlg.doubleSpinBox_Columns.value()
            cell_size = round((raster_bounds.height() / columns),1) #calculates pixel size value

            self.dlg.doubleSpinBox_Pixel.setValue(cell_size)
            self.dlg.doubleSpinBox_Rows.setValue(columns)


        except(IndexError):
            self.iface.messageBar().pushMessage("Error", "No layer selected", level=Qgis.Warning, duration=3)
            self.dlg.doubleSpinBox_Columns.setValue(0)

    def rowsChanged(self):
        try:
            selectedLayerName = self.dlg.cb_Shapes.currentText()
            selectedLayer = QgsProject.instance().mapLayersByName(selectedLayerName)[0] #select the layer index in combobox defined by user

            raster_bounds = QgsRectangle()
            source = selectedLayer
            bounds = source.sourceExtent()
            raster_bounds = bounds

            rows = self.dlg.doubleSpinBox_Rows.value()
            cell_size = round((raster_bounds.height() / rows),1) #calculates pixel size value

            self.dlg.doubleSpinBox_Pixel.setValue(cell_size)
            self.dlg.doubleSpinBox_Columns.setValue(rows)



        except(IndexError):
            self.iface.messageBar().pushMessage("Error", "No layer selected", level=Qgis.Warning, duration=3)
            self.dlg.doubleSpinBox_Rows.setValue(0)

    def pixelSizeChanged(self):
        try:
            selectedLayerName = self.dlg.cb_Shapes.currentText()
            selectedLayer = QgsProject.instance().mapLayersByName(selectedLayerName)[0] #select the layer index in combobox defined by user

            raster_bounds = QgsRectangle()
            source = selectedLayer

            bounds = source.sourceExtent()

            raster_bounds = bounds

            cell_size = self.dlg.doubleSpinBox_Pixel.value()
            rows = max(round(raster_bounds.height() / cell_size) + 1, 1) #calculates the number of rows from the defined pixel size.
            columns = max(round(raster_bounds.width() / cell_size) + 1, 1) #calculates the number of columns from the defined pixel size.

            #Block signals to change spinbox value without activating other code functions
            self.dlg.doubleSpinBox_Rows.blockSignals(True)
            self.dlg.doubleSpinBox_Rows.setValue(rows)
            self.dlg.doubleSpinBox_Rows.blockSignals(False)
            
            self.dlg.doubleSpinBox_Columns.blockSignals(True)
            self.dlg.doubleSpinBox_Columns.setValue(columns)
            self.dlg.doubleSpinBox_Columns.blockSignals(False)

        except(IndexError):
            self.iface.messageBar().pushMessage("Error", "No layer selected", level=Qgis.Warning, duration=3)
            self.dlg.doubleSpinBox_Pixel.setValue(0)

    def groupName(self):
    	groupName = self.dlg.cbTempoHeatmap.currentText()
    	self.dlg.line_groupName.setText(groupName)

    def loadData(self, heatmapsLayer): #Load data from selected layer in heatmaps combobox and send for code list creation
        global filePath, root, layersGroup
        root = QgsProject.instance().layerTreeRoot() 

        filePath = heatmapsLayer.dataProvider().dataSourceUri() 
        filePath = os.path.split(filePath) 
        timePeriod = self.dlg.cbTempoHeatmap.currentText()

        crs = heatmapsLayer.sourceCrs().authid() #Get the crs from the original file to be added to the memory layer.
        crs = crs[5:] 

        features = heatmapsLayer.getFeatures()

        heatmap_memory_layer = QgsVectorLayer("Point?crs=epsg:{}".format(crs), "Data Layer", "memory") #create a memory layer
        
        heatmap_layer_data = heatmapsLayer.dataProvider()
        heatmap_memory_layer_data = heatmap_memory_layer.dataProvider()

        attributes = heatmapsLayer.dataProvider().fields().toList()

        heatmap_memory_layer_data.addAttributes(attributes)
        heatmap_memory_layer.updateFields() 
        QgsProject.instance().addMapLayer(heatmap_memory_layer)

        for f in features:
            heatmap_memory_layer_data.addFeatures(features)

        self.generateList(heatmap_memory_layer, timePeriod)


    def generateList(self, heatmap_layer, timePeriod):
        codeList = []

        fieldName = self.dlg.cb_LayerFields.currentText() #get the field name with date attibutes selected by user

        field_index = heatmap_layer.fields().indexFromName(fieldName[0:10]) #get the index from the field

        heatmap_layer.startEditing()
        heatmap_layer_data = heatmap_layer.dataProvider()
        heatmap_layer_data.addAttributes([QgsField('___CODE___',QVariant.String)])
        heatmap_layer_data.addAttributes([QgsField('___DATE___',QVariant.Date)])
        heatmap_layer.commitChanges()
        code_index = heatmap_layer.fields().indexFromName('___CODE___') #Return the index from the code field
        date_index = heatmap_layer.fields().indexFromName('___DATE___') #Return the index from the code field
        
        if self.dlg.cb_dataFormat.isEnabled():
            dataFormat = self.dlg.cb_dataFormat.currentText()
            fieldIsDate = False
        else:
            fieldIsDate = True

        heatmap_layer.startEditing()
        features = heatmap_layer.getFeatures()
        
        dataFormat = self.dlg.cb_dataFormat.currentText()
        for f in features:
            id = f.id()

            date = f.attributes()[field_index]

            if fieldIsDate == False:
                date = datetime.strptime(date, dataFormat)
                date = str(date)
                date = date[0:10]
                date = QDate.fromString(date, 'yyyy-MM-dd')


            attr_value = {date_index:date}
            heatmap_layer_data.changeAttributeValues({id:attr_value})

        heatmap_layer.commitChanges()

        request = QgsFeatureRequest()
        clause = QgsFeatureRequest.OrderByClause('___DATE___', ascending=True)
        orderby = QgsFeatureRequest.OrderBy([clause])
        request.setOrderBy(orderby)
        features = heatmap_layer.getFeatures(request)


        def insertList(timeInterval, prefix, semanaCorrida=False, Quinzena=False, semanaFixa=False):
            
            if self.dlg.cb_dataFormat.isEnabled():
                dataFormat = self.dlg.cb_dataFormat.currentText()
                fieldIsDate = False
            else:
            	fieldIsDate = True

            if self.dlg.line_groupName.text() == '':
            	self.dlg.line_groupName.setText(prefix)
            	groupName = prefix
            else:
            	groupName = self.dlg.line_groupName.text()

            if root.findGroup(groupName): 
                pass 
            else:
                layersGroup = root.addGroup(groupName) 

            for f in features:
                id = f.id()

                date = f.attributes()[field_index]

                if fieldIsDate == True:
                    dt = date.toPyDate()

                if fieldIsDate == False:
                    dt = datetime.strptime(date,dataFormat)

                year = dt.year
                month = dt.month
                
                if semanaCorrida == True or Quinzena == True:
                    day = dt.timetuple().tm_yday #extract the day of year from date
                    timeResult = day / 365
                    timeUnity = timeResult * timeInterval

                elif semanaFixa == True:
                    week = dt.isocalendar()[1] 
                    timeUnity = week
                else:
                    timeResult = month / 12
                    timeUnity = timeResult * timeInterval

                timeUnity = ceil(timeUnity)

                if(prefix == "Ano"):
                    code = "{}_{}".format(prefix,year)
                else:
                    if timeUnity < 10:
                        code = "{}_0{}_{}".format(prefix,timeUnity,year)
                    else:
                        code = "{}_{}_{}".format(prefix,timeUnity,year)

                

                attr_value = {code_index:code}
                heatmap_layer_data.changeAttributeValues({id:attr_value})  
            
                if not codeList.__contains__(code):
                    codeList.append(code) #add code to list 

                heatmap_layer.commitChanges()

        def insertListEpiWeek(prefix):

            if self.dlg.cb_dataFormat.isEnabled():
                dataFormat = self.dlg.cb_dataFormat.currentText()
                fieldIsDate = False
            else:
            	fieldIsDate = True

            if self.dlg.line_groupName.text() == '':
            	self.dlg.line_groupName.setText(prefix)
            	groupName = prefix
            else:
            	groupName = self.dlg.line_groupName.text()

            if root.findGroup(groupName): 
                pass 
            else:
                layersGroup = root.addGroup(groupName)  

            for f in features:
                id = f.id()
                date = f.attributes()[field_index] 

                if fieldIsDate == True:
                    dt = date.toPyDate()

                if fieldIsDate == False:
                    dt = datetime.strptime(date,dataFormat)

                year = dt.year
                month = dt.month

                epidemiologicalWeek = self.generateEpidemiologicalWeeks(dt)
                if epidemiologicalWeek < 10:
                    code = "{}_0{}_{}".format(prefix,epidemiologicalWeek,year) 
                else:
                    code = "{}_{}_{}".format(prefix,epidemiologicalWeek,year)

                

                attr_value = {code_index:code}
                heatmap_layer_data.changeAttributeValues({id:attr_value}) 

                if not codeList.__contains__(code):
                    codeList.append(code) #add code to list 

                heatmap_layer.commitChanges()

        def insertListSeason(northSeasons=False):

            if self.dlg.cb_dataFormat.isEnabled():
                dataFormat = self.dlg.cb_dataFormat.currentText()
                fieldIsDate = False
            else:
            	fieldIsDate = True

            if self.dlg.line_groupName.text() == '':
            	self.dlg.line_groupName.setText(prefix)
            	groupName = prefix
            else:
            	groupName = self.dlg.line_groupName.text()

            if root.findGroup(groupName): 
                pass 
            else:
                layersGroup = root.addGroup(groupName)


            for f in features:
                id = f.id()
                date = f.attributes()[field_index] 

                if fieldIsDate == True:
                    dt = date.toPyDate()

                if fieldIsDate == False:
                    dt = datetime.strptime(date,dataFormat)

                year = dt.year

                month = dt.month
                day = dt.day
                season = ''

                if month in (1,2,3):  #seasons in the pattern of the southern hemisphere
	                season = 'Verão'
                elif month in (4,5,6):
	                season = 'Outono'
                elif month in (7,8,9):
	                season = 'Inverno'
                elif month in (10,11,12):
	                season = 'Primavera'

                if (month == 3) and (day > 19):
	                season = 'Outono'
                elif (month == 6) and (day > 20):
	                season = 'Inverno'
                elif (month == 9) and (day > 22):
	                season = 'Primavera'
                elif (month == 12) and (day > 21):
	                season = 'Verão'
                
                if northSeasons == True:  #reverse seasons to the northern hemisphere
                    if season == 'Outono':
                        season = 'Primavera'
                    elif season == 'Primavera':
                        season = 'Outono'

                    if season == 'Verão':
                        season = 'Inverno'
                    elif season == 'Inverno':
                        season = 'Verão'
                
                code = '{}_{}'.format(season,year)

                attr_value = {code_index:code}
                heatmap_layer_data.changeAttributeValues({id:attr_value}) 

                if not codeList.__contains__(code):
                    codeList.append(code) #add code to list 

                heatmap_layer.commitChanges()

        #Emulate Switch/Case structure using Dictionary 

        def EstacaoSul():
        	insertListSeason()

        def EstacaoNorte():
        	insertListSeason(northSeasons=True)

        def SemanaEpidemiologica():
            prefix = "Epidemiological Week" 
            insertListEpiWeek(prefix)

        def SemanaFixa():
            timeInterval = 52
            prefix = "Fixed Week"
            insertList(timeInterval, prefix, semanaFixa = True)

        def SemanaCorrida():
            timeInterval = 52
            prefix = "Floating Week"
            insertList(timeInterval, prefix, semanaCorrida = True)

        def Quinzena():
            timeInterval = 24
            prefix = "Fortnight"
            insertList(timeInterval, prefix, Quinzena = True)

        def Mensal():
            timeInterval = 12
            prefix = "Month"
            insertList(timeInterval, prefix)

        def Bimestre():
            timeInterval = 6
            prefix = "Two-Months"
            insertList(timeInterval, prefix)

        def Trimestre():
            timeInterval = 4
            prefix = "Trimester"
            insertList(timeInterval, prefix)

        def Quadrimestre():
            timeInterval = 3
            prefix = "Four-Months"
            insertList(timeInterval, prefix)

        def Semestre():
            timeInterval = 2
            prefix = "Semester"
            insertList(timeInterval, prefix)

        def Anual():
            timeInterval = 1
            prefix = "Year"
            insertList(timeInterval, prefix)


        dictionary={
        "Seasons - South Hemisphere":EstacaoSul,
        "Seasons -  North Hemisphere":EstacaoNorte,
        "Fortnight":Quinzena,
        "Epidemiological Week":SemanaEpidemiologica,
        "Fixed Week":SemanaFixa,
        "Floating Week":SemanaCorrida,
        "Two-Months":Bimestre,
        "Trimester":Trimestre,
        "Four-Months":Quadrimestre,
        "Semester":Semestre,
        "Month":Mensal,
        "Year":Anual
        }

        dictionary.get(timePeriod)()
        self.generateHeatmap(heatmap_layer,codeList)

        QgsProject.instance().removeMapLayer(heatmap_layer)

    def generateEpidemiologicalWeeks(self,date):

        year = date.year
        date_ordinal = date.toordinal()


        def generate_dt_initial(year):
            #Get ordinal number from the first week of year
            middle_week = 2

            dt_initial = datetime(year, 1, 1)

            dt_initial_ordinal = dt_initial.toordinal() #Get ordinal number from first day of year
            dt_initial_weekday = dt_initial.weekday() #Get weekday from the first day of year

            week1_ordinal = dt_initial_ordinal - dt_initial_weekday - 1 

            if dt_initial_weekday > middle_week: 
                week1_ordinal += 7 
            return week1_ordinal #return ordinal week value


        dt_initial_Year_ordinal = generate_dt_initial(year)
        week = (date_ordinal - dt_initial_Year_ordinal) // 7 #Week = Date - initial year date

        if week < 0:
            year = year - 1 #If week is less than zero go to previous year
            dt_initial_Year_ordinal = generate_dt_initial(year) #Generate the start date of the previous year
            week = (date_ordinal - dt_initial_Year_ordinal) // 7 #Determine where the date is in the week of the previous year

        if week >= 52:
            dt_initial_Year_ordinal = generate_dt_initial(year + 1)
            if date_ordinal >= dt_initial_Year_ordinal:
                year = year + 1
                week = 0
        week += 1

        epidemiologicalWeek = week
        return epidemiologicalWeek

    def generateHeatmap(self, heatmap_layer, codeList): 
        MaximumBandStatisticsList = []
        HeatmapRasterLayerList = []
        saveHeatMapPath = ''
        #Values ​​to update progress bar
        percent = 100/codeList.__len__()
        value = 0
        self.dlg_progress.progress_bar.setValue(value)

        heatmapRasterLayerVisibility = True
        username = os.getlogin()

        if self.dlg.raw_Data.isChecked():
        	if self.dlg.line_saveLocation.text() == '[Save to temporary file]':
        		saveHeatMapPath = 'C:/Users/{}/AppData/Local/Temp'.format(username)
        	elif self.dlg.line_saveLocation.text() == '':
        		saveHeatMapPath = 'C:/Users/{}/AppData/Local/Temp'.format(username)
        	else:
        		saveHeatMapPath = self.dlg.line_saveLocation.text()
        		
        else:
        	saveHeatMapPath = 'C:/Users/{}/AppData/Local/Temp'.format(username)


        for code in codeList:
            self.dlg_progress.progress_text.setText("Generating Heatmap {}...".format(code))
            value+=percent
            self.dlg_progress.progress_bar.setValue(value)
    
            heatmap_layer.setSubsetString("___CODE___ LIKE '{}'".format(code)) #Filter layer with each code for heatmaps generation
            prefixCode = code.split("_") 

            pixelSizeValue = self.dlg.doubleSpinBox_Pixel.value() #Extracts spinbox value to set pixel size
            radiusValue = self.dlg.doubleSpinBox_Radius.value() #Extracts spinbox value to set radius 

            output = saveHeatMapPath+"/{}.tif".format(str(code)) #Where to save the file, code will be the saved file name

            processing.run("qgis:heatmapkerneldensityestimation", 
            {'INPUT':heatmap_layer,
            'RADIUS':radiusValue,'RADIUS_FIELD':None,'PIXEL_SIZE': pixelSizeValue,'WEIGHT_FIELD':None,
            'KERNEL':0,'DECAY':0,'OUTPUT_VALUE':0,'OUTPUT': output})
        
            heatmapRasterLayer = QgsRasterLayer(output, code) 
            QgsProject.instance().addMapLayer(heatmapRasterLayer, False) 

            layersGroup = root.findGroup(self.dlg.line_groupName.text()) #Searches for the group created with the code prefix
            layersGroup.addLayer(heatmapRasterLayer) #Add layer to group and make it visible

            QgsProject.instance().layerTreeRoot().findLayer(heatmapRasterLayer.id()).setItemVisibilityChecked(heatmapRasterLayerVisibility)

            if heatmapRasterLayerVisibility == True: #Set only the first raster visibility true
                heatmapRasterLayerVisibility = False

            self.getHeatmapBandStatistics(heatmapRasterLayer, MaximumBandStatisticsList)
            HeatmapRasterLayerList.append(heatmapRasterLayer)

        self.coloringHeatmap(MaximumBandStatisticsList,HeatmapRasterLayerList)


    def getHeatmapBandStatistics(self,heatmapRasterLayer, MaximumBandStatisticsList):
        heatmap = heatmapRasterLayer 

        renderer = heatmap.renderer() 
        provider = heatmap.dataProvider() 
        extent = heatmap.extent() 

        stats = provider.bandStatistics(1, QgsRasterBandStats.All, extent, 0) 

        MaximumBandStatisticsList.append(stats.maximumValue) #Add the Maximum Band Values ​​to the List

    def coloringHeatmap(self, MaximumBandStatisticsList, HeatmapRasterLayerList):

        for layer in HeatmapRasterLayerList:
            if layer.type() == 1: 
                heatmap = layer 

                renderer = heatmap.renderer() 
                provider = heatmap.dataProvider() 
                extent = heatmap.extent() 
                
                stats = provider.bandStatistics(1, QgsRasterBandStats.All, extent, 0) 

                if stats.maximumValue == max(MaximumBandStatisticsList) and stats.maximumValue != min(MaximumBandStatisticsList):
                	heatmap.setName(heatmap.name()+"_Max")

                if stats.maximumValue == min(MaximumBandStatisticsList) and stats.maximumValue != max(MaximumBandStatisticsList):
                	heatmap.setName(heatmap.name()+"_Min")

                #Minimum, maximum and intermediate ranges for calculating scales

                if self.dlg.lowest_MaximumDensity.isChecked():
                    maximumBand = (min(MaximumBandStatisticsList)) #Use the lowest maximum density
                if self.dlg.highest_MaximumDensity.isChecked():
                    maximumBand = (max(MaximumBandStatisticsList)) #Use the highest maximum density

                minimumBand = 0
                interval1 = maximumBand/3.5
                interval2 = maximumBand/2.5
                interval3 = maximumBand/1.5

                colorList = [ QgsColorRampShader.ColorRampItem(minimumBand, QColor(255,255,255,0), str(minimumBand)), #White
                            QgsColorRampShader.ColorRampItem(interval1, QColor('#ABDDA4'), str(round(interval1,2))), #Green
                            QgsColorRampShader.ColorRampItem(interval2, QColor('#FCFFA4'), str(round(interval2,2))), #Yellow
                            QgsColorRampShader.ColorRampItem(interval3, QColor('#FFA500'), str(round(interval3,2))), #Orange
                            QgsColorRampShader.ColorRampItem(maximumBand, QColor('#FF0000'), str(round(maximumBand,2)))] #Red

                rasterShader = QgsRasterShader()

                colorRamp = QgsColorRampShader() 

                colorRamp.setColorRampItemList(colorList) 
                rasterShader.setRasterShaderFunction(colorRamp)

                renderHeatmap = QgsSingleBandPseudoColorRenderer(heatmap.dataProvider(), 
                                                                    heatmap.type(),  
                                                                    rasterShader)

                heatmap.setRenderer(renderHeatmap)

                heatmap.triggerRepaint()
                if self.dlg.rendered_Image.isChecked():
                    if self.dlg.line_saveLocation.text() == '' or self.dlg.line_saveLocation.text() == '[Save to temporary file]':
                    	pass
                    else:
                        self.saveRenderedHeatmap(heatmap)

    def saveRenderedHeatmap(self,layer):
        fileFormat = '.tif'
        saveHeatmapPath = self.dlg.line_saveLocation.text()

        width, height = layer.width(), layer.height()
        extent = layer.extent()
        renderer = layer.renderer()
        provider=layer.dataProvider()
        crs = layer.crs().toWkt()
        pipe = QgsRasterPipe()
        pipe.set(provider.clone())
        pipe.set(renderer.clone())
        file_writer = QgsRasterFileWriter('{}/{}{}'.format(saveHeatmapPath, layer.name(),fileFormat))
        file_writer.writeRaster(pipe,width,height,extent,layer.crs())
        self.iface.messageBar().pushMessage("Heatmaps save location: ", saveHeatmapPath, level=Qgis.Info, duration=5)

    def generateVideo(self):

        path = self.dlg.line_saveLocation.text()

        for file in os.listdir(path):

            im = Image.open(path+'/'+file)

            fill_color = (255,255,255)  

            im = im.convert("RGBA")   

            if im.mode in ('RGBA', 'LA'):
                background = Image.new(im.mode[:-1], im.size, fill_color)
                background.paste(im, im.split()[-1]) 
                im = background

            im.convert("RGB").save(path+'/'+file)

        imagelist = []

        for file in os.listdir(path):

            image = Image.open(path+'/'+file)
            imagelist.append(image)
            imagelist[0].save("{}/video.gif".format(path), save_all=True, append_images=imagelist[1:], duration=1500, loop=0)
         
    def close(self):
        self.dlg.close()

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Batch Heatmaps'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        if self.first_start == True:
            self.first_start = False
            dlg = BatchHeatmapsDialog()

        self.dlg.show()
        self.layersCombobox()

