# General
General documentation/comments to run the plugin

## Developer Docs
Documentation related to developer work
- [Debugging.md](./developer-docs/debugging.md) - Docs for debugging in QGIS, including setting up test environment and setting up vscode debugger
- [Logging.md](./developer-docs/logging.md) - Docs to understand Logging setup in QGIS, including enabling debug logs
- [qtDesigner.md](./developer-docs/qtDesigner.md) - Docs to get started with qtDesigner, used to edit the ui for the plugin.
- [deployment.md](./developer-docs/deployment.md) - Docs on how to deploy the plugin. 
- [testing.md](./developer-docs/testing.md) - Doc on testing the plugin.
- [Future-work.md](./Future-work.md) - Some future work that can be taken on to improve plugin.


## Workflows
Documentation related to workflow of the plugin. Each file is a specific workflow
- [commit-changes-workflow.md](./workflows/commit-changes-workflow.md) - Workflow for commiting changes to Feature Service


## Links
- [QGIS Plugin Tutorial - gis-ops.com](https://gis-ops.com/qgis-3-plugin-tutorial-plugin-development-reference-guide/) - Excellent guide for introduction to plugin development.
- [QGIS Plugin Home Page](https://plugins.qgis.org/)
- [Structuring QGIS Python Plugins](https://docs.qgis.org/testing/en/docs/pyqgis_developer_cookbook/plugins/plugins.html#structuring-python-plugins)
- [Building a Python Plugin (QGIS3)](https://www.qgistutorials.com/en/docs/3/building_a_python_plugin.html#building-a-python-plugin-qgis3)

