# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AzureMapsPluginDialog
                                 A QGIS plugin
 Azure Maps Creator plugin for QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-06-04
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Microsoft Corporation
        email                : bjapark@microsoft.com, xubin.zhuge@microsoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import webbrowser

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtGui import QFont
from PyQt5.QtCore import QSettings
from qgis.core import *

from .helpers.Constants import Constants

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer


FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "azure_maps_plugin_dialog_base.ui")
)


class AzureMapsPluginDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(AzureMapsPluginDialog, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface
        self.setFixedSize(500, 520)

        self.setStyleSheet(
            """
            font-size: 12px;
            """
        )

        self.getFeaturesButton.clicked.connect(self.on_get_features_clicked)
        plugin_dir = QgsApplication.qgisSettingsDirPath().replace("\\", "/")
        config_path = plugin_dir + Constants.Paths.RELATIVE_CONFIG_PATH
        self.plugin_settings = QSettings(config_path, QSettings.IniFormat)

        # Logs
        default_logs_folder = plugin_dir + Constants.Paths.RELATIVE_PLUGIN_PATH + "/{}".format(Constants.Logs.LOG_FOLDER_NAME)
        self.logsFolderPicker.setDefaultRoot(self.plugin_settings.value("logsFolder", default_logs_folder))
        self.logsFolderPicker.setFilePath(self.plugin_settings.value("logsFolder", default_logs_folder))

    def saveSettings(self):
        # Creator
        self.plugin_settings.setValue("datasetId", self.datasetId.currentText())
        self.plugin_settings.setValue("logsFolder", self.logsFolderPicker.filePath())

    def on_get_features_clicked(self):
        self.saveSettings()