# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AGGRADockWidget
                                 A QGIS plugin
 An autonomous agent framework to select geospatial data and then fetch data by generating and executing programs with self-debugging.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-08-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Geoinformation and Big Data Research Laboratory (GIBD)
        email                : tea5209@psu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import base64
import configparser
import os
import re
import shutil

import requests
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
import os
import sys
from qgis.PyQt.QtCore import QSettings
import time
import traceback
from io import StringIO
from qgis.PyQt.QtCore import Qt, QCoreApplication
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis._core import QgsProject, QgsVectorLayer, QgsCoordinateReferenceSystem, \
    QgsCoordinateTransform, QgsFeature, Qgis
from qgis.utils import iface

QCoreApplication.setAttribute(Qt.AA_ShareOpenGLContexts)

from PyQt5.QtCore import QUrl, QThread, pyqtSignal, pyqtSlot, QSettings, QObject
from PyQt5.QtGui import QTextCursor, QSyntaxHighlighter, QTextCharFormat, QColor

from PyQt5.QtWidgets import QGridLayout, QHBoxLayout, QWidget, QPushButton, QFileDialog, QMenu, QAction, QCompleter, \
    QVBoxLayout, QLineEdit, QTableWidgetItem, QDialog, QLabel, QMessageBox, QInputDialog, QComboBox


from qgis.gui import QgsPasswordLineEdit
from qgis.PyQt.QtWebKitWidgets import QWebView


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'AGGRA_dockwidget_base.ui'))

current_script_dir = os.path.dirname(os.path.abspath(__file__))
keys_dir = os.path.join(current_script_dir, 'LLM_Find', 'Keys')
from .install_packages.check_packages import check_and_install_libraries , check_missing_libraries, read_libraries_from_file, install_libraries


class LibraryCheckThread(QThread):
    finished_checking = pyqtSignal(list)

    def __init__(self, filename):
        QThread.__init__(self)
        self.filename = filename

    def run(self):
        # Perform the library check in this thread
        missing_packages = check_missing_libraries(read_libraries_from_file(self.filename))
        self.finished_checking.emit(missing_packages)


class VersionCheckThread(QThread):
    version_check_completed = pyqtSignal(bool)  # Emits True if update is needed

    def run(self):
        needs_update = self.check_openai_version()
        self.version_check_completed.emit(needs_update)

    def check_openai_version(self):
        try:
            import pkg_resources
            import requests

            # Get the installed version
            installed_version = pkg_resources.get_distribution("openai").version

            # Get the latest version from PyPI
            response = requests.get("https://pypi.org/pypi/openai/json", timeout=5)
            latest_version = response.json()["info"]["version"]

            # Compare versions
            if installed_version != latest_version:
                return True
            else:
                return False
        except Exception as e:
            print(f"Error checking openai version: {e}")
            return False

class AGGRADockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(AGGRADockWidget, self).__init__(parent)
        # Set default width
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        # Set initial size of the plugin window
        # self.set_initial_size(800, 600)  # Width: 800, Height: 600
        required_packages = os.path.join(current_script_dir, 'install_packages', 'requirements.txt')

        self.library_check_thread = LibraryCheckThread(required_packages)
        self.library_check_thread.finished_checking.connect(self.handle_missing_libraries)
        self.library_check_thread.start()  # Start the background thread

        # Start the OpenAI version check thread
        self.version_check_thread = VersionCheckThread()
        self.version_check_thread.version_check_completed.connect(self.handle_version_check)
        self.version_check_thread.start()

        self.load_OpenAI_key()

        self.initUI()

        # Initialize conversation history
        self.conversation_history = []

        self.api_keys = {} # Dictionary to store API keys

        self.task_history = []
        self.saved_fname_history = []

        self.stopFlag = False
        # Initialize QCompleter for task_LineEdit
        self.task_completer = QCompleter(self.task_history, self)
        self.task_completer.setCaseSensitivity(Qt.CaseInsensitive)
        # self.task_LineEdit.setCompleter(self.task_completer)

        # Initialize QCompleter for data_pathLineEdit
        self.saved_fname_completer = QCompleter(self.saved_fname_history, self)
        self.saved_fname_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.saved_fnameLineEdit.setCompleter(self.saved_fname_completer)

        self.ChatMode_checkbox.toggled.connect(self.toggle_saved_fnameLineEdit)

        self.tabWidget = self.findChild(QtWidgets.QTabWidget, 'tabWidget')
        self.tab_3_index = self.tabWidget.indexOf(self.tab_3)

        # Set the initial tab to the first tab (change this to the desired tab)
        self.tabWidget.setCurrentIndex(0)

        # Apply the syntax highlighter
        self.highlighter = PythonHighlighter(self.output_text_edit.document())
        self.code_highlighter = PythonHighlighter(self.CodeEditor.document(), always_highlight=True)



    def initUI(self):
        self.run_button = self.findChild(QPushButton, 'run_button')

        # self.run_button.clicked.connect(self.run_script)

        self.run_button.clicked.connect(self.send_button_clicked)
        # self.run_button.clicked.connect(lambda: self.append_message(self.task_LineEdit.toPlainText()))

        self.interrupt_button.clicked.connect(self.interrupt)
        # self.chatgpt_ans.setReadOnly(True)  # Make the text edit read-only (if desired)
        self.chatgpt_ans.setTextInteractionFlags(Qt.TextSelectableByMouse | Qt.TextSelectableByKeyboard)

        self.SelectDataPath_ToolBtn.clicked.connect(self.select_output_directory)

        self.clear_chatgpt_ansBtn.clicked.connect(self.clear_textboxes)

        self.interrupt_button.clicked.connect(self.stop_script)

        self.save_code_button.clicked.connect(self.save_code_to_file)
        self.open_code_button.clicked.connect(self.load_code_from_file)
        self.clear_code_editorBtn.clicked.connect(self.clear_output_window)
        self.Run_Generated_code.clicked.connect(self.run_generated_code)



        self.SelectDataPath_ToolBtn.clicked.connect(self.save_settings)

        self.task_LineEdit.textChanged.connect(self.save_settings)
        self.saved_fnameLineEdit.textChanged.connect(self.save_settings)
        # self.OpenAI_key_LineEdit.textChanged.connect(self.save_settings)
        self.modelNameComboBox.currentIndexChanged.connect(self.save_settings)
        self.SelectDataPath_ToolBtn.clicked.connect(self.save_settings)
        # Connect the button click to the method that adds a new row
        self.addrowButton.clicked.connect(self.add_row)
        self.removerowButton.clicked.connect(self.remove_row)
        self.add_document_button.clicked.connect(self.add_documentation_file)
        # self.add_document_github_button.clicked.connect(self.open_upload_dialog)
        # self.add_document_github_button.clicked.connect(self.show_contribution_dialog) ## For adding data source to GitHub
        self.Add_new_key_btn.clicked.connect(self.show_add_key_dialog)
        self.remove_keyfile_btn.clicked.connect(self.show_remove_key_dialog)

        # Let the table expand both horizontally and vertically
        self.tableWidget.setSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Expanding)

        # Set the second column to stretch, first column to resize-to-contents
        header = self.tableWidget.horizontalHeader()
        # First, set the default width of column 0
        self.tableWidget.setColumnWidth(0, 200)
        header.setSectionResizeMode(0, QtWidgets.QHeaderView.Interactive)
        header.setSectionResizeMode(1, QtWidgets.QHeaderView.Stretch)

        self.tableWidget.verticalHeader().setSectionResizeMode(QtWidgets.QHeaderView.Interactive)



        # Initialize the row label counter
        self.row_label_counter = 0
        self.textBrowser.setOpenExternalLinks(True)

        # self.load_api_keys()
        self.setup_initial_rows()  # Set up initial rows in the table
        # self.read_updated_config()




    def show_contribution_dialog(self):
        """Open the ContributionDialog for user interaction."""

        self.contribution_dialog = ContributionDialog(self)

        self.contribution_dialog.exec_()


    def handle_missing_libraries(self, missing_packages):
        if missing_packages:
            message = "The following Python packages are required to use the plugin:\n\n"
            message += "\n".join(missing_packages)
            message += "\n\nWould you like to install them now? After installation, please restart QGIS."

            reply = QMessageBox.question(self, 'Missing Dependencies', message,
                                         QMessageBox.Yes | QMessageBox.No, QMessageBox.No)
            if reply == QMessageBox.Yes:
                install_libraries(missing_packages)

    def check_libraries_once(self):

        """Check if libraries were already installed, otherwise run the check."""
        settings = QSettings('YourOrganization', 'YourApplication')
        libraries_checked = settings.value('libraries_checked', False, type=bool)

        if not libraries_checked:
            # First time: Libraries have not been checked
            print("Checking and installing required libraries...")
            from .install_packages.check_packages import check_and_install_libraries
            # Call your existing method to check and install libraries
            required_packages = os.path.join(os.path.dirname(__file__), 'install_packages', 'requirements.txt')
            check_and_install_libraries(required_packages)

            # Mark the libraries as checked and installed
            settings.setValue('libraries_checked', True)
        else:
            # Libraries have already been checked
            print("Libraries have already been checked and installed.")


    def handle_version_check(self, needs_update):
        if needs_update:
            message = (
                "A new version of the 'openai' package is available.\n"
                "Would you like to update it now? This may require administrator privileges."
            )
            reply = QMessageBox.question(
                self, 'Update Available', message,
                QMessageBox.Yes | QMessageBox.No, QMessageBox.No
            )
            if reply == QMessageBox.Yes:
                self.update_openai_package()

    def update_openai_package(self):
        try:
            import subprocess
            import sys

            # Run the pip install command to update the package
            subprocess.check_call(['python3', "-m", "pip", "install", "--upgrade", "openai"])

            QMessageBox.information(
                self, 'Update Successful',
                "The 'openai' package has been updated. Please restart the application."
            )
        except Exception as e:
            QMessageBox.critical(
                self, 'Update Failed',
                f"Failed to update 'openai' package:\n{e}"
            )

    def read_updated_config(self):
        current_script_dir = os.path.dirname(os.path.abspath(__file__))
        config_path = os.path.join(current_script_dir, 'LLM_Find', 'openai_key_config.ini')
        # config_path = os.path.join(os.path.dirname(self.script_path), 'openai_key_config.ini')
        config = configparser.ConfigParser()
        config.read(config_path)
        OpenAI_key = config['API_Key']['OpenAI_key']
        self.OpenAI_key_LineEdit.setText(OpenAI_key)

    def update_openai_config_file(self):
        current_script_dir = os.path.dirname(os.path.abspath(__file__))
        config_path = os.path.join(current_script_dir, 'LLM_Find', 'openai_key_config.ini')
        # Ensure the directory exists, if not, create it
        config_dir = os.path.dirname(config_path)
        if not os.path.exists(config_dir):
            os.makedirs(config_dir)

        config = configparser.ConfigParser()

        # Check if the config file exists
        if os.path.exists(config_path):
            # If the config file exists, read the existing content
            config.read(config_path)

        if 'API_Key' not in config:
            config['API_Key'] = {}
            # Retrieve the API key from the line edit
        OpenAI_key= self.OpenAI_key_LineEdit.text().strip()
        config['API_Key']['OpenAI_key'] = OpenAI_key

        with open(config_path, 'w') as configfile:
            config.write(configfile)

        # # Update the QSettings (optional, if you want to store it there too)
        settings = QSettings('YourOrganization', 'YourApplication')
        settings.setValue('API_Key/OpenAI_key', OpenAI_key)


    def load_OpenAI_key(self):
        current_script_dir = os.path.dirname(os.path.abspath(__file__))
        config_path = os.path.join(current_script_dir, 'LLM_Find', 'openai_key_config.ini')
        config = configparser.ConfigParser()
        if os.path.exists(config_path):
            config.read(config_path)
            if 'API_Key' in config and 'OpenAI_key' in config['API_Key']:
                api_key = config['API_Key']['OpenAI_key']
                self.OpenAI_key_LineEdit.setText(api_key)
        else:
            self.update_openai_config_file()



    def setup_initial_rows(self, keys_directory=keys_dir):
        # Get all .keys files from the 'Keys' directory
        # script_dir = os.path.dirname(os.path.abspath(__file__))
        # keys_directory = 'Keys'  # Adjust the directory path as needed
        keys_files = [f for f in os.listdir(keys_directory) if f.endswith('.keys') and f != 'template.keys']

        # Strip the .keys extension for display purposes
        initial_keys = [os.path.splitext(f)[0] for f in keys_files]

        # Add a row for each key file found
        for key in initial_keys:
            self.add_row(key_name=key, keys_directory=keys_directory)

        # initial_keys = ["OpenAI_key", "US_Census_key", "OpenWeather_key", "OpenTopography"]
        # for key in initial_keys:
        #     self.add_row(key)

    def add_row(self, key_name = None, keys_directory=keys_dir):
        # Get the current number of rows
        row_count = self.tableWidget.rowCount()
        # Insert a new row at the end
        self.tableWidget.insertRow(row_count)

        # Create a QWidget container for the QgsPasswordLineEdit
        container_widget = QtWidgets.QWidget()
        # Ensure the container widget can expand
        container_widget.setSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Expanding)
        password_edit = QgsPasswordLineEdit(container_widget)
        # Set the size policy for the password edit
        password_edit.setSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Expanding)

        # Set the layout for the container widget
        layout = QtWidgets.QHBoxLayout(container_widget)
        layout.addWidget(password_edit)
        layout.setContentsMargins(0, 0, 0, 0)  # Remove margins

        # Create a QComboBox for the first column
        combo_box = QtWidgets.QComboBox()
        # Set size policy for the combo box
        combo_box.setSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Expanding)

        # Add a blank option first
        combo_box.addItem("")  # Blank option at the top

        # Get the list of key names from the 'Keys' directory, excluding 'template.keys'
        # Get the list of key names from the 'Keys' directory, excluding 'template.keys'
        if keys_directory:
            keys_files = [f for f in os.listdir(keys_directory) if f.endswith('.keys') and f != 'template.keys']
            all_key_names = [os.path.splitext(f)[0] for f in keys_files]

            # Add the key name options from the files as drop-down options
            combo_box.addItems(all_key_names)
            # names = ["OpenAI_key", "OpenWeather_key", "US_Census_key", "OpenTopography"]  # Replace with your list of names
            # combo_box.addItems(names)

            # Connect the combo box change signal to a function that sets the corresponding API key
        combo_box.currentIndexChanged.connect(lambda: self.set_api_key(combo_box, password_edit, keys_directory))

        # Connect the password field change signal to update the .keys file when edited
        password_edit.textChanged.connect(lambda: self.update_datasources_api_key_file(combo_box, password_edit, keys_directory))

        if key_name:
            combo_box.setCurrentText(key_name)
        self.tableWidget.setCellWidget(row_count, 0, combo_box)


        # Set the API key if provided
        # if key_name:
        #     settings = QSettings('YourOrganization', 'YourApplication')
        #     api_key = settings.value(f'API_Key/{key_name}', '')
        #     password_edit.setText(api_key)

        # Load the API key from the corresponding file
        if key_name and keys_directory:
            self.set_api_key(combo_box, password_edit, keys_directory)
            # key_file_path = os.path.join(keys_directory, f"{key_name}.keys")
            # try:
            #     with open(key_file_path, 'r') as key_file:
            #         # Assuming the key file contains a line like: OpenAI_key = <actual_api_key>
            #         for line in key_file:
            #             if "=" in line:
            #                 key_value = line.split('=')[1].strip()
            #                 password_edit.setText(key_value)  # Set the API key in the password field
            #                 break  # We only expect one line containing the key
            # except FileNotFoundError:
            #     QMessageBox.warning(self, "File Error", f"File not found: {key_file_path}")

        # Create a QLineEdit for the second column
        # password_edit = QgsPasswordLineEdit
        self.tableWidget.setCellWidget(row_count, 1, container_widget)
        # self.tableWidget.setColumnWidth(1, 160)  # Adjust the width as needed
        # Let the table adjust the row height to fit the content
        self.tableWidget.resizeRowToContents(row_count)

        # Increment the row label counter
        self.row_label_counter += 1
        # # Adjust the table height
        # self.adjust_table_height()

    def set_api_key(self, combo_box, password_edit, keys_directory):
        # Get the selected key name from the combo box
        selected_key_name = combo_box.currentText()

        if selected_key_name:
            # Construct the path to the corresponding .keys file
            key_file_path = os.path.join(keys_directory, f"{selected_key_name}.keys")

            try:
                # Open the file and read the API key
                with open(key_file_path, 'r') as key_file:
                    for line in key_file:
                        if "=" in line:
                            key_value = line.split('=')[1].strip()
                            password_edit.setText(key_value)  # Set the API key in the password field
                            break  # Only expecting one key per file
            except FileNotFoundError:
                QMessageBox.warning(self, "File Error", f"File not found: {key_file_path}")
        else:
            # Clear the API key field if no valid key is selected
            password_edit.clear()

    def update_datasources_api_key_file(self, combo_box, password_edit, keys_directory):
        # Get the selected key name from the combo box
        selected_key_name = combo_box.currentText()

        # Ensure a key name is selected
        if selected_key_name:
            # Construct the path to the corresponding .keys file
            key_file_path = os.path.join(keys_directory, f"{selected_key_name}.keys")
            API_keyname = f"{selected_key_name}_key"

            # Get the new API key from the password edit field
            new_api_key = password_edit.text()

            try:
                # Read the file content
                with open(key_file_path, 'r') as key_file:
                    lines = key_file.readlines()

                # Find the line with the API key and update only that line
                with open(key_file_path, 'w') as key_file:
                    for line in lines:
                        if line.startswith(f"{API_keyname} ="):
                            # Replace the old key with the new key
                            key_file.write(f"{API_keyname} = {new_api_key}\n")
                        else:
                            # Write the line back as it is if it's not the key line
                            key_file.write(line)

            except Exception as e:
                QMessageBox.warning(self, "File Error",
                                    f"Failed to update the key file: {key_file_path}\nError: {str(e)}")

    def show_add_key_dialog(self):
        # Create and display the dialog
        keys_directory = keys_dir  # Adjust this path as needed
        dialog = AddKeyDialog(keys_directory, self)

        if dialog.exec_():  # If the dialog is successfully accepted (after pressing save)
            # Get the new key name (the user input from the dialog)
            new_key_name = dialog.name_input.text().strip()

            # Add the new key name to the existing combo boxes
            self.add_new_keyname_to_combo_boxes(new_key_name)
            self.add_row(key_name=new_key_name, keys_directory=keys_directory)

    def add_new_keyname_to_combo_boxes(self, new_key_name):
        # Iterate over the rows in your table and update the QComboBox for each row
        for row in range(self.tableWidget.rowCount()):
            combo_box = self.tableWidget.cellWidget(row, 0)  # Get the combo box in the first column of each row
            if isinstance(combo_box, QtWidgets.QComboBox):
                # Check if the new key is already in the combo box
                if new_key_name not in [combo_box.itemText(i) for i in range(combo_box.count())]:
                    # Add the new key to the combo box
                    combo_box.addItem(new_key_name)

        # After the dialog closes, refresh your table or UI to show the new key
        # self.refresh_key_table()  # Assuming you have a method to refresh your table

    # Function to show the remove key dialog and handle UI updates
    def show_remove_key_dialog(self):
        keys_directory = keys_dir  # Adjust the path as needed
        dialog = RemoveKeyDialog(keys_directory, self)

        if dialog.exec_():  # If the dialog is accepted (key successfully removed)
            # Get the removed key name from the combo box
            removed_key_name = dialog.combo_box.currentText()

            # Remove the key from the combo boxes
            self.remove_key_from_combo_boxes(removed_key_name)

    def remove_key_from_combo_boxes(self, removed_key_name):
        # First, iterate over the rows and remove the row where the key is selected
        for row in reversed(range(self.tableWidget.rowCount())):  # Reverse to avoid index issues when removing rows
            combo_box = self.tableWidget.cellWidget(row, 0)  # Get the combo box in the first column of each row
            if isinstance(combo_box, QtWidgets.QComboBox):
                # Check if the key is currently selected in this row
                if combo_box.currentText() == removed_key_name:
                    # Remove the entire row
                    self.tableWidget.removeRow(row)

        # Iterate over the rows in your table and update the QComboBox for each row
        for row in range(self.tableWidget.rowCount()):
            combo_box = self.tableWidget.cellWidget(row, 0)  # Get the combo box in the first column of each row
            if isinstance(combo_box, QtWidgets.QComboBox):
                # Find the index of the removed key in the combo box
                index = combo_box.findText(removed_key_name)
                if index != -1:
                    # Remove the key from the combo box if it exists
                    combo_box.removeItem(index)


        # # Get the selected key name from the combo box
        # selected_key_name = combo_box.currentText()
        #
        # if selected_key_name:
        #     # Construct the path to the corresponding .keys file
        #     key_file_path = os.path.join(keys_directory, f"{selected_key_name}.keys")
        #
        #     # Get the new API key from the password edit field
        #     new_api_key = password_edit.text()
        #
        #     # Update the .keys file with the new API key
        #     try:
        #         with open(key_file_path, 'w') as key_file:
        #             # Write the new API key in the format: key_name = new_api_key
        #             key_file.write(f"{selected_key_name} = {new_api_key}")
        #     except Exception as e:
        #         QMessageBox.warning(self, "File Error",
        #                             f"Failed to update the key file: {key_file_path}\nError: {str(e)}")

        #
        # self.api_keys = {}
        # settings = QSettings('YourOrganization', 'YourApplication')
        # for row in range(self.tableWidget.rowCount()):
        #     key_name = self.tableWidget.cellWidget(row, 0).currentText()
        #     api_key = self.tableWidget.cellWidget(row, 1).findChild(QgsPasswordLineEdit).text()
        #     self.api_keys[key_name] = api_key
        #     settings.setValue(f'API_Key/{key_name}', api_key)

    # def load_api_keys(self):
    #     settings = QSettings('YourOrganization', 'YourApplication')
    #     for row in range(self.tableWidget.rowCount()):
    #         key_name = self.tableWidget.cellWidget(row, 0).currentText()
    #         api_key = settings.value(f'API_Key/{key_name}', '')
    #         self.tableWidget.cellWidget(row, 1).findChild(QgsPasswordLineEdit).setText(api_key)

    def remove_row(self):
        # Get the selected row
        selected_row = self.tableWidget.currentRow()
        if selected_row >= 0:  # Ensure a row is selected
            self.tableWidget.removeRow(selected_row)
            # # Adjust the table height
            # self.adjust_table_height()



    # def adjust_table_height(self):
    #     total_height = self.tableWidget.horizontalHeader().height()
    #     for row in range(self.tableWidget.rowCount()):
    #         total_height += self.tableWidget.rowHeight(row)
    #     self.tableWidget.setFixedHeight(total_height)



    # def set_initial_size(self, width, height):
    #     """Set the initial size of the plugin window."""
    #     self.resize(width, height)

    def send_button_clicked(self):
        """Slot to handle the send button click."""
        user_message = self.task_LineEdit.toPlainText().strip()
        self.CodeEditor.clear()

        if not user_message:
            self.update_chatgpt_ans(f"AI: Please enter a data request in the request field.", is_user=False)
            return  # Stop further execution if the task is empty

        self.update_chatgpt_ans(
            f"--------------------------------------------------------------------------------------------",
            is_user=None)

        self.append_message(user_message)

        # Call update_config_file to save the latest API key
        self.update_openai_config_file()

        # Now read the updated config file to refresh the API key
        self.read_updated_config()

        if not self.ChatMode_checkbox.isChecked() and self.saved_fnameLineEdit.isEnabled() and not self.saved_fnameLineEdit.text().strip():
            self.update_chatgpt_ans(f"AI: Please specify the output directory.", is_user=False)
            return  # Stop further execution if data path is required but empty

        if self.ChatMode_checkbox.isChecked():  # Assuming SwitchControl behaves like a checkbox
            self.chatgpt_direct_answer(user_message)

        else:
            self.run_script()


    def chatgpt_direct_answer(self, user_message):
        """Method to interact with GPT-4 and display the result in output_text_edit_2."""
        # Retrieve the API key from the config
        self.OpenAI_key = self.get_openai_key()  # This retrieves the latest key from the config
        self.model_name = self.modelNameComboBox.currentText()

        self.gpt_thread = GPTRequestThread(user_message, self.OpenAI_key, self.model_name,
                                           self.conversation_history)  # your-api-key-here
        # self.gpt_thread = GPTRequestThread(user_message, "AAzz", self.conversation_history)#your-api-key-here
        self.gpt_thread.output_line.connect(self.update_output)
        self.gpt_thread.finished_signal.connect(lambda: self.update_chatgpt_ans("AI: Done", is_user=False))

        self.gpt_thread.start()

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    # def helpPage (self):
    #     """
    #             change the page of the manual according to the plot type selected and
    #             the language (looks for translations)
    #             """
    #
    #     # locale = QSettings().value('locale/userLocale', 'en_US')[0:2]
    #
    #     self.help_view.load(QUrl(''))
    #     self.layouth.addWidget(self.help_view)
    #     help_url = QUrl(
    #         'https://github.com/gladcolor/LLM-Find/blob/master/README.md')
    #     self.help_view.load(help_url)

    def save_settings(self):
        settings = QSettings('YourOrganization', 'YourApplication')

        settings.setValue('task', self.task_LineEdit.toPlainText())
        settings.setValue('saved_fname', self.saved_fnameLineEdit.text())
        # settings.setValue('OpenAI_key', self.OpenAI_key_LineEdit.text())
        settings.setValue('model_name', self.modelNameComboBox.currentText())

    def load_settings(self):
        settings = QSettings('YourOrganization', 'YourApplication')

        self.task_LineEdit.setPlainText(settings.value('task', ''))
        self.saved_fnameLineEdit.setText(settings.value('saved_fname', ''))
        # self.OpenAI_key_LineEdit.setText(settings.value('OpenAI_key', ''))
        self.modelNameComboBox.setCurrentText(settings.value('model_name', ''))

    def select_output_directory(self):
        file_dialog = QFileDialog(self, "Select Output Directory and Filename")
        file_dialog.setAcceptMode(QFileDialog.AcceptSave)
        file_dialog.setFileMode(QFileDialog.AnyFile)
        file_dialog.setDefaultSuffix("gpkg")
        file_dialog.setNameFilters([
            "GeoPackage (*.gpkg *.GPKG)",
            "Shapefile (*.shp)",
            "CSV files (*.csv)",
            "TIFF files (*.tif *.tiff *.TIF *.TIFF)",
            "PNG files (*.png *.PNG)",
            "All Files (*)"
        ])
        if file_dialog.exec_() == QFileDialog.Accepted:
            selected_file = file_dialog.selectedFiles()[0]
            self.saved_fnameLineEdit.setText(selected_file)
            self.saved_fname = selected_file

    def reproject_layer_to_wgs84(self, layer):
        wgs84_crs = QgsCoordinateReferenceSystem("EPSG:4326")
        transform_context = QgsProject.instance().transformContext()
        transform = QgsCoordinateTransform(layer.crs(), wgs84_crs, transform_context)

        # Create a new layer with WGS84 CRS
        reprojected_layer = QgsVectorLayer(
            layer.dataProvider().dataSourceUri(),
            layer.name() + "_wgs84",
            "memory"
        )
        reprojected_layer.setCrs(wgs84_crs)
        reprojected_layer_data_provider = reprojected_layer.dataProvider()

        # Copy fields from the original layer
        reprojected_layer_data_provider.addAttributes(layer.fields())
        reprojected_layer.updateFields()

        # Reproject features and add to the new layer
        features = []
        for feature in layer.getFeatures():
            reprojected_feature = QgsFeature()
            reprojected_feature.setGeometry(feature.geometry().transform(transform))
            reprojected_feature.setAttributes(feature.attributes())
            features.append(reprojected_feature)

        reprojected_layer_data_provider.addFeatures(features)
        reprojected_layer.updateExtents()

        return reprojected_layer

    def openFileDialog(self):
        # Define the file filter
        file_filter = "Data files (*.csv *.shp *.geojson)"
        saved_fname, _ = QFileDialog.getOpenFileName(None, "Select Data Path", "", file_filter)
        if saved_fname:
            # Set the chosen path in the line edit widget
            self.saved_fnameLineEdit.setText(f"{saved_fname}")


    def save_code_to_file(self):
        code = self.CodeEditor.toPlainText()
        if not code.strip():
            QMessageBox.warning(self, "No Code", "There is no code to save.")
            return
        options = QFileDialog.Options()
        file_name, _ = QFileDialog.getSaveFileName(
            self,
            "Save Code As",
            "",
            "Python(*.py);;Text file (*.txt);;All Files (*),",
            options=options
        )
        if file_name:
            try:
                with open(file_name, "w", encoding = 'utf-8') as file:
                    file.write(code)
                QMessageBox.information(self, "Success", f"Code saved to:\n{file_name}")
            except Exception as e:
                QMessageBox.warning(self, "Error", f"Failed to save code:\n{str(e)}")


    def load_code_from_file(self):
        options = QFileDialog.Options()
        file_name, _ = QFileDialog.getOpenFileName(
            self,
            "Open Code File",
            "",
            "Python(*.py);;Text file (*.txt);;All Files (*),",
            options=options
        )
        if file_name:
            try:
                with open(file_name, "r", encoding = 'utf-8') as file:
                    code = file.read()
                self.CodeEditor.setPlainText(code)
            except Exception as e:
                QMessageBox.information(self, "Error", f"Failed to load code:\n{str(e)}")


    def clear_output_window(self):
        self.execution_output_text_edit.clear()


    def run_generated_code(self):
        self.append_execution_output("Running code ...")
        code_to_run = self.CodeEditor.toPlainText()

        if not code_to_run.strip():
            QMessageBox.warning(self, "No Code", "There is no code to run.")
            return

        import __main__

        if 'processing' not in __main__.__dict__:
            import processing
            __main__.processing = processing

        exec_globals = __main__.__dict__
        exec_locals = {}


        self.generated_code_thread = RunGeneratedCodeThread(code_to_run, exec_globals)
        self.generated_code_thread.CodeEditor_output_line.connect(self.append_execution_output)
        self.generated_code_thread.execution_error.connect(self.append_execution_output)
        self.generated_code_thread.finished.connect(self.generated_code_execution_finished)
        self.generated_code_thread.start()

    def append_execution_output(self, line):

        if not line.strip():
            return
        lines = line.strip().split("\n")
        for line in lines:
            formatted_line = f">>> {line}"

            if "Traceback" in line or "Error" in line:
                color = QColor("red")
            elif "Warning" in line:
                color = QColor("orange")
            elif "Execution completed" in line:
                color = QColor("green")
            else:
                color = QColor("black")

            self.append_colored_text(self.execution_output_text_edit, formatted_line, color)

        self.execution_output_text_edit.moveCursor(QTextCursor.End)
        self.execution_output_text_edit.verticalScrollBar().setValue(
            self.execution_output_text_edit.verticalScrollBar().maximum()
        )

    def append_colored_text(self, text_edit, text, color):
        cursor = text_edit.textCursor()
        cursor.movePosition(QTextCursor.End)
        text_edit.setTextCursor(cursor)

        format = QTextCharFormat()
        format.setForeground(color)

        cursor.insertText(text + '\n', format)

    def generated_code_execution_finished(self):
        # QMessageBox.information(self, "Execution Complete", "The generated code has finished executing.")
        if self.generated_code_thread.success:
            self.append_execution_output("Execution completed")
        else:
            self.append_execution_output("The script finished with errors.")

    def run_script(self):
        # self.update_api_keys()
        # self.tabWidget.setCurrentIndex(self.tab_3_index)

        current_script_dir = os.path.dirname(os.path.abspath(__file__))
        script_path = os.path.join(current_script_dir, 'LLM_Find', 'LLM_FIND.py')
        # OpenAI_key = helper.load_OpenAI_key()
        self.OpenAI_key = self.get_openai_key()  # Retrieve the API key from the line edit
        # self.OpenAI_key = self.api_keys.get("OpenAI_key")
        if not self.OpenAI_key:
            self.update_chatgpt_ans(f"AI: Please enter a valid OpenAI API key.", is_user=False)
            return
        self.model_name = self.modelNameComboBox.currentText()

        # self.task = self.task_LineEdit.text()
        self.task = self.task_LineEdit.toPlainText()
        self.saved_fname = self.saved_fnameLineEdit.text()
        filename_only = os.path.basename(self.saved_fname)  # .split('.')[0]

        # Add task to history and update completer
        if self.task not in self.task_history:
            self.task_history.append(self.task)
            self.task_completer.model().setStringList(self.task_history)

        # Add data path to history and update completer
        if self.saved_fname not in self.saved_fname_history:
            self.saved_fname_history.append(self.saved_fname)
            self.saved_fname_completer.model().setStringList(self.saved_fname_history)

        self.thread = ScriptThread(script_path, self.task, self.saved_fname, self.api_keys, self.model_name)

        # self.task = self.task_LineEdit.text()
        # self.saved_fname = self.saved_fnameLineEdit.text()
        # filename_only = os.path.basename(self.saved_fname)  # .split('.')[0]

        # Add task to history and update completer
        if self.task not in self.task_history:
            self.task_history.append(self.task)
            self.task_completer.model().setStringList(self.task_history)

        # Add data path to history and update completer
        if self.saved_fname not in self.saved_fname_history:
            self.saved_fname_history.append(self.saved_fname)
            self.saved_fname_completer.model().setStringList(self.saved_fname_history)

        self.thread.output_line.connect(self.update_output)
        self.thread.chatgpt_update.connect(self.update_chatgpt_ans)
        self.thread.generated_code_ready.connect(self.update_code_editor)
        self.thread.finished.connect(self.thread_finished)
        self.thread.start()

        # Disable the send_button
        self.run_button.setEnabled(False)
        self.clear_chatgpt_ansBtn.setEnabled(False)
        self.task_LineEdit.setEnabled(False)
        self.saved_fnameLineEdit.setEnabled(False)
        self.SelectDataPath_ToolBtn.setEnabled(False)

    def update_code_editor(self, code):
        """Update the code_editor widget with the last extracted code block."""
        self.CodeEditor.setPlainText(code)


    def stop_script(self):
        if self.thread:
            self.thread.terminate()
            self.update_chatgpt_ans(f"AI: Script terminated")

            # print("Script terminated")
        self.run_button.setEnabled(True)
        self.clear_chatgpt_ansBtn.setEnabled(True)
        self.task_LineEdit.setEnabled(True)
        self.saved_fnameLineEdit.setEnabled(True)
        self.SelectDataPath_ToolBtn.setEnabled(True)

    def update_chatgpt_ans(self, message, is_user=False):
        # Append new message to conversation history
        self.conversation_history.append((message, is_user))
        self.chatgpt_ans.clear()
        for msg, user in self.conversation_history:
            self.append_text_with_format(msg, user)
            # self.chatgpt_ans.append(msg)
        self.chatgpt_ans.repaint()
        self.chatgpt_ans.verticalScrollBar().setValue(self.chatgpt_ans.verticalScrollBar().maximum())

    def append_text_with_format(self, text, is_user=True):
        cursor = self.chatgpt_ans.textCursor()
        cursor.movePosition(QTextCursor.End)

        if is_user:
            html = f'<div style="text-align: left; padding: 10px; margin: 5px; border: 2px solid blue; border-radius: 10px;">{text}</div>'
        else:
            html = f'<div style="text-align: right; padding: 10px; margin: 5px; border: 2px solid green; border-radius: 10px;">{text}</div>'

        cursor.insertHtml(html)
        cursor.insertHtml('<br>')  # Add a line break between messages
        # self.task_LineEdit.clear()

        self.chatgpt_ans.setTextCursor(cursor)

    @pyqtSlot(str)
    def append_message(self, message):
        message = self.task_LineEdit.toPlainText()
        if message.strip():  # Check if message is not empty
            # self.conversation_history.append(f"User: {message}")
            self.update_chatgpt_ans(f"User: {message}", is_user=True)
            self.update_chatgpt_ans(f"AI:Loading ...", is_user=False)
            # Clear the input field after sending the message
            # self.task_LineEdit.clear()

    def update_output(self, line):
        # self.output_text_edit.append(line)

        self.output_text_edit.insertPlainText(line)
        self.output_text_edit.insertPlainText('\n')  # Add a newline after each line
        self.output_text_edit.moveCursor(QTextCursor.End)  # Ensure cursor is at the end
        self.output_text_edit.repaint()

    def thread_finished(self, success):
        if success:
            # self.output_text_edit.append("The script ran successfully.")
            self.output_text_edit.insertPlainText("The script ran successfully.")
            self.update_chatgpt_ans(f"AI: Done")
        else:
            # self.output_text_edit.append("The script finished with errors.")
            self.output_text_edit.insertPlainText("The script finished with errors.")
            self.update_chatgpt_ans(f"AI: The script finished with errors.")

        # Re-enable the send_button    #Not working
        self.run_button.setEnabled(True)
        self.clear_chatgpt_ansBtn.setEnabled(True)
        self.task_LineEdit.setEnabled(True)
        self.saved_fnameLineEdit.setEnabled(True)
        self.SelectDataPath_ToolBtn.setEnabled(True)

    def clear_textboxes(self):
        self.output_text_edit.clear()
        self.task_LineEdit.clear()
        self.chatgpt_ans.clear()
        # self.output_text_edit_2.clear()
        # Clear conversation history to ensure no previous responses are carried forward
        self.conversation_history = []

    def toggle_saved_fnameLineEdit(self, checked):
        """Enable or disable data_pathLineEdit based on the switch_control state."""
        self.saved_fnameLineEdit.setEnabled(not checked)
        self.SelectDataPath_ToolBtn.setEnabled(not checked)
    def interrupt(self):
        if self.thread:
            self.thread.stop()  # Call the stop method to set the flag

    def get_openai_key(self):
        api_key = self.OpenAI_key_LineEdit.text()
        if not api_key:
            raise ValueError("API key is empty. Please enter a valid OpenAI API key.")
        return api_key


    def add_documentation_file(self):
        try:
            destination_dir = os.path.join(os.path.dirname(os.path.abspath(__file__)),"LLM_Find", "Handbooks")

            # Ensure the destination directory exists; if not, create it
            if not os.path.exists(destination_dir):
                os.makedirs(destination_dir)
            # Open file dialog to select .toml files
            files, _ = QFileDialog.getOpenFileNames(
                None, 'Select Documentation Files', '', 'TOML Files (*.toml)'
            )

            # If files are selected, process them
            if files:
                for file_path in files:
                    # Determine the new path for the file in the destination directory
                    new_file_path = os.path.join(destination_dir, os.path.basename(file_path))
                    # Copy the file to the new directory
                    shutil.copy(file_path, new_file_path)
                    # print(f"File {file_path} copied to {new_file_path}")  # or update your UI to reflect the change
                    # Display success message
                QMessageBox.information(None, 'Success',
                                        f'Documentation files have been successfully uploaded to {destination_dir}')
                # else:
                #     # If no files were selected, show an info message
                #     QMessageBox.information(None, 'No Files Selected', 'No documentation files were selected.')

        except Exception as e:
            # Display failure message in case of any errors
            QMessageBox.critical(None, 'Error', f'Failed to upload documentation files: {str(e)}')


class ScriptThread(QThread):
    output_line = pyqtSignal(str)
    chatgpt_update = pyqtSignal(str)
    # graph_ready = pyqtSignal(str)
    # GraphReady = pyqtSignal(str)
    generated_code_ready = pyqtSignal(str)
    finished = pyqtSignal(bool)

    def __init__(self, script_path, task, saved_fname, OpenAI_key, model_name):
        super().__init__()
        self.script_path = script_path
        self.task = task
        self.saved_fname = saved_fname
        self.OpenAI_key = OpenAI_key
        self.model_name = model_name

    def run(self):


        try:
            # Update the config file with the API keys
            # self.update_config_file()

            # #Re-read the config to ensure the keys are updated
            # self.read_updated_config()

            # Ensure that the updated configuration is read by reloading the config
            config_path = os.path.join(os.path.dirname(self.script_path), 'LLM_Find', 'openai_key_config.ini')
            config = configparser.ConfigParser()
            config.read(config_path)

            # Read the script content
            with open(self.script_path, "r") as script_file:
                script_content = script_file.read()




            local_vars = {
                'task': self.task,
                'saved_fname': self.saved_fname,
                # 'OpenAI_key': self.OpenAI_key,  # Add OpenAI_key to local variables
                'model_name': self.model_name
            }
            # # Add each API key to local_vars
            # for key_name, api_key in self.api_keys.items():
            #     local_vars[key_name] = api_key

            # Redirect stdout and stderr to capture the output
            original_stdout = sys.stdout
            original_stderr = sys.stderr
            sys_stdout_capture = StringIO()
            sys_stderr_capture = StringIO()
            sys.stdout = sys_stdout_capture
            sys.stderr = sys_stderr_capture

            def emit_output():
                sys_stdout_capture.flush()
                sys_stderr_capture.flush()
                captured_stdout = sys_stdout_capture.getvalue()
                captured_stderr = sys_stderr_capture.getvalue()
                sys_stdout_capture.truncate(0)
                sys_stderr_capture.truncate(0)
                sys_stdout_capture.seek(0)
                sys_stderr_capture.seek(0)

                if captured_stdout:
                    for line in captured_stdout.splitlines(keepends=True):
                        if line.endswith('\n'):
                            self.output_line.emit(line.rstrip())
                        else:
                            # handle the case where the line doesn't end with a newline
                            self.output_line.emit(line)


                        if "selected_data_source:" in line:
                            tool_IDs = line.split("selected_data_source:")[1].strip()
                            if tool_IDs:
                                # self.tool_filename_ready.emit(tool_filename)  # Emit the tool filename
                                # self.chatgpt_update.emit(f"AI: Selected tool(s): {tool_filename}")
                                self.chatgpt_update.emit(f"AI: Selected data source: {tool_IDs}")

                if captured_stderr:
                    for line in captured_stderr.splitlines(keepends=True):
                        if line.endswith('\n'):
                            self.output_line.emit(f"Error: {line.rstrip()}")
                        else:
                            # handle the case where the line doesn't end with a newline
                            self.output_line.emit(f"Error: {line}")

            # Execute the script using exec
            exec_globals = globals()
            exec_locals = local_vars

            # This will allow for real-time capturing and emitting of output
            import threading
            stop_thread = threading.Event()

            def monitor_output():
                while not stop_thread.is_set():
                    emit_output()
                    time.sleep(0.1)  # Adjust sleep time as needed

            monitor_thread = threading.Thread(target=monitor_output)
            monitor_thread.start()

            try:
                exec(script_content, exec_globals, exec_locals)
            finally:
                stop_thread.set()
                monitor_thread.join()

            # Emit any remaining output
            emit_output()

            # Restore original stdout and stderr
            sys.stdout = original_stdout
            sys.stderr = original_stderr

            if 'generated_code' in exec_locals:
                self.generated_code_ready.emit(exec_locals['generated_code'])

            else:
                self.output_line.emit("Error: 'generated_code' not found after script execution.")

            # Emit success signal
            self.finished.emit(True)

        except Exception as e:
            # Print traceback error to the text_edit
            traceback_str = traceback.format_exc()
            self.output_line.emit(f"Error: {e}\n{traceback_str}")  # Emit any exceptions to the UI
            self.chatgpt_update.emit(f"Error: {e}\n{traceback_str}")  # Emit any exceptions)
            self.finished.emit(False)  # Signal failure

    # def update_config_file(self):
    #     current_script_dir = os.path.dirname(os.path.abspath(__file__))
    #     config_path = os.path.join(current_script_dir, 'LLM_Find', 'openai_key_config.ini')
    #     # config_path = os.path.join(os.path.dirname(self.script_path), 'openai_key_config.ini')
    #     config = configparser.ConfigParser()
    #     config.read(config_path)
    #
    #     if 'API_Key' not in config:
    #         config['API_Key'] = {}
    #
    #     for key_name, api_key in self.api_keys.items():
    #         config['API_Key'][key_name] = api_key
    #
    #     with open(config_path, 'w') as configfile:
    #         config.write(configfile)

    # def read_updated_config(self):
    #     current_script_dir = os.path.dirname(os.path.abspath(__file__))
    #     config_path = os.path.join(current_script_dir, 'LLM_Find', 'openai_key_config.ini')
    #     # config_path = os.path.join(os.path.dirname(self.script_path), 'openai_key_config.ini')
    #     config = configparser.ConfigParser()
    #     config.read(config_path)
    #     if 'API_Key' in config:
    #         for row in range(self.tableWidget.rowCount()):
    #             key_name = self.tableWidget.cellWidget(row, 0).currentText()
    #             if key_name in config['API_Key']:
    #                 api_key = config['API_Key'][key_name]
    #                 self.tableWidget.cellWidget(row, 1).findChild(QgsPasswordLineEdit).setText(api_key)



    def stop(self):
        self._is_running = False

    def isRunning(self):
        return self._is_running




class GPTRequestThread(QThread):
    output_line = pyqtSignal(str)
    finished_signal = pyqtSignal()

    def __init__(self, prompt, OpenAI_key, model_name, conversation_history):
        super().__init__()
        self.prompt = prompt
        self.OpenAI_key = OpenAI_key
        self.model_name = model_name

    def load_api_key_from_config(self):
        """Load OpenAI API key from openai_key_config.ini."""
        current_script_dir = os.path.dirname(os.path.abspath(__file__))
        config_path = os.path.join(current_script_dir, 'LLM_Find', 'openai_key_config.ini')

        config = configparser.ConfigParser()
        config.read(config_path)

        if 'API_Key' in config and 'OpenAI_key' in config['API_Key']:
            return config['API_Key']['OpenAI_key']
        else:
            raise ValueError("API Key not found in config file.")

    def run(self):
        try:
            # self.update_config_file()
            from openai import OpenAI
            client = OpenAI(api_key=self.OpenAI_key)
            response = client.chat.completions.create(
                model= self.model_name,#"gpt-4",
                messages=[
                    {"role": "user", "content": self.prompt},
                ]
            )
            reply = response.choices[0].message.content.strip()
            self.output_line.emit(f"AI: {reply}")
        except Exception as e:
            self.output_line.emit(f"Error: {str(e)}")
        finally:
            self.finished_signal.emit()

class PythonHighlighter(QSyntaxHighlighter):
    def __init__(self, document, always_highlight=False):
        super(PythonHighlighter, self).__init__(document)
        self.always_highlight = always_highlight
        self.python_block = False

        self.highlighting_rules = []

        keyword_format = QTextCharFormat()
        keyword_format.setForeground(QColor("blue"))
        keywords = [
            "def", "class", "if", "else", "elif", "while", "for", "return", "import", "from", "as", "with", "try",
            "except", "finally", "raise", "yield", "lambda", "pass", "break", "continue", "global", "nonlocal",
            "assert", "del", "and", "as", "assert", "break", "class", "continue", "del", "elif", "else", "except",
            "False", "finally", "for", "in", "is", "None", "not", "or", "pass", "raise", "return", "True", "print"
        ]

        for keyword in keywords:
            pattern = re.compile(r'\b' + keyword + r'\b')
            self.highlighting_rules.append((pattern, keyword_format))

        # Strings
        string_format = QTextCharFormat()
        string_format.setForeground(QColor("green"))
        self.highlighting_rules.append((re.compile(r'"[^"\\]*(\\.[^"\\]*)*"'), string_format))
        self.highlighting_rules.append((re.compile(r"'[^'\\]*(\\.[^'\\]*)*'"), string_format))

        # Comments
        comment_format = QTextCharFormat()
        comment_format.setForeground(QColor("gray"))
        self.highlighting_rules.append((re.compile(r'#.*'), comment_format))

    def highlightBlock(self, text):
        if not self.always_highlight:
            if text.strip() == "```python":
                self.python_block = True
                return  # Don't highlight the marker line
            elif text.strip() == "```":
                self.python_block = False
                return  # Don't highlight the marker line

        # Apply syntax highlighting only if we're inside a Python block
        # if self.python_block:
        if self.always_highlight or self.python_block:
            for pattern, format in self.highlighting_rules:
                for match in pattern.finditer(text):
                    start, end = match.span()
                    self.setFormat(start, end - start, format)


class ContributionDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.plugin = parent  # Reference to the main plugin class

        self.setWindowTitle("Contribute to AutonomousGIS_GeodataRetrieverAgent")
        self.setMinimumWidth(400)

        self.setWindowTitle("Contribute to Spatial Analysis Agent")
        layout = QVBoxLayout(self)

        # Add a label for instructions
        instructions = QLabel("Instructions for contribution:")
        layout.addWidget(instructions)

        # Instructional label
        instructions = QLabel("""
        <h3>How to Contribute</h3>
        <ol>
            <li><b>Fork this repository</b> on GitHub: <a href='https://github.com/Teakinboyewa/AutonomousGIS_GeodataRetrieverAgent'>Click Here</a>.</li>
            <li><b>Clone your fork</b> to your local machine.</li>
            <li>Upload a TOML file using this dialog (it will go to your forked repository).</li>
            <li>After uploading, go to GitHub and <b>open a pull request</b> from your fork to the main repository.</li>
        </ol>
        """)
        instructions.setOpenExternalLinks(True)
        layout.addWidget(instructions)

        # File upload button
        self.upload_button = QPushButton("Upload TOML File to Fork")
        self.upload_button.clicked.connect(self.upload_toml_file)
        layout.addWidget(self.upload_button)

    def get_github_token(self):
        """Retrieve the GitHub token from the config file or prompt the user to enter one."""

        # Path to the configuration file
        current_script_dir = os.path.dirname(os.path.abspath(__file__))
        githubtokenConfig_path = os.path.join(current_script_dir, "config_files", "GitHubTokenConfig.ini")

        config = configparser.ConfigParser()

        try:
            # Check if the config file exists
            if os.path.exists(githubtokenConfig_path):
                # If the config file exists, read the token from it
                config.read(githubtokenConfig_path)
                token = config.get("GitHub", "token", fallback=None)

                # If no token found, prompt for token
                if not token:
                    token = self.prompt_for_token(githubtokenConfig_path)
                return token

            else:
                # If the config file doesn't exist, create it and prompt for token
                os.makedirs(os.path.dirname(githubtokenConfig_path), exist_ok=True)
                return self.prompt_for_token(githubtokenConfig_path)

        except (configparser.Error, IOError) as e:
            QMessageBox.warning(self, "Error", f"Failed to read or write the token configuration: {e}")
            return None

    def prompt_for_token(self, config_file_path):
        """Prompt the user for a GitHub token and store it in the config file."""
        token, ok = QInputDialog.getText(self, 'GitHub Token', 'Please enter your GitHub token:')
        if ok and token:
            self.save_github_token(config_file_path, token)
            return token
        else:
            return None

    def save_github_token(self, config_file_path, token):
        """Save the GitHub token to the configuration file."""
        config = configparser.ConfigParser()
        config.read(config_file_path)
        config["GitHub"] = {"token": token}

        with open(config_file_path, "w") as config_file:
            config.write(config_file)

    def check_if_fork_exists(self, token, username):
        repo = "Teakinboyewa/AutonomousGIS_GeodataRetrieverAgent"
        url = f"https://api.github.com/repos/{username}/AutonomousGIS_GeodataRetrieverAgent"

        headers = {
            "Authorization": f"token {token}",
            "Accept": "application/vnd.github.v3+json"
        }

        response = requests.get(url, headers=headers)

        if response.status_code == 200:
            return True  # The fork exists
        else:
            return False

    def upload_to_user_fork(self, token, file_path, username):
        repo = f"{username}/AutonomousGIS_GeodataRetrieverAgent"  # Target the user's fork
        FOLDER_IN_REPO = "LLM_Find/Handbook"  # Folder inside the repository
        file_name =os.path.basename(file_path)
        path_in_repo = f"{FOLDER_IN_REPO}/{file_name}"
        url = f"https://api.github.com/repos/{repo}/contents/{path_in_repo}"



        headers = {
            "Authorization": f"token {token}",

            "Accept": "application/vnd.github.v3+json"
        }

        # Check if the file already exists to get its S
        response = requests.get(url, headers=headers)

        if response.status_code == 200:
            file_data = response.json()
            sha = file_data["sha"]  # Get the SHA of the existing file
            file_exists = True
        elif response.status_code == 404:
            file_exists = False
            sha = None  # File doesn't exist, no SHA needed
        else:
            print(f"Error checking file existence: {response.json()}")
            raise Exception(f"Error checking file existence: {response.json()}")

        # Read the file content to upload
        with open(file_path, 'rb') as file:
            content = file.read()

        encoded_content = base64.b64encode(content).decode("utf-8")

        data = {
            "message": "Adding a new TOML file via QGIS plugin",
            "content": encoded_content
        }

        # If the file exists, include the SHA to update it
        if file_exists:
            data["sha"] = sha

        response = requests.put(url, json=data, headers=headers)

        if response.status_code in[200,201]:
            print("File successfully uploaded/updated in the forked GitHub repository.")
        else:
            print(f"Failed to upload/update file: {response.json()}")
            raise Exception(f"GitHub upload/update failed: {response.json()}")

        # if response.status_code == 201:
        #     print("File successfully uploaded to the forked GitHub repository.")
        # else:
        #     print(f"Failed to upload file: {response.json()}")
        #     raise Exception(f"GitHub upload failed: {response.json()}")

    def prompt_pull_request(self, username):
        pr_url = f"https://github.com/{username}/AutonomousGIS_GeodataRetrieverAgent/compare"
        msg = QMessageBox()
        msg.setIcon(QMessageBox.Information)
        msg.setText(
            f"File uploaded successfully to your fork.\nPlease open a pull request to merge it into the main repository.")
        msg.setInformativeText(f"<a href='{pr_url}'>Click here to open a pull request</a>")
        msg.setStandardButtons(QMessageBox.Ok)
        msg.exec_()

    def upload_toml_file(self):
        """Handle the file upload to the user's fork."""
        token = self.get_github_token()  # Get GitHub token from main plugin

        if not token:
            QMessageBox.warning(self, "Error", "GitHub token is required.")
            return

        # Prompt user to select a file
        file_dialog = QFileDialog(self)
        toml_files, _ = file_dialog.getOpenFileNames(self, "Select a TOML file", "", "TOML Files (*.toml)")

        if toml_files:
            # Ask for GitHub username (you can automate this with the token if preferred)
            username, ok = QInputDialog.getText(self, 'GitHub Username', 'Enter your GitHub username:')

            if ok and username:
                for toml_file in toml_files:
                    # Upload the file to the user's fork
                    self.upload_to_user_fork(token, toml_file, username)

                # Prompt the user to open a pull request
                self.prompt_pull_request(username)
            else:
                QMessageBox.warning(self, "Error", "GitHub username is required.")


class AddKeyDialog(QDialog):
    def __init__(self, keys_directory, parent=None):
        super().__init__(parent)
        self.keys_directory = keys_directory
        self.setWindowTitle("Add New Key")

        # Dialog layout
        layout = QVBoxLayout()

        # Key Name input
        self.name_label = QLabel("Enter the Key Name:")
        self.name_input = QLineEdit()
        layout.addWidget(self.name_label)
        layout.addWidget(self.name_input)

        # Key Value input
        self.key_label = QLabel("Enter the Key Value:")
        self.key_input = QLineEdit()
        layout.addWidget(self.key_label)
        layout.addWidget(self.key_input)

        # Save button
        self.save_button = QPushButton("Save")
        self.save_button.clicked.connect(self.save_key)
        layout.addWidget(self.save_button)

        self.setLayout(layout)

    def save_key(self):
        key_name = self.name_input.text().strip()
        key_value = self.key_input.text().strip()

        if not key_name or not key_value:
            QMessageBox.warning(self, "Input Error", "Both key name and key value are required.")
            return

        # Create the filename
        file_name = f"{key_name}.keys"
        file_path = os.path.join(self.keys_directory, file_name)

        # Construct the content of the file
        api_key_name = f"{key_name}_key"
        content = f"[API_Key]\n{api_key_name} = {key_value}\n"

        try:
            # Write the content to the new .keys file
            with open(file_path, 'w') as key_file:
                key_file.write(content)

            # Show success message
            # QMessageBox.information(self, "Success", f"New key file '{file_name}' created successfully.")

            # Close the dialog
            self.accept()

        except Exception as e:
            QMessageBox.warning(self, "File Error", f"Failed to create the key file: {file_name}\nError: {str(e)}")


class RemoveKeyDialog(QDialog):
    def __init__(self, keys_directory, parent=None):
        super().__init__(parent)
        self.keys_directory = keys_directory
        self.setWindowTitle("Remove Key")

        # Dialog layout
        layout = QVBoxLayout()

        # Combo box to list all the key files
        self.combo_box = QComboBox()
        self.load_key_names()
        layout.addWidget(QLabel("Select a key to remove:"))
        layout.addWidget(self.combo_box)

        # Remove button
        self.remove_button = QPushButton("Remove")
        self.remove_button.clicked.connect(self.remove_key)
        layout.addWidget(self.remove_button)

        self.setLayout(layout)

    def load_key_names(self):
        # Get all .keys files from the 'Keys' directory
        keys_files = [f for f in os.listdir(self.keys_directory) if f.endswith('.keys') and f != 'template.keys']
        all_key_names = [os.path.splitext(f)[0] for f in keys_files]
        self.combo_box.addItems(all_key_names)

    def remove_key(self):
        selected_key_name = self.combo_box.currentText()

        if not selected_key_name:
            QMessageBox.warning(self, "Selection Error", "Please select a key to remove.")
            return

        # Confirm deletion
        confirm = QMessageBox.question(self, "Confirm Delete",
            f"Are you sure you want to remove the key '{selected_key_name}'?",
            QMessageBox.Yes | QMessageBox.No)

        if confirm == QMessageBox.Yes:
            file_path = os.path.join(self.keys_directory, f"{selected_key_name}.keys")
            try:
                # Remove the key file
                os.remove(file_path)

                # Show success message
                QMessageBox.information(self, "Success", f"Key file '{selected_key_name}' removed successfully.")

                # Close the dialog and return success
                self.accept()

            except Exception as e:
                QMessageBox.warning(self, "File Error", f"Failed to remove the key file: {file_path}\nError: {str(e)}")

class StreamRedirector(QObject):
    output_written = pyqtSignal(str)

    def __init__(self):
        super().__init__()
        self.buffer = ''

    def write(self, text):
        if text:
            self.buffer += text
            while '\n' in self.buffer:
                line, self.buffer = self.buffer.split('\n', 1)
                self.output_written.emit(line)

    def flush(self):
        if self.buffer:
            self.output_written.emit(self.buffer)
            self.buffer = ''

class RunGeneratedCodeThread(QThread):
    CodeEditor_output_line = pyqtSignal(str)
    execution_error = pyqtSignal(str)
    report_ready = pyqtSignal(str)

    def __init__(self, code_to_run, exec_globals):
        super().__init__()
        self.code_to_run = code_to_run
        self.exec_globals = exec_globals  # Store exec_globals

    def run(self):
        self.success = True
        # Redirect stdout and stderr
        original_stdout = sys.stdout
        original_stderr = sys.stderr
        sys.stdout = StreamRedirector()
        sys.stderr = StreamRedirector()

        sys.stdout.output_written.connect(self.handle_output_line)
        # sys.stdout.output_written.connect(self.CodeEditor_output_line.emit)
        sys.stderr.output_written.connect(self.CodeEditor_output_line.emit)

        try:
            # exec_locals = {}
            exec(self.code_to_run, self.exec_globals)
        except Exception as e:
            self.success = False
            traceback_str = traceback.format_exc()
            self.execution_error.emit(f"Error executing code:\n{traceback_str}")
        finally:
            sys.stdout = original_stdout
            sys.stderr = original_stderr

    def handle_output_line(self, line):
        # Emit the line to the execution output
        self.CodeEditor_output_line.emit(line)
        path_pattern = re.compile(r'([A-Za-z]:\\[^\\/:*?"<>|\r\n]+(?:\\[^\\/:*?"<>|\r\n]+)*\.\w+|/[^/ ]+/[^ ]+)')
        match = path_pattern.search(line)
        if match:
            generated_output = match.group(0)
            if generated_output:
                self.report_ready.emit(generated_output)