# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AutomaticBackupDialog
                                 A QGIS plugin
 Create automatic backup for your project
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-12-27
        git sha              : $Format:%H$
        copyright            : (C) 2019 by S.Poudroux
        email                : sebastien.poudroux@kheper3d.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QTimer, QUrl
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QMessageBox,QFileDialog,QDialog
from qgis.core import *
from qgis.utils import iface
from pathlib import Path
from datetime import datetime






# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'automatic_backup_dialog_base.ui'))


class AutomaticBackupDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self):
        """Constructor."""
        QDialog.__init__(self)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.timer = QTimer()
        self.timer.timeout.connect(self.timerEvent)
        self.checkSettings()
        self.enableAutoSave.clicked.connect(self.enableBackup)
        self.enableAlternateBox.clicked.connect(self.enableAlternateSave)
        self.pushButton.clicked.connect(self.selectDirectory)
        self.pushButton_Help.clicked.connect(self.help)

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        self.locale = QSettings().value('locale/userLocale')[0:2]

    def closeEvent(self, event):
        pass
        '''self.reset()'''

    def reset(self):
        self.timer.stop()
        self.enableAutoSave.setChecked(False)
        self.enableAlternateBox.setDisabled(True)
        self.intervalSpinBox.setDisabled(True)
        self.intervalSpinBox.setProperty("value", 5)
        self.intervalLabel.setDisabled(True)
        self.enableSaveLayers.setChecked(False)
        self.enableSaveLayers.setDisabled(True)
        self.enableAlternateBox.setChecked(False)
        self.enableAlternateBox.setDisabled(True)
        self.label.setDisabled(True)
        self.lineEdit.setDisabled(True)
        self.pushButton.setDisabled(True)
        self.recordLabel.setDisabled(True)
        self.recordSpinBox.setDisabled(True)
        self.recordSpinBox.setProperty("value", 5)
        self.lineEdit.clear()

    def enableBackup(self):
        if self.enableAutoSave.isChecked():
            self.enableAlternateBox.setEnabled(True)
            self.intervalSpinBox.setEnabled(True)
            self.intervalLabel.setEnabled(True)
            self.enableSaveLayers.setEnabled(True)

        else:
            self.enableAlternateBox.setDisabled(True)
            self.intervalSpinBox.setDisabled(True)
            self.intervalLabel.setDisabled(True)
            self.enableSaveLayers.setChecked(False)
            self.enableSaveLayers.setDisabled(True)
            self.enableAlternateBox.setChecked(False)
            self.enableAlternateBox.setDisabled(True)

    def enableAlternateSave(self):
        if self.enableAlternateBox.isChecked():
            self.label.setEnabled(True)
            self.lineEdit.setEnabled(True)
            self.pushButton.setEnabled(True)
            self.recordLabel.setEnabled(True)
            self.recordSpinBox.setEnabled(True)
        else:
            self.label.setDisabled(True)
            self.lineEdit.setDisabled(True)
            self.pushButton.setDisabled(True)
            self.recordLabel.setDisabled(True)
            self.recordSpinBox.setDisabled(True)
            self.lineEdit.clear()

    def selectDirectory(self):
        self.lineEdit.setText(QFileDialog.getExistingDirectory())

    def output(self):
        return self.lineEdit.text()

    def reject(self):
        '''self.enableAutoSave.setChecked(False)
        self.enableSaveLayers.setChecked(False)
        self.enableSaveLayers.setDisabled(True)
        self.enableAlternateBox.setChecked(False)
        self.enableAlternateBox.setDisabled(True)
        self.intervalSpinBox.setDisabled(True)
        self.intervalLabel.setDisabled(True)
        self.label.setDisabled(True)
        self.lineEdit.setDisabled(True)
        self.pushButton.setDisabled(True)
        self.recordLabel.setDisabled(True)
        self.recordSpinBox.setDisabled(True)
        self.lineEdit.clear()
        self.stop()'''
        self.close()

    def checkSettings(self):
        settings = QSettings()
        value = settings.value("AutomaticBackup/enabled", defaultValue = "None")
        if value == "None":
            settings.setValue("AutomaticBackup/enabled","False")
            settings.setValue("AutomaticBackup/AlternateSave","False")
            settings.setValue("AutomaticBackup/Interval",self.intervalSpinBox.value())
            settings.setValue("AutomaticBackup/NumberOfRecords",self.recordSpinBox.value())
            settings.setValue("AutomaticBackup/SaveLayersInEditMode","False")
            settings.setValue("AutomaticBackup/RecordPath","")

        elif value == "True":
            self.start(settings.value("AutomaticBackup/Interval",""))
            self.enableAutoSave.setChecked(True)
            self.enableAlternateBox.setEnabled(True)
            self.intervalSpinBox.setEnabled(True)
            self.intervalSpinBox.setValue(int(settings.value("AutomaticBackup/Interval","")))
            self.intervalLabel.setEnabled(True)
            self.enableSaveLayers.setEnabled(True)
            self.recordSpinBox.setValue(int(settings.value("AutomaticBackup/NumberOfRecords","")))
            self.lineEdit.setText(settings.value("AutomaticBackup/RecordPath",""))
            if settings.value("AutomaticBackup/AlternateSave","") == 'True':
                self.enableAlternateBox.setChecked(True)
                self.label.setEnabled(True)
                self.lineEdit.setEnabled(True)
                self.pushButton.setEnabled(True)
                self.recordLabel.setEnabled(True)
                self.recordSpinBox.setEnabled(True)
            else:
                self.enableAlternateBox.setChecked(False)
                self.label.setDisabled(True)
                self.lineEdit.setDisabled(True)
                self.pushButton.setDisabled(True)
                self.recordLabel.setDisabled(True)
                self.recordSpinBox.setDisabled(True)

            if settings.value("AutomaticBackup/SaveLayersInEditMode","") == 'True':
                self.enableSaveLayers.setChecked(True)
            else:
                self.enableSaveLayers.setChecked(False)
        elif value == "False":
            self.enableAutoSave.setChecked(False)
            self.enableAlternateBox.setDisabled(True)
            if settings.value("AutomaticBackup/AlternateSave","") == 'True':
                self.enableAlternateBox.setChecked(True)
            else:
                self.enableAlternateBox.setChecked(False)
            self.intervalSpinBox.setDisabled(True)
            self.intervalLabel.setDisabled(True)
            self.enableSaveLayers.setDisabled(True)

            self.label.setDisabled(True)
            self.lineEdit.setDisabled(True)
            self.pushButton.setDisabled(True)
            self.recordLabel.setDisabled(True)
            self.recordSpinBox.setDisabled(True)
            if settings.value("AutomaticBackup/SaveLayersInEditMode","") == 'True':
                self.enableSaveLayers.setChecked(True)
            else:
                self.enableSaveLayers.setChecked(False)

    def accept(self):
        settings = QSettings()
        if self.enableAutoSave.isChecked():
            settings.setValue("AutomaticBackup/enabled","True")
            if self.enableAlternateBox.isChecked():
                if not self.output():
                    if self.locale == 'fr':
                        msg = u"Veuillez spécifier un dossier d'export."
                    else:
                        msg = u"Please specify an export folder."
                    QMessageBox.warning(self, 'Automatic Backup', msg)
                    return
                settings.setValue("AutomaticBackup/AlternateSave","True")
            else:
                settings.setValue("AutomaticBackup/AlternateSave","False")
            if self.enableSaveLayers.isChecked():
                settings.setValue("AutomaticBackup/SaveLayersInEditMode","True")
            else:
                settings.setValue("AutomaticBackup/SaveLayersInEditMode","False")
            settings.setValue("AutomaticBackup/Interval",self.intervalSpinBox.value())
            settings.setValue("AutomaticBackup/NumberOfRecords",self.recordSpinBox.value())
            settings.setValue("AutomaticBackup/RecordPath",self.output())
            self.start(self.intervalSpinBox.value())
            self.hide()
        else:
            settings.setValue("AutomaticBackup/enabled","False")
            if self.enableAlternateBox.isChecked():
                settings.setValue("AutomaticBackup/AlternateSave","True")
            else:
                settings.setValue("AutomaticBackup/AlternateSave","False")
            if self.enableSaveLayers.isChecked():
                settings.setValue("AutomaticBackup/SaveLayersInEditMode","True")
            else:
                settings.setValue("AutomaticBackup/SaveLayersInEditMode","False")
            settings.setValue("AutomaticBackup/Interval",self.intervalSpinBox.value())
            settings.setValue("AutomaticBackup/NumberOfRecords",self.recordSpinBox.value())
            settings.setValue("AutomaticBackup/RecordPath",self.output())
            self.stop()
            self.hide()

    def start(self,interval):
            self.timer.start(int(interval)*60000)

    def stop(self):
        self.timer.stop()

    def timerEvent(self):
        if self.enableSaveLayers.isChecked():
            self.editMode()
        self.backup()

    def editMode(self):
        for layer in iface.mapCanvas().layers():
            if layer.isEditable() and layer.isModified():
                layer.commitChanges()
                layer.startEditing()

    def backup(self):
        value = self.recordSpinBox.value()
        projectFileName = QgsProject.instance().fileName()
        suffix = Path(projectFileName).suffix
        project = QgsProject.instance()
        directory = self.output() + "/"
        dirFile = directory + str(Path(projectFileName).stem)

        if projectFileName != "" and project.isDirty():
            if self.enableAlternateBox.isChecked():
                name = str(Path(projectFileName).stem) + "_backup"
                files = [os.path.abspath(os.path.join(directory, f)) for f in os.listdir(directory) if name in f and f is not projectFileName]
                if len(files) == value:
                    file = min(files, key=os.path.getmtime)
                    os.remove(file)
                for i in range(value):
                    date = str(datetime.now().strftime('%Y_%m_%d_%H_%M'))
                    newFileName = dirFile + "_backup_{}{}".format(date,suffix)
                    if not os.path.exists(newFileName):
                        project.setFileName(newFileName)
                        project.write()
                        project.setFileName(projectFileName)
                        if self.locale == 'fr':
                            msg = u" Projet sauvegardé sous : " + newFileName
                        else:
                            msg = u" Project saved to : " + newFileName
                        iface.messageBar().pushSuccess("Automatic Backup", msg)
                        break

            else:
                newFileName = str(Path(projectFileName).parent) + "\\" + str(Path(projectFileName).stem) + "_backup{}".format(suffix)
                if os.path.exists(newFileName):
                    os.remove(newFileName)
                project.setFileName(newFileName)
                project.write()
                project.setFileName(projectFileName)
                if self.locale == 'fr':
                    msg = u" Projet sauvegardé sous : " + newFileName
                else:
                    msg = u" Project saved to : " + newFileName
                iface.messageBar().pushSuccess("Automatic Backup", msg)

    def help(self):
        if self.locale == 'fr':
            help_file = "file:///{}/help/fr/build/html/index.html".format(os.path.dirname(__file__))
        else:
            help_file = "file:///{}/help/en/build/html/index.html".format(os.path.dirname(__file__))
        QDesktopServices().openUrl(QUrl(help_file))