"""
/***************************************************************************
 AutoPlot
                                 A QGIS plugin
 AutoPlot
                              -------------------
        begin                : 2012-03-14
        copyright            : (C) 2012 by NPT
        email                : t.colley@npt.gov.uk
 ***************************************************************************

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from autoplotdialog import AutoPlotDialog

class AutoPlot:
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        self.layerRegistry = QgsMapLayerRegistry.instance()
        # create and show the dialog
        self.dlg = AutoPlotDialog(self.iface)
        
    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/autoplot/icon.png"), \
            "AutoPlot", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)
        # check if active layer 
        QObject.connect(self.layerRegistry, SIGNAL("layerWillBeRemoved(QString)"), self.checkLayers)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&AutoPlot", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&AutoPlot",self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
        # show the dialog
        self.dlg.show()
        result = self.dlg.exec_()
        self.targetLayer = self.dlg.targetLayer
        self.sourceLayer = self.dlg.sourceLayer
        # See if OK was pressed
        if result == 1:
            PolyAction(self.iface,self.sourceLayer,self.targetLayer)

    def checkLayers(self):
        for layer in self.iface.mapCanvas().layers():
            if self.sourceLayer.name == layer.name:
                QMessageBox.information(None,"Info","Selected Layer Removed. Re-run plugin")
            elif self.targetLayer.name == layer.name:
                QMessageBox.information(None,"Info","Selected Layer Removed. Re-run plugin")
                
class PolyAction(QAction):
    def __init__(self,iface,sLayer,tLayer):
        self.sourceLayer = sLayer
        self.targetLayer = tLayer
        mw = iface.mainWindow()
        QAction.__init__(self,"Polygon",mw)
        self.iface = iface
        canvas = self.iface.mapCanvas()
        self.tool = PolygonTool(canvas,iface,self.sourceLayer,self.targetLayer)
        canvas.setMapTool(self.tool)
        return None
    
class PolygonTool(QgsMapTool):
    def __init__(self,canvas,iface,sLayer,tLayer):
        self.targetLayer = tLayer
        self.sourceLayer = sLayer
        QgsMapTool.__init__(self,canvas)
        self.iface = iface
        self.canvas = canvas
        self.rb = QgsRubberBand(canvas, True)
        return None

    def deactivate(self):
        self.rb.reset()
        return None

    def canvasPressEvent(self,e):
        if e.button() == Qt.LeftButton:
            p = self.toLayerCoordinates(self.targetLayer,e.pos())
            self.rb.addPoint(self.toMapCoordinates(self.targetLayer,p))
        else:
            if self.rb.numberOfVertices() > 2:
                self.selectRubberBand(e.modifiers())
                self.rb.reset()
        return None

    def canvasMoveEvent(self,e):
        if self.rb.numberOfVertices() > 0:
            self.rb.removeLastPoint(0)
            p = self.toLayerCoordinates(self.targetLayer,e.pos())
            self.rb.addPoint(self.toMapCoordinates(self.targetLayer, p))
        return None

    def selectRubberBand(self, modifiers):
        if not self.sourceLayer.type() == self.sourceLayer.VectorLayer:
	    QMessageBox.critical(None,"Invalid Source Layer","The source layer is not a vector layer.")
	    return
	if not self.targetLayer.type() == self.targetLayer.VectorLayer:
            QMessageBox.critical(None,"Invalid Target Layer","The target layer is not a vector layer.")
            return
        coords = []
        [coords.append(QgsMapTool(self.canvas).toLayerCoordinates(self.sourceLayer, self.rb.getPoint(0,i))) for i in range(self.rb.numberOfVertices())]
        g = QgsGeometry().fromPolygon([coords])
        provider = self.sourceLayer.dataProvider()
        allA=provider.attributeIndexes()
        provider.select([],g.boundingBox(),True,True)
        feat = QgsFeature()
        selectedSet = []
        geoms = []
        while provider.nextFeature(feat):
            geom = QgsGeometry(feat.geometry())
            if geom.intersects(g):
                selectedSet.append(feat.id())
                geoms.append(geom)
        if modifiers & Qt.ControlModifier:
            selectedSet = list(set(layer.selectedFeatureIds()).union(selectedSet))
        elif modifiers & Qt.ShiftModifier:
            selectedSet = list(set(layer.selectedFeatureIds()).difference(selectedSet))
        self.sourceLayer.setSelectedFeatures(selectedSet)
        nF = self.sourceLayer.selectedFeatureCount()
        #QMessageBox.information(None,"Info","# Selected %s, # Geometries %s" % (nF, len(geoms)))
        mergeGeom = geoms[0]
        count = 0
        for x in geoms:
            count += 1
            #QMessageBox.information(None,"Info","%s" % x.asMultiPolygon())
            mergeGeom = QgsGeometry(mergeGeom.combine(x))
        #QMessageBox.information(None,"Info","%s" % count)
        msgBox = QMessageBox()
        msgBox.setText("You have selected %s features" % nF)
        msgBox.setInformativeText("Do you want to create a new feature from this selection?")
        msgBox.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
        msgBox.setDefaultButton(QMessageBox.Yes)
        msgBox.exec_()
        if msgBox.exec_() == 16384:
            self.addToLayer(mergeGeom)
        else:
            self.sourceLayer.setSelectedFeatures([])
            self.canvas.setMapTool(QgsMapToolPan(self.canvas))
            
    def addToLayer(self, mergeGeom):
        feat = QgsFeature()
        feat.setGeometry(mergeGeom)
        if self.targetLayer.isEditable():
            self.targetLayer.addFeature(feat)
            self.sourceLayer.setSelectedFeatures([])
            self.canvas.setMapTool(QgsMapToolPan(self.canvas))
        else:
            self.nonEditable(mergeGeom)

    def nonEditable(self,mergeGeom):
        msgBox = QMessageBox()
        msgBox.setText("Target Layer (%s) is not in edit mode." % self.targetLayer.name())
        msgBox.setInformativeText("Are you sure you want to plot to this layer?")
        msgBox.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
        msgBox.setDefaultButton(QMessageBox.Yes)
        msgBox.exec_()
        if msgBox.exec_() == 16384:
            self.targetLayer.startEditing()
            self.addToLayer(mergeGeom)
            self.sourceLayer.commitChanges()
            
