"""
/***************************************************************************
 AutoPlotDialog
                                 A QGIS plugin
 AutoPlot
                             -------------------
        begin                : 2012-03-14
        copyright            : (C) 2012 by NPT
        email                : t.colley@npt.gov.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from ui_autoplot import Ui_AutoPlot
# create the dialog for zoom to point
class AutoPlotDialog(QDialog):
    def __init__(self, iface):
        QDialog.__init__(self)
        self.iface = iface
        # set up the user interface from Designer.
        self.ui = Ui_AutoPlot()
        self.ui.setupUi(self)
        self.updateLayers()
        self.connect(self.ui.refreshButton, SIGNAL('clicked()'), self.updateLayers)
        self.connect(self.ui.targetLayerBox, SIGNAL('currentIndexChanged(int)'), self.comboBoxChanged)
        self.connect(self.ui.sourceLayerBox, SIGNAL('currentIndexChanged(int)'), self.comboBoxChanged)
        self.targetLayer = self.ui.targetLayerBox.itemData(self.ui.targetLayerBox.currentIndex()).toPyObject()
        self.sourceLayer = self.ui.sourceLayerBox.itemData(self.ui.sourceLayerBox.currentIndex()).toPyObject()
 #       self.layerList = self.ui.layerList
        self.model = QStandardItemModel()
        self.item = QStandardItem("Item")
        self.item.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled)
        self.item.setData(QVariant(Qt.Checked),Qt.CheckStateRole)
        self.model.appendRow(self.item)

 #       self.layerList.setModel(self.model)
        
    def comboBoxChanged(self, thisIndex):
        self.targetLayer = self.ui.targetLayerBox.itemData(self.ui.targetLayerBox.currentIndex()).toPyObject()     
        self.sourceLayer = self.ui.sourceLayerBox.itemData(self.ui.sourceLayerBox.currentIndex()).toPyObject()
        
    def updateLayers(self):
        """Update layers combo box"""
        # empty combo box
        self.ui.targetLayerBox.clear()
        self.ui.sourceLayerBox.clear()
        # get layers and fill target box
        for layer in self.iface.mapCanvas().layers():
            if layer.type() == layer.VectorLayer:
                self.ui.targetLayerBox.addItem(layer.name(), QVariant(layer))
                self.ui.sourceLayerBox.addItem(layer.name(), QVariant(layer))
        # set internal layer to current selected layer
        self.ui.targetLayerBox.emit(SIGNAL("currentIndexChanged"))
        self.ui.sourceLayerBox.emit(SIGNAL("currentIndexChanged"))
