AutoLayer QGIS Plugin
A smart QGIS plugin that automatically processes newly added layers with custom symbology, CRS handling, autosave functionality, and comprehensive settings management.

AutoLayer v2.0 - Key Features

-CRS Management

CRS selection dialog on startup with customizable preferred CRS list (up to 10)
Preferred CRS manager for adding/removing favorite CRS options
Auto assign CRS for vector and raster layers with invalid or unknown CRS to match project CRS

-AutoSave Functionality

AutoSave project with configurable interval and optional prompt
AutoSave layer edits with configurable interval and optional prompt
Automatic save triggers on layer modifications and geometry changes

-Auto Symbology

-Auto symbology for point, line, and polygon layers
-Sequential colors using 16-unique & highly visible color palette

-Special styling for custom layers:

"EO" layers: Default symbols with orange color
"Tile" layers: Blue outline polygons with TileID labels
"Grid" layers: Cyan outline polygons with id labels
"Cutline" layers: Green outline with 0.5mm stroke width



-Layer Management

Auto-enable editing mode for new vector layers
Auto-show feature count for new vector layers
Auto enable "Selection" mode on startup
Auto-collapse raster layers (.pix, .tif, .tiff) with automatic sorting

-Settings & Configuration

Settings dialog with dropdown menu for feature customization
Individual toggles/checkboxes for all auto-features
Toggle plugin on/off via toolbar icon (enabled by default)
Persistent settings storage across sessions

Installation
Method 1: Install from ZIP

Download the plugin: Clone this repository or download as ZIP
In QGIS, go to Plugins > Manage and Install Plugins... > Install from ZIP
Select the downloaded ZIP file
Click Install Plugin

Method 2: Manual Installation

Download/clone this repository
Copy the AutoLayer folder to your QGIS plugins directory:

Windows: C:\Users\[YourUsername]\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\
macOS: ~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/
Linux: ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/


Restart QGIS and enable the plugin from Plugins > Manage and Install Plugins

Usage
Getting Started

Enable the plugin using the toolbar icon (Show Image)
Click the dropdown arrow next to the icon to access Settings
Configure your preferred features and CRS options
Start adding layers - they will be processed automatically

Configuring Settings
Access the settings dialog via the toolbar dropdown menu to customize:

CRS Settings: Enable/disable CRS dialog, manage preferred CRS list, toggle auto-CRS for vectors/rasters
Symbology Settings: Toggle auto-symbology for points, lines, polygons, and custom layers
AutoSave Settings: Configure project and layer autosave intervals and prompts
Other Settings: Toggle selection mode, raster collapse, editing mode, and feature count

Managing Preferred CRS

Open Settings from the toolbar dropdown
Click Choose Preferred CRS button
Add up to 10 favorite CRS systems for quick access
These will appear in the startup CRS selection dialog

File Structure
AutoLayer/
├── __init__.py          # Plugin loader
├── metadata.txt         # Plugin metadata
├── autolayer.py         # Main plugin code
├── autolayer.png        # Plugin icon
├── LICENSE              # MIT License
└── README.md            # This file
Version History
v2.0 (Current)

Added customizable preferred CRS manager
Added comprehensive settings dialog
Added AutoSave for projects and layer edits
Added auto-enable editing mode
Added auto-show feature count
Added individual toggles for all features
Improved component modularity

v1.0

Initial release with basic CRS and symbology features

Requirements

QGIS version: 3.16 or higher
Python 3.6+

Author
MD Moinul Mobin

Email: mdmoinulmobin@gmail.com
GitHub: @md-moinul-mobin

Contributing
Contributions are welcome! Please feel free to submit a Pull Request.
License
This project is licensed under the MIT License - see the LICENSE file for details.
Support
For issues, questions, or feature requests:

Create an issue in this repository: GitHub Issues
Contact the author directly via email

Acknowledgments
Special thanks to the QGIS community for their excellent documentation and support.

Note: This plugin is designed to enhance workflow efficiency for GIS professionals working with multiple layers and coordinate systems.