# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AttributesJoinByLine
                                 A QGIS plugin
 Plugin to create polygon
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-06-16
        copyright            : (C) 2019 by Adrian Bocianowski
                             : The plug-in created thanks to the financial support of <a href="http://geofabryka.pl/">Geofabryka Sp. z o.o.</a>
        email                : adrian@bocianowski.com.pl
        git                  : tracker=https://github.com/abocianowski/AttributesJoinByLine/issues
                             : repository=https://github.com/abocianowski/AttributesJoinByLine
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from .resources import *
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant
from PyQt5.QtGui import QIcon, QColor
from PyQt5.QtWidgets import QAction, QWidget, QTableWidgetItem, QPushButton
from PyQt5 import uic, QtWidgets

from qgis.core import QgsProject,QgsSpatialIndex,QgsPointXY, QgsGeometry, QgsField, QgsVectorLayer, QgsLayerTreeLayer, QgsFeature, NULL

import threading

class AttributesJoinByLine(QWidget):
    def __init__(self, iface):
        QWidget.__init__(self)
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'attributesjoinbyline{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&AttributesJoinByLine')
        self.toolsToolbar = self.iface.addToolBar(u'Attributes Join By Line')
        self.toolsToolbar.setObjectName(u'Attributes Join By Line')
        self.Dialog = AttributesJoinByLineDialog()
        self.Dialog.sourcelayer.currentTextChanged.connect(self.onComboBoxChanged)
        self.Dialog.connectinglayer.currentTextChanged.connect(self.onComboBoxChanged)
        self.Dialog.targetLayer.currentTextChanged.connect(self.onComboBoxChanged)
        self.Dialog.runButton.setEnabled(False)
        self.Dialog.runButton.pressed.connect(self.runTask)

        #Colors
        self.redColor = QColor(255, 0, 0)
        self.blackColor = QColor(0, 0, 0)
        self.greyColor = QColor(65, 105, 225)
        self.greenColor = QColor(34, 139, 34)
        self.greyBlueColor = QColor(47, 79, 79)

        self.first_start = None

    def tr(self, message):
        return QCoreApplication.translate('AttributesJoinByLine', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
        checkable=False,
        checked=False,
        shortcut=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolsToolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        if checkable:
            action.setCheckable(True)
            
        if checked:
            action.setChecked(1)

        if shortcut:
            action.setShortcut(shortcut)

        self.actions.append(action)

        return action

    def initGui(self):
        icon_path = ':/plugins/AttributesJoinByLine/icons/'

        #Run Button 

        # <div>Icons made by 
        # <a href="https://www.flaticon.com/authors/srip" 
        # title="srip">srip</a> from <a href="https://www.flaticon.com/" 			    
        # title="Flaticon">www.flaticon.com</a> is licensed by 
        # <a href="http://creativecommons.org/licenses/by/3.0/" 			    
        # title="Creative Commons BY 3.0" target="_blank">CC 3.0 BY</a></div>
        self.RunButton = self.add_action(
                icon_path + 'AttributesJoinByLine.png',
                text=self.tr(u'Attributes Join by Line'),
                callback=self.run,
                parent=self.iface.mainWindow(),
                add_to_menu=False,
                enabled_flag = True,
                checkable=False)

        self.first_start = True

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&AttributesJoinByLine'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        if self.first_start == True:
            self.first_start = False

        self.Dialog.progressBar.setValue(0)

        # update combo box
        self.Dialog.sourcelayer.clear()
        self.Dialog.connectinglayer.clear()
        self.Dialog.targetLayer.clear()

        self.Dialog.sourcelayer.addItem(None)
        self.Dialog.connectinglayer.addItem(None)
        self.Dialog.targetLayer.addItem(None)

        self.pointLayersList = []
        self.lineLayersList = []

        for layer in QgsProject.instance().mapLayers().values():
            if layer.type() == 0: #Vector layers
                if layer.wkbType () ==1: #Point
                    self.pointLayersList.append(layer)
                    self.Dialog.sourcelayer.addItem(layer.name())
                    self.Dialog.targetLayer.addItem(layer.name())

                if layer.wkbType () in (5,2): #MultiLineString, Linestring
                    self.lineLayersList.append(layer)
                    self.Dialog.connectinglayer.addItem(layer.name())

        self.Dialog.tabs.setCurrentIndex(0)
        self.Dialog.show()

    def onComboBoxChanged(self):
        color = 'rgb(233,150,122)'
        sender = self.sender()
        if sender.currentText() != '':
                sender.setStyleSheet('')
        else:
                sender.setStyleSheet(f'background-color: {color}')
            
        if self.Dialog.sourcelayer.currentText() =='' or self.Dialog.connectinglayer.currentText() =='' or self.Dialog.targetLayer.currentText() =='':
            self.Dialog.runButton.setEnabled(False)
        else:
            self.Dialog.runButton.setEnabled(True)

    def runTask(self):
        self.Dialog.tabs.setCurrentIndex(1)

        for row in reversed(range(0,self.Dialog.log.rowCount())):
            self.Dialog.log.removeRow(row)

        self.sendDialogLog('running proces...',self.greenColor)

        self.addMissingColumns(self.pointLayersList[self.Dialog.sourcelayer.currentIndex ()-1], self.pointLayersList[self.Dialog.targetLayer.currentIndex ()-1])

        #Layers
        sourceLayer = self.pointLayersList[self.Dialog.sourcelayer.currentIndex ()-1]
        sFields = sourceLayer.fields()
        connectinglayer = self.lineLayersList[self.Dialog.connectinglayer.currentIndex ()-1]
        targetLayer = self.pointLayersList[self.Dialog.targetLayer.currentIndex ()-1]
        tFields = targetLayer.fields()
        tFeturesCount = targetLayer.featureCount ()

        p = 0
    
        connectinglayer_index = QgsSpatialIndex(connectinglayer.getFeatures())
        sourcePoint_index = QgsSpatialIndex(sourceLayer.getFeatures())

        failPoints = []
        failMultilines = []

        for targetPointfeature in targetLayer.getFeatures():
            targetGeometry = targetPointfeature.geometry().asPoint()
            nearestLinesIdx = connectinglayer_index.nearestNeighbor(targetGeometry,0)
            nearestLinesIdxCount = len(nearestLinesIdx)

            if nearestLinesIdxCount == 0:
                self.sendDialogLog('No connected lines found',self.redColor,layer = targetLayer, feature = targetPointfeature)
                failPoints.append([targetPointfeature,'No connected lines found'])
            else:
                # Check touches line to source point layer
                lineTouches = []
                for line in nearestLinesIdx:
                    linegeometry = connectinglayer.getFeature(line).geometry().mergeLines()
                    if linegeometry.intersects(targetPointfeature.geometry()):
                        try:
                            linegeometry = linegeometry.asPolyline()
                        except:
                            self.sendDialogLog('The line found is of the multilinestring type. Linestring type is allowed',self.redColor,layer = targetLayer, feature = targetPointfeature)
                            failMultilines.append([targetPointfeature,'The line found is of the multilinestring type. Linestring type is allowed'])
                        lineTouches.append(linegeometry)

                if len(lineTouches) == 0:
                    self.sendDialogLog('No connected lines found',self.redColor,layer = targetLayer, feature = targetPointfeature)
                    failPoints.append([targetPointfeature,'No connected lines found'])
                elif len(failMultilines) ==0:
                    # Find connected points with data using line
                    nearestSourcePoints = []
                    for line in lineTouches:
                        for point in line:
                            nearestSourcePoint = sourcePoint_index.nearestNeighbor(point,0)
                            if nearestSourcePoint != []:
                                nearestSourcePoints.append(nearestSourcePoint)


                    nearestSourcePointsCount = len(nearestSourcePoints)
                    if nearestSourcePointsCount == 0:
                        self.sendDialogLog('No targets points were found using the line',self.redColor,layer = targetLayer, feature = targetPointfeature)
                        failPoints.append([targetPointfeature,'No targets points were found using the line'])
        
                    elif nearestSourcePointsCount < len(lineTouches):
                        self.sendDialogLog('One of the lines is not connected to the source point',self.redColor,layer = targetLayer, feature = targetPointfeature)
                        failPoints.append([targetPointfeature,'One of the lines is not connected to the source point'])
                    
                    elif nearestSourcePointsCount == 1:
                        sourceFeature = sourceLayer.getFeature(nearestSourcePoints[0][0])
                        targetLayer.startEditing()
                        for f in sFields:
                            idx = tFields.indexFromName(f.name())
                            targetLayer.changeAttributeValue(targetPointfeature.id(), idx, sourceFeature.attribute (f.name()))
                        targetLayer.commitChanges()
                    
                    else:
                        #source points was founded  > 1
                        attributes = []
                        for point in nearestSourcePoints:
                            feature = sourceLayer.getFeature(point[0])
                            if attributes == []:
                                attributes = feature.attributes()
                                for i in range(0,len(attributes)):
                                    a = [attributes[i]]
                                    attributes[i] = a
                            else:
                                for i in range(0,len(attributes)):
                                    attributes[i].append(feature.attributes()[i])
                                    attributes[i] = list(set(attributes[i]))

                        fail = 0
                        fail_fields = []
                        attributes_tmp = []
                        i = 0
                        for a in attributes:
                            a = tuple(a)
                            b = list(dict.fromkeys(a))
                            items = [None,NULL,'']
                            if len(b)>1:
                                for item in items:
                                    b = [i for i in b if i != item]
                            if len(b) > 1:
                                fail += 1
                                fail_fields.append(sourceLayer.fields()[i].name())
                            attributes_tmp.append(b)
                            i +=1

                        attributes = attributes_tmp

                        if fail == 0:
                            targetLayer.startEditing()
                            i = 0
                            for f in sourceLayer.fields():
                                idx = tFields.indexFromName(f.name())
                                targetLayer.changeAttributeValue(targetPointfeature.id(), idx, attributes[i][0] )
                                i += 1
                            targetLayer.commitChanges()

                        else:
                            self.sendDialogLog(f"""Can't add {str(nearestSourcePointsCount)} attributes  from source objects. The fields: {fail_fields} have different values""", self.redColor, layer = targetLayer, feature = targetPointfeature )
                            failPoints.append([targetPointfeature,f"""Can't add attributes {str(nearestSourcePointsCount)} from source objects. The fields: {fail_fields} have different values"""])

            p += 1
            self.Dialog.progressBar.setValue((p/tFeturesCount)*100)
        if self.Dialog.addLayersWithError.isChecked():
            if len(failPoints) != 0 or len(failMultilines) != 0:

                for l2rem in QgsProject.instance().mapLayersByName('AJBL_error_target_points'):
                    QgsProject.instance().removeMapLayer(l2rem)

                epsg = targetLayer.sourceCrs().authid()
                layer = QgsVectorLayer(f'Point?crs={epsg}', 'AJBL_error_target_points' , 'memory')
                QgsProject.instance().addMapLayer(layer, False)
                layerTree = self.iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(0, QgsLayerTreeLayer(layer))
                layer.dataProvider().addAttributes([QgsField('Fail', QVariant.String)])
                
                for f in failPoints:
                    layer.startEditing()
                    feature = QgsFeature()
                    feature.setGeometry( f[0].geometry())
                    feature.setAttributes([f[1]])
                    layer.addFeature(feature)
                    layer.commitChanges()

                for f in failMultilines:
                    layer.startEditing()
                    feature = QgsFeature()
                    feature.setGeometry( f[0].geometry())
                    feature.setAttributes([f[1]])
                    layer.addFeature(feature)
                    layer.commitChanges()
                
                layer.reload()

        self.sendDialogLog('process has been completed',self.greenColor)
                                    
    def sendDialogLog(self, text, color, layer = None, feature = None):
        rowCount = self.Dialog.log.rowCount()

        item = QTableWidgetItem(text)
        item.setForeground(color)

        self.Dialog.log.insertRow(rowCount)
        self.Dialog.log.setItem(rowCount,1, item)

        if layer != None and feature != None:
            button = QPushButton('Show on map')
            button.clicked.connect(lambda:self.showOnMap(layer,feature))
            self.Dialog.log.setCellWidget(rowCount,0, button)

    def addMissingColumns(self,sourceLayer, targetLayer):
        trLayer_fields = []

        srFields = sourceLayer.fields()
        trFields = targetLayer.fields()

        for i in trFields:
            name = str(i.name())
            typeName = str(i.typeName())
            tpl = [name,typeName]
            trLayer_fields.append(tpl)

        for i in srFields:
            name = str(i.name())
            typeName = str(i.typeName())
            tpl = [name,typeName]
            if tpl not in trLayer_fields:
                pr = targetLayer.dataProvider()
                pr.addAttributes([i])
                targetLayer.updateFields()
                self.sendDialogLog(f'   Missing field - the field {tpl} did not appear in the target layer and was added',self.greyBlueColor)

    def showOnMap(self,layer,feature):
        layer.removeSelection()
        layer.selectByIds([feature.id()])
        self.canvas.zoomToSelected(layer)
        self.canvas.refresh()

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'dialog/AttributesJoinByLine_dialog.ui'))

class AttributesJoinByLineDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        super(AttributesJoinByLineDialog, self).__init__(parent)
        self.setupUi(self)


    

        
