# Attribute Templates & Autofill

Attribute Templates & Autofill is a QGIS plugin that allows you to create reusable attribute presets and automatically apply them when digitizing new vector features.

It significantly speeds up repetitive data entry workflows and ensures consistent attribute values across your GIS projects.

---

## ✨ Features

- Create multiple attribute templates per layer
- Automatically apply active template when adding new features
- Safely ignores primary key fields (prevents UNIQUE constraint errors)
- Apply templates to selected features
- Import and export templates (JSON format)
- Multilingual interface
- Compatible with QGIS 3.16+

---

## 🚀 Why use this plugin?

When digitizing large datasets, many attributes repeat with only minor differences.

Instead of manually filling the same fields over and over again, you can:

1. Create a template once
2. Activate it
3. Digitize features with attributes filled automatically

This improves productivity and reduces human errors.

---

## 🗂 Typical Use Cases

- Cadastral mapping
- Utility and infrastructure networks
- Environmental surveys
- Asset management
- Large-scale GIS data entry
- Any repetitive attribute workflow

---

## 📦 Installation

### From QGIS Plugin Repository
1. Open QGIS
2. Go to Plugins → Manage and Install Plugins
3. Search for **Attribute Templates & Autofill**
4. Click Install

### Manual Installation
1. Download the ZIP file
2. Go to Plugins → Install from ZIP
3. Select the downloaded archive

---

## 🔧 How It Works

1. Open the plugin panel
2. Select a vector layer
3. Create a template
4. Set it as active
5. Start digitizing — attributes will be filled automatically

---

## 📁 Template Storage

Templates are stored locally in QGIS settings and can be exported/imported as JSON files for backup or sharing.

---

## 📜 License

This plugin is distributed under the GNU General Public License (GPL).

---

## 👤 Author

Алешин Р.И.  
aeromax.live@mail.ru