# ArchDistribution (v1.0.1 'Pallet Town')

**문화유적분포지도 자동 생성 & 현상변경허용기준 스마트 분석 도구**

이 플러그인은 고고학 연구자와 조사기관을 위해 개발된 QGIS 전용 자동화 도구입니다.
복잡한 수치지형도 병합, 유적 분류, 도곽 설정, 스타일링 작업을 단 한 번의 클릭으로 해결하며, 특히 **현상변경허용기준(Zone) 레이어**의 자동 분할 및 스타일링 기능을 제공합니다.

---

## 🚀 주요 기능 (Key Features)

### 1. 🏗️ 현상변경허용기준 자동 분석 (Improved)
*   **정밀 구역 분할**: "2-1구역", "2-2구역" 등 세부 구역을 정규식(Regex)으로 완벽하게 식별하여 분리합니다.
*   **도곽 기준 클리핑(데이터 보존)**: 기본은 도곽(Extent) 기준으로만 잘라내어 데이터 손실을 최소화합니다. (Data Loss 방지)
*   **버퍼 범위 내 자르기(옵션)**: 필요 시 가장 큰 버퍼(최대 반경) 바깥은 제외하도록 설정할 수 있습니다. (도곽 ∩ 버퍼)
*   **스마트 스타일링**: 2구역 세부 번호(2-1, 2-2...)에 따라 서로 다른 테두리 색상과 투명한 채우기 스타일을 자동 적용합니다.
*   **안정성**: `.shx` 파일 오류 보정 및 혼합 기하학(GeometryCollection) 처리 로직이 내장되어 있습니다.

### 2. 🧠 스마트 유적 분류
*   **정밀 필터링**: '사지'로 등록된 유적도 '석불' 키워드가 있으면 '불교석조물'로 재분류하는 등 맥락을 파악합니다.
*   **자동 번호 부여**: 거리순(조사지역과 가까운 순), 가나다순, 북→남 순서 등 원하는 기준으로 번호를 매깁니다.

### 3. 🎨 지도 제작 자동화
*   **수치지형도 병합**: 여러 장의 DXF/NGI 지형도를 하나의 레이어로 깔끔하게 합칩니다.
*   **도곽 자동 생성**: 축척(1/5000 등)과 용지 크기(보고서/A4)만 입력하면 딱 맞는 도곽을 생성합니다.
*   **버퍼 분석**: 조사지역 주변 50m, 100m 등 다중 버퍼를 생성하고 분석합니다.
*   **작업 완료 후 자동 확대(Zoom)**: 결과 생성 후 도곽(Extent) 범위로 화면이 자동 이동/확대되어 바로 확인할 수 있습니다.

### 4. 🛡️ 안정성 및 로그
*   **자동 로그 저장**: 모든 작업 내역은 `latest_log.txt` 파일에 자동 저장되어, 문제가 생겨도 원인을 바로 파악할 수 있습니다.
*   **실시간 진행률**: 작업 단계별 진행 상황을 상세하게 보여줍니다.

---

## 📝 사용 방법 (Guide)

### 1단계: 레이어 준비
QGIS에 다음 레이어들을 미리 불러옵니다:
- **조사지역 (Polygon)**: 분석의 기준이 되는 조사 범위
- **수치지형도 (Line/Polygon)**: 배경 지도 데이터
- **주변 유적 (Point/Polygon)**: 분포지도에 표시할 유적
- **현상변경허용기준 (Polygon)**: (선택사항) 해당 구역 데이터

### 2단계: 설정 및 실행
1.  툴바의 🏛 아이콘을 클릭하여 플러그인을 실행합니다.
2.  **입력 탭**: 조사지역, 수치지형도, (선택) 현상변경허용기준 레이어를 선택합니다.
3.  **설정 탭**: 도면 크기(보고서용 프리셋 등)와 축척을 설정합니다.
4.  **[▶ 분석 및 지도 생성 실행]** 버튼을 클릭합니다.

### 3단계: 결과 확인
*   `ArchDistribution_결과물` 그룹에 모든 결과가 정리되어 나타납니다.
*   현상변경허용기준 레이어는 `현상변경허용기준` 그룹에 별도로 자동 분류되어 들어갑니다.
*   작업 완료 후 화면이 도곽(Extent)으로 자동 확대되며, 필요 시 레이어 우클릭 → “레이어로 확대(Zoom to Layer)”를 사용하세요.

---

## 🐛 문제 해결 (Troubleshooting)
오류 발생 시 플러그인 폴더 내의 `latest_log.txt` 파일을 확인하거나, 해당 내용을 복사하여 제보해 주세요.

---

## ⚠️ 주의사항 및 면책 (Disclaimer)
**본 플러그인은 업무 보조 도구이며, 최종 결과물의 정확성을 보장하지 않습니다.**
*   자동 분석 결과는 데이터 상태나 좌표계에 따라 오차가 발생할 수 있습니다.
*   **반드시 사용자가 직접 결과물을 검수해야 합니다.**
*   보고서나 법적 효력이 있는 문서에 사용하기 전, 전문가의 확인이 필요합니다.
*   개발자는 본 도구 사용으로 인한 어떠한 결과에 대해서도 책임을 지지 않습니다.

---

## 🌟 Citation & Star

이 플러그인이 유용했다면 **GitHub Star** ⭐를 눌러주세요! 개발자에게 큰 힘이 됩니다.
If you find this repository useful, please consider giving it a star ⭐ and citing it in your work:

```bibtex
@software{ArchDistribution2026,
  author = {lzpxilfe},
  title = {ArchDistribution: Automated QGIS plugin for archaeological distribution maps},
  year = {2026},
  url = {https://github.com/lzpxilfe/ArchDistribution},
  version = {1.0.1}
}
```

---

## 📞 정보
*   **Version**: 1.0.1 (Codename: Pallet Town)
*   **Author**: lzpxilfe (balguljang2)
*   **Repository**: [GitHub Link](https://github.com/lzpxilfe/ArchDistribution)
*   **License**: GPL v2
