# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AltibasePluginDialog
                                 A QGIS plugin
 This plugin allows Altibase vector layer.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-06-29
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Altibase Corp.
        email                : us@altibase.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys
import pyodbc
import configparser

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import pyqtSignal
from PyQt5.QtWidgets import *
from PyQt5.Qt import QStandardItemModel, QStandardItem, QTableWidgetItem
from PyQt5.QtCore import Qt
from qgis.core import *
from qgis.gui import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS2, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'conn_dialog_base.ui'))


class AltiConfig():
    def __init__(self):
        pass

    def getAllConfig(self):
        if os.path.isfile("%s/.altibase.ini" % os.path.dirname(__file__)):
            s_config = configparser.ConfigParser()
            s_config.read("%s/.altibase.ini" % os.path.dirname(__file__))
            return s_config.sections()
        else: return None

    def getConfig(self, a_conn_name):
        conn_info = []
        config = configparser.ConfigParser()
        config.read("%s/.altibase.ini" % os.path.dirname(__file__))
        conn_info.append(config[a_conn_name]['DSN'])
        if config[a_conn_name]['OPTIONS']:
            conn_info.append(config[a_conn_name]['OPTIONS'])
        return conn_info

    def addConfig(self, a_conn_name, a_dsn, a_conn_opt):
        config = configparser.ConfigParser()
        config.read("%s/.altibase.ini" % os.path.dirname(__file__))
        if config.has_section(a_conn_name):
            return False
        else:
            config = configparser.ConfigParser()
            config[a_conn_name] = {}
            config[a_conn_name]['DSN'] = a_dsn
            config[a_conn_name]['OPTIONS'] = a_conn_opt
            with open("%s/.altibase.ini" % os.path.dirname(__file__), "a") as configfile:
                config.write(configfile)
            return True

    def removeConfig(self, a_conn_name):
        config = configparser.ConfigParser()
        config.read("%s/.altibase.ini" % os.path.dirname(__file__))
        config.remove_section(a_conn_name)
        with open("%s/.altibase.ini" % os.path.dirname(__file__), "w") as configfile:
            config.write(configfile)

    def editConfig(self, a_conn_name, a_dsn, a_conn_opt, a_before_conn_name):
        config = configparser.ConfigParser()
        config.read("%s/.altibase.ini" % os.path.dirname(__file__))
        if config.has_section(a_conn_name):
            config.set(a_conn_name, 'DSN', a_dsn)
            config.set(a_conn_name, 'OPTIONS', a_conn_opt)
        else:
            config.remove_section(a_before_conn_name)
            config[a_conn_name] = {}
            config[a_conn_name]['DSN'] = a_dsn
            config[a_conn_name]['OPTIONS'] = a_conn_opt
        with open("%s/.altibase.ini" % os.path.dirname(__file__), "w") as configfile:
            config.write(configfile)


class AltiConn():
    def __init__(self):
        self.conn = None

    def testConnectDB(self, a_dsn):
        try:
            s_conn = pyodbc.connect('DSN=%s' % a_dsn)
            s_conn.close()
            return ""
        except Exception as e:
            return e

    def connectDB(self, a_conn_name):
        alti_config = AltiConfig()
        conn_info = alti_config.getConfig(a_conn_name)

        try:
            if len(conn_info) > 1:
                self.conn = pyodbc.connect( 'DSN=%s;%s' % (conn_info[0], conn_info[1]) )
            else:
                self.conn = pyodbc.connect('DSN=%s' % conn_info[0])
            return ""
        except Exception as e:
            self.conn = None
            return e

    def disconnectDB(self):
        if self.conn:
            self.conn.close()
            self.conn = None

    def execSelect(self, a_query):
        try:
            cur = self.conn.cursor()
            cur.execute(a_query)
            rows = cur.fetchall()
            self.conn.commit()
            cur.close()
            return rows
        except Exception as e:
            QgsMessageLog.logMessage('Error : {0}'.format(e), 'AltibasePlugin' )
            cur.close()
            return None

    def execDMLs(self, a_query_dic_list):
        query_dic = {}

        try:
            cur = self.conn.cursor()
            for query_dic in a_query_dic_list:
                #QgsMessageLog.logMessage('Query : %s' % query_dic['query'], 'AltibasePlugin' )
                if len(query_dic['query']) > 0:
                    cur.execute(query_dic['query'])
            self.conn.commit()
            cur.close()
            return 0
        except Exception as e:
            QgsMessageLog.logMessage('Error : {0}'.format(e), 'AltibasePlugin' )
            self.conn.rollback()
            cur.close()
            if query_dic: return query_dic['fid']
            else: return -1

    def execColumns(self, a_schema, a_table):
        try:
            cur = self.conn.cursor()
            cur.columns('"'+a_table+'"', schema='"'+a_schema+'"')
            rows = cur.fetchall()
            self.conn.commit()
            cur.close()
            return rows
        except Exception as e:
            QgsMessageLog.logMessage('Error : {0}'.format(e), 'AltibasePlugin' )
            cur.close()
            return None

    def execPrimaryKeys(self, a_schema, a_table):
        try:
            cur = self.conn.cursor()
            cur.primaryKeys('"'+a_table+'"', schema='"'+a_schema+'"')
            rows = cur.fetchall()
            self.conn.commit()
            cur.close()
            return rows
        except Exception as e:
            QgsMessageLog.logMessage('Error : {0}'.format(e), 'AltibasePlugin' )
            cur.close()
            return None


class AltibaseConnectionDialog(QtWidgets.QDialog, FORM_CLASS2):
    g_close_signal = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(AltibaseConnectionDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.g_conn_name = None
        self.g_before_conn_name = None
        self.g_dsn = None
        self.g_conn_opt = None
        self.g_bt_type = None
        
        self.g_msgbar = QgsMessageBar()
        self.g_msgbar.setSizePolicy(QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.setLayout(QGridLayout())
        self.layout().setContentsMargins(0, 0, 0, 0)
        self.layout().addWidget(self.g_msgbar, 0, 0, 1, 1)
        self.layout().setAlignment(Qt.AlignTop)

        self.TestConnBt.clicked.connect(self.TestConnBtFunc)
        self.OKBt.clicked.connect(self.OKBtFunc)
        self.CancelBt.clicked.connect(self.CancelBtFunc)

    def TestConnBtFunc(self):
        self.g_msgbar.clearWidgets()
        s_res = self.checkValidation()
        if s_res:
            alti_conn = AltiConn()
            
            res = alti_conn.testConnectDB(self.g_dsn)
            if not res: 
                self.g_msgbar.pushMessage("Connection successful", level=Qgis.Info, duration=2)
            else:
                widget = self.g_msgbar.createMessage("Error", "{0}".format(res))
                button = QPushButton(widget)
                button.setText("View message log")
                widget.layout().addWidget(button)
                self.g_msgbar.pushWidget(widget, Qgis.Warning)

    def OKBtFunc(self):
        s_res = self.checkValidation()
        if s_res:
            alti_config = AltiConfig()
            if self.g_bt_type == "new":
                res = alti_config.addConfig(self.g_conn_name, self.g_dsn, self.g_conn_opt)
                if res:
                    self.g_close_signal.emit()
                else: 
                    QMessageBox.warning(self,
                                        "Error",
                                        "Name '%s' already exists. Name must be unique." % self.g_conn_name,
                                        QMessageBox.Ok)
                    return
            elif self.g_bt_type == "edit":
                alti_config.editConfig(self.g_conn_name, self.g_dsn, self.g_conn_opt, self.g_before_conn_name)
                self.g_close_signal.emit()
            self.close()

    def CancelBtFunc(self):
        self.close()

    def getConnName(self):
        return self.g_conn_name

    def clear(self, a_dlg_type):
        self.g_bt_type = a_dlg_type
        self.ConnName.clear()
        self.DSN.clear()
        self.ConnOption.clear()

    def set(self, a_dlg_type, a_conn_name):
        alti_config = AltiConfig()
        conn_info = alti_config.getConfig(a_conn_name)
        self.g_bt_type = a_dlg_type
        self.g_before_conn_name = a_conn_name
        self.ConnName.setText(a_conn_name)
        self.DSN.setText(conn_info[0])
        if len(conn_info) > 1:
            self.ConnOption.setText(conn_info[1])
        else:
            self.ConnOption.clear()

    def checkValidation(self):
        if not self.ConnName.text() or \
           not self.DSN.text() :
            QMessageBox.warning(self,
                            "Error",
                            "Please enter Name and DSN.",
                            QMessageBox.Ok)
            return False
        else:
            self.g_conn_name = self.ConnName.text()
            self.g_dsn = self.DSN.text()
            self.g_conn_opt = self.ConnOption.text()
            return True
