# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AemetDownloader
                                 A QGIS plugin
 This Plugin download open data from aemet
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-02-03
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Florentino Mostaza
        email                : https://github.com/Parpaya
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.core import *
from qgis.gui import QgsMessageBar

import os.path
import requests
import json
import numpy as np
from datetime import *
import time
import re

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .aemet_downloader_dialog import AemetDownloaderDialog

from .listaprov import *
prov = lista_Provincias
PROV = LISTA_PROVINCIAS
class AemetDownloader:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.msgBar = iface.messageBar()

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AemetDownloader_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&AemetOpenDataDownloader')
        # We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'AemetDownloader')
        self.toolbar.setObjectName(u'AemetDownloader')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('AemetDownloader', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        # Create the dialog (after translation) and keep reference
        self.dlg = AemetDownloaderDialog()
        # self.dlg.setWindowFlags(Qt.WindowSystemMenuHint | Qt.WindowTitleHint)

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = os.path.join(self.plugin_dir,'icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Aemet_Data_Dawnloader'),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.dlg.pushButton_select_path.clicked.connect(self.select_output_folder)
        self.dlg.pushButton_run.clicked.connect(self.download)
        # will be set False in run()
        #self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&AemetOpenDataDownloader'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def select_output_folder(self):
        """Select output folder"""

        self.dlg.lineEdit_path.clear()
        folder = QFileDialog.getExistingDirectory(self.dlg, "Select folder")
        self.dlg.lineEdit_path.setText(folder)

    def not_data(self):
        """Message for fields without information"""
        try:
            self.msgBar.pushMessage('Completar parametros', level=Qgis.Info,duration=3)
        except:
            self.msgBar.pushMessage('Completar parametros', level=Qgis.Info,duration=3)

    # Progress Download
    def reporthook(self, blocknum, blocksize, totalsize):
        readsofar = blocknum * blocksize
        if totalsize > 0:
            percent = readsofar * 1e2 / totalsize
            self.dlg.progressBar.setValue(int(percent))

    def formatFolderName(self, foldername):
        foldernameformat = foldername.replace(' ', "_")
        return foldernameformat

    def download(self):
        """Dowload data funtion"""

        if self.dlg.lineEdit_api_key.text() == '' or self.dlg.lineEdit_path.text() == '':
            self.not_data()

        else:

            try:
                QApplication.setOverrideCursor(QCursor(Qt.WaitCursor))

                # Cargar el contador de consultas a aemet
                # Obtener la ruta absoluta del directorio donde se encuentra el contador
                dir_contador = os.path.dirname(os.path.realpath(__file__))
                # Combinar la ruta del directorio con la ruta al archivo
                ruta_archivo = os.path.join(dir_contador, "help", "contador.txt")
                with open(ruta_archivo) as archivo:
                    n = int(archivo.read())

                path = self.dlg.lineEdit_path.text()
                apikey = self.dlg.lineEdit_api_key.text()

                # Obtener la fecha y hora actual para añadirla a los nombres de archivos
                fecha_hora_actual = datetime.now()
                # Formatear la fecha y hora actual en una cadena legible
                fecha_hora_str = fecha_hora_actual.strftime("%Y-%m-%d_%H-%M-%S")




                # descarga de los datos de observacion convencional, ultimas 24h
                if self.dlg.checkBox_24h.isChecked():

                    # Configurar las credenciales de la API de AEMET Open Data

                    prov_24h = self.dlg.comboBox_prov_24h.currentText()

                    # Establecer el código de la estación meteorológica para la que se desea obtener los datos

                    # Obtener la ruta absoluta del directorio donde se encuentra el script
                    dir_script = os.path.dirname(os.path.realpath(__file__))

                    # Combinar la ruta del directorio con la ruta al archivo JSON
                    ruta_json = os.path.join(dir_script, "help", "estaciones_24h.json")

                    with open(ruta_json) as f:
                        estaciones = json.load(f)

                    datos_24h = [['indicativo', 'nombre', 'Provincia', 'fint', 'x', 'y', 'alt', 'precipitacion', 'hr', 'ta', 'tamin', 'tamax']]

                    # Bucle para obtener los datos de todas las estaciones de una provincia
                    for estacion in estaciones:
                        provincia = estacion['provincia']
                        if provincia == prov_24h:
                            # Consulta de los datos a la API de AEMET Open Data
                            url = "https://opendata.aemet.es/opendata/api/observacion/convencional/datos/estacion/{}?api_key={}".format(
                                estacion['indicativo'], apikey)
                            response = requests.get(url)
                            # Si la consulta fue exitosa, se obtiene la URL de descarga de los datos
                            if response.status_code == 200:
                                datos_estacion = response.json()
                                if 'datos' in datos_estacion:
                                    url_datos = datos_estacion['datos']
                                    # Descarga de los datos en formato JSON
                                    response_datos = requests.get(url_datos)
                                else:
                                    self.msgBar.pushMessage(
                                        'Error al realizar la descarga de la estacion ' + estacion['indicativo'],
                                        level=Qgis.Info, duration=3)

                            else:
                                self.msgBar.pushMessage('Error al realizar la consulta a la API', level=Qgis.Info, duration=3)
                            # Si la descarga es exitosa se guardaran los datos en la carpeta de destino
                            if response.status_code == 200:
                                valores_24h = response_datos.json()

                                # Vamos agregando los datos comunes a todas las estaciones a un csv para subirlo a QGIS
                                for observacion in valores_24h:
                                    try:
                                        resultado = [estacion['indicativo'], estacion['nombre'], estacion['provincia'],
                                                     observacion['fint'], observacion['lon'], observacion['lat'],
                                                     observacion['alt'], observacion['prec'], observacion['hr'],
                                                     observacion['ta'], observacion['tamin'], observacion['tamax']]

                                        datos_24h.append(resultado)
                                    except:
                                        ValueError

                                    # Descargamos los datos de la estación en un archivo json
                                    nombre_archivo = "Datos_24h_" + observacion['idema'] + "_" + fecha_hora_str + ".json"
                                    ruta_completa = os.path.join(path, nombre_archivo)
                                    with open(ruta_completa, 'w') as fp:
                                        json.dump(valores_24h, fp, indent=1)

                            else:
                                tipo_error = response.status_code
                                self.msgBar.pushMessage(
                                    'Error al realizar la descarga de la estacion ' + estacion[
                                        'Indicativo'] + '. Error ' + str(tipo_error),
                                    level=Qgis.Info, duration=3)

                            n += 1
                            print(n)
                            if n == 20:
                                time.sleep(60)
                                n = 0
                            else:
                                continue

                    if datos_24h != [['indicativo', 'nombre', 'Provincia', 'fint', 'x', 'y', 'alt', 'precipitacion', 'dmax', 'hr', 'ta', 'tamin', 'tamax']]:

                        nombre_archivo = "valores_observacion_convencional_24h_" + prov_24h + "_" + fecha_hora_str
                        ruta_completa = os.path.join(path, nombre_archivo)

                        np.savetxt(ruta_completa + ".csv",
                                   datos_24h,
                                   delimiter='; ',
                                   fmt='% s')

                        tipo = ".csv"
                        nombre_capa = "valores_observacion_convencional_24h_" + prov_24h
                        uri = "file:///" + ruta_completa + f"{tipo}?encoding={'utf-8'}&type={'csv'}&delimiter=;&xField={'x'}&yField={'y'}&crs=EPSG:{4326}"
                        vlayer = QgsVectorLayer(uri, nombre_capa, "delimitedtext")

                        if not vlayer.isValid():
                            self.msgBar.pushMessage('Error al cargar la capa', level=Qgis.Info, duration=3)

                        QgsProject.instance().addMapLayer(vlayer)




                # descarga de los datos climatologicos diarios dentro de un rango de timepo
                if self.dlg.checkBox_diarios.isChecked():

                    # Configurar las credenciales de la API de AEMET Open Data

                    prov_dia = self.dlg.comboBox_prov_diarios.currentText()
                    fechaclim = self.dlg.dateEdit_fecha_ini.text()
                    fechaclim2 = self.dlg.dateEdit_fecha_fin.text()

                    # Establecer el código de la estación meteorológica para la que se desea obtener los datos

                    # Obtener la ruta absoluta del directorio donde se encuentra el script
                    dir_script = os.path.dirname(os.path.realpath(__file__))

                    # Combinar la ruta del directorio con la ruta al archivo JSON
                    ruta_json = os.path.join(dir_script, "help", "lista_estaciones_valores_climatologicos.json")

                    with open(ruta_json) as f:
                        estaciones = json.load(f)

                    datosvalores = [['Indicativo', 'Nombre', 'Provincia', 'x', 'y', 'fecha', 'altitud', 'tmax', 'tmin', 'prec', 'horatmax', 'horatmin']]

                    # Establecer las fechas de inicio y fin de la consulta

                    fecha1 = datetime.strptime(fechaclim, '%Y-%m-%d')
                    fecha2 = datetime.strptime(fechaclim2, '%Y-%m-%d')

                    dias = (fecha2 - fecha1).days
                    dias_entero = int(dias)

                    # Establecer control de fechas
                    # Calcular la diferencia en días
                    #diferencia = fecha_fin.daysTo(fecha_ini)
                    #dias = diferencia.days

                    # Comprobar si el rango es mayor a 5 años (1825 días)
                    if dias_entero > 1825:
                        try:
                            self.msgBar.pushMessage('Las fechas no pueden distar mas de 5 años',
                                                    level=Qgis.Info, duration=3)
                        except:
                            self.msgBar.pushMessage('Las fechas no pueden distar mas de 5 años',
                                                    level=QgsMessageBar.INFO, duration=3)
                    else:
                        # Bucle para obtener los datos de todas las estaciones de una provincia
                        for estacion in estaciones:
                            provincia = estacion['Provincia']
                            if provincia == prov_dia:
                                # Consulta de los datos a la API de AEMET Open Data
                                url = "https://opendata.aemet.es/opendata/api/valores/climatologicos/diarios/datos/fechaini/{}T00:00:00UTC/fechafin/{}T23:59:59UTC/estacion/{}/?api_key={}".format(
                                    fechaclim, fechaclim2, estacion['Indicativo'], apikey)
                                response = requests.get(url)

                                if response.status_code == 200:
                                    datos_estacion = response.json()
                                    if 'datos' in datos_estacion:
                                        url_datos = datos_estacion['datos']
                                        # Descarga de los datos en formato JSON
                                        response_datos = requests.get(url_datos)
                                        # Si la descarga es exitosa se guardaran los datos en la carpeta de destino
                                        if response.status_code == 200:
                                            datos_clima_dia = response_datos.json()
                                            for valores in datos_clima_dia:
                                                try:
                                                    resultado = [estacion['Indicativo'], estacion['Nombre'], estacion['Provincia'],
                                                                 estacion['x'], estacion['y'],
                                                                 valores['fecha'], valores['altitud'], valores["tmax"],
                                                                 valores["tmin"], valores['prec'], valores['horatmax'],
                                                                 valores['horatmin']]
                                                    datosvalores.append(resultado)
                                                except:
                                                    ValueError

                                                # Descargamos los datos de la estación en un archivo json

                                                nombre_archivo = "Datos_clima_diarios_" + valores[
                                                    'indicativo'] + "_" + fechaclim + "_" + fechaclim2 + ".json"
                                                ruta_completa = os.path.join(path, nombre_archivo)
                                                with open(ruta_completa, 'w') as fp:
                                                    json.dump(datos_clima_dia, fp, indent=1)
                                        else:
                                            tipo_error = response.status_code
                                            self.msgBar.pushMessage(
                                                'Error al realizar la descarga de la estacion ' + estacion['Indicativo'] + '. Error ' + str(tipo_error),
                                                level=Qgis.Info, duration=3)

                                else:
                                    self.msgBar.pushMessage('Error al realizar la consulta a la API', level=Qgis.Info,
                                                            duration=3)
                                n += 1
                                print(n)
                                if n == 20:
                                    time.sleep(60)
                                    n = 0
                                else:
                                    continue

                        if datosvalores != [
                            ['Indicativo', 'Nombre', 'Provincia', 'x', 'y', 'fecha', 'altitud', 'tmax', 'tmin', 'prec', 'horatmax', 'horatmin']]:

                            nombre_archivo = "valores_climatologicos_diarios_" + prov_dia + "_" + fechaclim + "_" + fechaclim2
                            ruta_completa = os.path.join(path, nombre_archivo)

                            np.savetxt(ruta_completa + ".csv",
                                       datosvalores,
                                       delimiter='; ',
                                       fmt='% s')

                            tipo = ".csv"
                            nombre_capa = "valores_climatologicos_diarios_" + prov_dia + "_" + fechaclim + "_" + fechaclim2
                            uri = "file:///" + ruta_completa + f"{tipo}?encoding={'utf-8'}&type={'csv'}&delimiter=;&xField={'x'}&yField={'y'}&crs=EPSG:{4326}"
                            vlayer = QgsVectorLayer(uri, nombre_capa, "delimitedtext")

                            if not vlayer.isValid():
                                self.msgBar.pushMessage('Error al cargar la capa', level=Qgis.Info, duration=3)

                            QgsProject.instance().addMapLayer(vlayer)



                # descarga de los datos climatologicos mensuales dentro de un rango de timepo
                if self.dlg.checkBox_mes.isChecked():

                    # Configurar las credenciales de la API de AEMET Open Data
                    prov_dia = self.dlg.comboBox_prov_mes.currentText()
                    #Comprobamos que el año introducido es correcto
                    anio_reg = r"^(19|20)\d{2}$"
                    anio = self.dlg.lineEdit_anio_val_mes.text()

                    if re.match(anio_reg, anio):
                        anio = self.dlg.lineEdit_anio_val_mes.text()
                        # Obtener la ruta absoluta del directorio donde se encuentra el script
                        dir_script = os.path.dirname(os.path.realpath(__file__))

                        # Combinar la ruta del directorio con la ruta al archivo JSON
                        ruta_json = os.path.join(dir_script, "help", "lista_estaciones_valores_climatologicos.json")

                        with open(ruta_json) as f:
                            estaciones = json.load(f)

                        datosvalores = [['Nombre', 'Provincia', 'x', 'y', 'fecha', 'indicativo', 'p_mes', 'ta_max', 'ta_min']]

                        # Bucle para obtener los datos de todas las estaciones de una provincia
                        for estacion in estaciones:
                            provincia = estacion['Provincia']
                            if provincia == prov_dia:
                                # Consulta de los datos a la API de AEMET Open Data
                                url = "https://opendata.aemet.es/opendata/api/valores/climatologicos/mensualesanuales/datos/anioini/{}/aniofin/{}/estacion/{}/?api_key={}".format(
                                    anio, anio, estacion['Indicativo'], apikey)
                                response = requests.get(url)

                                if response.status_code == 200:
                                    datos_estacion = response.json()
                                    if 'datos' in datos_estacion:
                                        url_datos = datos_estacion['datos']
                                        # Descarga de los datos en formato JSON
                                        response_datos = requests.get(url_datos)
                                        # Si la descarga es exitosa se guardaran los datos en la carpeta de destino
                                        if response.status_code == 200:
                                            datos_clima_mes = response_datos.json()
                                            for valores in datos_clima_mes:
                                                try:
                                                    resultado = [estacion['Nombre'], estacion['Provincia'],
                                                                 estacion['x'], estacion['y'], valores['fecha'],
                                                                 valores['indicativo'], valores['p_mes'],
                                                                 valores['ta_max'], valores['ta_min']]
                                                    datosvalores.append(resultado)
                                                except:
                                                    ValueError

                                                # Descargamos los datos de la estación en un archivo json
                                                nombre_archivo = "datos_clima_mes_" + valores[
                                                    'indicativo'] + "_" + prov_dia + "_" + anio + ".json"
                                                ruta_completa = os.path.join(path, nombre_archivo)
                                                with open(ruta_completa, 'w') as fp:
                                                    json.dump(datos_clima_mes, fp, indent=1)
                                        else:
                                            tipo_error = response.status_code
                                            self.msgBar.pushMessage(
                                                'Error al realizar la descarga de los datos ' +
                                                estacion['Indicativo'] + '. Error ' + str(tipo_error),
                                                level=Qgis.Info, duration=3)
                                    else:
                                        self.msgBar.pushMessage(
                                            'No hay datos que satisfagan esos criterios en la ' + estacion['Indicativo'] + " de " +  estacion['Nombre'],
                                            level=Qgis.Info, duration=3)
                                else:
                                    self.msgBar.pushMessage('Error al realizar la consulta a la API', level=Qgis.Info,
                                                            duration=3)
                                n += 1
                                print(n)
                                if n == 20:
                                    time.sleep(60)
                                    print('pausa')
                                    n = 0
                                else:
                                    continue

                        if datosvalores != [
                            ['Nombre', 'Provincia', 'x', 'y', 'fecha', 'indicativo', 'p_mes', 'ta_max', 'ta_min']]:

                            nombre_archivo = "valores_climatologicos_mensuales_" + prov_dia + "_" + anio
                            ruta_completa = os.path.join(path, nombre_archivo)

                            np.savetxt(ruta_completa + ".csv",
                                       datosvalores,
                                       delimiter='; ',
                                       fmt='% s')

                            tipo = ".csv"
                            nombre_capa = "valores_climatologicos_mes_" + prov_dia + "_" + anio
                            uri = "file:///" + ruta_completa + f"{tipo}?encoding={'utf-8'}&type={'csv'}&delimiter=;&xField={'x'}&yField={'y'}&crs=EPSG:{4326}"
                            vlayer = QgsVectorLayer(uri, nombre_capa, "delimitedtext")

                            if not vlayer.isValid():
                                self.msgBar.pushMessage('Error al cargar la capa', level=Qgis.Info, duration=3)

                            QgsProject.instance().addMapLayer(vlayer)

                    else:
                        self.msgBar.pushMessage('El valor del año debe ser válido para obtener los datos meteorológicos mensuales', level=Qgis.Info, duration=3)






                # descarga de los datos climatologicos normales dentro de un rango de timepo
                if self.dlg.checkBox_normales.isChecked():

                    # Configurar las credenciales de la API de AEMET Open Data
                    prov_norm = self.dlg.comboBox_prov_norm.currentText()

                    # Obtener la ruta absoluta del directorio donde se encuentra el script
                    dir_script = os.path.dirname(os.path.realpath(__file__))

                    # Combinar la ruta del directorio con la ruta al archivo JSON
                    ruta_json = os.path.join(dir_script, "help", "lista_estaciones_valores_climatologicos.json")

                    with open(ruta_json) as f:
                        estaciones = json.load(f)

                    datosvalores = [['Indicativo', 'Nombre', 'Provincia', 'x', 'y', 'mes', "w_racha_max","np_010_n","np_010_s","q_max_s","n_tor_n","n_tor_s","q_max_n","tm_min_q4","tm_min_q1","tm_min_q3","tm_min_q2","q_mar_n","n_des_min","q_mar_s","q_med_n","ts_20_q1","ts_20_q2","e_cv","ts_20_q4","e_min","np_300_q4","np_300_q1","np_300_q3","hr_max","np_300_cv","n_nub_max","tm_min_cv","n_des_mn","n_des_md","ts_20_s","q_med_mn","evap_cv","q_med_md","nt_30_cv","mes","ts_20_cv","inso_max","ts_20_max","np_001_max","n_llu_md","nv_1000_s","ta_min_mn","tm_mes_max","ta_max_mn","nv_1000_n","ta_max_md","nw_91_min","ta_max_n","ta_max_s","ts_10_md","nw_55_mn","ta_min_s","nw_55_md","np_300_mn","evap_q4","evap_q1","np_300_md","evap_q3","evap_q2","p_mes_min","ts_min_min","n_des_s","nv_0100_mn","p_mes_md","n_tor_cv","nv_0100_md","q_min_max","n_des_n","p_sol_s","ts_20_n","ts_10_cv","nw_91_s","nw_91_n","nt_00_min","p_sol_n","n_nie_mn","n_nub_n","n_nie_md","tm_mes_md","p_sol_cv","n_nub_s","w_racha_min","np_300_max","nv_0050_md","ta_min_min","glo_mn","inso_s","glo_md","n_nie_q1","w_med_q4","n_tor_max","w_med_q2","w_med_q3","n_gra_md","inso_q4","q_max_min","ts_10_max","nt_30_min","n_nub_cv","p_mes_n","p_mes_q1","p_mes_q2","p_mes_q3","p_mes_q4","hr_cv","n_tor_md","p_mes_s","nw_91_cv","n_tor_mn","nv_1000_max","n_gra_cv","w_racha_n","w_med_min","w_racha_s","np_100_max","e_s","w_med_s","p_sol_md","n_cub_q4","n_cub_q3","n_cub_q2","n_cub_q1","nw_55_max","p_sol_mn","n_cub_s","hr_mn","q_med_max","hr_md","np_010_md","n_cub_n","np_010_mn","nw_91_q4","p_max_n","nw_91_q2","nw_91_q3","nw_91_q1","n_gra_q4","n_gra_q1","n_gra_q3","nw_55_s","nw_55_n","w_med_mn","n_nub_min","p_max_s","ts_20_min","inso_min","n_gra_max","p_sol_q1","p_sol_q3","p_sol_q2","p_sol_q4","n_fog_q1","ta_min_md","n_fog_q3","n_fog_q2","n_fog_q4","w_med_cv","p_max_max","e_n","q_min_md","n_fog_cv","p_mes_cv","nv_0100_max","np_300_q2","q_min_mn","ti_max_min","np_100_cv","hr_q3","hr_q2","hr_q1","nv_0050_s","hr_q4","evap_s","w_med_q1","evap_n","nv_0050_n","nv_0050_q2","nv_0050_q3","q_max_md","nv_0050_q1","nv_0050_q4","q_max_mn","n_llu_min","ts_min_max","evap_max","ta_min_q1","ta_min_q3","n_cub_cv","ta_min_q4","tm_mes_n","tm_max_s","nt_30_md","tm_max_n","tm_mes_s","nt_30_mn","ts_50_q4","ts_50_q3","ts_50_q2","ts_50_q1","q_mar_mn","np_100_q4","np_100_q3","np_100_q2","np_100_q1","n_des_cv","q_mar_md","tm_mes_q4","tm_mes_q2","tm_mes_q3","np_300_min","p_sol_min","n_cub_min","n_gra_s","w_racha_mn","p_max_cv","n_des_q4","n_des_q1","n_des_q3","n_des_q2","ti_max_max","n_gra_n","tm_min_n","nt_30_max","q_max_max","tm_min_s","nt_00_n","nv_0050_min","ts_10_s","n_nub_q4","n_nub_q1","n_nub_q2","n_nub_q3","ts_50_s","ts_10_n","nt_00_s","ts_10_min","tm_mes_mn","np_100_min","nv_1000_min","nt_30_s","nt_00_q3","nt_00_q2","nt_00_q1","n_tor_min","nt_00_q4","ts_20_q3","nt_00_max","nw_55_min","n_llu_mn","ts_50_mn","glo_min","ts_50_md","q_med_min","nv_0050_cv","inso_q2","inso_q3","inso_q1","n_fog_max","np_100_s","np_300_s","ta_min_cv","tm_mes_cv","ts_min_md","ts_min_mn","inso_cv","np_300_n","np_100_n","ts_min_n","tm_max_md","tm_max_mn","ts_min_s","tm_mes_q1","p_max_q1","p_max_q3","p_max_q2","p_max_q4","n_nie_s","n_gra_min","nt_30_n","n_nie_n","ts_50_n","nv_0100_min","q_mar_q1","q_mar_q2","q_mar_q3","q_mar_q4","p_max_min","n_llu_cv","n_nub_mn","w_racha_q1","w_racha_q3","w_racha_q2","n_nub_md","w_racha_q4","nt_00_cv","np_010_q4","np_010_q1","np_010_q3","np_010_q2","nv_1000_q3","ts_50_cv","nv_0100_s","n_llu_max","tm_max_min","tm_min_md","q_mar_cv","nv_0100_n","tm_min_mn","ts_10_mn","w_racha_cv","evap_min","ta_max_cv","n_llu_q4","n_llu_q2","n_llu_q3","n_llu_q1","q_min_q4","hr_min","w_med_max","nw_91_mn","q_min_q1","q_min_q2","q_min_q3","q_min_n","nw_91_md","q_min_s","n_tor_q4","n_tor_q1","n_tor_q2","n_tor_q3","tm_mes_min","n_cub_max","nw_55_cv","tm_min_min","q_mar_max","nv_0100_q4","nv_0100_q1","nv_0100_q2","nv_0100_q3","q_max_q2","q_max_q3","q_max_q1","q_max_q4","nv_0100_cv","ts_10_q3","ts_10_q2","ts_10_q1","ts_10_q4","q_max_cv","ta_max_max","np_010_cv","ta_max_q4","ta_max_q3","ta_max_q2","ta_max_q1","np_010_min","w_med_n","nv_1000_q4","nv_1000_q2","n_nie_max","nv_1000_q1","nv_1000_cv","glo_max","n_fog_s","ti_max_q2","n_fog_n","n_nie_cv","np_001_min","nw_55_q4","n_fog_min","nw_55_q2","nw_55_q3","nw_55_q1","hr_n","hr_s","q_med_s","nv_0050_max","ta_min_q2","n_des_max","n_fog_mn","p_sol_max","np_001_s","n_fog_md","q_min_cv","np_001_n","e_max","nt_00_md","np_100_mn","nt_30_q1","nt_00_mn","glo_q4","glo_q2","glo_q3","np_100_md","inso_n","q_med_q1","np_001_md","np_001_mn","ti_max_cv","nv_1000_mn","nv_1000_md","evap_md","ta_min_max","e_md","e_mn","nt_30_q3","ti_max_md","n_llu_n","ti_max_mn","glo_s","glo_n","ts_min_cv","n_llu_s","nv_0050_mn","n_nie_q3","n_nie_q2","n_nie_q4","glo_cv","tm_max_max","ts_20_mn","tm_max_cv","ts_20_md","np_001_cv","p_max_mn","nw_91_max","p_max_md","q_med_cv","ts_50_max","ts_50_min","ta_min_n","e_q4","e_q3","e_q2","e_q1","glo_q1","w_racha_md","q_min_min","ts_min_q3","ts_min_q2","ts_min_q1","p_mes_max","ts_min_q4","q_mar_min","tm_max_q3","tm_max_q2","tm_max_q1","p_mes_mn","tm_max_q4","n_gra_mn","tm_min_max","np_001_q4","np_001_q3","np_001_q2","np_001_q1","ti_max_n","w_med_md","ti_max_q4","ti_max_q3","n_gra_q2","ti_max_q1","ti_max_s","q_med_q2","q_med_q3","nt_30_q2","n_nie_min","nt_30_q4","q_med_q4","n_cub_md","n_cub_mn","ta_max_min","np_010_max","inso_md","inso_mn","evap_mn"]]

                    # Bucle para obtener los datos de todas las estaciones de una provincia
                    for estacion in estaciones:
                        provincia = estacion['Provincia']
                        if provincia == prov_norm:
                            # Consulta de los datos a la API de AEMET Open Data
                            url = "https://opendata.aemet.es/opendata/api//valores/climatologicos/normales/estacion/{}/?api_key={}".format(estacion['Indicativo'], apikey)
                            response = requests.get(url)

                            if response.status_code == 200:
                                datos_estacion = response.json()
                                if 'datos' in datos_estacion:
                                    url_datos = datos_estacion['datos']
                                    # Descarga de los datos en formato JSON
                                    response_datos = requests.get(url_datos)
                                    # Si la descarga es exitosa se guardaran los datos en la carpeta de destino
                                    if response.status_code == 200:
                                        datos_clima_norm = response_datos.json()
                                        for valores in datos_clima_norm:
                                            try:
                                                resultado = [estacion['Indicativo'], estacion['Nombre'], estacion['Provincia'], estacion['x'], estacion['y'], valores['mes'], valores['w_racha_max'], valores['np_010_n'], valores['np_010_s'], valores['q_max_s'], valores['n_tor_n'], valores['n_tor_s'], valores['q_max_n'], valores['tm_min_q4'], valores['tm_min_q1'], valores['tm_min_q3'], valores['tm_min_q2'], valores['q_mar_n'], valores['n_des_min'], valores['q_mar_s'], valores['q_med_n'], valores['ts_20_q1'], valores['ts_20_q2'], valores['e_cv'], valores['ts_20_q4'], valores['e_min'], valores['np_300_q4'], valores['np_300_q1'], valores['np_300_q3'], valores['hr_max'], valores['np_300_cv'], valores['n_nub_max'], valores['tm_min_cv'], valores['n_des_mn'], valores['n_des_md'], valores['ts_20_s'], valores['q_med_mn'], valores['evap_cv'], valores['q_med_md'], valores['nt_30_cv'], valores['mes'], valores['ts_20_cv'], valores['inso_max'], valores['ts_20_max'], valores['np_001_max'], valores['n_llu_md'], valores['nv_1000_s'], valores['ta_min_mn'], valores['tm_mes_max'], valores['ta_max_mn'], valores['nv_1000_n'], valores['ta_max_md'], valores['nw_91_min'], valores['ta_max_n'], valores['ta_max_s'], valores['ts_10_md'], valores['nw_55_mn'], valores['ta_min_s'], valores['nw_55_md'], valores['np_300_mn'], valores['evap_q4'], valores['evap_q1'], valores['np_300_md'], valores['evap_q3'], valores['evap_q2'], valores['p_mes_min'], valores['ts_min_min'], valores['n_des_s'], valores['nv_0100_mn'], valores['p_mes_md'], valores['n_tor_cv'], valores['nv_0100_md'], valores['q_min_max'], valores['n_des_n'], valores['p_sol_s'], valores['ts_20_n'], valores['ts_10_cv'], valores['nw_91_s'], valores['nw_91_n'], valores['nt_00_min'], valores['p_sol_n'], valores['n_nie_mn'], valores['n_nub_n'], valores['n_nie_md'], valores['tm_mes_md'], valores['p_sol_cv'], valores['n_nub_s'], valores['w_racha_min'], valores['np_300_max'], valores['nv_0050_md'], valores['ta_min_min'], valores['glo_mn'], valores['inso_s'], valores['glo_md'], valores['n_nie_q1'], valores['w_med_q4'], valores['n_tor_max'], valores['w_med_q2'], valores['w_med_q3'], valores['n_gra_md'], valores['inso_q4'], valores['q_max_min'], valores['ts_10_max'], valores['nt_30_min'], valores['n_nub_cv'], valores['p_mes_n'], valores['p_mes_q1'], valores['p_mes_q2'], valores['p_mes_q3'], valores['p_mes_q4'], valores['hr_cv'], valores['n_tor_md'], valores['p_mes_s'], valores['nw_91_cv'], valores['n_tor_mn'], valores['nv_1000_max'], valores['n_gra_cv'], valores['w_racha_n'], valores['w_med_min'], valores['w_racha_s'], valores['np_100_max'], valores['e_s'], valores['w_med_s'], valores['p_sol_md'], valores['n_cub_q4'], valores['n_cub_q3'], valores['n_cub_q2'], valores['n_cub_q1'], valores['nw_55_max'], valores['p_sol_mn'], valores['n_cub_s'], valores['hr_mn'], valores['q_med_max'], valores['hr_md'], valores['np_010_md'], valores['n_cub_n'], valores['np_010_mn'], valores['nw_91_q4'], valores['p_max_n'], valores['nw_91_q2'], valores['nw_91_q3'], valores['nw_91_q1'], valores['n_gra_q4'], valores['n_gra_q1'], valores['n_gra_q3'], valores['nw_55_s'], valores['nw_55_n'], valores['w_med_mn'], valores['n_nub_min'], valores['p_max_s'], valores['ts_20_min'], valores['inso_min'], valores['n_gra_max'], valores['p_sol_q1'], valores['p_sol_q3'], valores['p_sol_q2'], valores['p_sol_q4'], valores['n_fog_q1'], valores['ta_min_md'], valores['n_fog_q3'], valores['n_fog_q2'], valores['n_fog_q4'], valores['w_med_cv'], valores['p_max_max'], valores['e_n'], valores['q_min_md'], valores['n_fog_cv'], valores['p_mes_cv'], valores['nv_0100_max'], valores['np_300_q2'], valores['q_min_mn'], valores['ti_max_min'], valores['np_100_cv'], valores['hr_q3'], valores['hr_q2'], valores['hr_q1'], valores['nv_0050_s'], valores['hr_q4'], valores['evap_s'], valores['w_med_q1'], valores['evap_n'], valores['nv_0050_n'], valores['nv_0050_q2'], valores['nv_0050_q3'], valores['q_max_md'], valores['nv_0050_q1'], valores['nv_0050_q4'], valores['q_max_mn'], valores['n_llu_min'], valores['ts_min_max'], valores['evap_max'], valores['ta_min_q1'], valores['ta_min_q3'], valores['n_cub_cv'], valores['ta_min_q4'], valores['tm_mes_n'], valores['tm_max_s'], valores['nt_30_md'], valores['tm_max_n'], valores['tm_mes_s'], valores['nt_30_mn'], valores['ts_50_q4'], valores['ts_50_q3'], valores['ts_50_q2'], valores['ts_50_q1'], valores['q_mar_mn'], valores['np_100_q4'], valores['np_100_q3'], valores['np_100_q2'], valores['np_100_q1'], valores['n_des_cv'], valores['q_mar_md'], valores['tm_mes_q4'], valores['tm_mes_q2'], valores['tm_mes_q3'], valores['np_300_min'], valores['p_sol_min'], valores['n_cub_min'], valores['n_gra_s'], valores['w_racha_mn'], valores['p_max_cv'], valores['n_des_q4'], valores['n_des_q1'], valores['n_des_q3'], valores['n_des_q2'], valores['ti_max_max'], valores['n_gra_n'], valores['tm_min_n'], valores['nt_30_max'], valores['q_max_max'], valores['tm_min_s'], valores['nt_00_n'], valores['nv_0050_min'], valores['ts_10_s'], valores['n_nub_q4'], valores['n_nub_q1'], valores['n_nub_q2'], valores['n_nub_q3'], valores['ts_50_s'], valores['ts_10_n'], valores['nt_00_s'], valores['ts_10_min'], valores['tm_mes_mn'], valores['np_100_min'], valores['nv_1000_min'], valores['nt_30_s'], valores['nt_00_q3'], valores['nt_00_q2'], valores['nt_00_q1'], valores['n_tor_min'], valores['nt_00_q4'], valores['ts_20_q3'], valores['nt_00_max'], valores['nw_55_min'], valores['n_llu_mn'], valores['ts_50_mn'], valores['glo_min'], valores['ts_50_md'], valores['q_med_min'], valores['nv_0050_cv'], valores['inso_q2'], valores['inso_q3'], valores['inso_q1'], valores['n_fog_max'], valores['np_100_s'], valores['np_300_s'], valores['ta_min_cv'], valores['tm_mes_cv'], valores['ts_min_md'], valores['ts_min_mn'], valores['inso_cv'], valores['np_300_n'], valores['np_100_n'], valores['ts_min_n'], valores['tm_max_md'], valores['tm_max_mn'], valores['ts_min_s'], valores['tm_mes_q1'], valores['p_max_q1'], valores['p_max_q3'], valores['p_max_q2'], valores['p_max_q4'], valores['n_nie_s'], valores['n_gra_min'], valores['nt_30_n'], valores['n_nie_n'], valores['ts_50_n'], valores['nv_0100_min'], valores['q_mar_q1'], valores['q_mar_q2'], valores['q_mar_q3'], valores['q_mar_q4'], valores['p_max_min'], valores['n_llu_cv'], valores['n_nub_mn'], valores['w_racha_q1'], valores['w_racha_q3'], valores['w_racha_q2'], valores['n_nub_md'], valores['w_racha_q4'], valores['nt_00_cv'], valores['np_010_q4'], valores['np_010_q1'], valores['np_010_q3'], valores['np_010_q2'], valores['nv_1000_q3'], valores['ts_50_cv'], valores['nv_0100_s'], valores['n_llu_max'], valores['tm_max_min'], valores['tm_min_md'], valores['q_mar_cv'], valores['nv_0100_n'], valores['tm_min_mn'], valores['ts_10_mn'], valores['w_racha_cv'], valores['evap_min'], valores['ta_max_cv'], valores['n_llu_q4'], valores['n_llu_q2'], valores['n_llu_q3'], valores['n_llu_q1'], valores['q_min_q4'], valores['hr_min'], valores['w_med_max'], valores['nw_91_mn'], valores['q_min_q1'], valores['q_min_q2'], valores['q_min_q3'], valores['q_min_n'], valores['nw_91_md'], valores['q_min_s'], valores['n_tor_q4'], valores['n_tor_q1'], valores['n_tor_q2'], valores['n_tor_q3'], valores['tm_mes_min'], valores['n_cub_max'], valores['nw_55_cv'], valores['tm_min_min'], valores['q_mar_max'], valores['nv_0100_q4'], valores['nv_0100_q1'], valores['nv_0100_q2'], valores['nv_0100_q3'], valores['q_max_q2'], valores['q_max_q3'], valores['q_max_q1'], valores['q_max_q4'], valores['nv_0100_cv'], valores['ts_10_q3'], valores['ts_10_q2'], valores['ts_10_q1'], valores['ts_10_q4'], valores['q_max_cv'], valores['ta_max_max'], valores['np_010_cv'], valores['ta_max_q4'], valores['ta_max_q3'], valores['ta_max_q2'], valores['ta_max_q1'], valores['np_010_min'], valores['w_med_n'], valores['nv_1000_q4'], valores['nv_1000_q2'], valores['n_nie_max'], valores['nv_1000_q1'], valores['nv_1000_cv'], valores['glo_max'], valores['n_fog_s'], valores['ti_max_q2'], valores['n_fog_n'], valores['n_nie_cv'], valores['np_001_min'], valores['nw_55_q4'], valores['n_fog_min'], valores['nw_55_q2'], valores['nw_55_q3'], valores['nw_55_q1'], valores['hr_n'], valores['hr_s'], valores['q_med_s'], valores['nv_0050_max'], valores['ta_min_q2'], valores['n_des_max'], valores['n_fog_mn'], valores['p_sol_max'], valores['np_001_s'], valores['n_fog_md'], valores['q_min_cv'], valores['np_001_n'], valores['e_max'], valores['nt_00_md'], valores['np_100_mn'], valores['nt_30_q1'], valores['nt_00_mn'], valores['glo_q4'], valores['glo_q2'], valores['glo_q3'], valores['np_100_md'], valores['inso_n'], valores['q_med_q1'], valores['np_001_md'], valores['np_001_mn'], valores['ti_max_cv'], valores['nv_1000_mn'], valores['nv_1000_md'], valores['evap_md'], valores['ta_min_max'], valores['e_md'], valores['e_mn'], valores['nt_30_q3'], valores['ti_max_md'], valores['n_llu_n'], valores['ti_max_mn'], valores['glo_s'], valores['glo_n'], valores['ts_min_cv'], valores['n_llu_s'], valores['nv_0050_mn'], valores['n_nie_q3'], valores['n_nie_q2'], valores['n_nie_q4'], valores['glo_cv'], valores['tm_max_max'], valores['ts_20_mn'], valores['tm_max_cv'], valores['ts_20_md'], valores['np_001_cv'], valores['p_max_mn'], valores['nw_91_max'], valores['p_max_md'], valores['q_med_cv'], valores['ts_50_max'], valores['ts_50_min'], valores['ta_min_n'], valores['e_q4'], valores['e_q3'], valores['e_q2'], valores['e_q1'], valores['glo_q1'], valores['w_racha_md'], valores['q_min_min'], valores['ts_min_q3'], valores['ts_min_q2'], valores['ts_min_q1'], valores['p_mes_max'], valores['ts_min_q4'], valores['q_mar_min'], valores['tm_max_q3'], valores['tm_max_q2'], valores['tm_max_q1'], valores['p_mes_mn'], valores['tm_max_q4'], valores['n_gra_mn'], valores['tm_min_max'], valores['np_001_q4'], valores['np_001_q3'], valores['np_001_q2'], valores['np_001_q1'], valores['ti_max_n'], valores['w_med_md'], valores['ti_max_q4'], valores['ti_max_q3'], valores['n_gra_q2'], valores['ti_max_q1'], valores['ti_max_s'], valores['q_med_q2'], valores['q_med_q3'], valores['nt_30_q2'], valores['n_nie_min'], valores['nt_30_q4'], valores['q_med_q4'], valores['n_cub_md'], valores['n_cub_mn'], valores['ta_max_min'], valores['np_010_max'], valores['inso_md'], valores['inso_mn'], valores['evap_mn']]
                                                datosvalores.append(resultado)
                                            except:
                                                ValueError

                                            # Descargamos los datos de la estación en un archivo json
                                            nombre_archivo = "datos_clima_norm_" + valores[
                                                'indicativo'] + "_" + prov_norm + ".json"
                                            ruta_completa = os.path.join(path, nombre_archivo)
                                            with open(ruta_completa, 'w') as fp:
                                                json.dump(datos_clima_norm, fp, indent=1)
                                    else:
                                        tipo_error = response.status_code
                                        self.msgBar.pushMessage(
                                            'Error al realizar la descarga de los datos ' +
                                            estacion['Indicativo'] + '. Error ' + str(tipo_error),
                                            level=Qgis.Info, duration=3)
                                else:
                                    self.msgBar.pushMessage(
                                        'No hay datos que satisfagan esos criterios en la ' + estacion[
                                            'Indicativo'] + " de " + estacion['Nombre'],
                                        level=Qgis.Info, duration=3)
                            else:
                                self.msgBar.pushMessage('Error al realizar la consulta a la API', level=Qgis.Info,
                                                        duration=3)
                            n += 1
                            print(n)
                            if n == 20:
                                time.sleep(60)
                                print('pausa')
                                n = 0
                            else:
                                continue

                    if datosvalores != [['Indicativo', 'Nombre', 'Provincia', 'x', 'y', 'mes', "w_racha_max","np_010_n","np_010_s","q_max_s","n_tor_n","n_tor_s","q_max_n","tm_min_q4","tm_min_q1","tm_min_q3","tm_min_q2","q_mar_n","n_des_min","q_mar_s","q_med_n","ts_20_q1","ts_20_q2","e_cv","ts_20_q4","e_min","np_300_q4","np_300_q1","np_300_q3","hr_max","np_300_cv","n_nub_max","tm_min_cv","n_des_mn","n_des_md","ts_20_s","q_med_mn","evap_cv","q_med_md","nt_30_cv","mes","ts_20_cv","inso_max","ts_20_max","np_001_max","n_llu_md","nv_1000_s","ta_min_mn","tm_mes_max","ta_max_mn","nv_1000_n","ta_max_md","nw_91_min","ta_max_n","ta_max_s","ts_10_md","nw_55_mn","ta_min_s","nw_55_md","np_300_mn","evap_q4","evap_q1","np_300_md","evap_q3","evap_q2","p_mes_min","ts_min_min","n_des_s","nv_0100_mn","p_mes_md","n_tor_cv","nv_0100_md","q_min_max","n_des_n","p_sol_s","ts_20_n","ts_10_cv","nw_91_s","nw_91_n","nt_00_min","p_sol_n","n_nie_mn","n_nub_n","n_nie_md","tm_mes_md","p_sol_cv","n_nub_s","w_racha_min","np_300_max","nv_0050_md","ta_min_min","glo_mn","inso_s","glo_md","n_nie_q1","w_med_q4","n_tor_max","w_med_q2","w_med_q3","n_gra_md","inso_q4","q_max_min","ts_10_max","nt_30_min","n_nub_cv","p_mes_n","p_mes_q1","p_mes_q2","p_mes_q3","p_mes_q4","hr_cv","n_tor_md","p_mes_s","nw_91_cv","n_tor_mn","nv_1000_max","n_gra_cv","w_racha_n","w_med_min","w_racha_s","np_100_max","e_s","w_med_s","p_sol_md","n_cub_q4","n_cub_q3","n_cub_q2","n_cub_q1","nw_55_max","p_sol_mn","n_cub_s","hr_mn","q_med_max","hr_md","np_010_md","n_cub_n","np_010_mn","nw_91_q4","p_max_n","nw_91_q2","nw_91_q3","nw_91_q1","n_gra_q4","n_gra_q1","n_gra_q3","nw_55_s","nw_55_n","w_med_mn","n_nub_min","p_max_s","ts_20_min","inso_min","n_gra_max","p_sol_q1","p_sol_q3","p_sol_q2","p_sol_q4","n_fog_q1","ta_min_md","n_fog_q3","n_fog_q2","n_fog_q4","w_med_cv","p_max_max","e_n","q_min_md","n_fog_cv","p_mes_cv","nv_0100_max","np_300_q2","q_min_mn","ti_max_min","np_100_cv","hr_q3","hr_q2","hr_q1","nv_0050_s","hr_q4","evap_s","w_med_q1","evap_n","nv_0050_n","nv_0050_q2","nv_0050_q3","q_max_md","nv_0050_q1","nv_0050_q4","q_max_mn","n_llu_min","ts_min_max","evap_max","ta_min_q1","ta_min_q3","n_cub_cv","ta_min_q4","tm_mes_n","tm_max_s","nt_30_md","tm_max_n","tm_mes_s","nt_30_mn","ts_50_q4","ts_50_q3","ts_50_q2","ts_50_q1","q_mar_mn","np_100_q4","np_100_q3","np_100_q2","np_100_q1","n_des_cv","q_mar_md","tm_mes_q4","tm_mes_q2","tm_mes_q3","np_300_min","p_sol_min","n_cub_min","n_gra_s","w_racha_mn","p_max_cv","n_des_q4","n_des_q1","n_des_q3","n_des_q2","ti_max_max","n_gra_n","tm_min_n","nt_30_max","q_max_max","tm_min_s","nt_00_n","nv_0050_min","ts_10_s","n_nub_q4","n_nub_q1","n_nub_q2","n_nub_q3","ts_50_s","ts_10_n","nt_00_s","ts_10_min","tm_mes_mn","np_100_min","nv_1000_min","nt_30_s","nt_00_q3","nt_00_q2","nt_00_q1","n_tor_min","nt_00_q4","ts_20_q3","nt_00_max","nw_55_min","n_llu_mn","ts_50_mn","glo_min","ts_50_md","q_med_min","nv_0050_cv","inso_q2","inso_q3","inso_q1","n_fog_max","np_100_s","np_300_s","ta_min_cv","tm_mes_cv","ts_min_md","ts_min_mn","inso_cv","np_300_n","np_100_n","ts_min_n","tm_max_md","tm_max_mn","ts_min_s","tm_mes_q1","p_max_q1","p_max_q3","p_max_q2","p_max_q4","n_nie_s","n_gra_min","nt_30_n","n_nie_n","ts_50_n","nv_0100_min","q_mar_q1","q_mar_q2","q_mar_q3","q_mar_q4","p_max_min","n_llu_cv","n_nub_mn","w_racha_q1","w_racha_q3","w_racha_q2","n_nub_md","w_racha_q4","nt_00_cv","np_010_q4","np_010_q1","np_010_q3","np_010_q2","nv_1000_q3","ts_50_cv","nv_0100_s","n_llu_max","tm_max_min","tm_min_md","q_mar_cv","nv_0100_n","tm_min_mn","ts_10_mn","w_racha_cv","evap_min","ta_max_cv","n_llu_q4","n_llu_q2","n_llu_q3","n_llu_q1","q_min_q4","hr_min","w_med_max","nw_91_mn","q_min_q1","q_min_q2","q_min_q3","q_min_n","nw_91_md","q_min_s","n_tor_q4","n_tor_q1","n_tor_q2","n_tor_q3","tm_mes_min","n_cub_max","nw_55_cv","tm_min_min","q_mar_max","nv_0100_q4","nv_0100_q1","nv_0100_q2","nv_0100_q3","q_max_q2","q_max_q3","q_max_q1","q_max_q4","nv_0100_cv","ts_10_q3","ts_10_q2","ts_10_q1","ts_10_q4","q_max_cv","ta_max_max","np_010_cv","ta_max_q4","ta_max_q3","ta_max_q2","ta_max_q1","np_010_min","w_med_n","nv_1000_q4","nv_1000_q2","n_nie_max","nv_1000_q1","nv_1000_cv","glo_max","n_fog_s","ti_max_q2","n_fog_n","n_nie_cv","np_001_min","nw_55_q4","n_fog_min","nw_55_q2","nw_55_q3","nw_55_q1","hr_n","hr_s","q_med_s","nv_0050_max","ta_min_q2","n_des_max","n_fog_mn","p_sol_max","np_001_s","n_fog_md","q_min_cv","np_001_n","e_max","nt_00_md","np_100_mn","nt_30_q1","nt_00_mn","glo_q4","glo_q2","glo_q3","np_100_md","inso_n","q_med_q1","np_001_md","np_001_mn","ti_max_cv","nv_1000_mn","nv_1000_md","evap_md","ta_min_max","e_md","e_mn","nt_30_q3","ti_max_md","n_llu_n","ti_max_mn","glo_s","glo_n","ts_min_cv","n_llu_s","nv_0050_mn","n_nie_q3","n_nie_q2","n_nie_q4","glo_cv","tm_max_max","ts_20_mn","tm_max_cv","ts_20_md","np_001_cv","p_max_mn","nw_91_max","p_max_md","q_med_cv","ts_50_max","ts_50_min","ta_min_n","e_q4","e_q3","e_q2","e_q1","glo_q1","w_racha_md","q_min_min","ts_min_q3","ts_min_q2","ts_min_q1","p_mes_max","ts_min_q4","q_mar_min","tm_max_q3","tm_max_q2","tm_max_q1","p_mes_mn","tm_max_q4","n_gra_mn","tm_min_max","np_001_q4","np_001_q3","np_001_q2","np_001_q1","ti_max_n","w_med_md","ti_max_q4","ti_max_q3","n_gra_q2","ti_max_q1","ti_max_s","q_med_q2","q_med_q3","nt_30_q2","n_nie_min","nt_30_q4","q_med_q4","n_cub_md","n_cub_mn","ta_max_min","np_010_max","inso_md","inso_mn","evap_mn"]]:


                        nombre_archivo = "valores_climatologicos_normales_" + prov_norm
                        ruta_completa = os.path.join(path, nombre_archivo)

                        np.savetxt(ruta_completa + ".csv",
                                   datosvalores,
                                   delimiter='; ',
                                   fmt='% s')

                        tipo = ".csv"
                        nombre_capa = "valores_climatologicos_normales_" + prov_norm
                        uri = "file:///" + ruta_completa + f"{tipo}?encoding={'utf-8'}&type={'csv'}&delimiter=;&xField={'x'}&yField={'y'}&crs=EPSG:{4326}"
                        vlayer = QgsVectorLayer(uri, nombre_capa, "delimitedtext")

                        if not vlayer.isValid():
                            self.msgBar.pushMessage('Error al cargar la capa', level=Qgis.Info, duration=3)

                        QgsProject.instance().addMapLayer(vlayer)


            except Exception as e:
                QApplication.restoreOverrideCursor()
                try:
                    self.msgBar.pushMessage("Failed! " + str(e), level=Qgis.Warning, duration=3)
                except:
                    self.msgBar.pushMessage("Failed! " + str(e), level=QgsMessageBar.WARNING, duration=3)
                return

            self.dlg.progressBar.setValue(100)

            # guardar el contador
            with open(ruta_archivo, "w") as archivo:
                archivo.write(str(n))

            QApplication.restoreOverrideCursor()

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        #if self.first_start == True:
        #    self.first_start = False
        #    self.dlg = AemetDownloaderDialog()

        self.dlg.lineEdit_path.clear()
        self.dlg.comboBox_prov_24h.clear()
        self.dlg.comboBox_prov_diarios.clear()
        self.dlg.comboBox_prov_mes.clear()
        self.dlg.comboBox_prov_norm.clear()


        self.dlg.comboBox_prov_24h.addItems(prov)
        self.dlg.comboBox_prov_diarios.addItems(PROV)
        self.dlg.comboBox_prov_mes.addItems(PROV)
        self.dlg.comboBox_prov_norm.addItems(PROV)


        self.dlg.checkBox_24h.setChecked(0)
        self.dlg.checkBox_diarios.setChecked(0)
        self.dlg.checkBox_mes.setChecked(0)
        self.dlg.checkBox_normales.setChecked(0)


        # show the dialog
        self.dlg.progressBar.setValue(0)
        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
