# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ClassificationWithBSDDDialog
                                 A QGIS plugin
 Use the buildingSMART Data Dictionary (bSDD) to classify features and add attributes
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-05-29
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Sebastian Schilling, HTW Dresden
        email                : sebastian.schilling@htw-dresden.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import requests
import pandas as pd
import json
import sqlite3
import re

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import (
    QgsProject,
    QgsField
)
# from qgis.PyQt.QtCore import QMetaType
from qgis.PyQt.QtCore import QVariant


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'classification_with_bsdd_dialog_base.ui'))


class ClassificationWithBSDDDialog(QtWidgets.QDialog, FORM_CLASS):
    classList = []
    layer = ""
    dictClass = ""

    def setApiUrl(self, url):
        global input_url
        input_url = url

    def setClassList(self, list):
        global classList
        classList = list

    def setClassSelected(self, selected):
        global classSelected
        classSelected = selected

    def setLayerSelected(self, selected):
        global layerSelected
        layerSelected = selected

    def setLayer(self, selectedLayer):
        global layer
        layer = selectedLayer
        
    def setDictClass(self, selClass):
        global dictClass
        dictClass = selClass

    def setDictUri(self, selClass):
        global dictUrl
        dictUrl = selClass
        
    def setDictionaryList(self, dictList):
        global dictionaryList
        dictionaryList = dictList      
    
    def setDictionary(self, dict):
        global dictionary
        dictionary = dict
        
    def setSelectedFeatures(self, selFeatures):
        global selectedFeatures
        selectedFeatures = selFeatures
        
    def setFilePath(self, getFilePath):
        global filePath
        filePath = getFilePath
        
    def __init__(self, parent=None):
        """Constructor."""
        super(ClassificationWithBSDDDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.setClassSelected(False)
        self.setLayerSelected(False)

        self.btnConnectToDictionary.clicked.connect(self.onConnectToDictionaryClicked)
        self.btnClassifyFeatures.clicked.connect(self.onClassifyFeaturesClicked)
        self.btnSelectAll.clicked.connect(self.onSelectAllClicked)

        layers = QgsProject.instance().mapLayers()
        layerNames = [l.name() for l in layers.values()]
        self.chooseLayer.addItems(layerNames)
        self.chooseLayer.currentIndexChanged.connect(self.onLayerChosen)

        # Connect the checkbox to the method
        self.cbClassifyFile.stateChanged.connect(self.toggleChooseFileButton)
        # Connect the button to the method
        self.btnChooseFile.clicked.connect(self.openFileDialog)

    def onConnectToDictionaryClicked(self):

        url = self.edUrlToDictionary.text()
        self.setApiUrl(url)
        
        response = requests.get(url)

        if response.status_code == 200:
            self.lblConnError.clear()
            dictionaries = response.json()
            df = pd.json_normalize(dictionaries['dictionaries'])
            df = df.sort_values(ascending=True, by='name')
            self.setDictionaryList(df)
            
            self.chooseDictionary.setEnabled(True)
            self.chooseDictionary.clear()
            self.chooseDictionary.addItems(df['uri'])
            self.chooseDictionary.currentIndexChanged.connect(self.onDictionaryChosen)
        else:
            self.lblConnError.setText("Coudn't connect to the API")
            return


    def onDictionaryChosen(self):
        dictionaryUri = self.chooseDictionary.currentText()
        if dictionaryUri == "":
            return
        self.chooseClass.clear()
        self.chooseClass.setCurrentText("Choose concept ...")
        self.lblOutput.clear()
        self.lblName.clear()
        self.lblVersion.clear()
        dict = dictionaryList.loc[dictionaryList["uri"] == dictionaryUri].squeeze()
        self.setDictionary(dict)
        self.lblName.setText(dict['name'])
        self.lblVersion.setText(dict['version'])

        classesResponse = requests.get(input_url + "/Classes?URI=" + dictionaryUri)
        print(input_url + "/classes?Uri=" + dictionaryUri)
        print(classesResponse.status_code)
        if classesResponse.status_code == 200:
            classes = classesResponse.json()
            df = pd.json_normalize(classes['classes'])
            
            if len(df) == 0:
                self.lblOutput.setText("No concepts found")
                return
            
            df = df.sort_values(ascending=True, by='name')
            self.setClassList(df)
            self.chooseClass.setEnabled(True)
            self.chooseClass.addItems(df['name'])
            self.chooseClass.currentIndexChanged.connect(self.onClassChosen)

    # if class chosen
    def onClassChosen(self):
        self.setClassSelected(True)
        self.twAttributes.setRowCount(0)
        classIndex = self.chooseClass.currentIndex()
        if classIndex == -1:
            return

        con = classList.iloc[classIndex].squeeze()
        self.setDictUri(con['uri'])
        self.setDictClass(con['name']) 

        # get class attributes
        classResponse = requests.get(input_url.replace("Dictionary", "Class") + "?Uri=" + con['uri'] + "&IncludeClassProperties=true")
        if classResponse.status_code == 200:
            classInstance = classResponse.json()
            try:
                classProperties = pd.json_normalize(classInstance['classProperties'])
                self.lblOutput.clear()
                self.twAttributes.setRowCount(len(classProperties))
                self.twAttributes.setColumnCount(3)
                self.twAttributes.setHorizontalHeaderLabels(["AttrbuteName", "PropertySet", "Value"])
                self.twAttributes.horizontalHeader().setSectionResizeMode(QtWidgets.QHeaderView.Stretch)
                for index, row in classProperties.iterrows():
                    self.twAttributes.setItem(index, 0, QtWidgets.QTableWidgetItem(row["name"]))
                    self.twAttributes.setItem(index, 1, QtWidgets.QTableWidgetItem(row["propertySet"]))
            except:
                self.twAttributes.setRowCount(0)
                self.lblOutput.setText("No class properties found")
        
        self.enableClassifyFeatures()

    # if layer is chosen
    def onLayerChosen(self):
        self.setLayerSelected(True)
        self.btnSelectAll.setEnabled(True)
        layers = QgsProject.instance().mapLayersByName(self.chooseLayer.currentText())
        self.setLayer(layers[0])
        
        self.enableClassifyFeatures()

    # enable classification button
    def enableClassifyFeatures(self):
        if layerSelected == True and classSelected == True:
            self.btnClassifyFeatures.setEnabled(True)

    def onClassifyFeaturesClicked(self):
        self.setSelectedFeatures(layer.selectedFeatureIds())
        
        shapefile = layer.storageType() == "ESRI Shapefile"
    
        # add class to selected features
        if shapefile:
            self.addContent("bSDDClass", dictClass) 
        else:
            classiBaseString = "Classification|" + dictionary["name"]
            self.addContent(classiBaseString + "|name", dictionary["name"])
            self.addContent(classiBaseString + "|source", dictionary["uri"])
            self.addContent(classiBaseString + "|version", dictionary["version"])
            self.addContent(classiBaseString + "|class|" + dictClass + "|uri", dictUrl)
            self.addContent(classiBaseString + "|class|" + dictClass + "|name", dictClass)
            
            if layer.storageType() == "GPKG" and self.cbClassifyFile.isChecked(): 
                self.modifyGeoPackage()
            
            
        # add attributes and values to selected features
        rowCount = self.twAttributes.rowCount()
            
        if rowCount > 0:
            attributes = {}

            for row in range(rowCount):
                attribute = self.twAttributes.item(row, 0).text()
                group = self.twAttributes.item(row, 1).text()
                value = ""
                try:
                    value = self.twAttributes.item(row, 2).text()
                except:
                    value = "NULL"
                attributes[attribute] = value
                
                if not shapefile:
                    if group != "":
                        self.addContent(group + "|" + attribute, value)
                    else:
                        self.addContent(attribute, value)
            
            if shapefile:        
                attributesJson = json.dumps(attributes)
                self.addContent("bSDDAttr", attributesJson)
                  
        # refresh attribute table    
        layer.reload()

    def onSelectAllClicked(self):
        layer.selectAll()
     
    # add value only to selected features   
    def addContent(self, fieldName, value):
        
        layer_provider=layer.dataProvider()
        
        # if field does not exist, add it
        if  not fieldName in layer.fields().names():
            # layer_provider.addAttributes([QgsField(fieldName, QMetaType.Type.QString)])
            layer_provider.addAttributes([QgsField(fieldName, QVariant.String, "character varying")])
            layer.updateFields()
 
        aIndex = layer.fields().indexFromName(fieldName)

        # update values of field       
        layer.startEditing()
        try:
            for featureId in selectedFeatures:
                s = layer_provider.changeAttributeValues({featureId: {aIndex: value}})
                if not s:
                    print(f"Failed to update feature ID: {featureId}")
                
            # Commit the changes
            if not layer.commitChanges():
                raise Exception("Failed to commit changes")
        except Exception as e:
            layer.rollBack()
            print(f"Error: {e}")
        finally:
            # Ensure the layer is updated
            layer.triggerRepaint()
            
    def toggleChooseFileButton(self):
        self.btnChooseFile.setEnabled(self.cbClassifyFile.isChecked())

    def openFileDialog(self):
        options = QtWidgets.QFileDialog.Options()
        fileName, _ = QtWidgets.QFileDialog.getOpenFileName(self, "Select GPKG File", "", "GPKG Files (*.gpkg);;All Files (*)", options=options)
        if fileName:
            self.setFilePath(fileName)
            self.lblFilePath.setText(filePath)
            
    def modifyGeoPackage(self):
        conn = sqlite3.connect(filePath)
        c = conn.cursor()
        
        # insert extension into gpkg_extensions table
        tables_to_insert = ['gpkgext_relations', 'feature_classification_mapping', 'feature_classification_attributes_mapping', 'classification_dictionary_mapping']
        for table in tables_to_insert:
            
            c.execute("SELECT COUNT(*) FROM gpkg_extensions WHERE table_name = ?", (table,))
            
            if c.fetchone()[0] == 0:
                insert_extension = """
                INSERT INTO gpkg_extensions ("table_name", "extension_name", "definition", "scope") VALUES 
                (?, 'gpkg_related_tables', 'http://docs.opengeospatial.org/is/18-000/18-000.html', 'read-write');
                """
                c.execute(insert_extension, (table,))
                conn.commit()
        
        # create new tables
        create_table_classification = """
        CREATE TABLE IF NOT EXISTS "classification" ( 
        "cid" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, 
        "name" TEXT NOT NULL, 
        "uri" TEXT NOT NULL
        );
        """
        c.execute(create_table_classification)
        conn.commit()
        
        create_table_dictionary = """
        CREATE TABLE IF NOT EXISTS "dictionary" ( 
        "did" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, 
        "name" TEXT, 
        "uri" TEXT NOT NULL, 
        "version" TEXT
        );
        """
        c.execute(create_table_dictionary)
        conn.commit()
        
        create_table_classification_attributes = """
        CREATE TABLE IF NOT EXISTS "classification_attributes" ( 
        "caid" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, 
        "name" TEXT NOT NULL, 
        "property_set" TEXT, 
        "value" TEXT
        );
        """
        c.execute(create_table_classification_attributes)
        conn.commit()
        
        create_table_feature_classification_mapping = """
        CREATE TABLE IF NOT EXISTS "feature_classification_mapping" (
        base_id INTEGER NOT NULL,
        related_id INTEGER NOT NULL,
        PRIMARY KEY(base_id, related_id)
        );
        """
        c.execute(create_table_feature_classification_mapping)
        conn.commit()
        
        create_table_feature_classification_attributes_mapping = """
        CREATE TABLE IF NOT EXISTS "feature_classification_attributes_mapping" (
        base_id INTEGER NOT NULL,
        related_id INTEGER NOT NULL,
        PRIMARY KEY(base_id, related_id)
        );
        """
        c.execute(create_table_feature_classification_attributes_mapping)
        conn.commit()
        
        create_table_classification_dictionary_mapping = """
        CREATE TABLE IF NOT EXISTS "classification_dictionary_mapping" (
        base_id INTEGER NOT NULL,
        related_id INTEGER NOT NULL,
        PRIMARY KEY(base_id, related_id)
        );
        """
        c.execute(create_table_classification_dictionary_mapping)
        conn.commit()
        
        create_table_gpkgext_relations = """
        CREATE TABLE IF NOT EXISTS gpkgext_relations (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        base_table_name TEXT NOT NULL,
        base_primary_column TEXT NOT NULL DEFAULT 'id',
        related_table_name TEXT NOT NULL,
        related_primary_column TEXT NOT NULL DEFAULT 'id',
        relation_name TEXT NOT NULL,
        mapping_table_name TEXT NOT NULL UNIQUE
        );
        """
        c.execute(create_table_gpkgext_relations)
        conn.commit()
        
        parts = re.split(r'[|?&]', layer.source())
        layer_table = None
        for part in parts:
            if part.startswith('layername='):
                layer_table = part.split('=')[1]
                break
        if layer_table is None:
            raise ValueError("Layer table name could not be extracted from the source.")
        
        # initialize relation tables
        init_relation_tables = """
        INSERT INTO gpkgext_relations ("base_table_name", "base_primary_column", "related_table_name", "related_primary_column", "relation_name", "mapping_table_name") VALUES 
        (?, 'fid', 'classification', 'cid', 'simple_attributes', 'feature_classification_mapping'),
        (?, 'fid', 'classification_attributes', 'caid', 'simple_attributes', 'feature_classification_attributes_mapping'),
        ('classification', 'cid', 'dictionary', 'did', 'simple_attributes', 'classification_dictionary_mapping')
        ON CONFLICT(mapping_table_name) DO NOTHING;
        """
        c.execute(init_relation_tables, (layer_table, layer_table))
        conn.commit()
        
        # initialize relation tables
        add_attribute_tables = """
        INSERT INTO gpkg_contents ("table_name", "data_type", "identifier") VALUES 
        ('classification', 'attributes', 'classification'),
        ('classification_attributes', 'attributes', 'classification_attributes'),
        ('dictionary', 'attributes', 'dictionary')
        ON CONFLICT(table_name) DO NOTHING;
        """
        c.execute(add_attribute_tables)
        conn.commit()
        
        # insert classification
        dictionary_name = dictionary["name"]
        dictionary_uri = dictionary["uri"]
        dictionary_version = dictionary["version"]
        new_classification_id = ""
        
        selectClassification = """
        select cid from classification where name = ? and uri = ?;
        """
        c.execute(selectClassification, (dictClass, dictUrl))
        result = c.fetchone()
        
        if result is not None:
            new_classification_id = result[0]
        else:
            insert_classification = """
            INSERT INTO classification ("name", "uri") VALUES 
            (?, ?);
            """
            c.execute(insert_classification, (dictClass, dictUrl))
            conn.commit()
            new_classification_id = c.lastrowid
            
            # insert dictionary
            new_dictionary_id = ""
            selectDictionary = """
            select did from dictionary where uri = ? and name = ? and version = ?;
            """
            c.execute(selectDictionary, (dictionary_uri, dictionary_name, dictionary_version))
            res = c.fetchone()
            
            if res is not None:
                new_dictionary_id = res[0]
            else:
                insert_dictionary = """
                INSERT INTO dictionary ("name", "uri", "version") VALUES 
                (?, ?, ?);
                """
                c.execute(insert_dictionary, (dictionary_name, dictionary_uri, dictionary_version))
                conn.commit()
                new_dictionary_id = c.lastrowid
                
                # insert classification dictionary relations
                insert_dictionary_relations = """
                INSERT INTO classification_dictionary_mapping ("base_id", "related_id") VALUES (?, ?)
                ON CONFLICT(base_id, related_id) DO NOTHING;
                """
                c.execute(insert_dictionary_relations, (new_classification_id, new_dictionary_id))
                conn.commit()

        # insert feature classification relations
        for featureId in selectedFeatures:
            insert_relations = """
            INSERT INTO feature_classification_mapping ("base_id", "related_id") VALUES (?, ?)
            ON CONFLICT(base_id, related_id) DO NOTHING;
            """
            c.execute(insert_relations, (featureId, new_classification_id))
            conn.commit()
        
        # insert attributes
        rowCount = self.twAttributes.rowCount()  
        if rowCount > 0:
            for row in range(rowCount):
                attribute = self.twAttributes.item(row, 0).text()
                group = self.twAttributes.item(row, 1).text()
                value = ""
                try:
                    value = self.twAttributes.item(row, 2).text()
                except:
                    value = "NULL"
                insert_attributes = """
                INSERT INTO classification_attributes ("name", "property_set", "value") VALUES (?, ?, ?);
                """
                c.execute(insert_attributes, (attribute, group, value))
                conn.commit()
                
                new_attribute_id = c.lastrowid
                
                # insert feature attribute relations
                for featureId in selectedFeatures:
                    insert_attribut_relations = """
                    INSERT INTO feature_classification_attributes_mapping ("base_id", "related_id") VALUES (?, ?);
                    """
                    c.execute(insert_attribut_relations, (featureId, new_attribute_id))
                    conn.commit()
        c.close()
        conn.close()
                
