#!/bin/bash

# Loop through all SVG files in the current directory
for svg_file in *.svg; do
    if [ -f "$svg_file" ]; then
        # Extract the width and height from the SVG file
        dimensions=$(identify -format "%wx%h" "$svg_file")
        width=$(echo "$dimensions" | cut -dx -f1)
        height=$(echo "$dimensions" | cut -dx -f2)

        echo $width
        echo $height

        # Check if the width and height are both 16
        if [ "$width" -eq 16 ] && [ "$height" -eq 16 ]; then
            echo "Processing $svg_file (16x16)..."
            # Convert to 64x64
            rsvg-convert -w 64 -h 64 "$svg_file" -f svg -o "$svg_file"
        elif [ "$width" -eq 22 ] && [ "$height" -eq 22 ]; then
            echo "Processing $svg_file (22x22)..."
            # Convert to 64x64
            rsvg-convert -w 64 -h 64 "$svg_file" -f svg -o "$svg_file"
        elif [ "$width" -eq 24 ] && [ "$height" -eq 24 ]; then
            echo "Processing $svg_file (24x24)..."
            # Convert to 64x64
            rsvg-convert -w 64 -h 64 "$svg_file" -f svg -o "$svg_file"
        elif [ "$width" -eq 32 ] && [ "$height" -eq 32 ]; then
            echo "Processing $svg_file (32x32)..."
            # Convert to 64x64
            rsvg-convert -w 64 -h 64 "$svg_file" -f svg -o "$svg_file"
        else
            echo "$svg_file is >= 64x64, skipping..."
        fi
    fi
done
