# -*- coding: utf-8 -*-
"""
/***************************************************************************
 APLSDialog
                                 A QGIS plugin
 This plugin performs Average Path Length Similarity
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-06-11
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Mohammed Nasser
        email                : momaabna2019@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import *
import os,math,time
import processing
import tempfile
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'APLS_dialog_base.ui'))


class APLSDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(APLSDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.pushButtonstart.clicked.connect(self.start_apls)
        self.openFolder1.clicked.connect(self.openFolder1_fn)
        self.openFolder2.clicked.connect(self.openFolder2_fn)

    def openFolder1_fn(self):
        folder = QtWidgets.QFileDialog.getExistingDirectory(self, 'Select Folder')
        self.lineEdit.setText(folder)

    def openFolder2_fn(self):
        folder = QtWidgets.QFileDialog.getExistingDirectory(self, 'Select Folder')
        self.lineEdit_2.setText(folder)

    
    def start_apls(self):
        #implement on folder
        i1=self.lineEdit.text()
        i2=self.lineEdit_2.text()
        tol1 = float(self.lineEdit_3.text())
        tol2 = float(self.lineEdit_4.text())
        processing_folder = tempfile.gettempdir()+'/APLS_Plugin/'
        os.system('mkdir '+processing_folder)
        time.sleep(0.2)

        os.system('mkdir '+processing_folder+'short_test/')
        time.sleep(0.2)
        os.system('mkdir '+processing_folder+'short_pred/')
        
        #print(i1,i2)
        folder= i1+'/' if i1[-1]!='/' else i1
        folder2 =  i2+'/' if i2[-1]!='/' else i2
        dirs = os.listdir(folder2)
        ss=[]
        nn=0
        print('Processing total of :',len(dirs),'images.')
        self.progressBar.setValue(0)
        self.listWidget.clear()
        for sdir in dirs:
            file =sdir+'/'+sdir+'.shp'

            path2 = folder2+file
            nn+=1
            path =folder+file 

            APLS =self.apls(path,path2,processing_folder,file,tol=tol1,sn_tol=tol2)
            #run as a thread

            print('Apls for Folder :',sdir,' is ',APLS)
            self.listWidget.addItem('Apls for Folder :'+sdir+' is '+str(APLS))
            #update widget
            
            ss.append(APLS)
            self.progressBar.setValue(int(nn/len(dirs) *100))
        print('AVG APLS is',sum(ss)/len(ss))
        self.average.setText('AVG APLS : '+str(sum(ss)/len(ss)))
        self.minimum.setText('MIN APLS : '+str(min(ss)))
        self.maximum.setText('MAX APLS : '+str(max(ss)))
        


    def apls(self,path,path2,processing_folder,file,tol=20,sn_tol=8.0):
        processing.run("native:polygonfromlayerextent", {'INPUT':path,'ROUND_TO':0,'OUTPUT':path.split('.')[0]+'_extnt.shp'})
        #processing.run("native:extractvertices", {'INPUT':path,'OUTPUT':path.split('.')[0]+'_vertix.shp'})
        processing.run("native:extractspecificvertices", {'INPUT':path,'VERTICES':'0,-1','OUTPUT':path.split('.')[0]+'_vertix.shp'})
        processing.run("native:snapgeometries", {'INPUT':path.split('.')[0]+'_vertix.shp','REFERENCE_LAYER':path2,'TOLERANCE':sn_tol,'BEHAVIOR':0,'OUTPUT':path2.split('.')[0]+'_vertix.shp'})

        layer=QgsVectorLayer(path.split('.')[0]+'_extnt.shp',"briefkasten","ogr")
        features=layer.getFeatures()
        f=next(features)#.next()
        centx,centy=f.attributes()[4:6]
        v =next(f.geometry().vertices())
        #print(centx,centy)
        ######find nearest vertix to center 
        layer=QgsVectorLayer(path.split('.')[0]+'_vertix.shp',"briefkasten","ogr")
        features=layer.getFeatures()
        minn = 1000000
        id=0
        for idx,f in enumerate(features):#.next()
            v =next(f.geometry().vertices())
            d =math.sqrt((v.x()-centx)**2+(v.y()-centy)**2)
            if d<minn:
                id=idx
                minn=d
                coords=[v.x(),v.y()]
        #print(coords)
        layer=QgsVectorLayer(path2.split('.')[0]+'_vertix.shp',"briefkasten","ogr")
        features=layer.getFeatures()
        minn = 1000000
        id=0
        for idx,f in enumerate(features):#.next()
            v =next(f.geometry().vertices())
            d =math.sqrt((v.x()-centx)**2+(v.y()-centy)**2)
            if d<minn:
                id=idx
                minn=d
                coords2=[v.x(),v.y()]        
        ##Nearest paths
        processing.run("native:shortestpathlayertopoint", {'INPUT':path,'STRATEGY':0,'DIRECTION_FIELD':'','VALUE_FORWARD':'','VALUE_BACKWARD':'','VALUE_BOTH':'','DEFAULT_DIRECTION':2,'SPEED_FIELD':'','DEFAULT_SPEED':50,'TOLERANCE':tol,'START_POINTS':path.split('.')[0]+'_vertix.shp','END_POINT':str(coords[0])+','+str(coords[1])+' [EPSG:26986]','OUTPUT':processing_folder+'short_test/'+file.split('/')[1]})
        processing.run("native:shortestpathlayertopoint", {'INPUT':path2,'STRATEGY':0,'DIRECTION_FIELD':'','VALUE_FORWARD':'','VALUE_BACKWARD':'','VALUE_BOTH':'','DEFAULT_DIRECTION':2,'SPEED_FIELD':'','DEFAULT_SPEED':50,'TOLERANCE':tol,'START_POINTS':path2.split('.')[0]+'_vertix.shp','END_POINT':str(coords2[0])+','+str(coords2[1])+' [EPSG:26986]','OUTPUT':processing_folder+'short_pred/'+file.split('/')[1]})
        short_test =QgsVectorLayer(processing_folder+'short_test/'+file.split('/')[1],"briefkasten","ogr")
        features_test=short_test.getFeatures()
        short_pred =QgsVectorLayer(processing_folder+'short_pred/'+file.split('/')[1],"briefkasten","ogr")
        features_pred=short_pred.getFeatures()
        N=0
        s =0
        for (ftest,fpred) in zip(features_test,features_pred):
            cost_test =ftest.attributes()[-1]
            cost_pred =fpred.attributes()[-1]
            N+=1
            if cost_test and cost_pred:
                s+=min([1,abs(cost_test-cost_pred)/cost_test])
                #print((cost_test,cost_pred))
            elif not cost_test:
                s+=0
            elif not cost_pred:
                s+=1
                
        return 1-s/N

    


