import requests

LLM_MODEL = "intfloat/multilingual-e5-large-instruct"
END_POINT = "https://api.llmhub.infs.ch/embedding"

def request_embedding(text, api_key):
    task_description = "Embed the given text using the best-suited language."
    payload = {
        "model": LLM_MODEL, 
        "text": f"Instruct: {task_description}\nQuery: {text}"
    }
    headers = {
        'LLMHUB-API-KEY':  api_key,
        'Content-Type': "application/json"
    }

    response = requests.post(END_POINT, json=payload, headers=headers)
    response.raise_for_status()
    return response.json()["embedding"]