import os
import pytest
from AIAMAS.name_matching import *
from AIAMAS.embedder_utils import *

def test_remove_characters():
    # Test remove_characters
    name = "Example Name!"
    normalized_name = remove_characters(name)
    assert normalized_name == "examplename"

def test_find_best_matching_entity():
    layer_embedding = [0.1, 0.2, 0.3]
    spatial_entity_embeddings = {
        "entity1": [0.1, 0.2, 0.3],
        "entity2": [0.4, 0.5, 0.6]
    }
    best_match, best_similarity = find_best_matching_entity(layer_embedding, spatial_entity_embeddings)
    assert best_match == 'entity1' and best_similarity == 1 # perfect match

def test_request_embedding():
    text = "Sample text"
    api_key = os.getenv("API_KEY")
    embedding = request_embedding(text, api_key)
    assert embedding is not None