import os
import pytest
import json
import csv
from AIAMAS.name_matching import *
from AIAMAS.embedder_utils import *
from pathlib import Path

PATH = Path(os.path.dirname(os.path.abspath(__file__)))

def test_example_layernames():
    spatial_entities = {}
    entity_embeddings = {}
    
    data_dir = os.path.join(os.path.dirname(__file__), '..', 'data')
    test_data_dir = os.path.join(os.path.dirname(__file__), 'data')
    spatial_entities_path = os.path.join(data_dir, 'spatial_entities_colors_icons.json')
    embeddings_path = os.path.join(data_dir, 'entity_embeddings.json')
    # csv_path = os.path.join(test_data_dir, 'AIAMAS_Testing_Layernames_Entitynames_with_PointEntityName.csv')
    csv_path = os.path.join(test_data_dir, 'layernames_tests.csv')
            
    if os.path.exists(spatial_entities_path):
        with open(spatial_entities_path, 'r') as file:
            spatial_entities = json.load(file)
    
    if os.path.exists(embeddings_path):
        with open(embeddings_path, 'r') as file:
            entity_embeddings = json.load(file)
    entity_embeddings = entity_embeddings["entity_embeddings"]
    
    given_layer_names = []
    expected_layer_names = []
    actual_layer_names = []
    
    # Read from CSV
    if os.path.exists(csv_path):
        with open(csv_path, newline='', encoding='utf-8') as csvfile:
            reader = csv.DictReader(csvfile)
            for row in reader:
                given_layer_names.append(row['Layername'])
                expected_layer_names.append(row['PointEntityName'])
              
    for layer_name in given_layer_names:
        normalized_layer_name = remove_characters(layer_name)
        embedded_layer_name = request_embedding(normalized_layer_name, os.getenv("API_KEY"))
        
        if embedded_layer_name is not None: # Check if embedding is successful
            best_match, best_score = find_best_matching_entity(embedded_layer_name, entity_embeddings)
            if best_score < 0.87:
                best_match, best_score = "n/a", 0  # Handle the case where the match is too bad
        else:
            best_match, best_score = find_best_match_by_jarowinkler(normalized_layer_name, spatial_entities, language="English")
            if best_score < 0.8:
                best_match, best_score = "n/a", 0  # Handle the case where the match is too bad
                
        actual_layer_names.append(best_match)
        
    # Analyse
    for given, expected, actual in zip(given_layer_names, expected_layer_names, actual_layer_names):
        if expected == actual:
            print(f"'{given}', '{expected}' == '{actual}' ✅")
        else:
            print(f"'{given}', '{expected}' != '{actual}' ❌")
        
    assert actual_layer_names == expected_layer_names
    
    





