# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AGLgis
                                A QGIS plugin
 Indices Vegetativos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                               -------------------
        begin                 : 2024-10-24
        copyright             : (C) 2024 by Caio Arantes
        email                 : github.com/caioarantes
        git sha               : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 * *
 * This program is free software; you can redistribute it and/or modify   *
 * it under the terms of the GNU General Public License as published by   *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

import os
import sys
# Import QMessageBox for user feedback if a dependency is missing (optional but recommended)
from qgis.PyQt.QtWidgets import QMessageBox

# --- START: Dependency Loading Code ---
# Get the path to the current plugin directory
plugin_dir = os.path.dirname(__file__)

# Define the path to the 'extlibs' directory
extlibs_path = os.path.join(plugin_dir, 'extlibs')

# Add the 'extlibs' directory to sys.path if it exists and is not already there
# This ensures that Python can find the modules installed by 'paver setup'
if os.path.isdir(extlibs_path) and extlibs_path not in sys.path:
    sys.path.insert(0, extlibs_path)
    print(f"AGLgis Plugin: Added '{extlibs_path}' to sys.path.")
elif not os.path.isdir(extlibs_path):
    print(f"AGLgis Plugin Warning: 'extlibs' directory not found at '{extlibs_path}'. "
          "External dependencies might be missing. Please run 'paver setup'.")
    # Optional: Display a warning message to the user
    # QMessageBox.warning(None, "AGLgis Plugin Warning",
    #                     "External dependencies directory 'extlibs' not found. "
    #                     "Please ensure you have run 'paver setup' for the plugin.")


# --- END: Dependency Loading Code ---


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load AGLgis class from file AGLgis.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    # Ensure your AGLgis class imports its dependencies AFTER sys.path is modified
    # For example, if AGLgis.py uses 'requests', it will now find it.
    from .aglgis import AGLgis
    return AGLgis(iface)